/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.swing.gvt;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.event.AWTEventDispatcher;
import org.apache.batik.gvt.renderer.DynamicRendererFactory;
import org.apache.batik.gvt.renderer.ImageRenderer;
import org.apache.batik.gvt.renderer.ImageRendererFactory;
import org.apache.batik.gvt.text.Mark;
import org.apache.batik.swing.gvt.GVTTreeRenderer;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.gvt.GVTTreeRendererListener;
import org.apache.batik.swing.gvt.Interactor;
import org.apache.batik.swing.gvt.JGVTComponent;
import org.apache.batik.swing.gvt.Overlay;
import org.apache.batik.swing.gvt.TextSelectionManager;

public class JGVTComponent
extends JComponent {
    protected Listener listener;
    protected GVTTreeRenderer gvtTreeRenderer;
    protected GraphicsNode gvtRoot;
    protected ImageRendererFactory rendererFactory = new DynamicRendererFactory();
    protected ImageRenderer renderer;
    protected List gvtTreeRendererListeners = Collections.synchronizedList(new LinkedList());
    protected boolean needRender;
    protected boolean progressivePaint;
    protected Thread progressivePaintThread;
    protected BufferedImage image;
    protected AffineTransform initialTransform;
    protected AffineTransform renderingTransform;
    protected AffineTransform paintingTransform;
    protected List interactors = new LinkedList();
    protected Interactor interactor;
    protected List overlays = new LinkedList();
    protected AWTEventDispatcher eventDispatcher;
    protected TextSelectionManager textSelectionManager;
    protected boolean doubleBufferedRendering;
    protected boolean eventsEnabled;
    protected boolean selectableText;
    protected boolean suspendInteractions;
    protected boolean disableInteractions;

    public JGVTComponent() {
        this(false, false);
    }

    public JGVTComponent(boolean bl, boolean bl2) {
        this.setBackground(Color.white);
        this.eventsEnabled = bl;
        this.selectableText = bl2;
        this.listener = this.createListener();
        this.addKeyListener(this.listener);
        this.addMouseListener(this.listener);
        this.addMouseMotionListener(this.listener);
        this.addGVTTreeRendererListener(this.listener);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                JGVTComponent.this.updateRenderingTransform();
                JGVTComponent.this.scheduleGVTRendering();
            }
        });
    }

    public List getInteractors() {
        return this.interactors;
    }

    public List getOverlays() {
        return this.overlays;
    }

    public BufferedImage getOffScreen() {
        return this.image;
    }

    public void resetRenderingTransform() {
        this.setRenderingTransform(this.initialTransform);
    }

    public void stopProcessing() {
        if (this.gvtTreeRenderer != null) {
            this.needRender = false;
            this.gvtTreeRenderer.interrupt();
            this.interruptProgressivePaintThread();
        }
    }

    public GraphicsNode getGraphicsNode() {
        return this.gvtRoot;
    }

    public void setGraphicsNode(GraphicsNode graphicsNode) {
        this.setGraphicsNode(graphicsNode, true);
    }

    protected void setGraphicsNode(GraphicsNode graphicsNode, boolean bl) {
        this.gvtRoot = graphicsNode;
        if (graphicsNode != null && bl) {
            this.initializeEventHandling();
        }
        if (this.eventDispatcher != null) {
            this.eventDispatcher.setRootNode(graphicsNode);
        }
        this.computeRenderingTransform();
    }

    protected void initializeEventHandling() {
        if (this.eventsEnabled) {
            this.eventDispatcher = new AWTEventDispatcher();
            if (this.selectableText) {
                this.textSelectionManager = new TextSelectionManager(this, this.eventDispatcher);
            }
        }
    }

    public void setSelectionOverlayColor(Color color) {
        if (this.textSelectionManager != null) {
            this.textSelectionManager.setSelectionOverlayColor(color);
        }
    }

    public Color getSelectionOverlayColor() {
        if (this.textSelectionManager != null) {
            return this.textSelectionManager.getSelectionOverlayColor();
        }
        throw new IllegalArgumentException("Selection is disabled");
    }

    public void setSelectionOverlayStrokeColor(Color color) {
        if (this.textSelectionManager != null) {
            this.textSelectionManager.setSelectionOverlayStrokeColor(color);
        }
    }

    public Color getSelectionOverlayStrokeColor() {
        if (this.textSelectionManager != null) {
            return this.textSelectionManager.getSelectionOverlayStrokeColor();
        }
        throw new IllegalArgumentException("Selection is disabled");
    }

    public void setSelectionOverlayXORMode(boolean bl) {
        if (this.textSelectionManager != null) {
            this.textSelectionManager.setSelectionOverlayXORMode(bl);
        }
    }

    public boolean isSelectionOverlayXORMode() {
        if (this.textSelectionManager != null) {
            return this.textSelectionManager.isSelectionOverlayXORMode();
        }
        throw new IllegalArgumentException("Selection is disabled");
    }

    public void select(Mark mark, Mark mark2) {
        if (this.textSelectionManager != null) {
            this.textSelectionManager.setSelection(mark, mark2);
        }
    }

    public void deselectAll() {
        if (this.textSelectionManager != null) {
            this.textSelectionManager.clearSelection();
        }
    }

    public void setProgressivePaint(boolean bl) {
        if (this.progressivePaint != bl) {
            this.progressivePaint = bl;
            this.interruptProgressivePaintThread();
        }
    }

    public boolean getProgressivePaint() {
        return this.progressivePaint;
    }

    public void immediateRepaint() {
        if (EventQueue.isDispatchThread()) {
            Dimension dimension = this.getSize();
            this.paintImmediately(0, 0, dimension.width, dimension.height);
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    public void run() {
                        Dimension dimension = JGVTComponent.this.getSize();
                        JGVTComponent.this.paintImmediately(0, 0, dimension.width, dimension.height);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Dimension dimension = this.getSize();
        graphics2D.setComposite(AlphaComposite.SrcOver);
        graphics2D.setPaint(this.getBackground());
        graphics2D.fillRect(0, 0, dimension.width, dimension.height);
        if (this.image != null) {
            if (this.paintingTransform != null) {
                graphics2D.transform(this.paintingTransform);
            }
            graphics2D.drawRenderedImage(this.image, null);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            Iterator iterator = this.overlays.iterator();
            while (iterator.hasNext()) {
                ((Overlay)iterator.next()).paint(graphics);
            }
        }
    }

    public void setPaintingTransform(AffineTransform affineTransform) {
        this.paintingTransform = affineTransform;
        this.immediateRepaint();
    }

    public AffineTransform getPaintingTransform() {
        return this.paintingTransform;
    }

    public void setRenderingTransform(AffineTransform affineTransform) {
        this.renderingTransform = affineTransform;
        this.suspendInteractions = true;
        if (this.eventDispatcher != null) {
            try {
                this.eventDispatcher.setBaseTransform(this.renderingTransform.createInverse());
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                this.handleException(noninvertibleTransformException);
            }
        }
        this.scheduleGVTRendering();
    }

    public AffineTransform getInitialTransform() {
        return this.initialTransform;
    }

    public AffineTransform getRenderingTransform() {
        return this.renderingTransform;
    }

    public void setDoubleBufferedRendering(boolean bl) {
        this.doubleBufferedRendering = bl;
    }

    public boolean getDoubleBufferedRendering() {
        return this.doubleBufferedRendering;
    }

    public void addGVTTreeRendererListener(GVTTreeRendererListener gVTTreeRendererListener) {
        this.gvtTreeRendererListeners.add(gVTTreeRendererListener);
    }

    public void removeGVTTreeRendererListener(GVTTreeRendererListener gVTTreeRendererListener) {
        this.gvtTreeRendererListeners.remove(gVTTreeRendererListener);
    }

    public void flush() {
        this.renderer.flush();
    }

    public void flush(Rectangle rectangle) {
        this.renderer.flush(rectangle);
    }

    protected void renderGVTTree() {
        AffineTransform affineTransform;
        Dimension dimension = this.getSize();
        if (this.gvtRoot == null || dimension.width <= 0 || dimension.height <= 0) {
            return;
        }
        if (this.renderer == null || this.renderer.getTree() != this.gvtRoot) {
            this.renderer = this.rendererFactory.createImageRenderer();
            this.renderer.setTree(this.gvtRoot);
        }
        try {
            affineTransform = this.renderingTransform.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new InternalError(noninvertibleTransformException.getMessage());
        }
        Shape shape = affineTransform.createTransformedShape(new Rectangle(0, 0, dimension.width, dimension.height));
        this.gvtTreeRenderer = new GVTTreeRenderer(this.renderer, this.renderingTransform, this.doubleBufferedRendering, shape, dimension.width, dimension.height);
        this.gvtTreeRenderer.setPriority(1);
        Iterator iterator = this.gvtTreeRendererListeners.iterator();
        while (iterator.hasNext()) {
            this.gvtTreeRenderer.addGVTTreeRendererListener((GVTTreeRendererListener)iterator.next());
        }
        if (this.eventDispatcher != null) {
            this.eventDispatcher.setRootNode(null);
        }
        this.gvtTreeRenderer.start();
    }

    protected void computeRenderingTransform() {
        this.initialTransform = new AffineTransform();
        this.setRenderingTransform(this.initialTransform);
    }

    protected void updateRenderingTransform() {
    }

    protected void handleException(Exception exception) {
    }

    protected void releaseRenderingReferences() {
        this.eventDispatcher = null;
        if (this.textSelectionManager != null) {
            this.overlays.remove(this.textSelectionManager.getSelectionOverlay());
            this.textSelectionManager = null;
        }
        this.renderer = null;
        this.gvtRoot = null;
    }

    protected void scheduleGVTRendering() {
        if (this.gvtTreeRenderer != null) {
            this.needRender = true;
            this.gvtTreeRenderer.interrupt();
        } else {
            this.renderGVTTree();
        }
    }

    private void interruptProgressivePaintThread() {
        if (this.progressivePaintThread != null) {
            this.progressivePaintThread.interrupt();
            this.progressivePaintThread = null;
        }
    }

    protected Listener createListener() {
        return new Listener();
    }

    protected class Listener
    implements GVTTreeRendererListener,
    KeyListener,
    MouseListener,
    MouseMotionListener {
        protected Listener() {
        }

        public void gvtRenderingPrepare(GVTTreeRendererEvent gVTTreeRendererEvent) {
            JGVTComponent.this.suspendInteractions = true;
            if (!JGVTComponent.this.progressivePaint && !JGVTComponent.this.doubleBufferedRendering) {
                JGVTComponent.this.image = null;
                JGVTComponent.this.immediateRepaint();
            }
        }

        public void gvtRenderingStarted(GVTTreeRendererEvent gVTTreeRendererEvent) {
            JGVTComponent.this.paintingTransform = null;
            if (JGVTComponent.this.progressivePaint && !JGVTComponent.this.doubleBufferedRendering) {
                JGVTComponent.this.image = gVTTreeRendererEvent.getImage();
                JGVTComponent.this.progressivePaintThread = new Thread(this){
                    private final /* synthetic */ Listener this$1;
                    {
                        this.this$1 = listener;
                    }

                    public void run() {
                        3 var1_1 = this;
                        try {
                            while (!this.isInterrupted()) {
                                EventQueue.invokeAndWait(new Runnable(this, var1_1){
                                    private final /* synthetic */ Thread val$thisThread;
                                    private final /* synthetic */ 3 this$2;
                                    {
                                        this.this$2 = var1_1;
                                        this.val$thisThread = thread;
                                    }

                                    public void run() {
                                        if (Listener.access$100((Listener)3.access$000(this.this$2)).progressivePaintThread == this.val$thisThread) {
                                            Dimension dimension = Listener.access$100(3.access$000(this.this$2)).getSize();
                                            Listener.access$100(3.access$000(this.this$2)).paintImmediately(0, 0, dimension.width, dimension.height);
                                        }
                                    }
                                });
                                Thread.sleep(200L);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }

                    static /* synthetic */ Listener access$000(3 var0) {
                        return var0.this$1;
                    }
                };
                JGVTComponent.this.progressivePaintThread.setPriority(2);
                JGVTComponent.this.progressivePaintThread.start();
            }
            if (!JGVTComponent.this.doubleBufferedRendering) {
                JGVTComponent.this.suspendInteractions = false;
            }
        }

        public void gvtRenderingCompleted(GVTTreeRendererEvent gVTTreeRendererEvent) {
            JGVTComponent.this.interruptProgressivePaintThread();
            if (JGVTComponent.this.doubleBufferedRendering) {
                JGVTComponent.this.suspendInteractions = false;
            }
            JGVTComponent.this.gvtTreeRenderer = null;
            if (JGVTComponent.this.needRender) {
                JGVTComponent.this.renderGVTTree();
                JGVTComponent.this.needRender = false;
            } else {
                JGVTComponent.this.image = gVTTreeRendererEvent.getImage();
                JGVTComponent.this.immediateRepaint();
            }
            if (JGVTComponent.this.eventDispatcher != null) {
                JGVTComponent.this.eventDispatcher.setRootNode(JGVTComponent.this.gvtRoot);
            }
        }

        public void gvtRenderingCancelled(GVTTreeRendererEvent gVTTreeRendererEvent) {
            this.renderingStopped();
        }

        public void gvtRenderingFailed(GVTTreeRendererEvent gVTTreeRendererEvent) {
            this.renderingStopped();
        }

        private void renderingStopped() {
            JGVTComponent.this.interruptProgressivePaintThread();
            if (JGVTComponent.this.doubleBufferedRendering) {
                JGVTComponent.this.suspendInteractions = false;
            }
            JGVTComponent.this.gvtTreeRenderer = null;
            if (JGVTComponent.this.needRender) {
                JGVTComponent.this.renderGVTTree();
                JGVTComponent.this.needRender = false;
            } else {
                JGVTComponent.this.immediateRepaint();
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
            this.selectInteractor(keyEvent);
            if (JGVTComponent.this.interactor != null) {
                JGVTComponent.this.interactor.keyTyped(keyEvent);
                this.deselectInteractor();
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            this.selectInteractor(keyEvent);
            if (JGVTComponent.this.interactor != null) {
                JGVTComponent.this.interactor.keyPressed(keyEvent);
                this.deselectInteractor();
            } else if (JGVTComponent.this.eventDispatcher != null) {
                JGVTComponent.this.eventDispatcher.keyReleased(keyEvent);
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            this.selectInteractor(keyEvent);
            if (JGVTComponent.this.interactor != null) {
                JGVTComponent.this.interactor.keyReleased(keyEvent);
                this.deselectInteractor();
            } else if (JGVTComponent.this.eventDispatcher != null) {
                JGVTComponent.this.eventDispatcher.keyReleased(keyEvent);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.selectInteractor(mouseEvent);
            if (JGVTComponent.this.interactor != null) {
                JGVTComponent.this.interactor.mouseClicked(mouseEvent);
                this.deselectInteractor();
            } else if (JGVTComponent.this.eventDispatcher != null) {
                JGVTComponent.this.eventDispatcher.mouseClicked(mouseEvent);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.selectInteractor(mouseEvent);
            if (JGVTComponent.this.interactor != null) {
                JGVTComponent.this.interactor.mousePressed(mouseEvent);
                this.deselectInteractor();
            } else if (JGVTComponent.this.eventDispatcher != null) {
                JGVTComponent.this.eventDispatcher.mousePressed(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.selectInteractor(mouseEvent);
            if (JGVTComponent.this.interactor != null) {
                JGVTComponent.this.interactor.mouseReleased(mouseEvent);
                this.deselectInteractor();
            } else if (JGVTComponent.this.eventDispatcher != null) {
                JGVTComponent.this.eventDispatcher.mouseReleased(mouseEvent);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.selectInteractor(mouseEvent);
            if (JGVTComponent.this.interactor != null) {
                JGVTComponent.this.interactor.mouseEntered(mouseEvent);
                this.deselectInteractor();
            } else if (JGVTComponent.this.eventDispatcher != null) {
                JGVTComponent.this.eventDispatcher.mouseEntered(mouseEvent);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.selectInteractor(mouseEvent);
            if (JGVTComponent.this.interactor != null) {
                JGVTComponent.this.interactor.mouseExited(mouseEvent);
                this.deselectInteractor();
            } else if (JGVTComponent.this.eventDispatcher != null) {
                JGVTComponent.this.eventDispatcher.mouseExited(mouseEvent);
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.selectInteractor(mouseEvent);
            if (JGVTComponent.this.interactor != null) {
                JGVTComponent.this.interactor.mouseDragged(mouseEvent);
                this.deselectInteractor();
            } else if (JGVTComponent.this.eventDispatcher != null) {
                JGVTComponent.this.eventDispatcher.mouseDragged(mouseEvent);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.selectInteractor(mouseEvent);
            if (JGVTComponent.this.interactor != null) {
                JGVTComponent.this.interactor.mouseMoved(mouseEvent);
                this.deselectInteractor();
            } else if (JGVTComponent.this.eventDispatcher != null) {
                JGVTComponent.this.eventDispatcher.mouseMoved(mouseEvent);
            }
        }

        protected void selectInteractor(InputEvent inputEvent) {
            if (!JGVTComponent.this.disableInteractions && !JGVTComponent.this.suspendInteractions && JGVTComponent.this.interactor == null) {
                Iterator iterator = JGVTComponent.this.interactors.iterator();
                while (iterator.hasNext()) {
                    Interactor interactor = (Interactor)iterator.next();
                    if (!interactor.startInteraction(inputEvent)) continue;
                    JGVTComponent.this.interactor = interactor;
                    break;
                }
            }
        }

        protected void deselectInteractor() {
            if (JGVTComponent.this.interactor.endInteraction()) {
                JGVTComponent.this.interactor = null;
            }
        }

        static /* synthetic */ JGVTComponent access$100(Listener listener) {
            return listener.JGVTComponent.this;
        }
    }
}

