/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.swing.svg;

import java.awt.EventQueue;
import java.io.InterruptedIOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.swing.svg.SVGDocumentLoaderEvent;
import org.apache.batik.swing.svg.SVGDocumentLoaderListener;
import org.w3c.dom.svg.SVGDocument;

public class SVGDocumentLoader
extends Thread {
    protected String url;
    protected DocumentLoader loader;
    protected Exception exception;
    protected List listeners = Collections.synchronizedList(new LinkedList());

    public SVGDocumentLoader(String string, DocumentLoader documentLoader) {
        this.url = string;
        this.loader = documentLoader;
    }

    public void run() {
        try {
            this.fireStartedEvent();
            SVGDocument sVGDocument = (SVGDocument)this.loader.loadDocument(this.url);
            this.fireCompletedEvent(sVGDocument);
        }
        catch (InterruptedIOException interruptedIOException) {
            this.fireCancelledEvent();
        }
        catch (Exception exception) {
            this.exception = exception;
            this.fireFailedEvent();
        }
    }

    public Exception getException() {
        return this.exception;
    }

    public void addSVGDocumentLoaderListener(SVGDocumentLoaderListener sVGDocumentLoaderListener) {
        this.listeners.add(sVGDocumentLoaderListener);
    }

    public void removeSVGDocumentLoaderListener(SVGDocumentLoaderListener sVGDocumentLoaderListener) {
        this.listeners.remove(sVGDocumentLoaderListener);
    }

    protected void fireStartedEvent() {
        final Object[] objectArray = this.listeners.toArray();
        if (objectArray.length > 0) {
            final SVGDocumentLoaderEvent sVGDocumentLoaderEvent = new SVGDocumentLoaderEvent(this, null);
            if (EventQueue.isDispatchThread()) {
                int n = 0;
                while (n < objectArray.length) {
                    SVGDocumentLoaderListener sVGDocumentLoaderListener = (SVGDocumentLoaderListener)objectArray[n];
                    sVGDocumentLoaderListener.documentLoadingStarted(sVGDocumentLoaderEvent);
                    ++n;
                }
            } else {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        int n = 0;
                        while (n < objectArray.length) {
                            SVGDocumentLoaderListener sVGDocumentLoaderListener = (SVGDocumentLoaderListener)objectArray[n];
                            sVGDocumentLoaderListener.documentLoadingStarted(sVGDocumentLoaderEvent);
                            ++n;
                        }
                    }
                });
            }
        }
    }

    protected void fireCompletedEvent(SVGDocument sVGDocument) {
        final Object[] objectArray = this.listeners.toArray();
        if (objectArray.length > 0) {
            final SVGDocumentLoaderEvent sVGDocumentLoaderEvent = new SVGDocumentLoaderEvent(this, sVGDocument);
            if (EventQueue.isDispatchThread()) {
                int n = 0;
                while (n < objectArray.length) {
                    SVGDocumentLoaderListener sVGDocumentLoaderListener = (SVGDocumentLoaderListener)objectArray[n];
                    sVGDocumentLoaderListener.documentLoadingCompleted(sVGDocumentLoaderEvent);
                    ++n;
                }
            } else {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        int n = 0;
                        while (n < objectArray.length) {
                            SVGDocumentLoaderListener sVGDocumentLoaderListener = (SVGDocumentLoaderListener)objectArray[n];
                            sVGDocumentLoaderListener.documentLoadingCompleted(sVGDocumentLoaderEvent);
                            ++n;
                        }
                    }
                });
            }
        }
    }

    protected void fireFailedEvent() {
        final Object[] objectArray = this.listeners.toArray();
        if (objectArray.length > 0) {
            final SVGDocumentLoaderEvent sVGDocumentLoaderEvent = new SVGDocumentLoaderEvent(this, null);
            if (EventQueue.isDispatchThread()) {
                int n = 0;
                while (n < objectArray.length) {
                    SVGDocumentLoaderListener sVGDocumentLoaderListener = (SVGDocumentLoaderListener)objectArray[n];
                    sVGDocumentLoaderListener.documentLoadingFailed(sVGDocumentLoaderEvent);
                    ++n;
                }
            } else {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        int n = 0;
                        while (n < objectArray.length) {
                            SVGDocumentLoaderListener sVGDocumentLoaderListener = (SVGDocumentLoaderListener)objectArray[n];
                            sVGDocumentLoaderListener.documentLoadingFailed(sVGDocumentLoaderEvent);
                            ++n;
                        }
                    }
                });
            }
        }
    }

    protected void fireCancelledEvent() {
        final Object[] objectArray = this.listeners.toArray();
        if (objectArray.length > 0) {
            final SVGDocumentLoaderEvent sVGDocumentLoaderEvent = new SVGDocumentLoaderEvent(this, null);
            if (EventQueue.isDispatchThread()) {
                int n = 0;
                while (n < objectArray.length) {
                    SVGDocumentLoaderListener sVGDocumentLoaderListener = (SVGDocumentLoaderListener)objectArray[n];
                    sVGDocumentLoaderListener.documentLoadingCancelled(sVGDocumentLoaderEvent);
                    ++n;
                }
            } else {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        int n = 0;
                        while (n < objectArray.length) {
                            SVGDocumentLoaderListener sVGDocumentLoaderListener = (SVGDocumentLoaderListener)objectArray[n];
                            sVGDocumentLoaderListener.documentLoadingCancelled(sVGDocumentLoaderEvent);
                            ++n;
                        }
                    }
                });
            }
        }
    }
}

