/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.websphere6;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.factories.DeploymentFactoryManager;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.websphere6.WSClassLoader;
import org.netbeans.modules.j2ee.websphere6.WSDeploymentManager;
import org.netbeans.modules.j2ee.websphere6.WSVersion;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class WSDeploymentFactory
implements DeploymentFactory {
    public static final String SERVER_ROOT_ATTR = "serverRoot";
    public static final String DOMAIN_ROOT_ATTR = "domainRoot";
    public static final String IS_LOCAL_ATTR = "isLocal";
    public static final String HOST_ATTR = "host";
    public static final String PORT_ATTR = "port";
    public static final String DEBUGGER_PORT_ATTR = "debuggerPort";
    public static final String SERVER_NAME_ATTR = "serverName";
    public static final String CONFIG_XML_PATH = "configXmlPath";
    public static final String ADMIN_PORT_ATTR = "adminPort";
    public static final String USERNAME_ATTR = "username";
    public static final String PASSWORD_ATTR = "password";
    public static final String DEFAULT_HOST_PORT_ATTR = "defaultHostPort";
    private final WSVersion version;
    private static final Logger LOGGER = Logger.getLogger(WSDeploymentFactory.class.getName());
    private static WSDeploymentFactory instance60;
    private static WSDeploymentFactory instance61;
    private WSClassLoader loader;
    private Map<InstanceProperties, DeploymentFactory> factories = new WeakHashMap<InstanceProperties, DeploymentFactory>();
    private Map<InstanceProperties, DeploymentManager> managers = new WeakHashMap<InstanceProperties, DeploymentManager>();

    private WSDeploymentFactory(WSVersion wSVersion) {
        this.version = wSVersion;
    }

    public static synchronized WSDeploymentFactory create60() {
        if (instance60 == null) {
            instance60 = new WSDeploymentFactory(WSVersion.VERSION_60);
            DeploymentFactoryManager.getInstance().registerDeploymentFactory((DeploymentFactory)instance60);
        }
        return instance60;
    }

    public static synchronized WSDeploymentFactory create61() {
        if (instance61 == null) {
            instance61 = new WSDeploymentFactory(WSVersion.VERSION_61);
            DeploymentFactoryManager.getInstance().registerDeploymentFactory((DeploymentFactory)instance61);
        }
        return instance61;
    }

    public DeploymentManager getDeploymentManager(String string, String string2, String string3) throws DeploymentManagerCreationException {
        InstanceProperties instanceProperties;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "getDeploymentManager(" + string + ", " + string2 + ", " + string3 + ")");
        }
        if ((instanceProperties = InstanceProperties.getInstanceProperties((String)string)) == null) {
            return null;
        }
        DeploymentManager deploymentManager = this.managers.get(instanceProperties);
        if (null == deploymentManager) {
            deploymentManager = new WSDeploymentManager(string, string2, string3, this.version);
            this.managers.put(instanceProperties, deploymentManager);
        }
        return deploymentManager;
    }

    public DeploymentManager getDisconnectedDeploymentManager(String string) throws DeploymentManagerCreationException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "getDisconnectedDeploymentManager(" + string + ")");
        }
        return this.getDeploymentManager(string, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeploymentFactory getWSDeploymentFactory(String string) {
        InstanceProperties instanceProperties;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "getWSDeploymentFactory(" + string + ")");
        }
        if ((instanceProperties = InstanceProperties.getInstanceProperties((String)string)) == null) {
            return null;
        }
        DeploymentFactory deploymentFactory = this.factories.get(instanceProperties);
        if (null == deploymentFactory) {
            String string2 = null;
            String string3 = null;
            if (null != instanceProperties) {
                string2 = instanceProperties.getProperty(SERVER_ROOT_ATTR);
                string3 = instanceProperties.getProperty(DOMAIN_ROOT_ATTR);
            }
            if (null == string2) {
                string2 = NbPreferences.forModule(WSDeploymentFactory.class).get(SERVER_ROOT_ATTR, "");
            }
            if (null == string3) {
                string3 = NbPreferences.forModule(WSDeploymentFactory.class).get(DOMAIN_ROOT_ATTR, "");
            }
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "loadDeplomentFactory: serverRoot=" + string2);
            }
            this.loader = WSClassLoader.getInstance(string2, string3);
            this.loader.updateLoader();
            try {
                deploymentFactory = (DeploymentFactory)this.loader.loadClass("com.ibm.ws.management.application.j2ee.deploy.spi.factories.DeploymentFactoryImpl").newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                Logger.getLogger("global").log(Level.SEVERE, null, classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                Logger.getLogger("global").log(Level.SEVERE, null, instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.getLogger("global").log(Level.SEVERE, null, illegalAccessException);
            }
            finally {
                this.loader.restoreLoader();
            }
            this.factories.put(instanceProperties, deploymentFactory);
        }
        return deploymentFactory;
    }

    public boolean handlesURI(String string) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "handlesURI(" + string + ")");
        }
        if (string == null) {
            return false;
        }
        switch (this.version) {
            case VERSION_60: {
                return string.startsWith("deployer:WebSphere:");
            }
            case VERSION_61: {
                return string.startsWith("deployer:WebSphere61:");
            }
        }
        throw new IllegalArgumentException("Wrong enum value");
    }

    public String getProductVersion() {
        switch (this.version) {
            case VERSION_60: {
                return NbBundle.getMessage(WSDeploymentFactory.class, (String)"TXT_productVersion60");
            }
            case VERSION_61: {
                return NbBundle.getMessage(WSDeploymentFactory.class, (String)"TXT_productVersion61");
            }
        }
        throw new IllegalArgumentException("Wrong enum value");
    }

    public String getDisplayName() {
        LOGGER.log(Level.FINEST, "getDisplayName()");
        switch (this.version) {
            case VERSION_60: {
                return NbBundle.getMessage(WSDeploymentFactory.class, (String)"TXT_displayName60");
            }
            case VERSION_61: {
                return NbBundle.getMessage(WSDeploymentFactory.class, (String)"TXT_displayName61");
            }
        }
        throw new IllegalArgumentException("Wrong enum value");
    }
}

