/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.websphere6.config;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.DeploymentPlanConfiguration;
import org.netbeans.modules.j2ee.websphere6.config.WSModuleConfiguration;
import org.netbeans.modules.j2ee.websphere6.dd.beans.WSAppBnd;
import org.netbeans.modules.j2ee.websphere6.dd.beans.WSAppExt;
import org.netbeans.modules.j2ee.websphere6.util.WSUtil;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

public class WSEarModuleConfiguration
extends WSModuleConfiguration
implements DeploymentPlanConfiguration,
PropertyChangeListener {
    private File webspheredpfFile;
    private File wsAppBndFile;
    private File wsAppExtFile;
    private WSAppBnd websphereApplicationBnd;
    private WSAppExt websphereApplicationExt;
    DataObject[] dataObjects;

    public WSEarModuleConfiguration(J2eeModule j2eeModule) {
        super(j2eeModule);
        this.webspheredpfFile = j2eeModule.getDeploymentConfigurationFile("WebSphere6.dpf");
        this.wsAppBndFile = j2eeModule.getDeploymentConfigurationFile("ibm-application-bnd.xmi");
        this.wsAppExtFile = j2eeModule.getDeploymentConfigurationFile("ibm-application-ext.xmi");
        this.getWebSphereApplicationExt();
        this.getWebSphereApplicationBnd();
        try {
            DataObject dataObject = DataObject.find((FileObject)FileUtil.toFileObject((File)this.wsAppBndFile));
            dataObject.addPropertyChangeListener((PropertyChangeListener)this);
            DataObject dataObject2 = DataObject.find((FileObject)FileUtil.toFileObject((File)this.wsAppExtFile));
            dataObject2.addPropertyChangeListener((PropertyChangeListener)this);
            this.dataObjects = new DataObject[]{dataObject, dataObject2};
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            this.dataObjects = new DataObject[0];
            Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
        }
        this.correctDeploymentDescriptors();
        this.attachFOListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName() == "modified" && propertyChangeEvent.getNewValue() == Boolean.FALSE) {
            WSEarModuleConfiguration wSEarModuleConfiguration = this;
            synchronized (wSEarModuleConfiguration) {
                this.websphereApplicationExt = null;
                this.websphereApplicationBnd = null;
            }
        }
    }

    public synchronized WSAppBnd getWebSphereApplicationBnd() {
        if (this.websphereApplicationBnd == null) {
            try {
                if (!this.webspheredpfFile.exists()) {
                    this.writefile(this.webspheredpfFile, null);
                }
                if (this.wsAppBndFile.exists()) {
                    try {
                        this.websphereApplicationBnd = new WSAppBnd(this.wsAppBndFile, false);
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                    catch (RuntimeException runtimeException) {}
                } else {
                    this.websphereApplicationBnd = new WSAppBnd();
                    this.websphereApplicationBnd.setDefaults();
                    this.writefile(this.wsAppBndFile, this.websphereApplicationBnd);
                }
            }
            catch (ConfigurationException configurationException) {
                Exceptions.printStackTrace((Throwable)configurationException);
            }
        }
        return this.websphereApplicationBnd;
    }

    public synchronized WSAppExt getWebSphereApplicationExt() {
        if (this.websphereApplicationExt == null) {
            try {
                if (!this.webspheredpfFile.exists()) {
                    this.writefile(this.webspheredpfFile, null);
                }
                if (this.wsAppExtFile.exists()) {
                    try {
                        this.websphereApplicationExt = new WSAppExt(this.wsAppExtFile, false);
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                    catch (RuntimeException runtimeException) {}
                } else {
                    this.websphereApplicationExt = new WSAppExt();
                    this.websphereApplicationExt.setDefaults();
                    this.writefile(this.wsAppExtFile, this.websphereApplicationExt);
                }
            }
            catch (ConfigurationException configurationException) {
                Exceptions.printStackTrace((Throwable)configurationException);
            }
        }
        return this.websphereApplicationExt;
    }

    private void attachFOListener() {
        File file = this.getJ2eeModule().getDeploymentConfigurationFile("META_INF/application.xml");
        boolean bl = false;
        if (file.exists()) {
            FileObject fileObject = FileUtil.toFileObject((File)file);
            fileObject.addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

                public void fileChanged(FileEvent fileEvent) {
                    WSEarModuleConfiguration.this.correctDeploymentDescriptors();
                }
            });
        }
    }

    public void correctDeploymentDescriptors() {
        String string;
        String string2;
        File file = this.getJ2eeModule().getDeploymentConfigurationFile("META_INF/application.xml");
        int n = 0;
        if (file.exists() && (string2 = WSUtil.readFile(file)) != null && (n = string2.indexOf("<application")) >= 0 && !(string = string2.substring(n, string2.indexOf(">", n))).contains(" id=")) {
            WSUtil.writeFile(file, string2.replaceFirst("<application", "<application id=\"Application_ID\"\n"));
        }
    }

    public void save(OutputStream outputStream) throws ConfigurationException {
        WSAppExt wSAppExt = this.getWebSphereApplicationExt();
        if (wSAppExt == null) {
            throw new ConfigurationException("Cannot read configuration, it is probably in an inconsistent state.");
        }
        try {
            wSAppExt.write(outputStream);
        }
        catch (IOException iOException) {
            throw new ConfigurationException(iOException.getLocalizedMessage());
        }
        WSAppBnd wSAppBnd = this.getWebSphereApplicationBnd();
        if (wSAppExt == null) {
            throw new ConfigurationException("Cannot read configuration, it is probably in an inconsistent state.");
        }
        try {
            wSAppBnd.write(outputStream);
        }
        catch (IOException iOException) {
            throw new ConfigurationException(iOException.getLocalizedMessage());
        }
    }
}

