/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.websphere6.config.sync;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.netbeans.modules.j2ee.websphere6.config.sync.Synchronizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EjbSynchronizer
extends Synchronizer {
    private static final Logger LOGGER = Logger.getLogger(EjbSynchronizer.class.getName());
    private final File ejbjarFile;
    private final File ibmejbjarbndFile;
    private XPath xpath = null;
    private boolean saveEjbJarNeeded = false;
    private boolean saveIbmEjbJarBndNeeded = false;
    private static final String EJB_JAR_PREFIX = "META-INF/ejb-jar.xml#";

    public EjbSynchronizer(File file, File file2) {
        try {
            this.xpath = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom").newXPath();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.xpath = null;
        }
        this.ibmejbjarbndFile = file2;
        this.ejbjarFile = file;
    }

    public synchronized void syncDescriptors() {
        if (this.ejbjarFile != null && this.ibmejbjarbndFile != null) {
            try {
                String string;
                Node node;
                int n;
                this.saveEjbJarNeeded = false;
                this.saveIbmEjbJarBndNeeded = false;
                Document document = this.loadDocument(this.ejbjarFile);
                Document document2 = this.loadDocument(this.ibmejbjarbndFile);
                NodeList nodeList = (NodeList)this.xpath.compile("/ejb-jar/enterprise-beans/*").evaluate(document, XPathConstants.NODESET);
                Element element = document2.getDocumentElement();
                if (element == null) {
                    return;
                }
                NodeList nodeList2 = (NodeList)this.xpath.compile("./ejbBindings").evaluate(element, XPathConstants.NODESET);
                for (n = 0; n < nodeList.getLength(); ++n) {
                    Node node2;
                    node = nodeList.item(n);
                    string = this.getBeanId(node);
                    if (string != null && this.bindingExists(element, string)) continue;
                    boolean bl = false;
                    if (string == null) {
                        string = this.getBeanIdFromBinding(node, nodeList2);
                        if (string == null) {
                            string = this.createBeanId(node);
                            bl = true;
                        }
                        node2 = document.createAttribute("id");
                        node2.setValue(string);
                        node.getAttributes().setNamedItem(node2);
                        this.saveEjbJarNeeded = true;
                    }
                    if (!bl) continue;
                    node2 = this.constructBinding(document2, this.getBeanName(node), this.getBeanId(node), this.getBeanType(node));
                    element.appendChild(document2.createTextNode("    "));
                    element.appendChild(node2);
                    element.appendChild(document2.createTextNode("\n"));
                    this.saveIbmEjbJarBndNeeded = true;
                }
                for (n = 0; n < nodeList2.getLength(); ++n) {
                    node = nodeList2.item(n);
                    string = this.getBindingId(node);
                    if (this.beanExists(document, string)) continue;
                    element.removeChild(node);
                    this.saveIbmEjbJarBndNeeded = true;
                }
                if (this.saveEjbJarNeeded) {
                    this.saveDocument(document, this.ejbjarFile);
                }
                if (this.saveIbmEjbJarBndNeeded) {
                    this.saveDocument(document2, this.ibmejbjarbndFile);
                }
            }
            catch (XPathExpressionException xPathExpressionException) {
                LOGGER.log(Level.INFO, null, xPathExpressionException);
            }
            catch (XPathFactoryConfigurationException xPathFactoryConfigurationException) {
                LOGGER.log(Level.INFO, null, xPathFactoryConfigurationException);
            }
            catch (TransformerException transformerException) {
                LOGGER.log(Level.INFO, null, transformerException);
            }
            catch (IOException iOException) {
                LOGGER.log(Level.INFO, null, iOException);
            }
        }
    }

    private String getBeanIdFromBinding(Node node, NodeList nodeList) throws XPathFactoryConfigurationException, XPathExpressionException {
        String string = this.getBeanName(node);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string2;
            String string3;
            Node node2 = (Node)this.xpath.compile("./enterpriseBean").evaluate(nodeList.item(i), XPathConstants.NODE);
            Node node3 = node2.getAttributes().getNamedItem("href");
            if (node3 == null || !(string3 = (string2 = node3.getTextContent()).substring(string2.indexOf(EJB_JAR_PREFIX) + EJB_JAR_PREFIX.length(), string2.indexOf("__Bnd__"))).equals(string)) continue;
            return string2.substring(string2.indexOf(EJB_JAR_PREFIX) + EJB_JAR_PREFIX.length());
        }
        return null;
    }

    private String getBeanName(Node node) throws XPathFactoryConfigurationException, XPathExpressionException {
        return ((Node)this.xpath.compile("child::ejb-name").evaluate(node, XPathConstants.NODE)).getTextContent();
    }

    private String getBeanId(Node node) {
        Node node2 = node.getAttributes().getNamedItem("id");
        if (node2 != null) {
            return node2.getTextContent();
        }
        return null;
    }

    private String getBeanType(Node node) throws XPathFactoryConfigurationException, XPathExpressionException {
        if (node.getNodeName().equals("session")) {
            return "ejb:Session";
        }
        if (node.getNodeName().equals("entity")) {
            String string = ((Node)this.xpath.compile("child::persistence-type").evaluate(node, XPathConstants.NODE)).getTextContent();
            if (string.equals("Container")) {
                return "ejb:ContainerManagedEntity";
            }
            return "ejb:BeanManagedEntity";
        }
        if (node.getNodeName().equals("message-driven")) {
            return "ejb:MessageDriven";
        }
        return null;
    }

    private String createBeanId(Node node) throws XPathFactoryConfigurationException, XPathExpressionException {
        String string = this.getBeanName(node);
        return string + "__Bnd__" + new Date().getTime();
    }

    private boolean beanExists(Document document, String string) throws XPathExpressionException, XPathFactoryConfigurationException {
        String string2 = "/ejb-jar/enterprise-beans/*[@id=\"" + string + "\"]";
        Node node = (Node)this.xpath.compile(string2).evaluate(document, XPathConstants.NODE);
        return node != null;
    }

    private String getBindingId(Node node) {
        Node node2 = node.getAttributes().getNamedItem("xmi:id");
        if (node2 != null) {
            return node2.getTextContent();
        }
        return null;
    }

    private boolean bindingExists(Node node, String string) throws XPathFactoryConfigurationException, XPathExpressionException {
        String string2 = "./ejbBindings[@id=\"" + string + "\"]";
        Node node2 = (Node)this.xpath.compile(string2).evaluate(node, XPathConstants.NODE);
        return node2 != null;
    }

    private Node constructBinding(Document document, String string, String string2, String string3) {
        Element element = document.createElement("ejbBindings");
        element.setAttribute("jndiName", "ejb/" + string2);
        element.setAttributeNS("http://www.omg.org/XMI", "xmi:id", string2);
        Element element2 = document.createElement("enterpriseBean");
        element2.setAttribute("href", EJB_JAR_PREFIX + string2);
        element2.setAttributeNS("http://www.omg.org/XMI", "xmi:type", string3);
        element.appendChild(document.createTextNode("\n        "));
        element.appendChild(element2);
        element.appendChild(document.createTextNode("\n"));
        return element;
    }
}

