/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.websphere6.j2ee;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.spi.DeploymentManager;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceCreationException;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.websphere6.WSDeploymentManager;
import org.netbeans.modules.j2ee.websphere6.WSURIManager;

public class DeploymentManagerProperties {
    public static final String USERNAME_ATTR = "username";
    public static final String PASSWORD_ATTR = "password";
    public static final String DISPLAY_NAME_ATTR = "displayName";
    public static final String LOCATION_ATTR = "LOCATION";
    public static final String PORT_ATTR = "port";
    private static final Logger LOGGER = Logger.getLogger(DeploymentManagerProperties.class.getName());
    private final WSDeploymentManager WSDM;
    private InstanceProperties instanceProperties;

    public DeploymentManagerProperties(DeploymentManager deploymentManager) {
        this.WSDM = (WSDeploymentManager)deploymentManager;
        this.instanceProperties = WSURIManager.getInstanceProperties(this.WSDM.getVersion(), this.WSDM.getHost(), this.WSDM.getPort(), this.WSDM.getServerRoot(), this.WSDM.getDomainRoot());
        if (this.instanceProperties == null) {
            try {
                this.instanceProperties = WSURIManager.createInstanceProperties(this.WSDM.getVersion(), this.WSDM.getHost(), this.WSDM.getPort(), this.WSDM.getServerRoot(), this.WSDM.getDomainRoot(), this.WSDM.getUsername(), this.WSDM.getPassword(), this.WSDM.getHost() + ":" + this.WSDM.getPort());
            }
            catch (InstanceCreationException instanceCreationException) {
                LOGGER.log(Level.INFO, null, instanceCreationException);
            }
        }
    }

    public String getPassword() {
        if (this.instanceProperties == null) {
            return null;
        }
        return this.instanceProperties.getProperty(PASSWORD_ATTR);
    }

    public void setPassword(String string) {
        this.instanceProperties.setProperty(PASSWORD_ATTR, string);
    }

    public String getUserName() {
        if (this.instanceProperties == null) {
            return null;
        }
        return this.instanceProperties.getProperty(USERNAME_ATTR);
    }

    public void setUserName(String string) {
        this.instanceProperties.setProperty(USERNAME_ATTR, string);
    }

    public void refreshServerInstance() {
        this.instanceProperties.refreshServerInstance();
    }

    public String getPort() {
        if (this.instanceProperties == null) {
            return "8880";
        }
        return this.instanceProperties.getProperty(PORT_ATTR);
    }

    public void setPort(String string) {
        if (string.trim().matches("[0-9]+")) {
            this.instanceProperties.setProperty(PORT_ATTR, string);
            this.WSDM.setPort(string);
        }
    }

    public String getDisplayName() {
        if (this.instanceProperties == null) {
            return null;
        }
        return this.instanceProperties.getProperty(DISPLAY_NAME_ATTR);
    }

    public String getUrl() {
        if (this.instanceProperties == null) {
            return null;
        }
        return this.instanceProperties.getProperty("url");
    }

    public InstanceProperties getInstanceProperties() {
        return this.instanceProperties;
    }

    public String getServerRoot() {
        return this.WSDM.getServerRoot();
    }

    public void setServerRoot(String string) {
        this.WSDM.setServerRoot(string);
    }

    public String getDomainRoot() {
        return this.WSDM.getDomainRoot();
    }

    public void setDomainRoot(String string) {
        this.WSDM.setDomainRoot(string);
    }

    public void setHost(String string) {
        this.WSDM.setHost(string);
    }

    public void setServerName(String string) {
        this.WSDM.setServerName(string);
    }

    public void setConfigXmlPath(String string) {
        this.WSDM.setConfigXmlPath(string);
    }

    public void setIsLocal(String string) {
        this.WSDM.setIsLocal(string);
    }

    public boolean isLocal() {
        return this.WSDM.isLocal();
    }
}

