/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.websphere6.ui;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.j2ee.deployment.plugins.spi.J2eePlatformImpl;
import org.netbeans.modules.j2ee.websphere6.j2ee.DeploymentManagerProperties;
import org.netbeans.modules.j2ee.websphere6.ui.ConnectionTabVisualPanel;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class Customizer
extends JTabbedPane {
    private static final String CLASSPATH = "classpath";
    private static final String SOURCES = "src";
    private static final String JAVADOC = "javadoc";
    private J2eePlatformImpl platform;
    DeploymentManagerProperties dmp;

    public Customizer(J2eePlatformImpl j2eePlatformImpl, DeploymentManagerProperties deploymentManagerProperties) {
        this.platform = j2eePlatformImpl;
        this.dmp = deploymentManagerProperties;
        this.initComponents();
    }

    private void initComponents() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(Customizer.class, (String)"WS_Customizer"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(Customizer.class, (String)"WS_Customizer"));
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                String string = null;
                switch (Customizer.this.getSelectedIndex()) {
                    case 0: {
                        string = "websphere6_customizer_connection";
                        break;
                    }
                    case 1: {
                        string = "websphere6_customizer_classes";
                        break;
                    }
                    case 2: {
                        string = "websphere6_customizer_sources";
                        break;
                    }
                    case 3: {
                        string = "websphere6_customizer_javadoc";
                    }
                }
                Customizer.this.putClientProperty("HelpID", string);
            }
        });
        this.addTab(NbBundle.getMessage(Customizer.class, (String)"TXT_Connection"), new ConnectionTabVisualPanel(this.dmp));
        this.addTab(NbBundle.getMessage(Customizer.class, (String)"TXT_Classes"), this.createPathTab(CLASSPATH));
        this.addTab(NbBundle.getMessage(Customizer.class, (String)"TXT_Sources"), this.createPathTab(SOURCES));
        this.addTab(NbBundle.getMessage(Customizer.class, (String)"TXT_Javadoc"), this.createPathTab(JAVADOC));
    }

    private JComponent createPathTab(String string) {
        return new PathView(this.platform, string);
    }

    private static class PathModel
    extends AbstractListModel {
        private J2eePlatformImpl platform;
        private String type;
        private List data;

        public PathModel(J2eePlatformImpl j2eePlatformImpl, String string) {
            this.platform = j2eePlatformImpl;
            this.type = string;
        }

        public int getSize() {
            return this.getData().size();
        }

        public Object getElementAt(int n) {
            Serializable serializable;
            List list = this.getData();
            URL uRL = (URL)list.get(n);
            if ("jar".equals(uRL.getProtocol())) {
                serializable = FileUtil.getArchiveFile((URL)uRL);
                if (FileUtil.getArchiveRoot((URL)serializable).equals(uRL)) {
                    uRL = serializable;
                } else {
                    return uRL.toExternalForm();
                }
            }
            if ("file".equals(uRL.getProtocol())) {
                serializable = new File(URI.create(uRL.toExternalForm()));
                return ((File)serializable).getAbsolutePath();
            }
            return uRL.toExternalForm();
        }

        private synchronized List getData() {
            if (this.data == null) {
                this.data = new ArrayList();
                LibraryImplementation[] libraryImplementationArray = this.platform.getLibraries();
                for (int i = 0; i < libraryImplementationArray.length; ++i) {
                    this.data.addAll(libraryImplementationArray[i].getContent(this.type));
                }
            }
            return this.data;
        }
    }

    private static class PathView
    extends JPanel {
        private JList resources;
        private JButton addButton;
        private String type;
        private J2eePlatformImpl platform;

        public PathView(J2eePlatformImpl j2eePlatformImpl, String string) {
            this.type = string;
            this.platform = j2eePlatformImpl;
            this.initComponents();
        }

        private void initComponents() {
            this.setLayout(new GridBagLayout());
            JLabel jLabel = new JLabel();
            String string = null;
            String string2 = null;
            String string3 = null;
            if (this.type.equals(Customizer.CLASSPATH)) {
                string = "TXT_Classes";
                string2 = "MNE_Classes";
                string3 = "AD_Classes";
            } else if (this.type.equals(Customizer.SOURCES)) {
                string = "TXT_Sources";
                string2 = "MNE_Sources";
                string3 = "AD_Sources";
            } else if (this.type.equals(Customizer.JAVADOC)) {
                string = "TXT_Javadoc";
                string2 = "MNE_Javadoc";
                string3 = "AD_Javadoc";
            } else {
                assert (false) : "Illegal type of panel";
                return;
            }
            jLabel.setText(NbBundle.getMessage(Customizer.class, (String)string));
            jLabel.setDisplayedMnemonic(NbBundle.getMessage(Customizer.class, (String)string2).charAt(0));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = -1;
            gridBagConstraints.gridy = -1;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets = new Insets(6, 12, 2, 0);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            ((GridBagLayout)this.getLayout()).setConstraints(jLabel, gridBagConstraints);
            this.add(jLabel);
            this.resources = new JList(new PathModel(this.platform, this.type));
            jLabel.setLabelFor(this.resources);
            this.resources.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(Customizer.class, (String)string3));
            JScrollPane jScrollPane = new JScrollPane(this.resources);
            jScrollPane.setPreferredSize(new Dimension(200, 100));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = -1;
            gridBagConstraints.gridy = -1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 5;
            gridBagConstraints.insets = new Insets(0, 12, 12, 6);
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            ((GridBagLayout)this.getLayout()).setConstraints(jScrollPane, gridBagConstraints);
            this.add(jScrollPane);
        }
    }
}

