/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.websphere6.ui.wizard;

import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.websphere6.WSURIManager;
import org.netbeans.modules.j2ee.websphere6.WSVersion;
import org.netbeans.modules.j2ee.websphere6.ui.wizard.ServerLocationPanel;
import org.netbeans.modules.j2ee.websphere6.ui.wizard.ServerPropertiesPanel;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

public class WSInstantiatingIterator
implements WizardDescriptor.InstantiatingIterator {
    private static final String PROP_DISPLAY_NAME = "ServInstWizard_displayName";
    private static final String DEFAULT_DEBUGGER_PORT = "8787";
    private final WSVersion version;
    private WizardDescriptor wizardDescriptor;
    private String serverRoot;
    private String domainRoot;
    private String isLocal;
    private String host;
    private String port;
    private String username;
    private String password;
    private String serverName;
    private String configXmlPath;
    private String adminPort;
    private String defaultHostPort;
    private Vector steps = new Vector();
    private Vector panels;
    private ServerLocationPanel serverLocationPanel;
    private ServerPropertiesPanel serverPropertiesPanel;
    private int index;
    private Vector listeners;

    public WSInstantiatingIterator(WSVersion wSVersion) {
        this.steps.add(NbBundle.getMessage(ServerPropertiesPanel.class, (String)"SERVER_LOCATION_STEP"));
        this.steps.add(NbBundle.getMessage(ServerPropertiesPanel.class, (String)"SERVER_PROPERTIES_STEP"));
        this.panels = new Vector();
        this.serverLocationPanel = new ServerLocationPanel(this.steps.toArray(new String[this.steps.size()]), 0, new IteratorListener(), this);
        this.serverPropertiesPanel = new ServerPropertiesPanel(this.steps.toArray(new String[this.steps.size()]), 1, new IteratorListener(), this);
        this.panels.add(this.serverLocationPanel);
        this.panels.add(this.serverPropertiesPanel);
        this.listeners = new Vector();
        assert (wSVersion != null) : "Version must not be null";
        this.version = wSVersion;
    }

    public WSVersion getVersion() {
        return this.version;
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.wizardDescriptor = wizardDescriptor;
    }

    public String name() {
        return "";
    }

    public Set instantiate() throws IOException {
        HashSet<InstanceProperties> hashSet = new HashSet<InstanceProperties>();
        String string = WSURIManager.constructUrl(this.version, this.host, this.port, this.serverRoot, this.domainRoot);
        if (this.validate()) {
            InstanceProperties instanceProperties = InstanceProperties.createInstanceProperties((String)string, (String)this.username, (String)this.password, (String)this.getDisplayName());
            instanceProperties.setProperty("serverRoot", this.serverRoot);
            instanceProperties.setProperty("domainRoot", this.domainRoot);
            instanceProperties.setProperty("isLocal", this.isLocal);
            instanceProperties.setProperty("serverName", this.serverName);
            instanceProperties.setProperty("debuggerPort", DEFAULT_DEBUGGER_PORT);
            instanceProperties.setProperty("configXmlPath", this.configXmlPath);
            instanceProperties.setProperty("adminPort", this.adminPort);
            instanceProperties.setProperty("defaultHostPort", this.defaultHostPort);
            hashSet.add(instanceProperties);
            return hashSet;
        }
        return null;
    }

    private boolean validate() {
        try {
            new Socket(this.getHost(), (int)new Integer(this.getPort()));
        }
        catch (UnknownHostException unknownHostException) {
            JOptionPane.showMessageDialog(this.serverPropertiesPanel, NbBundle.getMessage(WSInstantiatingIterator.class, (String)"MSG_unknownHost", (Object)this.getHost()), NbBundle.getMessage(WSInstantiatingIterator.class, (String)"MSG_instanceCreationFailed"), 0);
            return false;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    private String getDisplayName() {
        return (String)this.wizardDescriptor.getProperty(PROP_DISPLAY_NAME);
    }

    public void setServerRoot(String string) {
        this.serverRoot = string;
        this.serverPropertiesPanel.getWizardServerProperties().updateInstancesList(string);
    }

    public String getServerRoot() {
        return this.serverRoot;
    }

    public void setDomainRoot(String string) {
        this.domainRoot = string;
    }

    public String getDomainRoot() {
        return this.domainRoot;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String string) {
        this.port = string;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getIsLocal() {
        return this.isLocal;
    }

    public void setIsLocal(String string) {
        this.isLocal = string;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String string) {
        this.serverName = string;
    }

    public String getConfigXmlPath() {
        return this.configXmlPath;
    }

    public void setConfigXmlPath(String string) {
        this.configXmlPath = string;
    }

    public String getAdminPort() {
        return this.adminPort;
    }

    public void setAdminPort(String string) {
        this.adminPort = string;
    }

    public String getDefaultHostPort() {
        return this.defaultHostPort;
    }

    public void setDefaultHostPort(String string) {
        this.defaultHostPort = string;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public boolean hasNext() {
        return this.index < this.panels.size() - 1;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public WizardDescriptor.Panel current() {
        return (WizardDescriptor.Panel)this.panels.get(this.index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener changeListener) {
        if (this.listeners != null) {
            Vector vector = this.listeners;
            synchronized (vector) {
                this.listeners.remove(changeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener changeListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChangeEvent(ChangeEvent changeEvent) {
        Vector vector;
        Vector vector2 = this.listeners;
        synchronized (vector2) {
            vector = (Vector)this.listeners.clone();
        }
        for (int i = 0; i < vector.size(); ++i) {
            ChangeListener changeListener = (ChangeListener)vector.elementAt(i);
            changeListener.stateChanged(changeEvent);
        }
    }

    private class IteratorListener
    implements ChangeListener {
        private IteratorListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            WSInstantiatingIterator.this.fireChangeEvent(changeEvent);
        }
    }
}

