/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.bindingsupport.template;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.xml.wsdl.bindingsupport.spi.ExtensibilityElementTemplateProvider;
import org.netbeans.modules.xml.wsdl.bindingsupport.template.TemplateGroup;
import org.netbeans.modules.xml.wsdl.bindingsupport.template.localized.LocalizedTemplateGroup;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensibilityElementTemplateFactory {
    private Map<String, TemplateGroup> templateGroupMap;
    private Map<String, ExtensibilityElementTemplateProvider> providerMap;
    private Map<TemplateGroup, LocalizedTemplateGroup> localizedTemplateGroupMap;
    private static ExtensibilityElementTemplateFactory factory;
    private State hasChanged = State.CHANGE_REQUIRED;

    private ExtensibilityElementTemplateFactory() {
        this.initialise();
    }

    public static ExtensibilityElementTemplateFactory getDefault() {
        if (factory == null) {
            ExtensibilityElementTemplateFactory.createFactory();
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void createFactory() {
        Class<ExtensibilityElementTemplateFactory> clazz = ExtensibilityElementTemplateFactory.class;
        synchronized (ExtensibilityElementTemplateFactory.class) {
            if (factory == null) {
                factory = new ExtensibilityElementTemplateFactory();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private void checkUpdates() {
        if (this.hasChanged == State.CHANGE_REQUIRED) {
            this.lookupProviders();
        }
    }

    private void initialise() {
        Lookup.Result result = Lookup.getDefault().lookupResult(ExtensibilityElementTemplateProvider.class);
        result.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent lookupEvent) {
                ExtensibilityElementTemplateFactory.this.hasChanged = State.CHANGE_REQUIRED;
            }
        });
        this.templateGroupMap = new HashMap<String, TemplateGroup>();
        this.providerMap = new HashMap<String, ExtensibilityElementTemplateProvider>();
        this.localizedTemplateGroupMap = new HashMap<TemplateGroup, LocalizedTemplateGroup>();
        this.lookupProviders();
    }

    public TemplateGroup getExtensibilityElementTemplateGroup(String string) {
        this.checkUpdates();
        if (this.templateGroupMap == null || string == null) {
            return null;
        }
        return this.templateGroupMap.get(string);
    }

    public Collection<TemplateGroup> getExtensibilityElementTemplateGroups() {
        this.checkUpdates();
        if (this.templateGroupMap == null) {
            return null;
        }
        return this.templateGroupMap.values();
    }

    public String getLocalizedMessage(String string, String string2, Object[] objectArray) {
        assert (string != null) : "namespace cannot be null";
        assert (string2 != null) : "message key cannot be null";
        this.checkUpdates();
        ExtensibilityElementTemplateProvider extensibilityElementTemplateProvider = this.providerMap.get(string);
        if (extensibilityElementTemplateProvider != null) {
            return extensibilityElementTemplateProvider.getLocalizedMessage(string2, objectArray);
        }
        return null;
    }

    public LocalizedTemplateGroup getLocalizedTemplateGroup(TemplateGroup templateGroup) {
        this.checkUpdates();
        String string = templateGroup.getNamespace();
        ExtensibilityElementTemplateProvider extensibilityElementTemplateProvider = this.providerMap.get(string);
        assert (extensibilityElementTemplateProvider != null) : "ExtensibilityElementTemplateProvider cannot be null";
        LocalizedTemplateGroup localizedTemplateGroup = this.localizedTemplateGroupMap.get(templateGroup);
        if (localizedTemplateGroup == null) {
            localizedTemplateGroup = new LocalizedTemplateGroup(templateGroup, extensibilityElementTemplateProvider);
            this.localizedTemplateGroupMap.put(templateGroup, localizedTemplateGroup);
        }
        return localizedTemplateGroup;
    }

    private synchronized void lookupProviders() {
        if (this.hasChanged == State.CHANGE_COMPLETED) {
            return;
        }
        this.hasChanged = State.CHANGING;
        this.localizedTemplateGroupMap.clear();
        this.providerMap.clear();
        this.templateGroupMap.clear();
        for (ExtensibilityElementTemplateProvider extensibilityElementTemplateProvider : Lookup.getDefault().lookupAll(ExtensibilityElementTemplateProvider.class)) {
            InputStream inputStream = extensibilityElementTemplateProvider.getTemplateInputStream();
            if (inputStream == null) continue;
            try {
                TemplateGroup templateGroup = TemplateGroup.read(inputStream);
                this.templateGroupMap.put(templateGroup.getNamespace(), templateGroup);
                this.providerMap.put(templateGroup.getNamespace(), extensibilityElementTemplateProvider);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                ErrorManager.getDefault().notify((Throwable)parserConfigurationException);
            }
            catch (SAXException sAXException) {
                ErrorManager.getDefault().notify((Throwable)sAXException);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
        if (this.hasChanged == State.CHANGING) {
            this.hasChanged = State.CHANGE_COMPLETED;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        CHANGE_REQUIRED,
        CHANGING,
        CHANGE_COMPLETED;

    }
}

