/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.spi;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.modules.websvc.wsitconf.spi.SecurityProfile;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityProfileRegistry {
    private static SecurityProfileRegistry instance;
    private Map<String, SecurityProfile> profiles = Collections.synchronizedMap(new HashMap());

    private SecurityProfileRegistry() {
    }

    public static SecurityProfileRegistry getDefault() {
        if (instance == null) {
            instance = new SecurityProfileRegistry();
            instance.populateRegistry();
        }
        return instance;
    }

    public SecurityProfile getProfile(String string) {
        return this.profiles.get(string);
    }

    public void register(SecurityProfile securityProfile) {
        this.profiles.put(securityProfile.getDisplayName(), securityProfile);
    }

    public void unregister(SecurityProfile securityProfile) {
        this.profiles.remove(securityProfile.getDisplayName());
    }

    public void unregister(String string) {
        this.profiles.remove(string);
    }

    public Set<SecurityProfile> getSecurityProfiles() {
        TreeSet<SecurityProfile> treeSet = new TreeSet<SecurityProfile>(new Comparator<SecurityProfile>(){

            @Override
            public int compare(SecurityProfile securityProfile, SecurityProfile securityProfile2) {
                Integer n = securityProfile.getId();
                Integer n2 = securityProfile2.getId();
                return n.compareTo(n2);
            }
        });
        treeSet.addAll(this.profiles.values());
        return Collections.unmodifiableSet(Collections.synchronizedSortedSet(treeSet));
    }

    private final SecurityProfileRegistry populateRegistry() {
        SecurityProfileRegistry securityProfileRegistry = SecurityProfileRegistry.getDefault();
        if (securityProfileRegistry.getSecurityProfiles().isEmpty()) {
            Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(SecurityProfile.class));
            Collection collection = result.allInstances();
            for (SecurityProfile securityProfile : collection) {
                securityProfileRegistry.register(securityProfile);
            }
        }
        return securityProfileRegistry;
    }
}

