/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.service.profiles;

import java.awt.Dialog;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoManager;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.wsitconf.spi.features.ClientDefaultsFeature;
import org.netbeans.modules.websvc.wsitconf.spi.features.SecureConversationFeature;
import org.netbeans.modules.websvc.wsitconf.spi.features.ServiceDefaultsFeature;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.ui.service.profiles.MessageAuthentication;
import org.netbeans.modules.websvc.wsitconf.ui.service.profiles.ProfileBase;
import org.netbeans.modules.websvc.wsitconf.util.UndoCounter;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.AlgoSuiteModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.PolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProfilesModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProprietarySecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.RMModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityTokensModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.policy.Policy;
import org.netbeans.modules.websvc.wsitmodelext.policy.PolicyQName;
import org.netbeans.modules.websvc.wsitmodelext.security.BootstrapPolicy;
import org.netbeans.modules.websvc.wsitmodelext.security.SecurityPolicyQName;
import org.netbeans.modules.websvc.wsitmodelext.security.TransportBinding;
import org.netbeans.modules.websvc.wsitmodelext.security.TrustElement;
import org.netbeans.modules.websvc.wsitmodelext.security.WssElement;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;

public class MessageAuthenticationProfile
extends ProfileBase
implements SecureConversationFeature,
ClientDefaultsFeature,
ServiceDefaultsFeature {
    private static final String DEFAULT_USERNAME = "wsit";
    private static final String DEFAULT_PASSWORD = "wsitPassword";

    public int getId() {
        return 40;
    }

    public String getDisplayName() {
        return ComboConstants.PROF_MSGAUTHSSL;
    }

    public String getDescription() {
        return ComboConstants.PROF_MSGAUTHSSL_INFO;
    }

    public boolean isCurrentProfile(WSDLComponent wSDLComponent) {
        return this.getDisplayName().equals(ProfilesModelHelper.getWSITSecurityProfile(wSDLComponent));
    }

    public void displayConfig(WSDLComponent wSDLComponent, UndoManager undoManager) {
        UndoCounter undoCounter = new UndoCounter();
        WSDLModel wSDLModel = wSDLComponent.getModel();
        wSDLModel.addUndoableEditListener((UndoableEditListener)undoCounter);
        MessageAuthentication messageAuthentication = new MessageAuthentication(wSDLComponent, this);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)messageAuthentication, this.getDisplayName());
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.CANCEL_OPTION) {
            for (int i = 0; i < undoCounter.getCounter(); ++i) {
                if (!undoManager.canUndo()) continue;
                undoManager.undo();
            }
        }
        wSDLModel.removeUndoableEditListener((UndoableEditListener)undoCounter);
    }

    public void setServiceDefaults(WSDLComponent wSDLComponent, Project project) {
        ProprietarySecurityPolicyModelHelper.setStoreLocation(wSDLComponent, null, false, false);
        ProprietarySecurityPolicyModelHelper.setStoreLocation(wSDLComponent, null, true, false);
    }

    public void setClientDefaults(WSDLComponent wSDLComponent, WSDLComponent wSDLComponent2, Project project) {
        ProprietarySecurityPolicyModelHelper.setStoreLocation(wSDLComponent, null, false, true);
        ProprietarySecurityPolicyModelHelper.setStoreLocation(wSDLComponent, null, true, true);
        ProprietarySecurityPolicyModelHelper.removeCallbackHandlerConfiguration((Binding)wSDLComponent);
        ProprietarySecurityPolicyModelHelper.setCallbackHandler((Binding)wSDLComponent, "usernameHandler", null, DEFAULT_USERNAME, true);
        ProprietarySecurityPolicyModelHelper.setCallbackHandler((Binding)wSDLComponent, "passwordHandler", null, DEFAULT_PASSWORD, true);
    }

    public boolean isServiceDefaultSetupUsed(WSDLComponent wSDLComponent, Project project) {
        String string = ProprietarySecurityPolicyModelHelper.getStoreAlias(wSDLComponent, false);
        String string2 = ProprietarySecurityPolicyModelHelper.getStoreAlias(wSDLComponent, true);
        String string3 = ProprietarySecurityPolicyModelHelper.getStoreLocation(wSDLComponent, true);
        String string4 = ProprietarySecurityPolicyModelHelper.getStoreLocation(wSDLComponent, false);
        String string5 = ProprietarySecurityPolicyModelHelper.getStorePassword(wSDLComponent, false);
        String string6 = ProprietarySecurityPolicyModelHelper.getStorePassword(wSDLComponent, true);
        return string == null && string2 == null && string3 == null && string4 == null && string6 == null && string5 == null;
    }

    public boolean isClientDefaultSetupUsed(WSDLComponent wSDLComponent, Binding binding, Project project) {
        if (ProprietarySecurityPolicyModelHelper.getCBHConfiguration((Binding)wSDLComponent) != null) {
            return false;
        }
        String string = ProprietarySecurityPolicyModelHelper.getStoreLocation(wSDLComponent, true);
        String string2 = ProprietarySecurityPolicyModelHelper.getStoreLocation(wSDLComponent, false);
        String string3 = ProprietarySecurityPolicyModelHelper.getStorePassword(wSDLComponent, false);
        String string4 = ProprietarySecurityPolicyModelHelper.getStorePassword(wSDLComponent, true);
        String string5 = ProprietarySecurityPolicyModelHelper.getStoreAlias(wSDLComponent, false);
        String string6 = ProprietarySecurityPolicyModelHelper.getStoreAlias(wSDLComponent, true);
        if (string5 == null && string6 == null && string == null && string2 == null && string4 == null && string3 == null) {
            String string7 = ProprietarySecurityPolicyModelHelper.getDefaultUsername((Binding)wSDLComponent);
            String string8 = ProprietarySecurityPolicyModelHelper.getDefaultPassword((Binding)wSDLComponent);
            if (DEFAULT_PASSWORD.equals(string8) && DEFAULT_USERNAME.equals(string7) && string == null && string4 == null && string3 != null && string2 == null) {
                return true;
            }
        }
        return false;
    }

    public boolean isSecureConversation(WSDLComponent wSDLComponent) {
        WSDLComponent wSDLComponent2 = SecurityTokensModelHelper.getSupportingToken(wSDLComponent, 2);
        return wSDLComponent2 != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableSecureConversation(WSDLComponent wSDLComponent, boolean bl) {
        if (bl) {
            WSDLModel wSDLModel = wSDLComponent.getModel();
            boolean bl2 = wSDLModel.isIntransaction();
            if (!bl2) {
                wSDLModel.startTransaction();
            }
            try {
                SecurityPolicyModelHelper.enableTrust10(wSDLComponent);
                SecurityTokensModelHelper.removeSupportingTokens(wSDLComponent);
                WSDLComponent wSDLComponent2 = SecurityTokensModelHelper.setSupportingTokens(wSDLComponent, ComboConstants.SECURECONVERSATION, 2);
                Policy policy = (Policy)PolicyModelHelper.createElement(wSDLComponent2, PolicyQName.POLICY.getQName(), Policy.class, false);
                BootstrapPolicy bootstrapPolicy = (BootstrapPolicy)PolicyModelHelper.createElement((WSDLComponent)policy, SecurityPolicyQName.BOOTSTRAPPOLICY.getQName(), BootstrapPolicy.class, false);
                policy = (Policy)PolicyModelHelper.createElement((WSDLComponent)bootstrapPolicy, PolicyQName.POLICY.getQName(), Policy.class, false);
                TransportBinding transportBinding = (TransportBinding)PolicyModelHelper.createElement((WSDLComponent)policy, SecurityPolicyQName.TRANSPORTBINDING.getQName(), TransportBinding.class, false);
                boolean bl3 = RMModelHelper.isRMEnabled(wSDLComponent);
                SecurityPolicyModelHelper.setDefaultTargets((WSDLComponent)policy, true, bl3);
                SecurityTokensModelHelper.setTokenType((WSDLComponent)transportBinding, ComboConstants.TRANSPORT, ComboConstants.HTTPS);
                SecurityPolicyModelHelper.setLayout((WSDLComponent)transportBinding, ComboConstants.STRICT);
                SecurityPolicyModelHelper.enableIncludeTimestamp((WSDLComponent)transportBinding, true);
                AlgoSuiteModelHelper.setAlgorithmSuite((WSDLComponent)transportBinding, ComboConstants.BASIC128);
                SecurityTokensModelHelper.setSupportingTokens((WSDLComponent)policy, ComboConstants.USERNAME, 1);
                WssElement wssElement = SecurityPolicyModelHelper.enableWss((WSDLComponent)bootstrapPolicy, true);
                SecurityPolicyModelHelper.enableMustSupportRefKeyIdentifier(wssElement, true);
                SecurityPolicyModelHelper.enableMustSupportRefIssuerSerial(wssElement, true);
                SecurityPolicyModelHelper.enableMustSupportRefThumbprint(wssElement, true);
                SecurityPolicyModelHelper.enableMustSupportRefEncryptedKey(wssElement, true);
                TrustElement trustElement = SecurityPolicyModelHelper.enableTrust10((WSDLComponent)bootstrapPolicy);
                SecurityPolicyModelHelper.enableMustSupportIssuedTokens(trustElement, true);
                SecurityPolicyModelHelper.enableRequireClientEntropy(trustElement, true);
                SecurityPolicyModelHelper.enableRequireServerEntropy(trustElement, true);
            }
            finally {
                if (!bl2) {
                    wSDLModel.endTransaction();
                }
            }
        } else {
            SecurityTokensModelHelper.removeSupportingTokens(wSDLComponent);
            SecurityTokensModelHelper.setSupportingTokens(wSDLComponent, ComboConstants.USERNAME, 1);
        }
    }
}

