/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.service.subpanels;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.RMMSModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.RMModelHelper;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.openide.util.NbBundle;

public class AdvancedRMPanel
extends JPanel {
    private Binding binding;
    private boolean inSync = false;
    private DefaultFormatterFactory inactff = null;
    private DefaultFormatterFactory maxBufff = null;
    private JCheckBox flowControlChBox;
    private JLabel inactivityTimeoutLabel;
    private JFormattedTextField inactivityTimeoutTextfield;
    private JLabel maxBufLabel;
    private JFormattedTextField maxBufTextField;

    public AdvancedRMPanel(Binding binding) {
        this.binding = binding;
        this.inactff = new DefaultFormatterFactory();
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        numberFormat.setGroupingUsed(false);
        NumberFormatter numberFormatter = new NumberFormatter(numberFormat);
        numberFormat.setMaximumIntegerDigits(8);
        numberFormatter.setCommitsOnValidEdit(true);
        numberFormatter.setMinimum(Integer.valueOf(0));
        numberFormatter.setMaximum(Integer.valueOf(99999999));
        this.inactff.setDefaultFormatter(numberFormatter);
        this.maxBufff = new DefaultFormatterFactory();
        NumberFormat numberFormat2 = NumberFormat.getIntegerInstance();
        numberFormat2.setGroupingUsed(false);
        NumberFormatter numberFormatter2 = new NumberFormatter(numberFormat2);
        numberFormat2.setMaximumIntegerDigits(8);
        numberFormatter2.setCommitsOnValidEdit(true);
        numberFormatter2.setMinimum(Integer.valueOf(0));
        numberFormatter2.setMaximum(Integer.valueOf(99999999));
        this.maxBufff.setDefaultFormatter(numberFormatter2);
        this.initComponents();
        this.sync();
    }

    private void sync() {
        this.inSync = true;
        String string = RMModelHelper.getInactivityTimeout(this.binding);
        if (string == null) {
            this.setInactivityTimeout("600000");
        } else {
            this.setInactivityTimeout(string);
        }
        String string2 = RMMSModelHelper.getMaxReceiveBufferSize(this.binding);
        if (string2 == null) {
            this.setMaxRcvBufferSize("32");
        } else {
            this.setMaxRcvBufferSize(string2);
        }
        this.setFlowControl(RMMSModelHelper.isFlowControlEnabled(this.binding));
        this.enableDisable();
        this.inSync = false;
    }

    private Number getMaxRcvBufferSize() {
        return (Number)this.maxBufTextField.getValue();
    }

    private void setMaxRcvBufferSize(String string) {
        this.maxBufTextField.setText(string);
    }

    private Number getInactivityTimeout() {
        return (Number)this.inactivityTimeoutTextfield.getValue();
    }

    private void setInactivityTimeout(String string) {
        this.inactivityTimeoutTextfield.setText(string);
    }

    private void setFlowControl(Boolean bl) {
        if (bl == null) {
            this.flowControlChBox.setSelected(false);
        } else {
            this.flowControlChBox.setSelected(bl);
        }
    }

    public Boolean getFlowControl() {
        if (this.flowControlChBox.isSelected()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void storeState() {
        Number number;
        if (this.flowControlChBox.isSelected()) {
            if (!RMMSModelHelper.isFlowControlEnabled(this.binding)) {
                RMMSModelHelper.enableFlowControl(this.binding);
            }
        } else if (RMMSModelHelper.isFlowControlEnabled(this.binding)) {
            RMMSModelHelper.disableFlowControl(this.binding);
        }
        if ((number = this.getInactivityTimeout()) == null || "600000".equals(number.toString())) {
            RMModelHelper.setInactivityTimeout(this.binding, null);
        } else {
            RMModelHelper.setInactivityTimeout(this.binding, number.toString());
        }
        Number number2 = this.getMaxRcvBufferSize();
        if (number2 == null || "32".equals(number2.toString())) {
            RMMSModelHelper.setMaxReceiveBufferSize(this.binding, null);
        } else {
            RMMSModelHelper.setMaxReceiveBufferSize(this.binding, number2.toString());
        }
    }

    private void enableDisable() {
        boolean bl = this.flowControlChBox.isSelected();
        this.maxBufLabel.setEnabled(bl);
        this.maxBufTextField.setEnabled(bl);
    }

    private void initComponents() {
        this.flowControlChBox = new JCheckBox();
        this.maxBufLabel = new JLabel();
        this.inactivityTimeoutLabel = new JLabel();
        this.inactivityTimeoutTextfield = new JFormattedTextField();
        this.maxBufTextField = new JFormattedTextField();
        this.flowControlChBox.setText(NbBundle.getMessage(AdvancedRMPanel.class, (String)"LBL_AdvancedRM_FlowControlChBox"));
        this.flowControlChBox.setMargin(new Insets(0, 0, 0, 0));
        this.flowControlChBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedRMPanel.this.flowControlChBoxActionPerformed(actionEvent);
            }
        });
        this.maxBufLabel.setText(NbBundle.getMessage(AdvancedRMPanel.class, (String)"LBL_AdvancedRM_maxBufLabel"));
        this.inactivityTimeoutLabel.setText(NbBundle.getMessage(AdvancedRMPanel.class, (String)"LBL_AdvancedRM_InactivityTimeoutLabel"));
        this.inactivityTimeoutTextfield.setFormatterFactory(this.inactff);
        this.maxBufTextField.setColumns(8);
        this.maxBufTextField.setFormatterFactory(this.maxBufff);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.maxBufLabel).add((Component)this.inactivityTimeoutLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.inactivityTimeoutTextfield, -1, 97, Short.MAX_VALUE).add((Component)this.maxBufTextField, -1, 97, Short.MAX_VALUE))).add((Component)this.flowControlChBox)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(17, 17, 17).add((Component)this.flowControlChBox).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.maxBufLabel).add((Component)this.maxBufTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.inactivityTimeoutLabel).add((Component)this.inactivityTimeoutTextfield, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.flowControlChBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdvancedRMPanel.class, (String)"LBL_AdvancedRM_FlowControl_ACSD"));
        this.maxBufLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdvancedRMPanel.class, (String)"LBL_AdvancedRM_MaxFlowBufSize_ACSD"));
        this.inactivityTimeoutLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdvancedRMPanel.class, (String)"LBL_AdvancedRM_InactTimeout_ACSD"));
        this.inactivityTimeoutTextfield.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AdvancedRMPanel.class, (String)"TXT_AdvancedRM_InactTimeout_ACSN"));
        this.inactivityTimeoutTextfield.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdvancedRMPanel.class, (String)"TXT_AdvancedRM_InactTimeout_ACSD"));
        this.maxBufTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AdvancedRMPanel.class, (String)"TXT_AdvancedRM_MaxBuf_ACSN"));
        this.maxBufTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdvancedRMPanel.class, (String)"TXT_AdvancedRM_MaxBuf_ACSD"));
    }

    private void flowControlChBoxActionPerformed(ActionEvent actionEvent) {
        this.enableDisable();
    }
}

