/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.service.subpanels;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.wsitconf.ui.ClassDialog;
import org.netbeans.modules.websvc.wsitconf.ui.StoreFileFilter;
import org.netbeans.modules.websvc.wsitconf.util.Util;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProprietarySecurityPolicyModelHelper;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class KeystorePanel
extends JPanel {
    public static final String PKCS12 = "PKCS12";
    public static final String JKS = "JKS";
    public static final String DEFAULT_PASSWORD = "changeit";
    public static final String DEFAULT_PASSWORD2 = "adminadmin";
    private WSDLComponent comp;
    private boolean jsr109 = false;
    private Project project = null;
    private boolean client;
    private String keystoreType = "JKS";
    private boolean inSync = false;
    String keyStoreLocation = null;
    String ksType = null;
    String keyStorePassword = null;
    String keyStoreAlias = null;
    String keyPassword = null;
    String aliasSelector = null;
    private JButton aliasSelectorButton;
    private JTextField aliasSelectorField;
    private JLabel aliasSelectorLbl;
    private JComboBox keyAliasCombo;
    private JLabel keyAliasLabel;
    private JPasswordField keyPasswordField;
    private JLabel keyPasswordLabel;
    private JButton keystoreLocationButton;
    private JLabel keystoreLocationLabel;
    private JTextField keystoreLocationTextField;
    private JPasswordField keystorePasswordField;
    private JLabel keystorePasswordLabel;
    private JButton loadkeysButton;

    public KeystorePanel(WSDLComponent wSDLComponent, Project project, boolean bl, boolean bl2) {
        this.comp = wSDLComponent;
        this.jsr109 = bl;
        this.project = project;
        this.client = bl2;
        this.initComponents();
        this.keyAliasCombo.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.keyAliasLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.keyPasswordLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.keyPasswordField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.keystoreLocationLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.keystoreLocationTextField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.keystorePasswordLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.keystorePasswordField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.aliasSelectorLbl.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.aliasSelectorField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.sync();
    }

    private String getKeystoreAlias() {
        return (String)this.keyAliasCombo.getSelectedItem();
    }

    private void setKeystoreAlias(String string) {
        this.keyAliasCombo.setSelectedItem(string);
    }

    private String getKeyPassword() {
        return String.valueOf(this.keyPasswordField.getPassword());
    }

    private void setKeyPassword(String string) {
        this.keyPasswordField.setText(string);
    }

    private String getSelector() {
        String string = this.aliasSelectorField.getText();
        if ("".equals(string) || string == null) {
            return null;
        }
        return string;
    }

    private void setSelector(String string) {
        this.aliasSelectorField.setText(string);
    }

    private char[] getCharKeystorePassword() {
        return this.keystorePasswordField.getPassword();
    }

    private String getKeystorePassword() {
        return String.valueOf(this.keystorePasswordField.getPassword());
    }

    private void setKeystorePassword(String string) {
        this.keystorePasswordField.setText(string);
    }

    private void setKeystorePath(String string) {
        this.keystoreLocationTextField.setText(string);
    }

    private String getKeystorePath() {
        String string = this.keystoreLocationTextField.getText();
        if ("".equals(string) || string == null) {
            return null;
        }
        return string;
    }

    private void setKeystoreType(String string) {
        this.keystoreType = string;
    }

    public void sync() {
        this.inSync = true;
        this.keyStoreLocation = ProprietarySecurityPolicyModelHelper.getStoreLocation(this.comp, false);
        if (this.keyStoreLocation != null) {
            this.setKeystorePath(this.keyStoreLocation);
        } else if (this.jsr109) {
            this.setKeystorePath(Util.getStoreLocation(this.project, false, this.client));
        }
        this.ksType = ProprietarySecurityPolicyModelHelper.getStoreType(this.comp, false);
        if (this.ksType != null) {
            this.setKeystoreType(this.ksType);
        }
        this.keyStorePassword = ProprietarySecurityPolicyModelHelper.getStorePassword(this.comp, false);
        if (this.keyStorePassword != null) {
            this.setKeystorePassword(this.keyStorePassword);
            this.reloadAliases();
        } else if (this.jsr109) {
            this.keyStorePassword = DEFAULT_PASSWORD;
            this.setKeystorePassword(DEFAULT_PASSWORD);
            if (!this.reloadAliases()) {
                String string;
                this.keyStorePassword = string = Util.getPassword(this.project);
                this.setKeystorePassword(this.keyStorePassword);
            }
            if (!this.reloadAliases()) {
                this.keyStorePassword = "";
                this.setKeystorePassword("");
            }
        }
        this.keyStoreAlias = ProprietarySecurityPolicyModelHelper.getStoreAlias(this.comp, false);
        this.setKeystoreAlias(this.keyStoreAlias);
        this.keyPassword = ProprietarySecurityPolicyModelHelper.getKeyPassword(this.comp);
        if (this.keyPassword != null) {
            this.setKeyPassword(this.keyPassword);
        }
        this.aliasSelector = ProprietarySecurityPolicyModelHelper.getAliasSelector(this.comp);
        if (this.aliasSelector != null) {
            this.setSelector(this.aliasSelector);
        }
        this.enableDisable();
        this.inSync = false;
    }

    private void enableDisable() {
    }

    public void storeState() {
        String string = this.getKeystoreAlias();
        if (string == null || string.length() == 0) {
            ProprietarySecurityPolicyModelHelper.setKeyStoreAlias(this.comp, null, this.client);
        } else {
            ProprietarySecurityPolicyModelHelper.setKeyStoreAlias(this.comp, string, this.client);
        }
        String string2 = this.getKeyPassword();
        String string3 = this.getKeystorePassword();
        String string4 = this.getKeystorePath();
        if (string2 == null || string2.length() == 0) {
            ProprietarySecurityPolicyModelHelper.setKeyPassword(this.comp, null, this.client);
        } else {
            ProprietarySecurityPolicyModelHelper.setKeyPassword(this.comp, string2, this.client);
        }
        if (string3 == null || string3.length() == 0) {
            ProprietarySecurityPolicyModelHelper.setStorePassword(this.comp, null, false, this.client);
        } else {
            ProprietarySecurityPolicyModelHelper.setStorePassword(this.comp, string3, false, this.client);
        }
        ProprietarySecurityPolicyModelHelper.setStoreType(this.comp, this.keystoreType, false, this.client);
        ProprietarySecurityPolicyModelHelper.setStoreLocation(this.comp, string4, false, this.client);
        String string5 = this.getSelector();
        ProprietarySecurityPolicyModelHelper.setAliasSelector(this.comp, string5, false);
    }

    private void initComponents() {
        this.keystoreLocationLabel = new JLabel();
        this.keystorePasswordLabel = new JLabel();
        this.keystoreLocationTextField = new JTextField();
        this.keystoreLocationButton = new JButton();
        this.keyAliasLabel = new JLabel();
        this.keyPasswordLabel = new JLabel();
        this.keyAliasCombo = new JComboBox();
        this.keystorePasswordField = new JPasswordField();
        this.keyPasswordField = new JPasswordField();
        this.loadkeysButton = new JButton();
        this.aliasSelectorLbl = new JLabel();
        this.aliasSelectorField = new JTextField();
        this.aliasSelectorButton = new JButton();
        Mnemonics.setLocalizedText((JLabel)this.keystoreLocationLabel, (String)NbBundle.getMessage(KeystorePanel.class, (String)"LBL_KeyStorePanel_LocationLabel"));
        Mnemonics.setLocalizedText((JLabel)this.keystorePasswordLabel, (String)NbBundle.getMessage(KeystorePanel.class, (String)"LBL_StorePanel_StorePassword"));
        Mnemonics.setLocalizedText((AbstractButton)this.keystoreLocationButton, (String)NbBundle.getMessage(KeystorePanel.class, (String)"LBL_KeystorePanel_Browse"));
        this.keystoreLocationButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KeystorePanel.this.keystoreLocationButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.keyAliasLabel, (String)NbBundle.getMessage(KeystorePanel.class, (String)"LBL_KeyStorePanel_KeyAliasLabel"));
        Mnemonics.setLocalizedText((JLabel)this.keyPasswordLabel, (String)NbBundle.getMessage(KeystorePanel.class, (String)"LBL_Keystore_KeyPasswordLabel"));
        this.keyAliasCombo.setEditable(true);
        Mnemonics.setLocalizedText((AbstractButton)this.loadkeysButton, (String)NbBundle.getMessage(KeystorePanel.class, (String)"LBL_LoadKeys"));
        this.loadkeysButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KeystorePanel.this.loadkeysButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.aliasSelectorLbl, (String)NbBundle.getMessage(KeystorePanel.class, (String)"LBL_Keystore_KeySelectorLabel"));
        Mnemonics.setLocalizedText((AbstractButton)this.aliasSelectorButton, (String)NbBundle.getMessage(KeystorePanel.class, (String)"LBL_KeystorePanel_Browse"));
        this.aliasSelectorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KeystorePanel.this.aliasSelectorButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.keystoreLocationLabel).add((Component)this.keystorePasswordLabel).add((Component)this.keyAliasLabel).add((Component)this.keyPasswordLabel).add((Component)this.aliasSelectorLbl)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.keystoreLocationTextField, -1, 257, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.keystoreLocationButton).addPreferredGap(0)).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.keyAliasCombo, 0, 169, Short.MAX_VALUE).add((Component)this.keystorePasswordField, -1, 169, Short.MAX_VALUE).add(1, (Component)this.keyPasswordField, -1, 169, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.loadkeysButton).add(68, 68, 68)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.aliasSelectorField, -1, 257, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.aliasSelectorButton))).add(4, 4, 4)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.keystoreLocationLabel).add((Component)this.keystoreLocationButton).add((Component)this.keystoreLocationTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.keystorePasswordLabel).add((Component)this.keystorePasswordField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.keyAliasLabel).add((Component)this.keyAliasCombo, -2, -1, -2).add((Component)this.loadkeysButton)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.keyPasswordLabel).add((Component)this.keyPasswordField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.aliasSelectorLbl).add((Component)this.aliasSelectorField, -2, -1, -2).add((Component)this.aliasSelectorButton)).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.linkSize(new Component[]{this.keyAliasCombo, this.keyPasswordField, this.keystoreLocationTextField, this.keystorePasswordField}, 2);
    }

    private void loadkeysButtonActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.reloadAliases();
        if (!bl) {
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(KeystorePanel.class, (String)"MSG_WrongPassword")));
        }
    }

    private void keystoreLocationButtonActionPerformed(ActionEvent actionEvent) {
        File file;
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setDialogTitle(NbBundle.getMessage(KeystorePanel.class, (String)"LBL_KeystoreBrowse_Title"));
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setFileFilter(new StoreFileFilter());
        File file2 = new File(this.keystoreLocationTextField.getText());
        if (file2 != null && file2.exists()) {
            if (file2.isDirectory()) {
                jFileChooser.setCurrentDirectory(file2);
            } else {
                jFileChooser.setCurrentDirectory(file2.getParentFile());
            }
        }
        if (jFileChooser.showOpenDialog(this) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
            this.setKeystorePath(file.getPath());
            String string = FileUtil.getExtension((String)file.getName());
            this.keystoreType = "jks".equals(string) ? JKS : PKCS12;
        }
    }

    private void aliasSelectorButtonActionPerformed(ActionEvent actionEvent) {
        block1: {
            Set<String> set;
            Iterator<String> iterator;
            if (this.project == null) break block1;
            ClassDialog classDialog = new ClassDialog(this.project, "com.sun.xml.wss.AliasSelector");
            classDialog.show();
            if (classDialog.okButtonPressed() && (iterator = (set = classDialog.getSelectedClasses()).iterator()).hasNext()) {
                String string = iterator.next();
                this.setSelector(string);
                ProprietarySecurityPolicyModelHelper.setAliasSelector(this.comp, string, false);
            }
        }
    }

    private boolean reloadAliases() {
        List<String> list;
        try {
            list = Util.getAliases(this.getKeystorePath(), this.getCharKeystorePassword(), this.keystoreType);
        }
        catch (IOException iOException) {
            return false;
        }
        this.keyAliasCombo.removeAllItems();
        if (list != null) {
            this.keyAliasCombo.addItem("");
            for (String string : list) {
                this.keyAliasCombo.addItem(string);
            }
            if (this.keyAliasCombo.getItemCount() > 1) {
                this.keyAliasCombo.setSelectedIndex(1);
            }
        }
        return true;
    }
}

