/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.wsdlmodelext;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.dd.api.web.AuthConstraint;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.SecurityConstraint;
import org.netbeans.modules.j2ee.dd.api.web.UserDataConstraint;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.dd.api.web.WebResourceCollection;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.websvc.wsitconf.spi.SecurityProfile;
import org.netbeans.modules.websvc.wsitconf.spi.SecurityProfileRegistry;
import org.netbeans.modules.websvc.wsitconf.spi.features.ClientDefaultsFeature;
import org.netbeans.modules.websvc.wsitconf.spi.features.ServiceDefaultsFeature;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.util.Util;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.AlgoSuiteModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.PolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.RMModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityTokensModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.addressing.Address;
import org.netbeans.modules.websvc.wsitmodelext.addressing.Address10;
import org.netbeans.modules.websvc.wsitmodelext.policy.All;
import org.netbeans.modules.websvc.wsitmodelext.policy.Policy;
import org.netbeans.modules.websvc.wsitmodelext.policy.PolicyQName;
import org.netbeans.modules.websvc.wsitmodelext.security.AsymmetricBinding;
import org.netbeans.modules.websvc.wsitmodelext.security.BootstrapPolicy;
import org.netbeans.modules.websvc.wsitmodelext.security.SecurityPolicyQName;
import org.netbeans.modules.websvc.wsitmodelext.security.SymmetricBinding;
import org.netbeans.modules.websvc.wsitmodelext.security.TransportBinding;
import org.netbeans.modules.websvc.wsitmodelext.security.Trust10;
import org.netbeans.modules.websvc.wsitmodelext.security.TrustElement;
import org.netbeans.modules.websvc.wsitmodelext.security.Wss10;
import org.netbeans.modules.websvc.wsitmodelext.security.Wss11;
import org.netbeans.modules.websvc.wsitmodelext.security.WssElement;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.InitiatorToken;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.ProtectionToken;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.RecipientToken;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.SecureConversationToken;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingInput;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.BindingOutput;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.Port;
import org.netbeans.modules.xml.wsdl.model.Service;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLComponentFactory;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPAddress;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Referenceable;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ProfilesModelHelper {
    public static final String XWS_SECURITY_SERVER = "xws-security-server";
    public static final String XWS_SECURITY_CLIENT = "xws-security-client";
    public static final String WSSIP = "wssip";
    public static final String DEFAULT_PASSWORD = "wsit";
    public static final String DEFAULT_USERNAME = "wsit";
    private static final Logger logger = Logger.getLogger(ProfilesModelHelper.class.getName());

    public static boolean isSSLProfile(String string) {
        return ComboConstants.PROF_MSGAUTHSSL.equals(string) || ComboConstants.PROF_SAMLSSL.equals(string) || ComboConstants.PROF_TRANSPORT.equals(string);
    }

    public static String getSecurityProfile(WSDLComponent wSDLComponent) {
        assert (wSDLComponent instanceof BindingOperation || wSDLComponent instanceof Binding);
        Set<SecurityProfile> set = SecurityProfileRegistry.getDefault().getSecurityProfiles();
        for (SecurityProfile securityProfile : set) {
            if (!securityProfile.isCurrentProfile(wSDLComponent)) continue;
            return securityProfile.getDisplayName();
        }
        return ComboConstants.PROF_GENERIC;
    }

    public static boolean isSCEnabled(WSDLComponent wSDLComponent) {
        assert (wSDLComponent instanceof BindingOperation || wSDLComponent instanceof Binding);
        Policy policy = PolicyModelHelper.getPolicyForElement(wSDLComponent);
        SymmetricBinding symmetricBinding = (SymmetricBinding)PolicyModelHelper.getTopLevelElement((WSDLComponent)policy, SymmetricBinding.class);
        if (symmetricBinding == null) {
            return false;
        }
        WSDLComponent wSDLComponent2 = SecurityTokensModelHelper.getTokenElement((WSDLComponent)symmetricBinding, ProtectionToken.class);
        if (wSDLComponent2 == null) {
            return false;
        }
        WSDLComponent wSDLComponent3 = SecurityTokensModelHelper.getTokenTypeElement(wSDLComponent2);
        if (wSDLComponent3 == null) {
            return false;
        }
        boolean bl = wSDLComponent3 instanceof SecureConversationToken;
        return bl;
    }

    public static String getWSITSecurityProfile(WSDLComponent wSDLComponent) {
        if (wSDLComponent instanceof Binding || wSDLComponent instanceof BindingOperation) {
            RecipientToken recipientToken;
            InitiatorToken initiatorToken;
            Object object;
            Policy policy = PolicyModelHelper.getPolicyForElement(wSDLComponent);
            SymmetricBinding symmetricBinding = (SymmetricBinding)PolicyModelHelper.getTopLevelElement((WSDLComponent)policy, SymmetricBinding.class);
            WSDLComponent wSDLComponent2 = SecurityTokensModelHelper.getTokenElement((WSDLComponent)symmetricBinding, ProtectionToken.class);
            WSDLComponent wSDLComponent3 = SecurityTokensModelHelper.getTokenTypeElement(wSDLComponent2);
            ExtensibilityElement extensibilityElement = null;
            boolean bl = wSDLComponent3 instanceof SecureConversationToken;
            WSDLComponent wSDLComponent4 = null;
            if (bl) {
                wSDLComponent4 = SecurityTokensModelHelper.getTokenElement(wSDLComponent3, BootstrapPolicy.class);
                extensibilityElement = SecurityPolicyModelHelper.getSecurityBindingTypeElement(wSDLComponent4);
            }
            TransportBinding transportBinding = null;
            transportBinding = bl && extensibilityElement instanceof TransportBinding ? (TransportBinding)extensibilityElement : (TransportBinding)PolicyModelHelper.getTopLevelElement((WSDLComponent)policy, TransportBinding.class);
            if (transportBinding != null) {
                Object object2;
                if (wSDLComponent instanceof BindingOperation) {
                    BindingInput bindingInput = ((BindingOperation)wSDLComponent).getBindingInput();
                    WSDLComponent wSDLComponent5 = SecurityTokensModelHelper.getSupportingToken((WSDLComponent)bindingInput, 2);
                    if (wSDLComponent5 != null) {
                        return ComboConstants.PROF_MSGAUTHSSL;
                    }
                    wSDLComponent5 = SecurityTokensModelHelper.getSupportingToken((WSDLComponent)bindingInput, 1);
                    String string = SecurityTokensModelHelper.getTokenType(wSDLComponent5);
                    if (ComboConstants.SAML.equals(string)) {
                        return ComboConstants.PROF_SAMLSSL;
                    }
                    if (ComboConstants.USERNAME.equals(string) || ComboConstants.X509.equals(string)) {
                        return ComboConstants.PROF_MSGAUTHSSL;
                    }
                    return ComboConstants.PROF_TRANSPORT;
                }
                WSDLComponent wSDLComponent6 = SecurityTokensModelHelper.getSupportingToken(wSDLComponent, 2);
                if (wSDLComponent6 != null) {
                    return ComboConstants.PROF_MSGAUTHSSL;
                }
                if (bl) {
                    object2 = (Policy)PolicyModelHelper.getTopLevelElement(wSDLComponent4, Policy.class);
                    wSDLComponent6 = SecurityTokensModelHelper.getSupportingToken((WSDLComponent)object2, 1);
                } else {
                    wSDLComponent6 = SecurityTokensModelHelper.getSupportingToken(wSDLComponent, 1);
                }
                object2 = SecurityTokensModelHelper.getTokenType(wSDLComponent6);
                if (ComboConstants.SAML.equals(object2)) {
                    return ComboConstants.PROF_SAMLSSL;
                }
                if (ComboConstants.USERNAME.equals(object2) || ComboConstants.X509.equals(object2)) {
                    return ComboConstants.PROF_MSGAUTHSSL;
                }
                return ComboConstants.PROF_TRANSPORT;
            }
            symmetricBinding = bl && extensibilityElement instanceof SymmetricBinding ? (SymmetricBinding)extensibilityElement : (SymmetricBinding)PolicyModelHelper.getTopLevelElement((WSDLComponent)policy, SymmetricBinding.class);
            if (symmetricBinding != null && (wSDLComponent3 = (ProtectionToken)SecurityTokensModelHelper.getTokenElement((WSDLComponent)symmetricBinding, ProtectionToken.class)) != null) {
                object = SecurityTokensModelHelper.getTokenType(wSDLComponent3);
                if (ComboConstants.ISSUED.equals(object)) {
                    return ComboConstants.PROF_STSISSUED;
                }
                if (ComboConstants.KERBEROS.equals(object)) {
                    return ComboConstants.PROF_KERBEROS;
                }
                if (ComboConstants.X509.equals(object)) {
                    initiatorToken = null;
                    if (bl) {
                        recipientToken = (Policy)PolicyModelHelper.getTopLevelElement(wSDLComponent4, Policy.class);
                        initiatorToken = SecurityTokensModelHelper.getSupportingToken((WSDLComponent)recipientToken, 2);
                    } else {
                        initiatorToken = SecurityTokensModelHelper.getSupportingToken(wSDLComponent, 2);
                    }
                    object = SecurityTokensModelHelper.getTokenType((WSDLComponent)initiatorToken);
                    if (ComboConstants.ISSUED.equals(object)) {
                        return ComboConstants.PROF_STSISSUEDENDORSE;
                    }
                    if (ComboConstants.X509.equals(object)) {
                        return ComboConstants.PROF_ENDORSCERT;
                    }
                    if (object == null) {
                        return ComboConstants.PROF_USERNAME;
                    }
                }
            }
            object = null;
            object = bl && extensibilityElement instanceof AsymmetricBinding ? (AsymmetricBinding)extensibilityElement : (AsymmetricBinding)PolicyModelHelper.getTopLevelElement((WSDLComponent)policy, AsymmetricBinding.class);
            if (object != null) {
                initiatorToken = (InitiatorToken)SecurityTokensModelHelper.getTokenElement((WSDLComponent)object, InitiatorToken.class);
                recipientToken = (RecipientToken)SecurityTokensModelHelper.getTokenElement((WSDLComponent)object, RecipientToken.class);
                if (initiatorToken != null && recipientToken != null) {
                    String string = SecurityTokensModelHelper.getTokenType((WSDLComponent)initiatorToken);
                    String string2 = SecurityTokensModelHelper.getTokenType((WSDLComponent)recipientToken);
                    if (ComboConstants.X509.equals(string) && ComboConstants.X509.equals(string2)) {
                        if (wSDLComponent instanceof BindingOperation) {
                            BindingInput bindingInput = ((BindingOperation)wSDLComponent).getBindingInput();
                            WSDLComponent wSDLComponent7 = SecurityTokensModelHelper.getSupportingToken((WSDLComponent)bindingInput, 1);
                            String string3 = SecurityTokensModelHelper.getTokenType(wSDLComponent7);
                            if (ComboConstants.SAML.equals(string3)) {
                                return ComboConstants.PROF_SAMLSENDER;
                            }
                            if (string3 == null) {
                                return ComboConstants.PROF_MUTUALCERT;
                            }
                        } else {
                            Object object3;
                            WSDLComponent wSDLComponent8 = null;
                            if (bl) {
                                object3 = (Policy)PolicyModelHelper.getTopLevelElement(wSDLComponent4, Policy.class);
                                wSDLComponent8 = SecurityTokensModelHelper.getSupportingToken((WSDLComponent)object3, 1);
                            } else {
                                wSDLComponent8 = SecurityTokensModelHelper.getSupportingToken(wSDLComponent, 1);
                            }
                            object3 = SecurityTokensModelHelper.getTokenType(wSDLComponent8);
                            if (ComboConstants.SAML.equals(object3)) {
                                return ComboConstants.PROF_SAMLSENDER;
                            }
                            if (object3 == null) {
                                return ComboConstants.PROF_MUTUALCERT;
                            }
                        }
                    }
                    if (ComboConstants.SAML.equals(string) && ComboConstants.X509.equals(string2)) {
                        return ComboConstants.PROF_SAMLHOLDER;
                    }
                    if (ComboConstants.ISSUED.equals(string) && ComboConstants.X509.equals(string2)) {
                        return ComboConstants.PROF_STSISSUEDCERT;
                    }
                }
            }
        }
        return ComboConstants.PROF_GENERIC;
    }

    private static void updateServiceUrl(WSDLComponent wSDLComponent, boolean bl) {
        String string;
        String string2;
        if (bl) {
            string2 = "http:";
            string = "https:";
        } else {
            string2 = "https:";
            string = "http:";
        }
        if (wSDLComponent instanceof Binding) {
            Collection collection = wSDLComponent.getModel().getDefinitions().getServices();
            for (Service service : collection) {
                Collection collection2 = service.getPorts();
                for (Port port : collection2) {
                    String string3;
                    Object object;
                    Object object2;
                    Object object3;
                    if (!port.getBinding().references((Referenceable)((Binding)wSDLComponent))) continue;
                    List list = port.getExtensibilityElements(Address.class);
                    if (list != null && !list.isEmpty()) {
                        object3 = list.iterator();
                        while (object3.hasNext()) {
                            object2 = (Address)object3.next();
                            object = object2.getAddress();
                            if (object == null) continue;
                            object2.setAddress(((String)object).replaceFirst(string2, string));
                        }
                    }
                    if ((object3 = port.getExtensibilityElements(Address10.class)) != null && !object3.isEmpty()) {
                        object2 = object3.iterator();
                        while (object2.hasNext()) {
                            object = (Address10)object2.next();
                            string3 = object.getAddress();
                            if (string3 == null) continue;
                            object.setAddress(string3.replaceFirst(string2, string));
                        }
                    }
                    if ((object2 = port.getExtensibilityElements(SOAPAddress.class)) == null || object2.isEmpty()) continue;
                    object = object2.iterator();
                    while (object.hasNext()) {
                        string3 = (SOAPAddress)object.next();
                        String string4 = string3.getLocation();
                        if (string4 == null) continue;
                        string3.setLocation(string4.replaceFirst(string2, string));
                    }
                }
            }
        }
    }

    public static boolean isServiceUrlHttps(Binding binding) {
        Collection collection = binding.getModel().getDefinitions().getServices();
        for (Service service : collection) {
            Collection collection2 = service.getPorts();
            for (Port port : collection2) {
                String string;
                Object object;
                Object object2;
                Object object3;
                if (!port.getBinding().references((Referenceable)binding)) continue;
                List list = port.getExtensibilityElements(Address.class);
                if (list != null && !list.isEmpty()) {
                    object3 = list.iterator();
                    while (object3.hasNext()) {
                        object2 = (Address)object3.next();
                        object = object2.getAddress();
                        if (object == null || !((String)object).contains("https:")) continue;
                        return true;
                    }
                }
                if ((object3 = port.getExtensibilityElements(Address10.class)) != null && !object3.isEmpty()) {
                    object2 = object3.iterator();
                    while (object2.hasNext()) {
                        object = (Address10)object2.next();
                        string = object.getAddress();
                        if (string == null || !string.contains("https:")) continue;
                        return true;
                    }
                }
                if ((object2 = port.getExtensibilityElements(SOAPAddress.class)) == null || object2.isEmpty()) continue;
                object = object2.iterator();
                while (object.hasNext()) {
                    string = (SOAPAddress)object.next();
                    String string2 = string.getLocation();
                    if (string2 == null || !string2.contains("https:")) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static void setSecurityProfile(WSDLComponent wSDLComponent, String string, String string2, boolean bl) {
        assert (wSDLComponent != null);
        assert (string != null);
        assert (wSDLComponent instanceof BindingOperation || wSDLComponent instanceof Binding);
        SecurityProfile securityProfile = SecurityProfileRegistry.getDefault().getProfile(string);
        SecurityProfile securityProfile2 = SecurityProfileRegistry.getDefault().getProfile(string2);
        if (securityProfile2 != null) {
            securityProfile2.profileDeselected(wSDLComponent);
        }
        securityProfile.profileSelected(wSDLComponent, bl);
    }

    public static boolean isServiceDefaultSetupSupported(String string) {
        SecurityProfile securityProfile = SecurityProfileRegistry.getDefault().getProfile(string);
        return securityProfile instanceof ServiceDefaultsFeature;
    }

    public static boolean isClientDefaultSetupSupported(String string) {
        SecurityProfile securityProfile = SecurityProfileRegistry.getDefault().getProfile(string);
        return securityProfile instanceof ClientDefaultsFeature;
    }

    public static boolean isServiceDefaultSetupUsed(String string, Binding binding, Project project) {
        SecurityProfile securityProfile = SecurityProfileRegistry.getDefault().getProfile(string);
        if (securityProfile instanceof ServiceDefaultsFeature) {
            return ((ServiceDefaultsFeature)((Object)securityProfile)).isServiceDefaultSetupUsed((WSDLComponent)binding, project);
        }
        return false;
    }

    public static boolean isClientDefaultSetupUsed(String string, Binding binding, WSDLComponent wSDLComponent, Project project) {
        SecurityProfile securityProfile = SecurityProfileRegistry.getDefault().getProfile(string);
        if (securityProfile instanceof ClientDefaultsFeature) {
            return ((ClientDefaultsFeature)((Object)securityProfile)).isClientDefaultSetupUsed((WSDLComponent)binding, (Binding)wSDLComponent, project);
        }
        return false;
    }

    public static void setClientDefaults(String string, Binding binding, WSDLComponent wSDLComponent, Project project) {
        SecurityProfile securityProfile = SecurityProfileRegistry.getDefault().getProfile(string);
        if (securityProfile instanceof ClientDefaultsFeature) {
            ((ClientDefaultsFeature)((Object)securityProfile)).setClientDefaults((WSDLComponent)binding, wSDLComponent, project);
        }
    }

    public static void setServiceDefaults(String string, Binding binding, Project project) {
        SecurityProfile securityProfile = SecurityProfileRegistry.getDefault().getProfile(string);
        if (securityProfile instanceof ServiceDefaultsFeature) {
            ((ServiceDefaultsFeature)((Object)securityProfile)).setServiceDefaults((WSDLComponent)binding, project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSecurityProfile(WSDLComponent wSDLComponent, String string, boolean bl) {
        WSDLModel wSDLModel = wSDLComponent.getModel();
        boolean bl2 = wSDLModel.isIntransaction();
        if (!bl2) {
            wSDLModel.startTransaction();
        }
        PolicyModelHelper.createPolicy(wSDLComponent, true);
        try {
            if (ComboConstants.PROF_TRANSPORT.equals(string)) {
                WSDLComponent wSDLComponent2 = SecurityPolicyModelHelper.setSecurityBindingType(wSDLComponent, ComboConstants.TRANSPORT);
                SecurityTokensModelHelper.setTokenType(wSDLComponent2, ComboConstants.TRANSPORT, ComboConstants.HTTPS);
                SecurityPolicyModelHelper.setLayout(wSDLComponent2, ComboConstants.LAX);
                SecurityPolicyModelHelper.enableIncludeTimestamp(wSDLComponent2, true);
                AlgoSuiteModelHelper.setAlgorithmSuite(wSDLComponent2, ComboConstants.BASIC128);
                SecurityPolicyModelHelper.enableWss(wSDLComponent, false);
                SecurityPolicyModelHelper.disableTrust10(wSDLComponent);
                SecurityTokensModelHelper.removeSupportingTokens(wSDLComponent);
            } else if (ComboConstants.PROF_MSGAUTHSSL.equals(string)) {
                WSDLComponent wSDLComponent3 = SecurityPolicyModelHelper.setSecurityBindingType(wSDLComponent, ComboConstants.TRANSPORT);
                SecurityTokensModelHelper.setTokenType(wSDLComponent3, ComboConstants.TRANSPORT, ComboConstants.HTTPS);
                SecurityPolicyModelHelper.setLayout(wSDLComponent3, ComboConstants.LAX);
                SecurityPolicyModelHelper.enableIncludeTimestamp(wSDLComponent3, true);
                AlgoSuiteModelHelper.setAlgorithmSuite(wSDLComponent3, ComboConstants.BASIC128);
                WssElement wssElement = SecurityPolicyModelHelper.enableWss(wSDLComponent, false);
                SecurityPolicyModelHelper.disableTrust10(wSDLComponent);
                SecurityPolicyModelHelper.enableMustSupportRefKeyIdentifier(wssElement, true);
                SecurityTokensModelHelper.removeSupportingTokens(wSDLComponent);
                SecurityTokensModelHelper.setSupportingTokens(wSDLComponent, ComboConstants.USERNAME, 1);
            } else if (ComboConstants.PROF_SAMLSSL.equals(string)) {
                WSDLComponent wSDLComponent4 = SecurityPolicyModelHelper.setSecurityBindingType(wSDLComponent, ComboConstants.TRANSPORT);
                SecurityTokensModelHelper.setTokenType(wSDLComponent4, ComboConstants.TRANSPORT, ComboConstants.HTTPS);
                SecurityPolicyModelHelper.setLayout(wSDLComponent4, ComboConstants.LAX);
                SecurityPolicyModelHelper.enableIncludeTimestamp(wSDLComponent4, true);
                AlgoSuiteModelHelper.setAlgorithmSuite(wSDLComponent4, ComboConstants.BASIC128);
                WssElement wssElement = SecurityPolicyModelHelper.enableWss(wSDLComponent, false);
                SecurityPolicyModelHelper.disableTrust10(wSDLComponent);
                SecurityPolicyModelHelper.enableMustSupportRefKeyIdentifier(wssElement, true);
                SecurityTokensModelHelper.removeSupportingTokens(wSDLComponent);
                SecurityTokensModelHelper.setSupportingTokens(wSDLComponent, ComboConstants.SAML, 1);
            } else if (ComboConstants.PROF_USERNAME.equals(string)) {
                WSDLComponent wSDLComponent5 = SecurityPolicyModelHelper.setSecurityBindingType(wSDLComponent, ComboConstants.SYMMETRIC);
                WSDLComponent wSDLComponent6 = SecurityTokensModelHelper.setTokenType(wSDLComponent5, "protection", ComboConstants.X509);
                SecurityTokensModelHelper.setTokenInclusionLevel(wSDLComponent6, ComboConstants.NEVER);
                SecurityPolicyModelHelper.setLayout(wSDLComponent5, ComboConstants.STRICT);
                SecurityPolicyModelHelper.enableIncludeTimestamp(wSDLComponent5, true);
                SecurityPolicyModelHelper.enableSignEntireHeadersAndBody(wSDLComponent5, true);
                AlgoSuiteModelHelper.setAlgorithmSuite(wSDLComponent5, ComboConstants.BASIC128);
                WssElement wssElement = SecurityPolicyModelHelper.enableWss(wSDLComponent, true);
                SecurityPolicyModelHelper.disableTrust10(wSDLComponent);
                SecurityPolicyModelHelper.enableMustSupportRefKeyIdentifier(wssElement, true);
                SecurityPolicyModelHelper.enableMustSupportRefIssuerSerial(wssElement, true);
                SecurityPolicyModelHelper.enableMustSupportRefThumbprint(wssElement, true);
                SecurityPolicyModelHelper.enableMustSupportRefEncryptedKey(wssElement, true);
                SecurityTokensModelHelper.removeSupportingTokens(wSDLComponent);
                SecurityTokensModelHelper.setSupportingTokens(wSDLComponent, ComboConstants.USERNAME, 1);
            } else if (ComboConstants.PROF_MUTUALCERT.equals(string)) {
                WSDLComponent wSDLComponent7 = SecurityPolicyModelHelper.setSecurityBindingType(wSDLComponent, ComboConstants.ASYMMETRIC);
                WSDLComponent wSDLComponent8 = SecurityTokensModelHelper.setTokenType(wSDLComponent7, "initiator", ComboConstants.X509);
                SecurityTokensModelHelper.setTokenInclusionLevel(wSDLComponent8, ComboConstants.ALWAYSRECIPIENT);
                wSDLComponent8 = SecurityTokensModelHelper.setTokenType(wSDLComponent7, "recipient", ComboConstants.X509);
                SecurityTokensModelHelper.setTokenInclusionLevel(wSDLComponent8, ComboConstants.NEVER);
                SecurityPolicyModelHelper.setLayout(wSDLComponent7, ComboConstants.STRICT);
                SecurityPolicyModelHelper.enableIncludeTimestamp(wSDLComponent7, true);
                SecurityPolicyModelHelper.enableSignEntireHeadersAndBody(wSDLComponent7, true);
                AlgoSuiteModelHelper.setAlgorithmSuite(wSDLComponent7, ComboConstants.BASIC128);
                WssElement wssElement = SecurityPolicyModelHelper.enableWss(wSDLComponent, false);
                SecurityPolicyModelHelper.disableTrust10(wSDLComponent);
                SecurityPolicyModelHelper.enableMustSupportRefKeyIdentifier(wssElement, true);
                SecurityPolicyModelHelper.enableMustSupportRefIssuerSerial(wssElement, true);
                SecurityTokensModelHelper.removeSupportingTokens(wSDLComponent);
            } else if (ComboConstants.PROF_ENDORSCERT.equals(string)) {
                WSDLComponent wSDLComponent9 = SecurityPolicyModelHelper.setSecurityBindingType(wSDLComponent, ComboConstants.SYMMETRIC);
                WSDLComponent wSDLComponent10 = SecurityTokensModelHelper.setTokenType(wSDLComponent9, "protection", ComboConstants.X509);
                SecurityTokensModelHelper.setTokenInclusionLevel(wSDLComponent10, ComboConstants.NEVER);
                SecurityPolicyModelHelper.setLayout(wSDLComponent9, ComboConstants.LAX);
                SecurityPolicyModelHelper.enableIncludeTimestamp(wSDLComponent9, true);
                SecurityPolicyModelHelper.enableSignEntireHeadersAndBody(wSDLComponent9, true);
                AlgoSuiteModelHelper.setAlgorithmSuite(wSDLComponent9, ComboConstants.BASIC128);
                WssElement wssElement = SecurityPolicyModelHelper.enableWss(wSDLComponent, true);
                SecurityPolicyModelHelper.disableTrust10(wSDLComponent);
                SecurityPolicyModelHelper.enableMustSupportRefKeyIdentifier(wssElement, true);
                SecurityPolicyModelHelper.enableMustSupportRefIssuerSerial(wssElement, true);
                SecurityPolicyModelHelper.enableMustSupportRefThumbprint(wssElement, true);
                SecurityPolicyModelHelper.enableMustSupportRefEncryptedKey(wssElement, true);
                SecurityTokensModelHelper.removeSupportingTokens(wSDLComponent);
                wSDLComponent10 = SecurityTokensModelHelper.setSupportingTokens(wSDLComponent, ComboConstants.X509, 2);
            } else if (ComboConstants.PROF_SAMLSENDER.equals(string)) {
                WSDLComponent wSDLComponent11 = SecurityPolicyModelHelper.setSecurityBindingType(wSDLComponent, ComboConstants.ASYMMETRIC);
                WSDLComponent wSDLComponent12 = SecurityTokensModelHelper.setTokenType(wSDLComponent11, "initiator", ComboConstants.X509);
                SecurityTokensModelHelper.setTokenInclusionLevel(wSDLComponent12, ComboConstants.ALWAYSRECIPIENT);
                wSDLComponent12 = SecurityTokensModelHelper.setTokenType(wSDLComponent11, "recipient", ComboConstants.X509);
                SecurityTokensModelHelper.setTokenInclusionLevel(wSDLComponent12, ComboConstants.NEVER);
                SecurityPolicyModelHelper.setLayout(wSDLComponent11, ComboConstants.STRICT);
                SecurityPolicyModelHelper.enableIncludeTimestamp(wSDLComponent11, true);
                SecurityPolicyModelHelper.enableSignEntireHeadersAndBody(wSDLComponent11, true);
                AlgoSuiteModelHelper.setAlgorithmSuite(wSDLComponent11, ComboConstants.BASIC128);
                WssElement wssElement = SecurityPolicyModelHelper.enableWss(wSDLComponent, false);
                SecurityPolicyModelHelper.disableTrust10(wSDLComponent);
                SecurityPolicyModelHelper.enableMustSupportRefKeyIdentifier(wssElement, true);
                SecurityPolicyModelHelper.enableMustSupportRefIssuerSerial(wssElement, true);
                SecurityTokensModelHelper.removeSupportingTokens(wSDLComponent);
                SecurityTokensModelHelper.setSupportingTokens(wSDLComponent, ComboConstants.SAML, 1);
            } else if (ComboConstants.PROF_SAMLHOLDER.equals(string)) {
                WSDLComponent wSDLComponent13 = SecurityPolicyModelHelper.setSecurityBindingType(wSDLComponent, ComboConstants.ASYMMETRIC);
                WSDLComponent wSDLComponent14 = SecurityTokensModelHelper.setTokenType(wSDLComponent13, "initiator", ComboConstants.SAML);
                SecurityTokensModelHelper.setTokenInclusionLevel(wSDLComponent14, ComboConstants.ALWAYSRECIPIENT);
                wSDLComponent14 = SecurityTokensModelHelper.setTokenType(wSDLComponent13, "recipient", ComboConstants.X509);
                SecurityTokensModelHelper.setTokenInclusionLevel(wSDLComponent14, ComboConstants.NEVER);
                SecurityPolicyModelHelper.setLayout(wSDLComponent13, ComboConstants.STRICT);
                SecurityPolicyModelHelper.enableIncludeTimestamp(wSDLComponent13, true);
                SecurityPolicyModelHelper.enableSignEntireHeadersAndBody(wSDLComponent13, true);
                AlgoSuiteModelHelper.setAlgorithmSuite(wSDLComponent13, ComboConstants.BASIC128);
                WssElement wssElement = SecurityPolicyModelHelper.enableWss(wSDLComponent, false);
                SecurityPolicyModelHelper.disableTrust10(wSDLComponent);
                SecurityPolicyModelHelper.enableMustSupportRefKeyIdentifier(wssElement, true);
                SecurityPolicyModelHelper.enableMustSupportRefIssuerSerial(wssElement, true);
                SecurityTokensModelHelper.removeSupportingTokens(wSDLComponent);
            } else if (ComboConstants.PROF_KERBEROS.equals(string)) {
                WSDLComponent wSDLComponent15 = SecurityPolicyModelHelper.setSecurityBindingType(wSDLComponent, ComboConstants.SYMMETRIC);
                WSDLComponent wSDLComponent16 = SecurityTokensModelHelper.setTokenType(wSDLComponent15, "protection", ComboConstants.KERBEROS);
                SecurityTokensModelHelper.setTokenInclusionLevel(wSDLComponent16, ComboConstants.ONCE);
                SecurityPolicyModelHelper.setLayout(wSDLComponent15, ComboConstants.STRICT);
                SecurityPolicyModelHelper.enableIncludeTimestamp(wSDLComponent15, true);
                SecurityPolicyModelHelper.enableSignEntireHeadersAndBody(wSDLComponent15, true);
                AlgoSuiteModelHelper.setAlgorithmSuite(wSDLComponent15, ComboConstants.BASIC128);
                WssElement wssElement = SecurityPolicyModelHelper.enableWss(wSDLComponent, true);
                SecurityPolicyModelHelper.disableTrust10(wSDLComponent);
                SecurityPolicyModelHelper.enableMustSupportRefKeyIdentifier(wssElement, true);
                SecurityPolicyModelHelper.enableMustSupportRefIssuerSerial(wssElement, true);
                SecurityPolicyModelHelper.enableMustSupportRefThumbprint(wssElement, true);
                SecurityPolicyModelHelper.enableMustSupportRefEncryptedKey(wssElement, true);
                SecurityTokensModelHelper.removeSupportingTokens(wSDLComponent);
            } else if (ComboConstants.PROF_STSISSUED.equals(string)) {
                WSDLComponent wSDLComponent17 = SecurityPolicyModelHelper.setSecurityBindingType(wSDLComponent, ComboConstants.SYMMETRIC);
                WSDLComponent wSDLComponent18 = SecurityTokensModelHelper.setTokenType(wSDLComponent17, "protection", ComboConstants.ISSUED);
                SecurityTokensModelHelper.setTokenInclusionLevel(wSDLComponent18, ComboConstants.ALWAYSRECIPIENT);
                SecurityPolicyModelHelper.setLayout(wSDLComponent17, ComboConstants.LAX);
                SecurityPolicyModelHelper.enableIncludeTimestamp(wSDLComponent17, true);
                SecurityPolicyModelHelper.enableSignEntireHeadersAndBody(wSDLComponent17, true);
                AlgoSuiteModelHelper.setAlgorithmSuite(wSDLComponent17, ComboConstants.BASIC128);
                WssElement wssElement = SecurityPolicyModelHelper.enableWss(wSDLComponent, true);
                SecurityPolicyModelHelper.enableMustSupportRefKeyIdentifier(wssElement, true);
                SecurityPolicyModelHelper.enableMustSupportRefIssuerSerial(wssElement, true);
                SecurityPolicyModelHelper.enableMustSupportRefThumbprint(wssElement, true);
                SecurityPolicyModelHelper.enableMustSupportRefEncryptedKey(wssElement, true);
                TrustElement trustElement = SecurityPolicyModelHelper.enableTrust10(wSDLComponent);
                SecurityPolicyModelHelper.enableMustSupportIssuedTokens(trustElement, true);
                SecurityPolicyModelHelper.enableRequireClientEntropy(trustElement, true);
                SecurityPolicyModelHelper.enableRequireServerEntropy(trustElement, true);
                SecurityTokensModelHelper.removeSupportingTokens(wSDLComponent);
            } else if (ComboConstants.PROF_STSISSUEDCERT.equals(string)) {
                WSDLComponent wSDLComponent19 = SecurityPolicyModelHelper.setSecurityBindingType(wSDLComponent, ComboConstants.ASYMMETRIC);
                WSDLComponent wSDLComponent20 = SecurityTokensModelHelper.setTokenType(wSDLComponent19, "initiator", ComboConstants.ISSUED);
                SecurityTokensModelHelper.setTokenInclusionLevel(wSDLComponent20, ComboConstants.ALWAYSRECIPIENT);
                wSDLComponent20 = SecurityTokensModelHelper.setTokenType(wSDLComponent19, "recipient", ComboConstants.X509);
                SecurityTokensModelHelper.setTokenInclusionLevel(wSDLComponent20, ComboConstants.NEVER);
                SecurityPolicyModelHelper.setLayout(wSDLComponent19, ComboConstants.LAX);
                SecurityPolicyModelHelper.enableIncludeTimestamp(wSDLComponent19, true);
                SecurityPolicyModelHelper.enableSignEntireHeadersAndBody(wSDLComponent19, true);
                AlgoSuiteModelHelper.setAlgorithmSuite(wSDLComponent19, ComboConstants.BASIC128);
                WssElement wssElement = SecurityPolicyModelHelper.enableWss(wSDLComponent, true);
                SecurityPolicyModelHelper.enableMustSupportRefKeyIdentifier(wssElement, true);
                SecurityPolicyModelHelper.enableMustSupportRefIssuerSerial(wssElement, true);
                SecurityPolicyModelHelper.enableMustSupportRefThumbprint(wssElement, true);
                SecurityPolicyModelHelper.enableMustSupportRefEncryptedKey(wssElement, true);
                TrustElement trustElement = SecurityPolicyModelHelper.enableTrust10(wSDLComponent);
                SecurityPolicyModelHelper.enableMustSupportIssuedTokens(trustElement, true);
                SecurityPolicyModelHelper.enableRequireClientEntropy(trustElement, true);
                SecurityPolicyModelHelper.enableRequireServerEntropy(trustElement, true);
                SecurityTokensModelHelper.removeSupportingTokens(wSDLComponent);
            } else if (ComboConstants.PROF_STSISSUEDENDORSE.equals(string)) {
                WSDLComponent wSDLComponent21 = SecurityPolicyModelHelper.setSecurityBindingType(wSDLComponent, ComboConstants.SYMMETRIC);
                WSDLComponent wSDLComponent22 = SecurityTokensModelHelper.setTokenType(wSDLComponent21, "protection", ComboConstants.X509);
                SecurityTokensModelHelper.setTokenInclusionLevel(wSDLComponent22, ComboConstants.ALWAYS);
                SecurityPolicyModelHelper.setLayout(wSDLComponent21, ComboConstants.LAX);
                SecurityPolicyModelHelper.enableIncludeTimestamp(wSDLComponent21, true);
                SecurityPolicyModelHelper.enableSignEntireHeadersAndBody(wSDLComponent21, true);
                AlgoSuiteModelHelper.setAlgorithmSuite(wSDLComponent21, ComboConstants.BASIC128);
                WssElement wssElement = SecurityPolicyModelHelper.enableWss(wSDLComponent, true);
                SecurityPolicyModelHelper.enableMustSupportRefKeyIdentifier(wssElement, true);
                SecurityPolicyModelHelper.enableMustSupportRefIssuerSerial(wssElement, true);
                SecurityPolicyModelHelper.enableMustSupportRefThumbprint(wssElement, true);
                SecurityPolicyModelHelper.enableMustSupportRefEncryptedKey(wssElement, true);
                TrustElement trustElement = SecurityPolicyModelHelper.enableTrust10(wSDLComponent);
                SecurityPolicyModelHelper.enableMustSupportIssuedTokens(trustElement, true);
                SecurityPolicyModelHelper.enableRequireClientEntropy(trustElement, true);
                SecurityPolicyModelHelper.enableRequireServerEntropy(trustElement, true);
                SecurityTokensModelHelper.removeSupportingTokens(wSDLComponent);
                wSDLComponent22 = SecurityTokensModelHelper.setSupportingTokens(wSDLComponent, ComboConstants.ISSUED, 2);
            }
            ProfilesModelHelper.setMessageLevelSecurityProfilePolicies(wSDLComponent, string);
            if (bl) {
                ProfilesModelHelper.updateServiceUrl(wSDLComponent, ProfilesModelHelper.isSSLProfile(string));
            }
        }
        finally {
            if (!bl2) {
                wSDLModel.endTransaction();
            }
        }
    }

    private static FileObject getDDFO(WSDLComponent wSDLComponent) {
        WSDLModel wSDLModel;
        FileObject fileObject;
        if (wSDLComponent != null && (fileObject = Util.getFOForModel(wSDLModel = wSDLComponent.getModel())) != null) {
            Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (Util.isWebProject(project)) {
                WebModule webModule = WebModule.getWebModule((FileObject)fileObject);
                return webModule.getDeploymentDescriptor();
            }
            return Util.getSunDDFO(project);
        }
        return null;
    }

    private static SecurityConstraint getSecurityConstraint(WSDLComponent wSDLComponent) {
        FileObject fileObject = ProfilesModelHelper.getDDFO(wSDLComponent);
        if (fileObject != null) {
            Object object;
            WebResourceCollection webResourceCollection;
            SecurityConstraint[] securityConstraintArray;
            WebApp webApp = null;
            try {
                webApp = DDProvider.getDefault().getDDRoot(fileObject);
            }
            catch (IOException iOException) {
                logger.log(Level.FINE, null, iOException);
            }
            String string = null;
            if (wSDLComponent instanceof Binding) {
                securityConstraintArray = wSDLComponent.getModel().getDefinitions().getServices();
                for (Service service : securityConstraintArray) {
                    Collection collection = service.getPorts();
                    SecurityConstraint securityConstraint = collection.iterator();
                    while (securityConstraint.hasNext()) {
                        webResourceCollection = (Port)securityConstraint.next();
                        object = webResourceCollection.getBinding().getQName();
                        String string2 = ((Binding)wSDLComponent).getName();
                        if (!string2.equals(((QName)object).getLocalPart())) continue;
                        string = service.getName();
                    }
                }
            }
            if (webApp != null && webApp.getStatus() != 2) {
                for (SecurityConstraint securityConstraint : securityConstraintArray = webApp.getSecurityConstraint()) {
                    webResourceCollection = securityConstraint.getWebResourceCollection(0);
                    if (webResourceCollection == null || (object = webResourceCollection.getUrlPattern(0)) == null || !((String)object).contains(string)) continue;
                    return securityConstraint;
                }
            }
        }
        return null;
    }

    public static void unsetSSLAttributes(WSDLComponent wSDLComponent) {
        SecurityConstraint securityConstraint = ProfilesModelHelper.getSecurityConstraint(wSDLComponent);
        if (securityConstraint != null) {
            try {
                FileObject fileObject = ProfilesModelHelper.getDDFO(wSDLComponent);
                if (fileObject == null) {
                    return;
                }
                WebApp webApp = DDProvider.getDefault().getDDRoot(fileObject);
                if (webApp != null && webApp.getStatus() != 2) {
                    webApp.removeSecurityConstraint(securityConstraint);
                    webApp.write(fileObject);
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    public static void setSSLAttributes(WSDLComponent wSDLComponent) {
        if (ProfilesModelHelper.getSecurityConstraint(wSDLComponent) == null) {
            FileObject fileObject = ProfilesModelHelper.getDDFO(wSDLComponent);
            if (fileObject == null) {
                return;
            }
            try {
                WebApp webApp = DDProvider.getDefault().getDDRoot(fileObject);
                if (webApp != null && webApp.getStatus() != 2) {
                    Collection collection;
                    SecurityConstraint securityConstraint = (SecurityConstraint)webApp.createBean("SecurityConstraint");
                    AuthConstraint authConstraint = (AuthConstraint)webApp.createBean("AuthConstraint");
                    authConstraint.addRoleName("EMPLOYEE");
                    securityConstraint.setAuthConstraint(authConstraint);
                    UserDataConstraint userDataConstraint = (UserDataConstraint)webApp.createBean("UserDataConstraint");
                    userDataConstraint.setTransportGuarantee("CONFIDENTIAL");
                    securityConstraint.setUserDataConstraint(userDataConstraint);
                    String string = null;
                    String string2 = "/";
                    boolean bl = false;
                    if (wSDLComponent instanceof Binding) {
                        collection = wSDLComponent.getModel().getDefinitions().getServices();
                        for (Service service : collection) {
                            Collection collection2 = service.getPorts();
                            for (Port port : collection2) {
                                QName qName = port.getBinding().getQName();
                                String string3 = ((Binding)wSDLComponent).getName();
                                if (!string3.equals(qName.getLocalPart())) continue;
                                string = service.getName();
                                string2 = string2.concat(string + "/*");
                                bl = true;
                                break;
                            }
                            if (!bl) continue;
                            break;
                        }
                    }
                    securityConstraint.setDisplayName(NbBundle.getMessage(ProfilesModelHelper.class, (String)"LBL_SECCONSTRAINT_DNAME", string));
                    collection = (WebResourceCollection)webApp.createBean("WebResourceCollection");
                    collection.setHttpMethod(new String[]{"POST"});
                    collection.setUrlPattern(new String[]{string2});
                    collection.setWebResourceName("Secure Area");
                    securityConstraint.addWebResourceCollection((WebResourceCollection)collection);
                    webApp.addSecurityConstraint(securityConstraint);
                    webApp.write(fileObject);
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Exceptions.printStackTrace((Throwable)classNotFoundException);
            }
        }
    }

    public static void setMessageLevelSecurityProfilePolicies(WSDLComponent wSDLComponent, String string) {
        assert (wSDLComponent instanceof BindingOperation || wSDLComponent instanceof Binding);
        if (wSDLComponent instanceof Binding) {
            Collection collection = ((Binding)wSDLComponent).getBindingOperations();
            Iterator iterator = null;
            if (collection != null && collection.size() > 0) {
                iterator = collection.iterator();
                BindingOperation bindingOperation = (BindingOperation)iterator.next();
                ProfilesModelHelper.setMessageLevelSecurityProfilePolicies(bindingOperation, string);
                BindingInput bindingInput = bindingOperation.getBindingInput();
                BindingOutput bindingOutput = bindingOperation.getBindingOutput();
                String string2 = null;
                if (bindingInput != null) {
                    string2 = PolicyModelHelper.getPolicyUriForElement((WSDLComponent)bindingInput);
                }
                String string3 = null;
                if (bindingOutput != null) {
                    string3 = PolicyModelHelper.getPolicyUriForElement((WSDLComponent)bindingOutput);
                }
                while (iterator.hasNext()) {
                    BindingOperation bindingOperation2 = (BindingOperation)iterator.next();
                    if (bindingInput != null) {
                        bindingInput = bindingOperation2.getBindingInput();
                        PolicyModelHelper.attachPolicyToElement(string2, (WSDLComponent)bindingInput);
                    }
                    if (bindingOutput == null) continue;
                    bindingOutput = bindingOperation2.getBindingOutput();
                    PolicyModelHelper.attachPolicyToElement(string3, (WSDLComponent)bindingOutput);
                }
            }
        } else {
            ProfilesModelHelper.setMessageLevelSecurityProfilePolicies((BindingOperation)wSDLComponent, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMessageLevelSecurityProfilePolicies(BindingOperation bindingOperation, String string) {
        assert (bindingOperation != null);
        WSDLModel wSDLModel = bindingOperation.getModel();
        BindingInput bindingInput = bindingOperation.getBindingInput();
        BindingOutput bindingOutput = bindingOperation.getBindingOutput();
        Binding binding = (Binding)bindingOperation.getParent();
        boolean bl = SecurityPolicyModelHelper.isWss11((WSDLComponent)binding);
        boolean bl2 = RMModelHelper.isRMEnabled((WSDLComponent)binding);
        boolean bl3 = wSDLModel.isIntransaction();
        if (!bl3) {
            wSDLModel.startTransaction();
        }
        try {
            if (ComboConstants.PROF_TRANSPORT.equals(string)) {
                return;
            }
            if (ComboConstants.PROF_MSGAUTHSSL.equals(string)) {
                return;
            }
            if (ComboConstants.PROF_SAMLSSL.equals(string)) {
                return;
            }
            if (ComboConstants.PROF_USERNAME.equals(string)) {
                SecurityPolicyModelHelper.setDefaultTargets((WSDLComponent)bindingInput, bl, bl2);
                SecurityPolicyModelHelper.setDefaultTargets((WSDLComponent)bindingOutput, bl, bl2);
                return;
            }
            if (ComboConstants.PROF_MUTUALCERT.equals(string)) {
                SecurityPolicyModelHelper.setDefaultTargets((WSDLComponent)bindingInput, true, bl2);
                SecurityPolicyModelHelper.setDefaultTargets((WSDLComponent)bindingOutput, true, bl2);
                return;
            }
            if (ComboConstants.PROF_ENDORSCERT.equals(string)) {
                SecurityPolicyModelHelper.setDefaultTargets((WSDLComponent)bindingInput, bl, bl2);
                SecurityPolicyModelHelper.setDefaultTargets((WSDLComponent)bindingOutput, bl, bl2);
                return;
            }
            if (ComboConstants.PROF_SAMLSENDER.equals(string)) {
                SecurityPolicyModelHelper.setDefaultTargets((WSDLComponent)bindingInput, bl, bl2);
                SecurityPolicyModelHelper.setDefaultTargets((WSDLComponent)bindingOutput, bl, bl2);
                return;
            }
            if (ComboConstants.PROF_SAMLHOLDER.equals(string)) {
                SecurityPolicyModelHelper.setDefaultTargets((WSDLComponent)bindingInput, bl, bl2);
                SecurityPolicyModelHelper.setDefaultTargets((WSDLComponent)bindingOutput, bl, bl2);
                return;
            }
            if (ComboConstants.PROF_KERBEROS.equals(string)) {
                SecurityPolicyModelHelper.setDefaultTargets((WSDLComponent)bindingInput, bl, bl2);
                SecurityPolicyModelHelper.setDefaultTargets((WSDLComponent)bindingOutput, bl, bl2);
                return;
            }
            if (ComboConstants.PROF_STSISSUED.equals(string)) {
                SecurityPolicyModelHelper.setDefaultTargets((WSDLComponent)bindingInput, bl, bl2);
                SecurityPolicyModelHelper.setDefaultTargets((WSDLComponent)bindingOutput, bl, bl2);
                return;
            }
            if (ComboConstants.PROF_STSISSUEDCERT.equals(string)) {
                SecurityPolicyModelHelper.setDefaultTargets((WSDLComponent)bindingInput, bl, bl2);
                SecurityPolicyModelHelper.setDefaultTargets((WSDLComponent)bindingOutput, bl, bl2);
                return;
            }
            if (ComboConstants.PROF_STSISSUEDENDORSE.equals(string)) {
                SecurityPolicyModelHelper.setDefaultTargets((WSDLComponent)bindingInput, bl, bl2);
                SecurityPolicyModelHelper.setDefaultTargets((WSDLComponent)bindingOutput, bl, bl2);
                return;
            }
        }
        finally {
            if (!bl3) {
                wSDLModel.endTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enableSecureConversation(WSDLComponent wSDLComponent, boolean bl) {
        assert (wSDLComponent != null);
        assert (wSDLComponent instanceof BindingOperation || wSDLComponent instanceof Binding);
        Binding binding = null;
        binding = wSDLComponent instanceof BindingOperation ? (Binding)wSDLComponent.getParent() : (Binding)wSDLComponent;
        if (ProfilesModelHelper.isSCEnabled((WSDLComponent)binding)) {
            return;
        }
        WSDLModel wSDLModel = wSDLComponent.getModel();
        WSDLComponentFactory wSDLComponentFactory = wSDLModel.getFactory();
        boolean bl2 = wSDLModel.isIntransaction();
        if (!bl2) {
            wSDLModel.startTransaction();
        }
        try {
            if (bl) {
                Trust10 trust10;
                Wss11 wss11;
                ExtensibilityElement extensibilityElement;
                ExtensibilityElement extensibilityElement2 = SecurityPolicyModelHelper.getSecurityBindingTypeElement(wSDLComponent);
                WSDLComponent wSDLComponent2 = (WSDLComponent)extensibilityElement2.getParent();
                boolean bl3 = SecurityPolicyModelHelper.isSignEntireHeadersAndBody(wSDLComponent);
                boolean bl4 = SecurityPolicyModelHelper.isSignEntireHeadersAndBody(wSDLComponent);
                String string = AlgoSuiteModelHelper.getAlgorithmSuite(wSDLComponent);
                BootstrapPolicy bootstrapPolicy = (BootstrapPolicy)wSDLComponentFactory.create(wSDLComponent2, SecurityPolicyQName.BOOTSTRAPPOLICY.getQName());
                wSDLComponent2.addExtensibilityElement((ExtensibilityElement)bootstrapPolicy);
                Policy policy = (Policy)PolicyModelHelper.createElement((WSDLComponent)bootstrapPolicy, PolicyQName.POLICY.getQName(), Policy.class, false);
                policy.addExtensibilityElement((ExtensibilityElement)extensibilityElement2.copy((Component)policy));
                for (int i = 0; i < 3; ++i) {
                    extensibilityElement = (ExtensibilityElement)SecurityTokensModelHelper.getSupportingToken(wSDLComponent, i);
                    if (extensibilityElement == null) continue;
                    policy.addExtensibilityElement((ExtensibilityElement)extensibilityElement.copy((Component)policy));
                    ((WSDLComponent)extensibilityElement.getParent()).removeExtensibilityElement(extensibilityElement);
                }
                WSDLComponent wSDLComponent3 = SecurityPolicyModelHelper.setSecurityBindingType(wSDLComponent, ComboConstants.SYMMETRIC);
                extensibilityElement = (SecureConversationToken)SecurityTokensModelHelper.setTokenType(wSDLComponent3, "protection", ComboConstants.SECURECONVERSATION);
                SecurityTokensModelHelper.setTokenInclusionLevel((WSDLComponent)extensibilityElement, ComboConstants.ALWAYSRECIPIENT);
                policy = (Policy)PolicyModelHelper.createElement((WSDLComponent)extensibilityElement, PolicyQName.POLICY.getQName(), Policy.class, false);
                ExtensibilityElement extensibilityElement3 = (ExtensibilityElement)bootstrapPolicy.copy((Component)policy);
                policy.addExtensibilityElement(extensibilityElement3);
                wSDLComponent2.removeExtensibilityElement((ExtensibilityElement)bootstrapPolicy);
                policy = (Policy)PolicyModelHelper.getTopLevelElement((WSDLComponent)extensibilityElement3, Policy.class);
                Wss10 wss10 = SecurityPolicyModelHelper.getWss10(wSDLComponent2);
                if (wss10 != null) {
                    policy.addExtensibilityElement((ExtensibilityElement)wss10.copy((Component)policy));
                }
                if ((wss11 = SecurityPolicyModelHelper.getWss11(wSDLComponent2)) != null) {
                    policy.addExtensibilityElement((ExtensibilityElement)wss11.copy((Component)policy));
                }
                if ((trust10 = SecurityPolicyModelHelper.getTrust10(wSDLComponent2)) != null) {
                    policy.addExtensibilityElement((ExtensibilityElement)trust10.copy((Component)policy));
                }
                SecurityPolicyModelHelper.setLayout(wSDLComponent3, ComboConstants.STRICT);
                if (string != null) {
                    AlgoSuiteModelHelper.setAlgorithmSuite(wSDLComponent3, string);
                } else {
                    AlgoSuiteModelHelper.setAlgorithmSuite(wSDLComponent3, ComboConstants.BASIC128);
                }
                if (bl4) {
                    SecurityPolicyModelHelper.enableIncludeTimestamp(wSDLComponent3, true);
                }
                if (bl3) {
                    SecurityPolicyModelHelper.enableSignEntireHeadersAndBody(wSDLComponent3, true);
                }
                boolean bl5 = RMModelHelper.isRMEnabled((WSDLComponent)binding);
                SecurityPolicyModelHelper.setDefaultTargets((WSDLComponent)policy, true, bl5);
                SecurityPolicyModelHelper.disableWss(wSDLComponent2);
                WssElement wssElement = SecurityPolicyModelHelper.enableWss(wSDLComponent2, true);
                SecurityPolicyModelHelper.enableMustSupportRefKeyIdentifier(wssElement, true);
                SecurityPolicyModelHelper.enableMustSupportRefIssuerSerial(wssElement, true);
                SecurityPolicyModelHelper.enableMustSupportRefThumbprint(wssElement, true);
                SecurityPolicyModelHelper.enableMustSupportRefEncryptedKey(wssElement, true);
                SecurityPolicyModelHelper.disableTrust10(wSDLComponent2);
                trust10 = SecurityPolicyModelHelper.enableTrust10(wSDLComponent2);
                SecurityPolicyModelHelper.enableRequireClientEntropy((TrustElement)trust10, true);
                SecurityPolicyModelHelper.enableRequireServerEntropy((TrustElement)trust10, true);
                SecurityPolicyModelHelper.enableMustSupportIssuedTokens((TrustElement)trust10, true);
            } else {
                Trust10 trust10;
                ExtensibilityElement extensibilityElement;
                ExtensibilityElement extensibilityElement4 = SecurityPolicyModelHelper.getSecurityBindingTypeElement(wSDLComponent);
                WSDLComponent wSDLComponent4 = SecurityTokensModelHelper.getTokenElement((WSDLComponent)extensibilityElement4, ProtectionToken.class);
                WSDLComponent wSDLComponent5 = SecurityTokensModelHelper.getTokenTypeElement(wSDLComponent4);
                WSDLComponent wSDLComponent6 = SecurityTokensModelHelper.getTokenElement(wSDLComponent5, BootstrapPolicy.class);
                ExtensibilityElement extensibilityElement5 = SecurityPolicyModelHelper.getSecurityBindingTypeElement(wSDLComponent6);
                WSDLComponent wSDLComponent7 = (WSDLComponent)((WSDLComponent)extensibilityElement4.getParent()).getParent();
                wSDLComponent7.addExtensibilityElement((ExtensibilityElement)extensibilityElement5.copy((Component)wSDLComponent7));
                for (int i = 0; i < 3; ++i) {
                    extensibilityElement = (ExtensibilityElement)SecurityTokensModelHelper.getSupportingToken((WSDLComponent)extensibilityElement5.getParent(), i);
                    if (extensibilityElement == null) continue;
                    wSDLComponent7.addExtensibilityElement((ExtensibilityElement)extensibilityElement.copy((Component)wSDLComponent7));
                    ((WSDLComponent)extensibilityElement.getParent()).removeExtensibilityElement(extensibilityElement);
                }
                Wss10 wss10 = SecurityPolicyModelHelper.getWss10((WSDLComponent)extensibilityElement5.getParent());
                if (wss10 != null) {
                    wSDLComponent7.addExtensibilityElement((ExtensibilityElement)wss10.copy((Component)wSDLComponent7));
                }
                if ((extensibilityElement = SecurityPolicyModelHelper.getWss11((WSDLComponent)extensibilityElement5.getParent())) != null) {
                    wSDLComponent7.addExtensibilityElement((ExtensibilityElement)extensibilityElement.copy((Component)wSDLComponent7));
                }
                if ((trust10 = SecurityPolicyModelHelper.getTrust10((WSDLComponent)extensibilityElement5.getParent())) != null) {
                    wSDLComponent7.addExtensibilityElement((ExtensibilityElement)trust10.copy((Component)wSDLComponent7));
                }
                SecurityPolicyModelHelper.setSecurityBindingType(wSDLComponent, null);
                SecurityPolicyModelHelper.disableWss(wSDLComponent);
                SecurityPolicyModelHelper.disableTrust10(wSDLComponent);
                Object t = PolicyModelHelper.getTopLevelElement(wSDLComponent7, All.class);
                ExtensibilityElement extensibilityElement6 = SecurityPolicyModelHelper.getSecurityBindingTypeElement(wSDLComponent7);
                t.addExtensibilityElement((ExtensibilityElement)extensibilityElement6.copy(t));
                ((WSDLComponent)extensibilityElement6.getParent()).removeExtensibilityElement(extensibilityElement6);
                wss10 = SecurityPolicyModelHelper.getWss10(wSDLComponent7);
                if (wss10 != null) {
                    t.addExtensibilityElement((ExtensibilityElement)wss10.copy(t));
                    ((WSDLComponent)wss10.getParent()).removeExtensibilityElement((ExtensibilityElement)wss10);
                }
                if ((extensibilityElement = SecurityPolicyModelHelper.getWss11(wSDLComponent7)) != null) {
                    t.addExtensibilityElement((ExtensibilityElement)extensibilityElement.copy(t));
                    ((WSDLComponent)extensibilityElement.getParent()).removeExtensibilityElement(extensibilityElement);
                }
                if ((trust10 = SecurityPolicyModelHelper.getTrust10(wSDLComponent7)) != null) {
                    t.addExtensibilityElement((ExtensibilityElement)trust10.copy(t));
                    ((WSDLComponent)trust10.getParent()).removeExtensibilityElement((ExtensibilityElement)trust10);
                }
                for (int i = 0; i < 3; ++i) {
                    ExtensibilityElement extensibilityElement7 = (ExtensibilityElement)SecurityTokensModelHelper.getSupportingToken(wSDLComponent7, i);
                    if (extensibilityElement7 == null) continue;
                    t.addExtensibilityElement((ExtensibilityElement)extensibilityElement7.copy(t));
                    ((WSDLComponent)extensibilityElement7.getParent()).removeExtensibilityElement(extensibilityElement7);
                }
            }
        }
        finally {
            if (!bl2) {
                wSDLModel.endTransaction();
            }
        }
    }
}

