/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collections;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.netbeans.modules.vmd.api.model.ComponentProducer;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.common.DocumentSupport;
import org.netbeans.modules.vmd.midp.codegen.InstanceNameResolver;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.items.GaugeCD;
import org.netbeans.modules.vmd.midp.propertyeditors.BooleanInplaceEditor;
import org.netbeans.modules.vmd.midp.propertyeditors.MidpPropertyEditorSupport;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorUserCode;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.InplaceEditor;
import org.openide.util.NbBundle;

public final class PropertyEditorAlertIndicator
extends PropertyEditorUserCode
implements PropertyEditorElement {
    private CustomEditor customEditor;
    private JRadioButton radioButton;
    private BooleanInplaceEditor inplaceEditor;
    private Boolean valueState;
    private boolean executeInsideWriteTransactionUsed = true;
    private String rbLabel;

    private PropertyEditorAlertIndicator(String string) {
        super(NbBundle.getMessage(PropertyEditorAlertIndicator.class, (String)"LBL_VALUE_ALERT_INDICATOR_UCLABEL"));
        this.rbLabel = string;
        this.initComponents();
        this.initElements(Collections.singleton(this));
    }

    public static PropertyEditorAlertIndicator createInstance(String string) {
        return new PropertyEditorAlertIndicator(string);
    }

    private void initComponents() {
        this.radioButton = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.radioButton, (String)NbBundle.getMessage(PropertyEditorAlertIndicator.class, (String)"LBL_VALUE_ALERT_INDICATOR_STR"));
        this.customEditor = new CustomEditor();
    }

    public JComponent getCustomEditorComponent() {
        return this.customEditor;
    }

    public JRadioButton getRadioButton() {
        return this.radioButton;
    }

    public boolean isInitiallySelected() {
        return true;
    }

    public boolean isVerticallyResizable() {
        return false;
    }

    public boolean isPaintable() {
        PropertyValue propertyValue = (PropertyValue)this.getValue();
        return propertyValue.getKind() != PropertyValue.Kind.USERCODE;
    }

    public InplaceEditor getInplaceEditor() {
        if (this.inplaceEditor == null) {
            this.inplaceEditor = new BooleanInplaceEditor(this);
            PropertyValue propertyValue = (PropertyValue)this.getValue();
            DesignComponent designComponent = propertyValue.getComponent();
            JCheckBox jCheckBox = (JCheckBox)this.inplaceEditor.getComponent();
            if (designComponent != null) {
                jCheckBox.setSelected(true);
            }
            jCheckBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    PropertyEditorAlertIndicator.this.executeInsideWriteTransactionUsed = true;
                    JCheckBox jCheckBox = (JCheckBox)PropertyEditorAlertIndicator.this.inplaceEditor.getComponent();
                    PropertyEditorAlertIndicator.this.valueState = jCheckBox.isSelected();
                    PropertyEditorAlertIndicator.this.setValue(PropertyEditorUserCode.NULL_VALUE);
                    PropertyEditorAlertIndicator.this.invokeSaveToModel();
                }
            });
        } else {
            PropertyValue propertyValue = (PropertyValue)this.getValue();
            DesignComponent designComponent = propertyValue.getComponent();
            JCheckBox jCheckBox = (JCheckBox)this.inplaceEditor.getComponent();
            if (designComponent != null) {
                jCheckBox.setSelected(true);
            } else {
                jCheckBox.setSelected(false);
            }
        }
        return this.inplaceEditor;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        JComponent jComponent = this.inplaceEditor.getComponent();
        jComponent.setSize(rectangle.width, rectangle.height);
        jComponent.doLayout();
        jComponent.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        Graphics graphics2 = graphics.create(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        jComponent.setOpaque(false);
        jComponent.paint(graphics2);
        graphics2.dispose();
    }

    public String getAsText() {
        if (this.isCurrentValueAUserCodeType()) {
            return USER_CODE_TEXT;
        }
        if (this.isCurrentValueANull()) {
            return "false";
        }
        return "true";
    }

    public void setTextForPropertyValue(String string) {
    }

    public String getTextForPropertyValue() {
        return null;
    }

    public void updateState(PropertyValue propertyValue) {
        this.customEditor.setValue(propertyValue);
        this.radioButton.setSelected(!this.isCurrentValueAUserCodeType());
    }

    public boolean isExecuteInsideWriteTransactionUsed() {
        return this.executeInsideWriteTransactionUsed;
    }

    public Object getDefaultValue() {
        this.executeInsideWriteTransactionUsed = false;
        return super.getDefaultValue();
    }

    public boolean executeInsideWriteTransaction() {
        if (this.component == null || this.component.get() == null) {
            return false;
        }
        DesignComponent designComponent = (DesignComponent)this.component.get();
        if (this.isCurrentValueAUserCodeType()) {
            this.removeGauge(designComponent);
            return true;
        }
        if (this.valueState.booleanValue()) {
            if (designComponent.readProperty("indicator").getComponent() != null) {
                return false;
            }
            ComponentProducer componentProducer = DocumentSupport.getComponentProducer((DesignDocument)designComponent.getDocument(), (String)GaugeCD.TYPEID.toString());
            if (componentProducer == null) {
                throw new IllegalStateException("No producer for TypeID : " + GaugeCD.TYPEID);
            }
            DesignComponent designComponent2 = componentProducer.createComponent(designComponent.getDocument()).getMainComponent();
            designComponent2.writeProperty("interactive", MidpTypes.createBooleanValue(false));
            designComponent2.writeProperty("usedByAlert", MidpTypes.createBooleanValue(true));
            designComponent2.writeProperty("label", PropertyValue.createNull());
            designComponent2.writeProperty("instanceName", InstanceNameResolver.createFromSuggested(designComponent2, "indicator"));
            PropertyValue propertyValue = PropertyValue.createComponentReference((DesignComponent)designComponent2);
            PropertyEditorAlertIndicator.super.setValue(propertyValue);
            designComponent.addComponent(designComponent2);
            designComponent.writeProperty("indicator", propertyValue);
        } else {
            this.removeGauge(designComponent);
        }
        return false;
    }

    private boolean removeGauge(DesignComponent designComponent) {
        DesignComponent designComponent2 = designComponent.readProperty("indicator").getComponent();
        if (designComponent2 == null) {
            designComponent.writeProperty("indicator", NULL_VALUE);
            PropertyEditorAlertIndicator.super.setValue(PropertyEditorAlertIndicator.NULL_VALUE);
            return false;
        }
        designComponent.writeProperty("indicator", PropertyValue.createNull());
        designComponent.getDocument().deleteComponent(designComponent2);
        PropertyEditorAlertIndicator.super.setValue(PropertyEditorAlertIndicator.NULL_VALUE);
        return false;
    }

    public void customEditorOKButtonPressed() {
        super.customEditorOKButtonPressed();
        this.executeInsideWriteTransactionUsed = true;
        if (this.radioButton.isSelected()) {
            this.valueState = "true".equals(this.customEditor.getText()) ? Boolean.valueOf(true) : Boolean.valueOf(false);
            JCheckBox jCheckBox = (JCheckBox)this.inplaceEditor.getComponent();
            jCheckBox.setSelected(this.valueState);
            this.setValue(NULL_VALUE);
            this.invokeSaveToModel();
        }
    }

    public boolean canWrite() {
        return MidpPropertyEditorSupport.singleSelectionEditAsTextOnly();
    }

    private class CustomEditor
    extends JPanel
    implements ActionListener {
        private JCheckBox checkBox;

        public CustomEditor() {
            this.initComponents();
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.checkBox = new JCheckBox();
            if (PropertyEditorAlertIndicator.this.rbLabel != null) {
                Mnemonics.setLocalizedText((AbstractButton)this.checkBox, (String)PropertyEditorAlertIndicator.this.rbLabel);
            }
            this.checkBox.addActionListener(this);
            this.add((Component)this.checkBox, "Center");
        }

        public void setValue(PropertyValue propertyValue) {
            this.checkBox.setSelected(propertyValue != null && propertyValue.getPrimitiveValue() != null && MidpTypes.getBoolean(propertyValue));
        }

        public String getText() {
            return this.checkBox.isSelected() ? "true" : "false";
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PropertyEditorAlertIndicator.this.radioButton.setSelected(true);
        }
    }
}

