/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collections;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.propertyeditors.BooleanInplaceEditor;
import org.netbeans.modules.vmd.midp.propertyeditors.MidpPropertyEditorSupport;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorUserCode;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.InplaceEditor;
import org.openide.util.NbBundle;

public class PropertyEditorBooleanUC
extends PropertyEditorUserCode
implements PropertyEditorElement {
    private static final PropertyValue TRUE_VALUE = MidpTypes.createBooleanValue(true);
    private static final PropertyValue FALSE_VALUE = MidpTypes.createBooleanValue(false);
    private CustomEditor customEditor;
    private JRadioButton radioButton;
    private BooleanInplaceEditor inplaceEditor;
    private boolean supportsCustomEditor;
    private TypeID parentTypeID;
    private String rbLabel;

    private PropertyEditorBooleanUC(boolean bl, TypeID typeID, String string) {
        super(NbBundle.getMessage(PropertyEditorBooleanUC.class, (String)"LBL_VALUE_BOOLEAN_UCLABEL"));
        this.supportsCustomEditor = bl;
        this.parentTypeID = typeID;
        this.rbLabel = string;
        this.initElements(Collections.singleton(this));
        super.getUserCodeRadioButton().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                PropertyEditorBooleanUC.this.customEditor.checkBox.setSelected(false);
            }

            public void focusLost(FocusEvent focusEvent) {
            }
        });
    }

    public static PropertyEditorBooleanUC createInstance() {
        return new PropertyEditorBooleanUC(false, null, null);
    }

    public static PropertyEditorBooleanUC createInstance(String string) {
        return new PropertyEditorBooleanUC(true, null, string);
    }

    public static PropertyEditorBooleanUC createInstance(TypeID typeID, String string) {
        return new PropertyEditorBooleanUC(true, typeID, string);
    }

    public InplaceEditor getInplaceEditor() {
        if (this.inplaceEditor == null) {
            this.inplaceEditor = new BooleanInplaceEditor(this);
            PropertyValue propertyValue = (PropertyValue)this.getValue();
            Boolean bl = (Boolean)propertyValue.getPrimitiveValue();
            JCheckBox jCheckBox = (JCheckBox)this.inplaceEditor.getComponent();
            if (bl != null) {
                jCheckBox.setSelected(bl);
            }
            jCheckBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    JCheckBox jCheckBox = (JCheckBox)PropertyEditorBooleanUC.this.inplaceEditor.getComponent();
                    PropertyValue propertyValue = MidpTypes.createBooleanValue(jCheckBox.isSelected());
                    PropertyEditorBooleanUC.this.setValue(propertyValue);
                }
            });
        } else {
            PropertyValue propertyValue = (PropertyValue)this.getValue();
            Boolean bl = (Boolean)propertyValue.getPrimitiveValue();
            JCheckBox jCheckBox = (JCheckBox)this.inplaceEditor.getComponent();
            if (bl == null || !bl.booleanValue()) {
                jCheckBox.setSelected(false);
            } else {
                jCheckBox.setSelected(true);
            }
        }
        return this.inplaceEditor;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        JComponent jComponent = this.inplaceEditor.getComponent();
        jComponent.setSize(rectangle.width, rectangle.height);
        jComponent.doLayout();
        jComponent.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        Graphics graphics2 = graphics.create(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        jComponent.setOpaque(false);
        jComponent.paint(graphics2);
        graphics2.dispose();
    }

    public boolean supportsCustomEditor() {
        if (!this.isWriteableByParentType()) {
            return false;
        }
        return this.supportsCustomEditor ? super.supportsCustomEditor() : false;
    }

    public JComponent getCustomEditorComponent() {
        if (this.customEditor == null) {
            this.customEditor = new CustomEditor();
        }
        return this.customEditor;
    }

    public JRadioButton getRadioButton() {
        if (this.radioButton == null) {
            this.radioButton = new JRadioButton();
            Mnemonics.setLocalizedText((AbstractButton)this.radioButton, (String)NbBundle.getMessage(PropertyEditorBooleanUC.class, (String)"LBL_VALUE_BOOLEAN"));
        }
        return this.radioButton;
    }

    public boolean isPaintable() {
        PropertyValue propertyValue = (PropertyValue)this.getValue();
        return propertyValue.getKind() == PropertyValue.Kind.VALUE;
    }

    public boolean isVerticallyResizable() {
        return false;
    }

    public boolean isInitiallySelected() {
        return false;
    }

    public String getAsText() {
        if (this.isCurrentValueAUserCodeType()) {
            return USER_CODE_TEXT;
        }
        if (this.isCurrentValueANull()) {
            return "false";
        }
        return MidpTypes.getBoolean((PropertyValue)super.getValue()) ? "true" : "false";
    }

    public void setTextForPropertyValue(String string) {
        this.saveValue(string);
    }

    public String getTextForPropertyValue() {
        return null;
    }

    public void updateState(PropertyValue propertyValue) {
        this.customEditor.setValue(propertyValue);
        this.radioButton.setSelected(!this.isCurrentValueAUserCodeType());
    }

    private void saveValue(String string) {
        super.setValue((Object)("false".equals(string) ? FALSE_VALUE : TRUE_VALUE));
    }

    public void customEditorOKButtonPressed() {
        super.customEditorOKButtonPressed();
        if (this.radioButton.isSelected()) {
            this.saveValue(this.customEditor.getText());
            if ("true".equals(this.customEditor.getText())) {
                this.updateInplaceEditorComponent(true);
            } else {
                this.updateInplaceEditorComponent(false);
            }
        }
    }

    public boolean canWrite() {
        if (!this.isWriteableByParentType()) {
            return false;
        }
        return MidpPropertyEditorSupport.singleSelectionEditAsTextOnly();
    }

    public Object getDefaultValue() {
        PropertyValue propertyValue = (PropertyValue)super.getDefaultValue();
        if (propertyValue.getKind() == PropertyValue.Kind.VALUE && propertyValue.getPrimitiveValue() instanceof Boolean) {
            this.updateInplaceEditorComponent((Boolean)propertyValue.getPrimitiveValue());
        }
        return super.getDefaultValue();
    }

    private boolean isWriteableByParentType() {
        if (this.component == null || this.component.get() == null) {
            return false;
        }
        if (this.parentTypeID != null) {
            final DesignComponent designComponent = (DesignComponent)this.component.get();
            final DesignComponent[] designComponentArray = new DesignComponent[1];
            designComponent.getDocument().getTransactionManager().readAccess(new Runnable(){

                public void run() {
                    designComponentArray[0] = designComponent.getParentComponent();
                }
            });
            if (designComponentArray[0] != null && this.parentTypeID.equals((Object)designComponentArray[0].getType())) {
                return false;
            }
        }
        return true;
    }

    private void updateInplaceEditorComponent(boolean bl) {
        JCheckBox jCheckBox = (JCheckBox)this.inplaceEditor.getComponent();
        jCheckBox.setSelected(bl);
    }

    private class CustomEditor
    extends JPanel
    implements ActionListener {
        private JCheckBox checkBox;

        public CustomEditor() {
            this.initComponents();
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.checkBox = new JCheckBox();
            if (PropertyEditorBooleanUC.this.rbLabel != null) {
                Mnemonics.setLocalizedText((AbstractButton)this.checkBox, (String)PropertyEditorBooleanUC.this.rbLabel);
            }
            this.checkBox.addActionListener(this);
            this.add((Component)this.checkBox, "Center");
        }

        public void setValue(PropertyValue propertyValue) {
            this.checkBox.setSelected(propertyValue != null && propertyValue.getPrimitiveValue() != null && MidpTypes.getBoolean(propertyValue));
        }

        public String getText() {
            return this.checkBox.isSelected() ? "true" : "false";
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PropertyEditorBooleanUC.this.radioButton.setSelected(true);
        }
    }
}

