/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.serialization;

import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.netbeans.modules.vmd.api.model.PropertyDescriptor;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.Versionable;
import org.netbeans.modules.vmd.midp.components.MidpTypes;

public final class MidpTypesConvertor {
    public static PropertyDescriptor createPropertyDescriptorForParameter(String string, boolean bl, VariableElement variableElement) {
        TypeMirror typeMirror = variableElement.asType();
        switch (typeMirror.getKind()) {
            case BOOLEAN: {
                return MidpTypesConvertor.createProperty(string, bl, MidpTypes.TYPEID_BOOLEAN, PropertyValue.createUserCode((String)"false"));
            }
            case BYTE: {
                return MidpTypesConvertor.createProperty(string, bl, MidpTypes.TYPEID_BYTE, PropertyValue.createUserCode((String)"(byte) 0"));
            }
            case CHAR: {
                return MidpTypesConvertor.createProperty(string, bl, MidpTypes.TYPEID_CHAR, PropertyValue.createUserCode((String)"(char) 0"));
            }
            case SHORT: {
                return MidpTypesConvertor.createProperty(string, bl, MidpTypes.TYPEID_SHORT, PropertyValue.createUserCode((String)"(short) 0"));
            }
            case DOUBLE: {
                return MidpTypesConvertor.createProperty(string, bl, MidpTypes.TYPEID_DOUBLE, PropertyValue.createUserCode((String)"0.0"));
            }
            case FLOAT: {
                return MidpTypesConvertor.createProperty(string, bl, MidpTypes.TYPEID_FLOAT, PropertyValue.createUserCode((String)"0.0f"));
            }
            case INT: {
                return MidpTypesConvertor.createProperty(string, bl, MidpTypes.TYPEID_INT, PropertyValue.createUserCode((String)"0"));
            }
            case LONG: {
                return MidpTypesConvertor.createProperty(string, bl, MidpTypes.TYPEID_LONG, PropertyValue.createUserCode((String)"0l"));
            }
            case DECLARED: {
                String string2 = ((TypeElement)((DeclaredType)typeMirror).asElement()).getQualifiedName().toString();
                if (!"java.lang.String".equals(string2)) break;
                return new PropertyDescriptor(string, MidpTypes.TYPEID_JAVA_LANG_STRING, PropertyValue.createNull(), true, true, Versionable.FOREVER);
            }
        }
        return new PropertyDescriptor(string, MidpTypes.TYPEID_JAVA_CODE, MidpTypes.createJavaCodeValue("null"), false, true, Versionable.FOREVER);
    }

    private static PropertyDescriptor createProperty(String string, boolean bl, TypeID typeID, PropertyValue propertyValue) {
        return new PropertyDescriptor(string, typeID, bl ? propertyValue : PropertyValue.createNull(), !bl, true, Versionable.FOREVER);
    }
}

