/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components.tree;

import java.util.Collection;
import java.util.LinkedList;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class CheckTreeNode
extends DefaultMutableTreeNode {
    public static final int STATE_CHECKED = 1;
    public static final int STATE_UNCHECKED = 2;
    public static final int STATE_PARTIALLY_CHECKED = 4;
    protected int checkState = 2;
    private Icon icon;

    public CheckTreeNode() {
        this(null);
    }

    public CheckTreeNode(Object object) {
        this(object, null);
    }

    public CheckTreeNode(Object object, Icon icon) {
        super(object);
        this.setChecked(false);
        this.icon = icon;
    }

    public int getCheckState() {
        return this.checkState;
    }

    public Collection setChecked(boolean bl) {
        if (bl) {
            return this.setFullyChecked();
        }
        return this.setUnchecked();
    }

    public boolean isFullyChecked() {
        return this.getCheckState() == 1;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public boolean isPartiallyChecked() {
        return this.getCheckState() == 4;
    }

    public Collection toggleState() {
        if (this.getCheckState() == 1) {
            return this.setUnchecked();
        }
        return this.setFullyChecked();
    }

    protected Collection setPartiallyChecked() {
        LinkedList<CheckTreeNode> linkedList = new LinkedList<CheckTreeNode>();
        linkedList.add(this);
        if (this.checkState == 4) {
            return linkedList;
        }
        this.checkState = 4;
        TreeNode treeNode = this.getParent();
        if (treeNode != null && treeNode instanceof CheckTreeNode) {
            linkedList.addAll(((CheckTreeNode)treeNode).setPartiallyChecked());
        }
        return linkedList;
    }

    private Collection setFullyChecked() {
        TreeNode treeNode;
        LinkedList<CheckTreeNode> linkedList = new LinkedList<CheckTreeNode>();
        linkedList.add(this);
        if (this.checkState == 1) {
            return linkedList;
        }
        this.checkState = 1;
        if (!this.isLeaf()) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                TreeNode treeNode2 = this.getChildAt(i);
                if (!(treeNode2 instanceof CheckTreeNode)) continue;
                linkedList.addAll(((CheckTreeNode)treeNode2).setFullyChecked());
            }
        }
        if ((treeNode = this.getParent()) != null && treeNode instanceof CheckTreeNode) {
            if (this.areSiblingsFullyChecked()) {
                linkedList.addAll(((CheckTreeNode)treeNode).setFullyChecked());
            } else {
                linkedList.addAll(((CheckTreeNode)treeNode).setPartiallyChecked());
            }
        }
        return linkedList;
    }

    private Collection setUnchecked() {
        TreeNode treeNode;
        LinkedList<CheckTreeNode> linkedList = new LinkedList<CheckTreeNode>();
        linkedList.add(this);
        if (this.checkState == 2) {
            return linkedList;
        }
        this.checkState = 2;
        if (!this.isLeaf()) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                TreeNode treeNode2 = this.getChildAt(i);
                if (!(treeNode2 instanceof CheckTreeNode)) continue;
                linkedList.addAll(((CheckTreeNode)treeNode2).setUnchecked());
            }
        }
        if ((treeNode = this.getParent()) != null && treeNode instanceof CheckTreeNode) {
            if (this.areSiblingsUnchecked()) {
                linkedList.addAll(((CheckTreeNode)treeNode).setUnchecked());
            } else {
                linkedList.addAll(((CheckTreeNode)treeNode).setPartiallyChecked());
            }
        }
        return linkedList;
    }

    private boolean areSiblingsFullyChecked() {
        TreeNode treeNode = this.getParent();
        for (int i = 0; i < treeNode.getChildCount(); ++i) {
            TreeNode treeNode2 = treeNode.getChildAt(i);
            if (treeNode2 == this || treeNode2 instanceof CheckTreeNode && ((CheckTreeNode)treeNode2).getCheckState() == 1) continue;
            return false;
        }
        return true;
    }

    private boolean areSiblingsUnchecked() {
        TreeNode treeNode = this.getParent();
        for (int i = 0; i < treeNode.getChildCount(); ++i) {
            TreeNode treeNode2 = treeNode.getChildAt(i);
            if (treeNode2 == this || treeNode2 instanceof CheckTreeNode && ((CheckTreeNode)treeNode2).getCheckState() == 2) continue;
            return false;
        }
        return true;
    }
}

