/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.monitor;

import java.awt.Color;
import java.util.ResourceBundle;
import org.netbeans.lib.profiler.results.monitor.VMTelemetryDataManager;
import org.netbeans.lib.profiler.ui.charts.AsyncMarksProvider;
import org.netbeans.lib.profiler.ui.monitor.VMTelemetryXYChartModel;

public class SurvivingGenerationsXYChartModel
extends VMTelemetryXYChartModel
implements AsyncMarksProvider {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.monitor.Bundle");
    private static final String SURVGEN_STRING = messages.getString("SurvivingGenerationsXYChartModel_SurvGenString");
    private static final String TIME_REL_STRING = messages.getString("SurvivingGenerationsXYChartModel_TimeRelString");
    private static final Color GC_MARKS_COLOR = new Color(250, 230, 230);

    public SurvivingGenerationsXYChartModel(VMTelemetryDataManager vMTelemetryDataManager) {
        super(vMTelemetryDataManager);
        this.setupModel(new String[]{SURVGEN_STRING, TIME_REL_STRING}, new Color[]{new Color(255, 127, 127), new Color(127, 63, 191)});
    }

    public Color getMarkColor() {
        return GC_MARKS_COLOR;
    }

    public long getMarkEnd(int n) {
        return this.vmTelemetryDataManager.gcFinishs[n];
    }

    public long getMarkStart(int n) {
        return this.vmTelemetryDataManager.gcStarts[n];
    }

    public int getMarksCount() {
        return this.vmTelemetryDataManager.getGCItemCount();
    }

    public long getMaxDisplayYValue(int n) {
        switch (n) {
            case 0: {
                return this.getMaxYValue(0);
            }
            case 1: {
                return 1000L;
            }
        }
        return 0L;
    }

    protected long[] getYValues(int n) {
        switch (n) {
            case 0: {
                return this.vmTelemetryDataManager.nSurvivingGenerations;
            }
            case 1: {
                return this.vmTelemetryDataManager.relativeGCTimeInPerMil;
            }
        }
        return null;
    }
}

