/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.io;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.core.api.multiview.MultiViewHandler;
import org.netbeans.core.api.multiview.MultiViewPerspective;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.modules.vmd.api.io.DataEditorView;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.providers.IOSupport;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectUtils {
    private ProjectUtils() {
    }

    public static String getProjectID(Project project) {
        return FileUtil.toFile((FileObject)project.getProjectDirectory()).toURI().toString();
    }

    public static Project getProject(String string) {
        try {
            return FileOwnerQuery.getOwner((URI)new URI(string));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw Debug.error((Object[])new Object[]{uRISyntaxException});
        }
    }

    public static Project getProject(DataObjectContext dataObjectContext) {
        if (dataObjectContext == null) {
            return null;
        }
        return FileOwnerQuery.getOwner((FileObject)dataObjectContext.getDataObject().getPrimaryFile());
    }

    public static Project getProject(DesignDocument designDocument) {
        return ProjectUtils.getProject(ProjectUtils.getDataObjectContextForDocument(designDocument));
    }

    public static DataObjectContext getDataObjectContextForDocument(DesignDocument designDocument) {
        return IOSupport.getDataObjectContextForDocumentInterface(designDocument);
    }

    public static List<SourceGroup> getSourceGroups(DataObjectContext dataObjectContext) {
        assert (dataObjectContext != null);
        Project project = ProjectUtils.getProject(dataObjectContext);
        Sources sources = org.netbeans.api.project.ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
        return Arrays.asList(sourceGroupArray);
    }

    public static List<SourceGroup> getSourceGroups(String string) {
        assert (string != null);
        Project project = ProjectUtils.getProject(string);
        if (project == null) {
            return null;
        }
        Sources sources = org.netbeans.api.project.ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
        return Arrays.asList(sourceGroupArray);
    }

    public static void requestVisibility(DataObjectContext dataObjectContext, String string) {
        block0: for (TopComponent topComponent : TopComponent.getRegistry().getOpened()) {
            DataEditorView dataEditorView = (DataEditorView)topComponent.getLookup().lookup(DataEditorView.class);
            if (dataEditorView == null || dataEditorView.getContext() != dataObjectContext) continue;
            MultiViewHandler multiViewHandler = MultiViews.findMultiViewHandler((TopComponent)topComponent);
            for (MultiViewPerspective multiViewPerspective : multiViewHandler.getPerspectives()) {
                if (!multiViewPerspective.getDisplayName().equals(string)) continue;
                multiViewHandler.requestVisible(multiViewPerspective);
                continue block0;
            }
        }
    }

    public static String getSourceEditorViewDisplayName() {
        return NbBundle.getMessage(ProjectUtils.class, (String)"LBL_SourceEditorView");
    }
}

