/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.io.File;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.makeproject.api.MakeArtifact;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.platforms.Platform;
import org.netbeans.modules.cnd.makeproject.api.platforms.Platforms;
import org.netbeans.modules.cnd.makeproject.api.remote.FilePathAdaptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class LibraryItem {
    public static final int PROJECT_ITEM = 0;
    public static final int STD_LIB_ITEM = 1;
    public static final int LIB_ITEM = 2;
    public static final int LIB_FILE_ITEM = 3;
    public static final int OPTION_ITEM = 4;
    private int type;

    protected LibraryItem() {
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public String getToolTip() {
        return "Should be overridden";
    }

    public String getIconName() {
        return "org/netbeans/modules/cnd/resources/blank.gif";
    }

    public void setValue(String string) {
    }

    public String toString() {
        return "Should be overridden";
    }

    public String getOption() {
        return "";
    }

    public String getOption(MakeConfiguration makeConfiguration) {
        return "" + this.getOption();
    }

    public boolean canEdit() {
        return false;
    }

    public Object clone() {
        return this;
    }

    private static String getString(String string) {
        return NbBundle.getMessage(LibraryItem.class, (String)string);
    }

    public static class OptionItem
    extends LibraryItem {
        private String libraryOption;

        public OptionItem(String string) {
            this.libraryOption = string;
            this.setType(4);
        }

        public String getLibraryOption() {
            return this.libraryOption;
        }

        public void setLibraryOption(String string) {
            this.libraryOption = string;
        }

        public String getToolTip() {
            return LibraryItem.getString("LibraryOptionTxt") + " " + this.getLibraryOption() + " (" + this.getOption() + ")";
        }

        public String getIconName() {
            return "org/netbeans/modules/cnd/makeproject/ui/resources/general.gif";
        }

        public String toString() {
            return this.getLibraryOption();
        }

        public void setValue(String string) {
            this.setLibraryOption(string);
        }

        public String getOption() {
            return this.getLibraryOption();
        }

        public boolean canEdit() {
            return true;
        }

        public Object clone() {
            return new OptionItem(this.getLibraryOption());
        }
    }

    public static class LibFileItem
    extends LibraryItem {
        private String path;

        public LibFileItem(String string) {
            this.path = string;
            this.setType(3);
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String string) {
            this.path = string;
        }

        public String getToolTip() {
            return LibraryItem.getString("LibraryFileTxt") + " " + this.getPath() + " (" + this.getOption() + ")";
        }

        public String getIconName() {
            if (this.getPath().endsWith(".so") || this.getPath().endsWith(".dll") || this.getPath().endsWith(".dylib")) {
                return "org/netbeans/modules/cnd/loaders/DllIcon.gif";
            }
            if (this.getPath().endsWith(".a")) {
                return "org/netbeans/modules/cnd/loaders/static_library.gif";
            }
            return "org/netbeans/modules/cnd/loaders/unknown.gif";
        }

        public String toString() {
            return this.getPath();
        }

        public void setValue(String string) {
            this.setPath(string);
        }

        public String getOption() {
            return this.getPath();
        }

        public boolean canEdit() {
            return true;
        }

        public Object clone() {
            return new LibFileItem(this.getPath());
        }
    }

    public static class LibItem
    extends LibraryItem {
        private String libName;

        public LibItem(String string) {
            this.libName = string;
            this.setType(2);
        }

        public String getLibName() {
            return this.libName;
        }

        public void setLibName(String string) {
            this.libName = string;
        }

        public String getToolTip() {
            return LibraryItem.getString("LibraryTxt") + "  " + this.getLibName() + " (" + this.getOption() + ")";
        }

        public String getIconName() {
            return "org/netbeans/modules/cnd/loaders/LibraryIcon.gif";
        }

        public String toString() {
            return this.getLibName();
        }

        public void setValue(String string) {
            this.setLibName(string);
        }

        public String getOption() {
            return "-l" + this.getLibName();
        }

        public boolean canEdit() {
            return true;
        }

        public Object clone() {
            return new LibItem(this.getLibName());
        }
    }

    public static class StdLibItem
    extends LibraryItem {
        private String name;
        private String displayName;
        private String[] libs;

        public StdLibItem(String string, String string2, String[] stringArray) {
            this.name = string;
            this.displayName = string2;
            this.libs = stringArray;
            this.setType(1);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String string) {
            this.displayName = string;
        }

        public String[] getLibs() {
            return this.libs;
        }

        public void setLibs(String[] stringArray) {
            this.libs = stringArray;
        }

        public String getToolTip() {
            return LibraryItem.getString("StandardLibraryTxt") + " " + this.getDisplayName() + " (" + this.getOption() + ")";
        }

        public String getIconName() {
            return "org/netbeans/modules/cnd/resources/stdLibrary.gif";
        }

        public String toString() {
            return this.getDisplayName();
        }

        public void setValue(String string) {
        }

        public String getOption() {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < this.libs.length; ++i) {
                if (this.libs[i].charAt(0) != '-') {
                    stringBuilder.append("-l" + this.libs[i] + " ");
                    continue;
                }
                stringBuilder.append(this.libs[i] + " ");
            }
            return stringBuilder.toString();
        }

        public boolean canEdit() {
            return false;
        }

        public Object clone() {
            StdLibItem stdLibItem = new StdLibItem(this.getName(), this.getDisplayName(), this.getLibs());
            return stdLibItem;
        }
    }

    public static class ProjectItem
    extends LibraryItem {
        private MakeArtifact makeArtifact;
        private Project project;

        public ProjectItem(MakeArtifact makeArtifact) {
            this.makeArtifact = makeArtifact;
            this.setType(0);
        }

        public MakeArtifact getMakeArtifact() {
            return this.makeArtifact;
        }

        public void setMakeArtifact(MakeArtifact makeArtifact) {
            this.makeArtifact = makeArtifact;
        }

        public Project getProject(String string) {
            if (this.project == null) {
                String string2 = IpeUtils.toAbsolutePath((String)string, (String)this.getMakeArtifact().getProjectLocation());
                string2 = FilePathAdaptor.mapToLocal(string2);
                try {
                    FileObject fileObject = FileUtil.toFileObject((File)new File(string2).getCanonicalFile());
                    this.project = ProjectManager.getDefault().findProject(fileObject);
                }
                catch (Exception exception) {
                    System.err.println("Cannot find subproject in '" + string2 + "' " + exception);
                }
            }
            return this.project;
        }

        public String getToolTip() {
            String string = LibraryItem.getString("ProjectTxt") + " " + this.getMakeArtifact().getProjectLocation();
            if (this.getMakeArtifact().getOutput() != null && this.getMakeArtifact().getOutput().length() > 0) {
                string = string + " (" + this.getMakeArtifact().getOutput() + ")";
            }
            return string;
        }

        public String getIconName() {
            return "org/netbeans/modules/cnd/makeproject/ui/resources/makeProject.gif";
        }

        public String toString() {
            String string = IpeUtils.getBaseName((String)this.getMakeArtifact().getProjectLocation());
            if (this.getMakeArtifact().getOutput() != null && this.getMakeArtifact().getOutput().length() > 0) {
                string = string + " (" + this.getMakeArtifact().getOutput() + ")";
            }
            return string;
        }

        public void setValue(String string) {
        }

        public String getOption(MakeConfiguration makeConfiguration) {
            CompilerSet compilerSet = CompilerSetManager.getDefault().getCompilerSet(makeConfiguration.getCompilerSet().getValue());
            Platform platform = Platforms.getPlatform(makeConfiguration.getPlatform().getValue());
            String string = this.getMakeArtifact().getOutput();
            if (!IpeUtils.isPathAbsolute((String)string)) {
                string = this.getMakeArtifact().getProjectLocation() + '/' + string;
            }
            string = IpeUtils.escapeOddCharacters((String)string);
            String string2 = IpeUtils.getDirName((String)string);
            String string3 = IpeUtils.getBaseName((String)string);
            return platform.getLibraryLinkOption(string3, string2, string, compilerSet);
        }

        public boolean canEdit() {
            return false;
        }

        public Object clone() {
            ProjectItem projectItem = new ProjectItem(this.getMakeArtifact());
            return projectItem;
        }
    }
}

