/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.platforms;

import java.util.ArrayList;
import org.netbeans.modules.cnd.makeproject.api.platforms.Platform;
import org.netbeans.modules.cnd.makeproject.api.platforms.PlatformGeneric;
import org.netbeans.modules.cnd.makeproject.api.platforms.PlatformLinux;
import org.netbeans.modules.cnd.makeproject.api.platforms.PlatformMacOSX;
import org.netbeans.modules.cnd.makeproject.api.platforms.PlatformSolarisIntel;
import org.netbeans.modules.cnd.makeproject.api.platforms.PlatformSolarisSparc;
import org.netbeans.modules.cnd.makeproject.api.platforms.PlatformWindows;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Platforms {
    private static ArrayList<Platform> platforms = null;
    private static Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Platform> getPlatforms() {
        Object object = lock;
        synchronized (object) {
            if (platforms == null) {
                platforms = new ArrayList();
                platforms.add(new PlatformSolarisSparc());
                platforms.add(new PlatformSolarisIntel());
                platforms.add(new PlatformLinux());
                platforms.add(new PlatformWindows());
                platforms.add(new PlatformMacOSX());
                platforms.add(new PlatformGeneric());
            }
            return platforms;
        }
    }

    public static Platform getPlatform(String string) {
        for (Platform platform : Platforms.getPlatforms()) {
            if (!platform.getName().equals(string)) continue;
            return platform;
        }
        return null;
    }

    public static Platform getPlatform(int n) {
        for (Platform platform : Platforms.getPlatforms()) {
            if (platform.getId() != n) continue;
            return platform;
        }
        return null;
    }

    public static String[] getPlatformDisplayNames() {
        String[] stringArray = new String[Platforms.getPlatforms().size()];
        int n = 0;
        for (Platform platform : Platforms.getPlatforms()) {
            stringArray[n++] = platform.getDisplayName();
        }
        return stringArray;
    }
}

