/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.configurations;

import org.netbeans.modules.cnd.api.compilers.Tool;
import org.netbeans.modules.cnd.api.xml.AttrValuePair;
import org.netbeans.modules.cnd.api.xml.VersionException;
import org.netbeans.modules.cnd.api.xml.XMLDecoder;
import org.netbeans.modules.cnd.api.xml.XMLEncoder;
import org.netbeans.modules.cnd.api.xml.XMLEncoderStream;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.configurations.CommonConfigurationXMLCodec;
import org.xml.sax.Attributes;

public class ItemXMLCodec
extends XMLDecoder
implements XMLEncoder {
    private ItemConfiguration item;
    public static final String ITEM_ELEMENT = "item";
    public static final String PATH_ATTR = "path";
    public static final String EXCLUDED_ELEMENT = "excluded";
    public static final String TOOL_ELEMENT = "tool";
    public static final String ITEM_EXCLUDED_ELEMENT = "itemExcluded";
    public static final String ITEM_TOOL_ELEMENT = "itemTool";
    public static final String DEBUGGING_ELEMENT = "justfordebugging";
    public static final String TRUE_VALUE = "true";
    public static final String FALSE_VALUE = "false";

    public ItemXMLCodec(ItemConfiguration itemConfiguration) {
        this.item = itemConfiguration;
    }

    public String tag() {
        return this.item.getId();
    }

    public void start(Attributes attributes) throws VersionException {
        String string = ITEM_ELEMENT;
        int n = 1;
        this.checkVersion(attributes, string, n);
    }

    public void end() {
    }

    public void startElement(String string, Attributes attributes) {
    }

    public void endElement(String string, String string2) {
    }

    public void encode(XMLEncoderStream xMLEncoderStream) {
        xMLEncoderStream.elementOpen(ITEM_ELEMENT, new AttrValuePair[]{new AttrValuePair(PATH_ATTR, this.item.getItem().getPath())});
        if (this.item.getExcluded().getModified()) {
            xMLEncoderStream.element(ITEM_EXCLUDED_ELEMENT, "" + this.item.getExcluded().getValue());
        }
        xMLEncoderStream.element(ITEM_TOOL_ELEMENT, "" + this.item.getTool());
        if (this.item.getTool() == Tool.CCompiler) {
            CommonConfigurationXMLCodec.writeCCompilerConfiguration(xMLEncoderStream, this.item.getCCompilerConfiguration());
        } else if (this.item.getTool() == Tool.CCCompiler) {
            CommonConfigurationXMLCodec.writeCCCompilerConfiguration(xMLEncoderStream, this.item.getCCCompilerConfiguration());
        } else if (this.item.getTool() == Tool.FortranCompiler) {
            CommonConfigurationXMLCodec.writeFortranCompilerConfiguration(xMLEncoderStream, this.item.getFortranCompilerConfiguration());
        } else if (this.item.getTool() == Tool.CustomTool) {
            CommonConfigurationXMLCodec.writeCustomToolConfiguration(xMLEncoderStream, this.item.getCustomToolConfiguration());
        }
        xMLEncoderStream.elementClose(ITEM_ELEMENT);
    }
}

