/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.options;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.Tool;
import org.netbeans.modules.cnd.makeproject.NativeProjectProvider;
import org.netbeans.modules.cnd.makeproject.api.compilers.CCCCompiler;
import org.netbeans.modules.cnd.makeproject.ui.options.CodeAssistancePanelController;
import org.netbeans.modules.cnd.makeproject.ui.options.PredefinedPanel;
import org.netbeans.modules.cnd.ui.options.ToolsPanel;
import org.openide.util.NbBundle;

public class ParserSettingsPanel
extends JPanel
implements ChangeListener,
ActionListener {
    private HashMap predefinedPanels = new HashMap();
    private boolean updating = false;
    private boolean modified = false;
    private ToolsPanel tp;
    private JPanel collectionPanel;
    private JComboBox compilerCollectionComboBox;
    private JLabel compilerCollectionLabel;
    private JScrollPane scrollPane;
    private JPanel tabPanel;
    private JTabbedPane tabbedPane;

    public ParserSettingsPanel() {
        this.setName("TAB_CodeAssistanceTab");
        this.initComponents();
        this.getAccessibleContext().setAccessibleDescription(ParserSettingsPanel.getString("MANAGE_COMPILERS_SETTINGS_AD"));
        this.compilerCollectionComboBox.getAccessibleContext().setAccessibleDescription(ParserSettingsPanel.getString("COMPILER_COLLECTION_AD"));
        this.tp = ToolsPanel.getToolsPanel();
        if (this.tp != null) {
            ToolsPanel.addCompilerSetChangeListener((ChangeListener)this);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.updating && this.isShowing()) {
            this.updateTabs();
        }
    }

    private void updateCompilerCollections(CompilerSet compilerSet) {
        this.compilerCollectionComboBox.removeAllItems();
        for (CompilerSet compilerSet2 : this.tp.getCompilerSetManager().getCompilerSets()) {
            this.compilerCollectionComboBox.addItem(compilerSet2);
        }
        if (compilerSet == null) {
            compilerSet = this.tp.getCompilerSetManager().getCompilerSet(0);
        }
        if (compilerSet != null) {
            this.compilerCollectionComboBox.setSelectedItem(compilerSet);
        }
        this.updateTabs();
    }

    private void updateTabs() {
        Tool tool;
        this.tabbedPane.removeAll();
        CompilerSet compilerSet = (CompilerSet)this.compilerCollectionComboBox.getSelectedItem();
        if (compilerSet == null) {
            return;
        }
        ArrayList<Tool> arrayList = new ArrayList<Tool>();
        Tool tool2 = compilerSet.getTool(Tool.CCompiler);
        if (tool2 != null && tool2.getPath().length() > 0) {
            arrayList.add(tool2);
        }
        if ((tool = compilerSet.getTool(Tool.CCCompiler)) != null && tool.getPath().length() > 0) {
            arrayList.add(tool);
        }
        for (Tool tool3 : arrayList) {
            PredefinedPanel predefinedPanel = (PredefinedPanel)this.predefinedPanels.get(compilerSet.getName() + tool3.getPath());
            if (predefinedPanel == null) {
                predefinedPanel = new PredefinedPanel((CCCCompiler)tool3, this);
                this.predefinedPanels.put(compilerSet.getName() + tool3.getPath(), predefinedPanel);
            }
            this.tabbedPane.addTab(tool3.getDisplayName(), predefinedPanel);
        }
    }

    public void fireFilesPropertiesChanged() {
        if (CodeAssistancePanelController.TRACE_CODEASSIST) {
            System.err.println("fireFilesPropertiesChanged for ParserSettingsPanel");
        }
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projectArray.length; ++i) {
            NativeProjectProvider nativeProjectProvider = (NativeProjectProvider)projectArray[i].getLookup().lookup(NativeProjectProvider.class);
            if (nativeProjectProvider == null) continue;
            nativeProjectProvider.fireFilesPropertiesChanged();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object instanceof CompilerSet) {
            this.updateCompilerCollections((CompilerSet)object);
        } else {
            this.updateCompilerCollections(null);
        }
    }

    private void initComponents() {
        this.collectionPanel = new JPanel();
        this.compilerCollectionLabel = new JLabel();
        this.compilerCollectionComboBox = new JComboBox();
        this.scrollPane = new JScrollPane();
        this.tabPanel = new JPanel();
        this.tabbedPane = new JTabbedPane();
        this.compilerCollectionLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/options/Bundle").getString("COMPILER_COLLECTION_MN").charAt(0));
        this.compilerCollectionLabel.setLabelFor(this.compilerCollectionComboBox);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/options/Bundle");
        this.compilerCollectionLabel.setText(resourceBundle.getString("COMPILER_COLLECTION_LBL"));
        GroupLayout groupLayout = new GroupLayout((Container)this.collectionPanel);
        this.collectionPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.compilerCollectionLabel).addPreferredGap(0).add((Component)this.compilerCollectionComboBox, 0, 246, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.compilerCollectionLabel).add((Component)this.compilerCollectionComboBox, -2, -1, -2)));
        GroupLayout groupLayout2 = new GroupLayout((Container)this.tabPanel);
        this.tabPanel.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.tabbedPane, -1, 397, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.tabbedPane, -1, 362, Short.MAX_VALUE));
        this.tabbedPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ParserSettingsPanel.class, (String)"COMPILERS_TABBEDPANE_AN"));
        this.tabbedPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ParserSettingsPanel.class, (String)"COMPILERS_TABBEDPANE_AD"));
        this.scrollPane.setViewportView(this.tabPanel);
        GroupLayout groupLayout3 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.collectionPanel, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add(0, 0, 0).add((Component)this.scrollPane, -1, 397, Short.MAX_VALUE).add(0, 0, 0))));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((Component)this.collectionPanel, -2, -1, -2).addContainerGap(265, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add(36, 36, 36).add((Component)this.scrollPane, -1, 256, Short.MAX_VALUE).add(0, 0, 0))));
    }

    private static String getString(String string) {
        return NbBundle.getMessage(ParserSettingsPanel.class, (String)string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update() {
        if (CodeAssistancePanelController.TRACE_CODEASSIST) {
            System.err.println("update for ParserSettingsPanel");
        }
        try {
            this.updating = true;
            this.compilerCollectionComboBox.removeActionListener(this);
            this.updateCompilerCollections(this.tp.getCurrentCompilerSet());
            this.compilerCollectionComboBox.addActionListener(this);
            PredefinedPanel[] predefinedPanelArray = this.getPredefinedPanels();
            for (int i = 0; i < predefinedPanelArray.length; ++i) {
                predefinedPanelArray[i].update();
            }
        }
        finally {
            this.updating = false;
        }
    }

    void cancel() {
        if (CodeAssistancePanelController.TRACE_CODEASSIST) {
            System.err.println("cancel for ParserSettingsPanel");
        }
        PredefinedPanel[] predefinedPanelArray = this.getPredefinedPanels();
        for (int i = 0; i < predefinedPanelArray.length; ++i) {
            predefinedPanelArray[i].cancel();
        }
    }

    boolean isDataValid() {
        boolean bl = true;
        PredefinedPanel[] predefinedPanelArray = this.getPredefinedPanels();
        for (int i = 0; i < predefinedPanelArray.length; ++i) {
            bl &= predefinedPanelArray[i].isDataValid();
        }
        if (CodeAssistancePanelController.TRACE_CODEASSIST) {
            System.err.println("isDataValid for ParserSettingsPanel is " + bl);
        }
        return bl;
    }

    boolean isChanged() {
        boolean bl = false;
        PredefinedPanel[] predefinedPanelArray = this.getPredefinedPanels();
        for (int i = 0; i < predefinedPanelArray.length; ++i) {
            bl |= predefinedPanelArray[i].isChanged();
        }
        if (CodeAssistancePanelController.TRACE_CODEASSIST) {
            System.err.println("isChanged for ParserSettingsPanel is " + bl);
        }
        return bl;
    }

    public void save() {
        if (CodeAssistancePanelController.TRACE_CODEASSIST) {
            System.err.println("save for ParserSettingsPanel");
        }
        PredefinedPanel[] predefinedPanelArray = this.getPredefinedPanels();
        boolean bl = false;
        for (int i = 0; i < predefinedPanelArray.length; ++i) {
            bl |= predefinedPanelArray[i].save();
        }
        if (bl || this.modified) {
            if (CodeAssistancePanelController.TRACE_CODEASSIST) {
                System.err.println("fireFilesPropertiesChanged in save for ParserSettingsPanel");
            }
            this.fireFilesPropertiesChanged();
            this.modified = false;
        } else if (CodeAssistancePanelController.TRACE_CODEASSIST) {
            System.err.println("not need to fireFilesPropertiesChanged in save for ParserSettingsPanel");
        }
    }

    private PredefinedPanel[] getPredefinedPanels() {
        return this.predefinedPanels.values().toArray(new PredefinedPanel[this.predefinedPanels.size()]);
    }
}

