/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.options;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.cnd.makeproject.MakeOptions;
import org.netbeans.modules.cnd.makeproject.api.platforms.Platforms;
import org.openide.util.NbBundle;

public class ProjectOptionsPanel
extends JPanel {
    private boolean changed;
    private boolean listen = false;
    private ArrayList propertyChangeListeners = new ArrayList();
    private DocumentListener documentListener;
    private JLabel defaultPlatformInfoLabel;
    private JCheckBox dependencyCheckingCheckBox;
    private JLabel filePathLabel;
    private JTextArea filePathTxt;
    private JComboBox filePathcomboBox;
    private JSeparator jSeparator1;
    private JLabel makeOptionsLabel;
    private JTextField makeOptionsTextField;
    private JLabel makeOptionsTxt;
    private JComboBox platformComboBox;
    private JLabel platformLabel;
    private JCheckBox reuseCheckBox;
    private JCheckBox saveCheckBox;

    public ProjectOptionsPanel() {
        this.initComponents();
        this.reuseCheckBox.getAccessibleContext().setAccessibleDescription(ProjectOptionsPanel.getString("REUSE_CHECKBOX_AD"));
        this.saveCheckBox.getAccessibleContext().setAccessibleDescription(ProjectOptionsPanel.getString("SAVE_CHECKBOX_AD"));
        this.platformComboBox.getAccessibleContext().setAccessibleDescription(ProjectOptionsPanel.getString("DEFAULT_PLATFORM_AD"));
        this.filePathcomboBox.getAccessibleContext().setAccessibleDescription(ProjectOptionsPanel.getString("FILE_PATH_AD"));
        this.makeOptionsTextField.getAccessibleContext().setAccessibleDescription(ProjectOptionsPanel.getString("MAKE_OPTIONS_AD"));
        this.documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                ProjectOptionsPanel.this.validateFields();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                ProjectOptionsPanel.this.validateFields();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                ProjectOptionsPanel.this.validateFields();
            }
        };
        this.makeOptionsTextField.getDocument().addDocumentListener(this.documentListener);
        this.setName("TAB_ProjectsTab");
    }

    public void update() {
        int n;
        this.listen = false;
        MakeOptions makeOptions = MakeOptions.getInstance();
        this.platformComboBox.removeAllItems();
        for (n = 0; n < Platforms.getPlatformDisplayNames().length; ++n) {
            this.platformComboBox.addItem(Platforms.getPlatformDisplayNames()[n]);
        }
        this.platformComboBox.setSelectedIndex(makeOptions.getPlatform());
        this.dependencyCheckingCheckBox.setSelected(makeOptions.getDepencyChecking());
        this.makeOptionsTextField.setText(makeOptions.getMakeOptions());
        this.filePathcomboBox.removeAllItems();
        for (n = 0; n < MakeOptions.PathModeNames.length; ++n) {
            this.filePathcomboBox.addItem(MakeOptions.PathModeNames[n]);
        }
        this.filePathcomboBox.setSelectedIndex(makeOptions.getPathMode());
        this.saveCheckBox.setSelected(makeOptions.getSave());
        this.reuseCheckBox.setSelected(makeOptions.getReuse());
        this.listen = true;
        this.changed = false;
    }

    public void applyChanges() {
        MakeOptions makeOptions = MakeOptions.getInstance();
        makeOptions.setPlatform(this.platformComboBox.getSelectedIndex());
        makeOptions.setDepencyChecking(this.dependencyCheckingCheckBox.isSelected());
        makeOptions.setMakeOptions(this.makeOptionsTextField.getText());
        makeOptions.setPathMode(this.filePathcomboBox.getSelectedIndex());
        makeOptions.setSave(this.saveCheckBox.isSelected());
        makeOptions.setReuse(this.reuseCheckBox.isSelected());
        this.changed = false;
    }

    public void cancel() {
        this.changed = false;
    }

    public boolean dataValid() {
        return true;
    }

    public boolean isChanged() {
        return this.changed;
    }

    private void validateFields() {
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "valid", this, this);
        this.firePropertyChange(propertyChangeEvent);
    }

    public void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        PropertyChangeListener[] propertyChangeListenerArray = this.propertyChangeListeners.toArray(new PropertyChangeListener[this.propertyChangeListeners.size()]);
        for (int i = 0; i < propertyChangeListenerArray.length; ++i) {
            propertyChangeListenerArray[i].propertyChange(propertyChangeEvent);
        }
    }

    private static String getString(String string) {
        return NbBundle.getMessage(ProjectOptionsPanel.class, (String)string);
    }

    private void initComponents() {
        this.platformLabel = new JLabel();
        this.platformComboBox = new JComboBox();
        this.defaultPlatformInfoLabel = new JLabel();
        this.makeOptionsLabel = new JLabel();
        this.makeOptionsTextField = new JTextField();
        this.makeOptionsTxt = new JLabel();
        this.filePathLabel = new JLabel();
        this.filePathcomboBox = new JComboBox();
        this.filePathTxt = new JTextArea();
        this.filePathTxt.setBackground(this.getBackground());
        this.saveCheckBox = new JCheckBox();
        this.reuseCheckBox = new JCheckBox();
        this.dependencyCheckingCheckBox = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.setLayout(new GridBagLayout());
        this.platformLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/options/Bundle").getString("DEFAULT_PLATFORM_MN").charAt(0));
        this.platformLabel.setLabelFor(this.platformComboBox);
        this.platformLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/options/Bundle").getString("DEFAULT_PLATFORM"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.platformLabel, gridBagConstraints);
        this.platformComboBox.setMinimumSize(new Dimension(60, 18));
        this.platformComboBox.setPreferredSize(new Dimension(60, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 4, 0, 0);
        this.add((Component)this.platformComboBox, gridBagConstraints);
        this.defaultPlatformInfoLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/options/Bundle").getString("USED_TXT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 4, 0, 12);
        this.add((Component)this.defaultPlatformInfoLabel, gridBagConstraints);
        this.makeOptionsLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/options/Bundle").getString("MAKE_OPTIONS_MN").charAt(0));
        this.makeOptionsLabel.setLabelFor(this.makeOptionsTextField);
        this.makeOptionsLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/options/Bundle").getString("MAKE_OPTIONS"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.makeOptionsLabel, gridBagConstraints);
        this.makeOptionsTextField.setColumns(45);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 4, 0, 12);
        this.add((Component)this.makeOptionsTextField, gridBagConstraints);
        this.makeOptionsTxt.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/options/Bundle").getString("MAKE_OPTIONS_TXT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 6, 0, 12);
        this.add((Component)this.makeOptionsTxt, gridBagConstraints);
        this.filePathLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/options/Bundle").getString("FILE_PATH_MN").charAt(0));
        this.filePathLabel.setLabelFor(this.filePathcomboBox);
        this.filePathLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/options/Bundle").getString("FILE_PATH"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.filePathLabel, gridBagConstraints);
        this.filePathcomboBox.setMinimumSize(new Dimension(75, 18));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 4, 0, 12);
        this.add((Component)this.filePathcomboBox, gridBagConstraints);
        this.filePathTxt.setEditable(false);
        this.filePathTxt.setLineWrap(true);
        this.filePathTxt.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/options/Bundle").getString("FILE_PATH_MODE_TXT"));
        this.filePathTxt.setWrapStyleWord(true);
        this.filePathTxt.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.filePathTxt, gridBagConstraints);
        this.saveCheckBox.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/options/Bundle").getString("SAVE_CHECKBOX_MN").charAt(0));
        this.saveCheckBox.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/options/Bundle").getString("SAVE_CHECKBOX_TXT"));
        this.saveCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.saveCheckBox.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 6, 0, 12);
        this.add((Component)this.saveCheckBox, gridBagConstraints);
        this.reuseCheckBox.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/options/Bundle").getString("REUSE_CHECKBOX_MN").charAt(0));
        this.reuseCheckBox.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/options/Bundle").getString("REUSE_CHECKBOX_TXT"));
        this.reuseCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.reuseCheckBox.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 6, 12);
        this.add((Component)this.reuseCheckBox, gridBagConstraints);
        this.dependencyCheckingCheckBox.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/options/Bundle").getString("DEPENDENCY_CHECKING_MN").charAt(0));
        this.dependencyCheckingCheckBox.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/options/Bundle").getString("DEPENDENCY_CHECKING_TXT"));
        this.dependencyCheckingCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.dependencyCheckingCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.dependencyCheckingCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectOptionsPanel.this.dependencyCheckingCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 11);
        this.add((Component)this.dependencyCheckingCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jSeparator1, gridBagConstraints);
    }

    private void dependencyCheckingCheckBoxActionPerformed(ActionEvent actionEvent) {
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "valid", this, this);
        this.firePropertyChange(propertyChangeEvent);
    }
}

