/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xam.ui;

import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.ui.cookies.GetComponentCookie;
import org.netbeans.modules.xml.xam.ui.cookies.ViewComponentCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;

public class XAMUtils {
    public static Component getComponent(Node node) {
        GetComponentCookie getComponentCookie = (GetComponentCookie)node.getCookie(GetComponentCookie.class);
        Component component = null;
        try {
            if (getComponentCookie != null) {
                component = getComponentCookie.getComponent();
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (component == null) {
            component = (Component)node.getLookup().lookup(Component.class);
        }
        return component;
    }

    public static ViewComponentCookie getViewCookie(Component component, ViewComponentCookie.View view) {
        if (component == null) {
            return null;
        }
        try {
            ViewComponentCookie viewComponentCookie;
            DataObject dataObject;
            FileObject fileObject;
            Model model = component.getModel();
            if (model != null && (fileObject = (FileObject)model.getModelSource().getLookup().lookup(FileObject.class)) != null && (dataObject = DataObject.find((FileObject)fileObject)) != null && (viewComponentCookie = (ViewComponentCookie)dataObject.getCookie(ViewComponentCookie.class)) != null && viewComponentCookie.canView(view, component)) {
                return viewComponentCookie;
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public static boolean isWritable(Model model) {
        FileObject fileObject;
        ModelSource modelSource;
        if (model != null && (modelSource = model.getModelSource()).isEditable() && (fileObject = (FileObject)modelSource.getLookup().lookup(FileObject.class)) != null) {
            return fileObject.canWrite();
        }
        return false;
    }
}

