/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xam.ui.column;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.xml.xam.ui.column.Column;
import org.netbeans.modules.xml.xam.ui.column.ColumnView;
import org.netbeans.modules.xml.xam.ui.column.LinkButton;
import org.netbeans.modules.xml.xam.ui.column.TimerButton;

public class LinkPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private Component layoutFiller;
    private Map<LinkButton, Column> buttonColumnMap;
    private JScrollPane scrollPane;
    private ColumnView columnView;
    private JPanel linkPanel = new JPanel(new GridBagLayout());
    private static final int ICON_WIDTH = 11;
    private static final int ICON_HEIGHT = 11;
    private static final int[] xpoints = new int[20];
    private static final int[] ypoints = new int[20];

    public LinkPanel(ColumnView columnView) {
        super(new BorderLayout());
        this.scrollPane = new JScrollPane(this.linkPanel, 21, 31);
        this.scrollPane.setBorder(null);
        this.add((Component)this.scrollPane, "Center");
        this.columnView = columnView;
        Border border = (Border)UIManager.get("Nb.Editor.Toolbar.border");
        if (border == null) {
            border = BorderFactory.createMatteBorder(0, 0, 1, 0, Color.BLACK);
        }
        this.setBorder(border);
        this.buttonColumnMap = new HashMap<LinkButton, Column>();
        TimerButton timerButton = new TimerButton(new ScrollLeftAction(this.scrollPane));
        TimerButton timerButton2 = new TimerButton(new ScrollRightAction(this.scrollPane));
        LinkPanel.configureButton(timerButton, new LeftIcon());
        LinkPanel.configureButton(timerButton2, new RightIcon());
        timerButton.setPreferredSize(new Dimension(17, 17));
        timerButton2.setPreferredSize(new Dimension(17, 17));
        JPanel jPanel = new JPanel(new GridLayout(1, 0));
        jPanel.setBorder(new EmptyBorder(0, 3, 1, 2));
        jPanel.add(timerButton);
        jPanel.add(timerButton2);
        this.add((Component)jPanel, "East");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof LinkButton) {
            Object object2;
            LinkButton linkButton = (LinkButton)object;
            if (this.scrollPane != null) {
                object2 = this.scrollPane.getViewport();
                Rectangle rectangle = ((JViewport)object2).getViewRect();
                Rectangle rectangle2 = linkButton.getBounds();
                Component component = ((JViewport)object2).getView();
                rectangle.x = Math.max(0, Math.min(rectangle2.x - (rectangle.width - rectangle2.width) / 2, component.getWidth() - rectangle.width));
                ((JViewport)object2).scrollRectToVisible(rectangle);
            }
            object2 = this.buttonColumnMap.get(linkButton);
            this.columnView.scrollToColumn((Column)object2, true);
        }
    }

    public void appendLink(Column column) {
        Serializable serializable;
        if (this.linkPanel.getComponentCount() > 0) {
            serializable = new GridBagConstraints();
            ((GridBagConstraints)serializable).insets = new Insets(0, 3, 2, 0);
            this.linkPanel.add((Component)new JLabel(">"), serializable);
        }
        serializable = new LinkButton(column.getTitle());
        AccessibleContext accessibleContext = ((JButton)serializable).getAccessibleContext();
        accessibleContext.setAccessibleName(column.getTitle());
        accessibleContext.setAccessibleDescription(column.getDescription());
        ((AbstractButton)serializable).addActionListener(this);
        this.buttonColumnMap.put((LinkButton)serializable, column);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.linkPanel.add((Component)serializable, gridBagConstraints);
        if (this.layoutFiller != null) {
            this.linkPanel.remove(this.layoutFiller);
        } else {
            this.layoutFiller = Box.createHorizontalGlue();
        }
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.linkPanel.add(this.layoutFiller, gridBagConstraints);
        this.linkPanel.revalidate();
        this.linkPanel.repaint();
    }

    public void clearLinks() {
        this.linkPanel.removeAll();
        this.buttonColumnMap.clear();
        this.linkPanel.revalidate();
        this.linkPanel.repaint();
    }

    private static void configureButton(JButton jButton, Icon icon) {
        jButton.setIcon(icon);
        jButton.setMargin(null);
        jButton.setText(null);
        jButton.setFocusable(false);
    }

    public void truncateLinks(int n) {
        n = n * 2 - 1;
        for (int i = this.linkPanel.getComponentCount() - 1; i > n; --i) {
            Component component = this.linkPanel.getComponent(n);
            if (component instanceof LinkButton) {
                this.buttonColumnMap.remove((LinkButton)component);
            }
            this.linkPanel.remove(n);
        }
        this.linkPanel.revalidate();
        this.linkPanel.repaint();
    }

    public void updateLink(Column column) {
        Set<Map.Entry<LinkButton, Column>> set = this.buttonColumnMap.entrySet();
        for (Map.Entry<LinkButton, Column> entry : set) {
            if (!entry.getValue().equals(column)) continue;
            LinkButton linkButton = entry.getKey();
            linkButton.setText(column.getTitle());
        }
    }

    private static class RightIcon
    implements Icon {
        private RightIcon() {
        }

        public int getIconWidth() {
            return 11;
        }

        public int getIconHeight() {
            return 9;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(component.isEnabled() ? component.getForeground() : UIManager.getColor("controlShadow"));
            int n3 = this.getIconWidth();
            int n4 = this.getIconHeight() + 1;
            xpoints[0] = n + 3;
            ypoints[0] = (n2 -= 2) + 1;
            xpoints[1] = n + 3;
            ypoints[1] = n2 + n4 + 1;
            xpoints[2] = n + (n3 - 4) + 1;
            ypoints[2] = n2 + n4 / 2 + 1;
            graphics.fillPolygon(xpoints, ypoints, 3);
        }
    }

    private static class LeftIcon
    implements Icon {
        private LeftIcon() {
        }

        public int getIconHeight() {
            return 11;
        }

        public int getIconWidth() {
            return 11;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(component.isEnabled() ? component.getForeground() : UIManager.getColor("controlShadow"));
            int n3 = this.getIconWidth();
            int n4 = this.getIconHeight() + 1;
            xpoints[0] = n + (n3 - 4);
            ypoints[0] = (n2 -= 2) + 2;
            xpoints[1] = xpoints[0];
            ypoints[1] = n2 + n4 + 1;
            xpoints[2] = n + 2;
            ypoints[2] = n2 + n4 / 2 + 1;
            graphics.fillPolygon(xpoints, ypoints, 3);
        }
    }

    private static class ScrollRightAction
    extends AbstractAction
    implements ChangeListener {
        private static final long serialVersionUID = 1L;
        private JScrollPane pane;

        public ScrollRightAction(JScrollPane jScrollPane) {
            this.pane = jScrollPane;
            jScrollPane.getViewport().addChangeListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JViewport jViewport = this.pane.getViewport();
            Dimension dimension = jViewport.getExtentSize();
            Point point = jViewport.getViewPosition();
            point.x += dimension.width / 10;
            int n = jViewport.getViewSize().width - dimension.width;
            if (point.x > n) {
                point.x = n;
            }
            jViewport.setViewPosition(point);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JViewport jViewport = this.pane.getViewport();
            Dimension dimension = jViewport.getExtentSize();
            Point point = jViewport.getViewPosition();
            int n = jViewport.getViewSize().width - dimension.width;
            this.setEnabled(point.x < n);
        }
    }

    private static class ScrollLeftAction
    extends AbstractAction
    implements ChangeListener {
        private static final long serialVersionUID = 1L;
        private JScrollPane pane;

        public ScrollLeftAction(JScrollPane jScrollPane) {
            this.pane = jScrollPane;
            jScrollPane.getViewport().addChangeListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JViewport jViewport = this.pane.getViewport();
            Dimension dimension = jViewport.getExtentSize();
            Point point = jViewport.getViewPosition();
            point.x -= dimension.width / 10;
            if (point.x < 0) {
                point.x = 0;
            }
            jViewport.setViewPosition(point);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JViewport jViewport = this.pane.getViewport();
            Point point = jViewport.getViewPosition();
            this.setEnabled(point.x > 0);
        }
    }
}

