/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xam.ui.customizer;

import java.io.IOException;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ui.ModelCookie;
import org.netbeans.modules.xml.xam.ui.customizer.ExternalReferenceDecorator;
import org.netbeans.modules.xml.xam.ui.customizer.ExternalReferenceNode;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;

public class ExternalReferenceDataNode
extends FilterNode
implements ExternalReferenceNode {
    public static final String PROP_SELECTED = "selected";
    public static final String PROP_PREFIX = "prefix";
    private ExternalReferenceDecorator decorator;
    private Sheet sheet;
    private boolean selected;
    private String prefix;

    public ExternalReferenceDataNode(Node node, ExternalReferenceDecorator externalReferenceDecorator) {
        super(node, (org.openide.nodes.Children)new Children(node, externalReferenceDecorator));
        this.decorator = externalReferenceDecorator;
    }

    public boolean canRename() {
        return false;
    }

    public boolean canSelect() {
        DataObject dataObject = (DataObject)this.getLookup().lookup(DataObject.class);
        return dataObject != null && !dataObject.getPrimaryFile().isFolder() && this.decorator.validate(this) == null;
    }

    private Node.Property createProperty(String string, Class clazz, Object object, String string2, String string3) {
        PropertySupport.Reflection reflection = null;
        try {
            reflection = new PropertySupport.Reflection(object, clazz, string2, string3);
            reflection.setName(string);
            reflection.setDisplayName(NbBundle.getMessage(ExternalReferenceDataNode.class, (String)("CTL_ExternalReferenceCreator_Column_Name_" + string)));
            reflection.setShortDescription(NbBundle.getMessage(ExternalReferenceDataNode.class, (String)("CTL_ExternalReferenceCreator_Column_Desc_" + string)));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ErrorManager.getDefault().notify((Throwable)noSuchMethodException);
        }
        return reflection;
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = sheet.get("properties");
        set.put(this.createProperty("name", String.class, this, "getHtmlDisplayName", null));
        if (this.canSelect()) {
            set.put(this.createProperty(PROP_SELECTED, Boolean.TYPE, this, "isSelected", "setSelected"));
            Node.Property property = this.createProperty(PROP_PREFIX, String.class, this, "getPrefix", "setPrefix");
            property.setValue("suppressCustomEditor", (Object)Boolean.TRUE);
            set.put(property);
        } else {
            Node.Property property = this.createProperty(PROP_PREFIX, String.class, this, "getPrefix", null);
            property.setValue("suppressCustomEditor", (Object)Boolean.TRUE);
            set.put(property);
        }
        return sheet;
    }

    protected final synchronized Sheet getSheet() {
        if (this.sheet != null) {
            return this.sheet;
        }
        this.sheet = this.createSheet();
        this.firePropertySetsChange(null, null);
        return this.sheet;
    }

    public Node.PropertySet[] getPropertySets() {
        Sheet sheet = this.getSheet();
        return sheet.toArray();
    }

    public String getHtmlDisplayName() {
        String string = this.getOriginal().getHtmlDisplayName();
        if (this.decorator != null) {
            if (string == null) {
                string = this.getDisplayName();
            }
            string = this.decorator.getHtmlDisplayName(string, this);
        }
        return string;
    }

    public String getNamespace() {
        ModelCookie modelCookie;
        DataObject dataObject = (DataObject)this.getLookup().lookup(DataObject.class);
        if (dataObject != null && (modelCookie = (ModelCookie)dataObject.getCookie(ModelCookie.class)) != null) {
            try {
                Object t = modelCookie.getModel();
                return this.decorator.getNamespace((Model)t);
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return null;
    }

    public Model getModel() {
        ModelCookie modelCookie;
        DataObject dataObject = (DataObject)this.getLookup().lookup(DataObject.class);
        if (dataObject != null && (modelCookie = (ModelCookie)dataObject.getCookie(ModelCookie.class)) != null) {
            try {
                return modelCookie.getModel();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return null;
    }

    public String getPrefix() {
        if (this.prefix == null) {
            this.prefix = this.decorator.generatePrefix(this);
        }
        return this.prefix;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean hasModel() {
        DataObject dataObject = (DataObject)this.getLookup().lookup(DataObject.class);
        if (dataObject != null) {
            ModelCookie modelCookie = (ModelCookie)dataObject.getCookie(ModelCookie.class);
            return modelCookie != null;
        }
        return false;
    }

    public void setDisplayName(String string) {
        super.disableDelegation(12);
        super.setDisplayName(string);
    }

    public void setPrefix(String string) {
        String string2 = this.prefix;
        this.prefix = string;
        this.firePropertyChange(PROP_PREFIX, string2, string);
    }

    public void setSelected(boolean bl) {
        if (!this.canSelect()) {
            throw new IllegalStateException("node cannot be selected");
        }
        boolean bl2 = this.selected;
        this.selected = bl;
        this.firePropertyChange(PROP_SELECTED, bl2, bl);
    }

    private static class Children
    extends FilterNode.Children {
        private ExternalReferenceDecorator decorator;

        public Children(Node node, ExternalReferenceDecorator externalReferenceDecorator) {
            super(node);
            this.decorator = externalReferenceDecorator;
        }

        protected Node[] createNodes(Node node) {
            DataObject dataObject = (DataObject)node.getLookup().lookup(DataObject.class);
            if (dataObject != null) {
                FileObject fileObject = dataObject.getPrimaryFile();
                if (fileObject.isFolder() && fileObject.getNameExt().equals("nbproject") && fileObject.getFileObject("project.xml") != null) {
                    return new Node[0];
                }
                ModelCookie modelCookie = (ModelCookie)dataObject.getCookie(ModelCookie.class);
                String string = fileObject.getNameExt();
                String string2 = this.decorator.getDocumentType().toString();
                if (fileObject.isFolder() || modelCookie != null && string.endsWith(string2)) {
                    return super.createNodes(node);
                }
            }
            return new Node[0];
        }

        protected Node copyNode(Node node) {
            return this.decorator.createExternalReferenceNode(node);
        }
    }
}

