/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.api.ejbjar;

import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.ejbjar.EjbJarAccessor;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.spi.ejbjar.EjbJarImplementation;
import org.netbeans.modules.j2ee.spi.ejbjar.EjbJarProvider;
import org.netbeans.modules.j2ee.spi.ejbjar.EjbJarsInProject;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EjbJar {
    private EjbJarImplementation impl;
    private static final Lookup.Result<EjbJarProvider> implementations = Lookup.getDefault().lookup(new Lookup.Template(EjbJarProvider.class));

    private EjbJar(EjbJarImplementation ejbJarImplementation) {
        if (ejbJarImplementation == null) {
            throw new IllegalArgumentException();
        }
        this.impl = ejbJarImplementation;
    }

    public static EjbJar getEjbJar(FileObject fileObject) {
        if (fileObject == null) {
            throw new NullPointerException("Passed null to EjbJar.getEjbJar(FileObject)");
        }
        for (EjbJarProvider ejbJarProvider : implementations.allInstances()) {
            EjbJar ejbJar = ejbJarProvider.findEjbJar(fileObject);
            if (ejbJar == null) continue;
            return ejbJar;
        }
        return null;
    }

    public static EjbJar[] getEjbJars(Project project) {
        EjbJar[] ejbJarArray;
        EjbJarsInProject ejbJarsInProject = (EjbJarsInProject)project.getLookup().lookup(EjbJarsInProject.class);
        if (ejbJarsInProject != null && (ejbJarArray = ejbJarsInProject.getEjbJars()) != null) {
            return ejbJarArray;
        }
        return new EjbJar[0];
    }

    public String getJ2eePlatformVersion() {
        return this.impl.getJ2eePlatformVersion();
    }

    public FileObject getDeploymentDescriptor() {
        return this.impl.getDeploymentDescriptor();
    }

    public FileObject[] getJavaSources() {
        return this.impl.getJavaSources();
    }

    public FileObject getMetaInf() {
        return this.impl.getMetaInf();
    }

    public MetadataModel<EjbJarMetadata> getMetadataModel() {
        return this.impl.getMetadataModel();
    }

    static {
        EjbJarAccessor.DEFAULT = new EjbJarAccessor(){

            public EjbJar createEjbJar(EjbJarImplementation ejbJarImplementation) {
                return new EjbJar(ejbJarImplementation);
            }

            public EjbJarImplementation getEjbJarImplementation(EjbJar ejbJar) {
                return ejbJar == null ? null : ejbJar.impl;
            }
        };
    }
}

