/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocListener;
import com.lowagie.text.DocWriter;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Image;
import com.lowagie.text.ImgWMF;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.ColorDetails;
import com.lowagie.text.pdf.ExtendedColor;
import com.lowagie.text.pdf.FontDetails;
import com.lowagie.text.pdf.OutputStreamCounter;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PdfAcroForm;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfContents;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfDocument;
import com.lowagie.text.pdf.PdfEncryption;
import com.lowagie.text.pdf.PdfException;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfICCBased;
import com.lowagie.text.pdf.PdfImage;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfIndirectObject;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPage;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfPageLabels;
import com.lowagie.text.pdf.PdfPages;
import com.lowagie.text.pdf.PdfPatternPainter;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfReaderInstance;
import com.lowagie.text.pdf.PdfShading;
import com.lowagie.text.pdf.PdfShadingPattern;
import com.lowagie.text.pdf.PdfSpotColor;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfTransition;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.SpotColor;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;

public class PdfWriter
extends DocWriter {
    public static final int PageLayoutSinglePage = 1;
    public static final int PageLayoutOneColumn = 2;
    public static final int PageLayoutTwoColumnLeft = 4;
    public static final int PageLayoutTwoColumnRight = 8;
    public static final int PageModeUseNone = 16;
    public static final int PageModeUseOutlines = 32;
    public static final int PageModeUseThumbs = 64;
    public static final int PageModeFullScreen = 128;
    public static final int HideToolbar = 256;
    public static final int HideMenubar = 512;
    public static final int HideWindowUI = 1024;
    public static final int FitWindow = 2048;
    public static final int CenterWindow = 4096;
    public static final int NonFullScreenPageModeUseNone = 8192;
    public static final int NonFullScreenPageModeUseOutlines = 16384;
    public static final int NonFullScreenPageModeUseThumbs = 32768;
    public static final int DirectionL2R = 65536;
    public static final int DirectionR2L = 131072;
    static final int ViewerPreferencesMask = 261888;
    public static final int AllowPrinting = 2052;
    public static final int AllowModifyContents = 8;
    public static final int AllowCopy = 16;
    public static final int AllowModifyAnnotations = 32;
    public static final int AllowFillIn = 256;
    public static final int AllowScreenReaders = 512;
    public static final int AllowAssembly = 1024;
    public static final int AllowDegradedPrinting = 4;
    public static final boolean STRENGTH40BITS = false;
    public static final boolean STRENGTH128BITS = true;
    public static final PdfName DOCUMENT_CLOSE = PdfName.DC;
    public static final PdfName WILL_SAVE = PdfName.WS;
    public static final PdfName DID_SAVE = PdfName.DS;
    public static final PdfName WILL_PRINT = PdfName.WP;
    public static final PdfName DID_PRINT = PdfName.DP;
    public static final PdfName PAGE_OPEN = PdfName.O;
    public static final PdfName PAGE_CLOSE = PdfName.C;
    public static final int SIGNATURE_EXISTS = 1;
    public static final int SIGNATURE_APPEND_ONLY = 2;
    public static final char VERSION_1_2 = '2';
    public static final char VERSION_1_3 = '3';
    public static final char VERSION_1_4 = '4';
    public static final char VERSION_1_5 = '5';
    private static final int VPOINT = 7;
    protected byte[] HEADER = DocWriter.getISOBytes("%PDF-1.4\n%\u00e2\u00e3\u00cf\u00d3\n");
    protected PdfPages root = new PdfPages(this);
    protected PdfDictionary imageDictionary = new PdfDictionary();
    private HashMap images = new HashMap();
    protected HashMap formXObjects = new HashMap();
    protected int formXObjectsCounter = 1;
    protected int fontNumber = 1;
    protected int colorNumber = 1;
    protected int patternNumber = 1;
    protected PdfContentByte directContent;
    protected PdfContentByte directContentUnder;
    protected HashMap documentFonts = new HashMap();
    protected HashMap documentColors = new HashMap();
    protected HashMap documentPatterns = new HashMap();
    protected HashMap documentShadings = new HashMap();
    protected HashMap documentShadingPatterns = new HashMap();
    protected ColorDetails patternColorspaceRGB;
    protected ColorDetails patternColorspaceGRAY;
    protected ColorDetails patternColorspaceCMYK;
    protected HashMap documentSpotPatterns = new HashMap();
    protected HashMap documentExtGState = new HashMap();
    protected PdfBody body;
    protected PdfDocument pdf;
    private PdfPageEvent pageEvent;
    protected PdfEncryption crypto;
    protected HashMap importedPages = new HashMap();
    protected PdfReaderInstance currentPdfReaderInstance;
    protected ArrayList pageReferences = new ArrayList();
    protected int currentPageNumber = 1;
    protected PdfDictionary group;
    public static final float SPACE_CHAR_RATIO_DEFAULT = 2.5f;
    public static final float NO_SPACE_CHAR_RATIO = 1.0E7f;
    public static final int RUN_DIRECTION_DEFAULT = 0;
    public static final int RUN_DIRECTION_NO_BIDI = 1;
    public static final int RUN_DIRECTION_LTR = 2;
    public static final int RUN_DIRECTION_RTL = 3;
    protected int runDirection = 1;
    private float spaceCharRatio = 2.5f;
    private PdfDictionary extraCatalog;

    protected PdfWriter(PdfDocument pdfDocument, OutputStream outputStream) {
        super(pdfDocument, outputStream);
        this.pdf = pdfDocument;
        this.directContent = new PdfContentByte(this);
        this.directContentUnder = new PdfContentByte(this);
    }

    public static PdfWriter getInstance(Document document, OutputStream outputStream) throws DocumentException {
        PdfDocument pdfDocument = new PdfDocument();
        document.addDocListener(pdfDocument);
        PdfWriter pdfWriter = new PdfWriter(pdfDocument, outputStream);
        pdfDocument.addWriter(pdfWriter);
        return pdfWriter;
    }

    public static PdfWriter getInstance(Document document, OutputStream outputStream, DocListener docListener) throws DocumentException {
        PdfDocument pdfDocument = new PdfDocument();
        pdfDocument.addDocListener(docListener);
        document.addDocListener(pdfDocument);
        PdfWriter pdfWriter = new PdfWriter(pdfDocument, outputStream);
        pdfDocument.addWriter(pdfWriter);
        return pdfWriter;
    }

    PdfIndirectReference add(PdfPage pdfPage, PdfContents pdfContents) throws PdfException {
        PdfIndirectObject pdfIndirectObject;
        if (!this.open) {
            throw new PdfException("The document isn't open.");
        }
        try {
            pdfIndirectObject = this.body.add(pdfContents);
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
        pdfPage.add(pdfIndirectObject.getIndirectReference());
        if (this.group != null) {
            pdfPage.put(PdfName.GROUP, this.group);
            this.group = null;
        }
        this.root.addPage(pdfPage);
        ++this.currentPageNumber;
        return null;
    }

    PdfName addDirectImageSimple(Image image) throws PdfException, DocumentException {
        PdfName pdfName;
        if (this.images.containsKey(image.getMySerialId())) {
            pdfName = (PdfName)this.images.get(image.getMySerialId());
        } else {
            if (image.isImgTemplate()) {
                pdfName = new PdfName("img" + this.images.size());
                if (image.templateData() == null) {
                    try {
                        ImgWMF imgWMF = (ImgWMF)image;
                        imgWMF.readWMF(this.getDirectContent().createTemplate(0.0f, 0.0f));
                    }
                    catch (Exception exception) {
                        throw new DocumentException(exception.getMessage());
                    }
                }
            } else {
                PdfObject pdfObject;
                Image image2 = image.getImageMask();
                PdfIndirectReference pdfIndirectReference = null;
                if (image2 != null) {
                    pdfObject = (PdfName)this.images.get(image2.getMySerialId());
                    pdfIndirectReference = this.getImageReference((PdfName)pdfObject);
                }
                pdfObject = new PdfImage(image, "img" + this.images.size(), pdfIndirectReference);
                if (image.hasICCProfile()) {
                    PdfICCBased pdfICCBased = new PdfICCBased(image.getICCProfile());
                    PdfIndirectReference pdfIndirectReference2 = this.add(pdfICCBased);
                    PdfArray pdfArray = new PdfArray();
                    pdfArray.add(PdfName.ICCBASED);
                    pdfArray.add(pdfIndirectReference2);
                    PdfObject pdfObject2 = ((PdfDictionary)pdfObject).get(PdfName.COLORSPACE);
                    if (pdfObject2 != null && pdfObject2.type() == 5) {
                        ArrayList arrayList = ((PdfArray)pdfObject2).getArrayList();
                        if (arrayList.size() > 1 && PdfName.INDEXED.equals(arrayList.get(0))) {
                            arrayList.set(1, pdfArray);
                        } else {
                            ((PdfDictionary)pdfObject).put(PdfName.COLORSPACE, pdfArray);
                        }
                    } else {
                        ((PdfDictionary)pdfObject).put(PdfName.COLORSPACE, pdfArray);
                    }
                }
                this.add((PdfImage)pdfObject);
                pdfName = ((PdfImage)pdfObject).name();
            }
            this.images.put(image.getMySerialId(), pdfName);
        }
        return pdfName;
    }

    PdfIndirectReference add(PdfImage pdfImage) throws PdfException {
        if (!this.imageDictionary.contains(pdfImage.name())) {
            PdfIndirectObject pdfIndirectObject;
            try {
                pdfIndirectObject = this.body.add(pdfImage);
            }
            catch (IOException iOException) {
                throw new ExceptionConverter(iOException);
            }
            this.imageDictionary.put(pdfImage.name(), pdfIndirectObject.getIndirectReference());
            return pdfIndirectObject.getIndirectReference();
        }
        return (PdfIndirectReference)this.imageDictionary.get(pdfImage.name());
    }

    protected PdfIndirectReference add(PdfICCBased pdfICCBased) throws PdfException {
        PdfIndirectObject pdfIndirectObject;
        try {
            pdfIndirectObject = this.body.add(pdfICCBased);
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
        return pdfIndirectObject.getIndirectReference();
    }

    PdfIndirectReference getImageReference(PdfName pdfName) {
        return (PdfIndirectReference)this.imageDictionary.get(pdfName);
    }

    public void open() {
        super.open();
        try {
            this.os.write(this.HEADER);
            this.body = new PdfBody(this);
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    protected PdfDictionary getCatalog(PdfIndirectReference pdfIndirectReference) {
        return ((PdfDocument)this.document).getCatalog(pdfIndirectReference);
    }

    protected void addSharedObjectsToBody() throws IOException {
        Object object;
        Iterator iterator;
        Iterator iterator2;
        Iterator iterator3;
        Object object2;
        Object object3;
        Object object4;
        Iterator iterator4 = this.documentFonts.values().iterator();
        while (iterator4.hasNext()) {
            object4 = (FontDetails)iterator4.next();
            ((FontDetails)object4).writeFont(this);
        }
        object4 = this.formXObjects.values().iterator();
        while (object4.hasNext()) {
            object3 = (Object[])object4.next();
            object2 = (PdfTemplate)object3[1];
            if (object2 != null && ((PdfTemplate)object2).getIndirectReference() instanceof PRIndirectReference || object2 == null || ((PdfTemplate)object2).getType() != 1) continue;
            iterator3 = this.body.add((PdfObject)((PdfTemplate)object2).getFormXObject(), ((PdfTemplate)object2).getIndirectReference());
        }
        object3 = this.importedPages.values().iterator();
        while (object3.hasNext()) {
            this.currentPdfReaderInstance = (PdfReaderInstance)object3.next();
            this.currentPdfReaderInstance.writeAllPages();
        }
        this.currentPdfReaderInstance = null;
        object2 = this.documentColors.values().iterator();
        while (object2.hasNext()) {
            iterator3 = (ColorDetails)object2.next();
            iterator2 = this.body.add((PdfObject)((ColorDetails)((Object)iterator3)).getSpotColor(this), ((ColorDetails)((Object)iterator3)).getIndirectReference());
        }
        iterator3 = this.documentPatterns.keySet().iterator();
        while (iterator3.hasNext()) {
            iterator2 = (PdfPatternPainter)iterator3.next();
            iterator = this.body.add((PdfObject)((PdfPatternPainter)((Object)iterator2)).getPattern(), ((PdfTemplate)((Object)iterator2)).getIndirectReference());
        }
        iterator2 = this.documentShadingPatterns.keySet().iterator();
        while (iterator2.hasNext()) {
            iterator = (PdfShadingPattern)iterator2.next();
            ((PdfShadingPattern)((Object)iterator)).addToBody();
        }
        iterator = this.documentShadings.keySet().iterator();
        while (iterator.hasNext()) {
            object = (PdfShading)iterator.next();
            ((PdfShading)object).addToBody();
        }
        object = this.documentExtGState.keySet().iterator();
        while (object.hasNext()) {
            PdfDictionary pdfDictionary = (PdfDictionary)object.next();
            PdfObject[] pdfObjectArray = (PdfObject[])this.documentExtGState.get(pdfDictionary);
            this.addToBody((PdfObject)pdfDictionary, (PdfIndirectReference)pdfObjectArray[1]);
        }
    }

    public synchronized void close() {
        if (this.open) {
            if (this.currentPageNumber - 1 != this.pageReferences.size()) {
                throw new RuntimeException("The page " + this.pageReferences.size() + " was requested but the document has only " + (this.currentPageNumber - 1) + " pages.");
            }
            this.pdf.close();
            try {
                Object object;
                this.addSharedObjectsToBody();
                PdfIndirectReference pdfIndirectReference = this.root.writePageTree();
                PdfDictionary pdfDictionary = this.getCatalog(pdfIndirectReference);
                if (this.extraCatalog != null) {
                    pdfDictionary.mergeDifferent(this.extraCatalog);
                }
                PdfIndirectObject pdfIndirectObject = this.body.add(pdfDictionary);
                PdfIndirectObject pdfIndirectObject2 = this.body.add(((PdfDocument)this.document).getInfo());
                PdfIndirectReference pdfIndirectReference2 = null;
                PdfObject pdfObject = null;
                if (this.crypto != null) {
                    object = this.body.add(this.crypto.getEncryptionDictionary());
                    pdfIndirectReference2 = ((PdfIndirectObject)object).getIndirectReference();
                    pdfObject = this.crypto.getFileID();
                } else {
                    pdfObject = PdfEncryption.createInfoId(PdfEncryption.createDocumentId());
                }
                this.body.writeCrossReferenceTable(this.os);
                object = new PdfTrailer(this.body.size(), this.body.offset(), pdfIndirectObject.getIndirectReference(), pdfIndirectObject2.getIndirectReference(), pdfIndirectReference2, pdfObject);
                ((PdfTrailer)object).toPdf(this, this.os);
                super.close();
            }
            catch (IOException iOException) {
                throw new ExceptionConverter(iOException);
            }
        }
    }

    int size() {
        return this.body.size();
    }

    public float getTableBottom(Table table) {
        return this.pdf.bottom(table) - this.pdf.indentBottom();
    }

    public boolean fitsPage(Table table, float f) {
        return this.pdf.bottom(table) > this.pdf.indentBottom() + f;
    }

    public boolean fitsPage(Table table) {
        return this.fitsPage(table, 0.0f);
    }

    public boolean fitsPage(PdfPTable pdfPTable, float f) {
        return this.pdf.fitsPage(pdfPTable, f);
    }

    public boolean fitsPage(PdfPTable pdfPTable) {
        return this.pdf.fitsPage(pdfPTable, 0.0f);
    }

    boolean isPaused() {
        return this.pause;
    }

    public PdfContentByte getDirectContent() {
        if (!this.open) {
            throw new RuntimeException("The document is not open.");
        }
        return this.directContent;
    }

    public PdfContentByte getDirectContentUnder() {
        if (!this.open) {
            throw new RuntimeException("The document is not open.");
        }
        return this.directContentUnder;
    }

    void resetContent() {
        this.directContent.reset();
        this.directContentUnder.reset();
    }

    public PdfAcroForm getAcroForm() {
        return this.pdf.getAcroForm();
    }

    public PdfOutline getRootOutline() {
        return this.directContent.getRootOutline();
    }

    OutputStreamCounter getOs() {
        return this.os;
    }

    FontDetails addSimple(BaseFont baseFont) {
        if (baseFont.getFontType() == 4) {
            return new FontDetails(new PdfName("F" + this.fontNumber++), this.body.getPdfIndirectReference(), baseFont);
        }
        FontDetails fontDetails = (FontDetails)this.documentFonts.get(baseFont);
        if (fontDetails == null) {
            fontDetails = new FontDetails(new PdfName("F" + this.fontNumber++), this.body.getPdfIndirectReference(), baseFont);
            this.documentFonts.put(baseFont, fontDetails);
        }
        return fontDetails;
    }

    void eliminateFontSubset(PdfDictionary pdfDictionary) {
        Iterator iterator = this.documentFonts.values().iterator();
        while (iterator.hasNext()) {
            FontDetails fontDetails = (FontDetails)iterator.next();
            if (pdfDictionary.get(fontDetails.getFontName()) == null) continue;
            fontDetails.setSubset(false);
        }
    }

    ColorDetails addSimple(PdfSpotColor pdfSpotColor) {
        ColorDetails colorDetails = (ColorDetails)this.documentColors.get(pdfSpotColor);
        if (colorDetails == null) {
            colorDetails = new ColorDetails(new PdfName("CS" + this.colorNumber++), this.body.getPdfIndirectReference(), pdfSpotColor);
            this.documentColors.put(pdfSpotColor, colorDetails);
        }
        return colorDetails;
    }

    ColorDetails addSimplePatternColorspace(Color color) {
        int n = ExtendedColor.getType(color);
        if (n == 4 || n == 5) {
            throw new RuntimeException("An uncolored tile pattern can not have another pattern or shading as color.");
        }
        try {
            switch (n) {
                case 0: {
                    if (this.patternColorspaceRGB == null) {
                        this.patternColorspaceRGB = new ColorDetails(new PdfName("CS" + this.colorNumber++), this.body.getPdfIndirectReference(), null);
                        PdfArray pdfArray = new PdfArray(PdfName.PATTERN);
                        pdfArray.add(PdfName.DEVICERGB);
                        PdfIndirectObject pdfIndirectObject = this.body.add((PdfObject)pdfArray, this.patternColorspaceRGB.getIndirectReference());
                    }
                    return this.patternColorspaceRGB;
                }
                case 2: {
                    if (this.patternColorspaceCMYK == null) {
                        this.patternColorspaceCMYK = new ColorDetails(new PdfName("CS" + this.colorNumber++), this.body.getPdfIndirectReference(), null);
                        PdfArray pdfArray = new PdfArray(PdfName.PATTERN);
                        pdfArray.add(PdfName.DEVICECMYK);
                        PdfIndirectObject pdfIndirectObject = this.body.add((PdfObject)pdfArray, this.patternColorspaceCMYK.getIndirectReference());
                    }
                    return this.patternColorspaceCMYK;
                }
                case 1: {
                    if (this.patternColorspaceGRAY == null) {
                        this.patternColorspaceGRAY = new ColorDetails(new PdfName("CS" + this.colorNumber++), this.body.getPdfIndirectReference(), null);
                        PdfArray pdfArray = new PdfArray(PdfName.PATTERN);
                        pdfArray.add(PdfName.DEVICEGRAY);
                        PdfIndirectObject pdfIndirectObject = this.body.add((PdfObject)pdfArray, this.patternColorspaceGRAY.getIndirectReference());
                    }
                    return this.patternColorspaceGRAY;
                }
                case 3: {
                    ColorDetails colorDetails = this.addSimple(((SpotColor)color).getPdfSpotColor());
                    ColorDetails colorDetails2 = (ColorDetails)this.documentSpotPatterns.get(colorDetails);
                    if (colorDetails2 == null) {
                        colorDetails2 = new ColorDetails(new PdfName("CS" + this.colorNumber++), this.body.getPdfIndirectReference(), null);
                        PdfArray pdfArray = new PdfArray(PdfName.PATTERN);
                        pdfArray.add(colorDetails.getIndirectReference());
                        PdfIndirectObject pdfIndirectObject = this.body.add((PdfObject)pdfArray, colorDetails2.getIndirectReference());
                        this.documentSpotPatterns.put(colorDetails, colorDetails2);
                    }
                    return colorDetails2;
                }
            }
            throw new RuntimeException("Invalid color type in PdfWriter.addSimplePatternColorspace().");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    void addSimpleShadingPattern(PdfShadingPattern pdfShadingPattern) {
        if (!this.documentShadingPatterns.containsKey(pdfShadingPattern)) {
            pdfShadingPattern.setName(this.patternNumber);
            ++this.patternNumber;
            this.documentShadingPatterns.put(pdfShadingPattern, null);
            this.addSimpleShading(pdfShadingPattern.getShading());
        }
    }

    void addSimpleShading(PdfShading pdfShading) {
        if (!this.documentShadings.containsKey(pdfShading)) {
            this.documentShadings.put(pdfShading, null);
            pdfShading.setName(this.documentShadings.size());
        }
    }

    PdfObject[] addSimpleExtGState(PdfDictionary pdfDictionary) {
        if (!this.documentExtGState.containsKey(pdfDictionary)) {
            this.documentExtGState.put(pdfDictionary, new PdfObject[]{new PdfName("GS" + (this.documentExtGState.size() + 1)), this.getPdfIndirectReference()});
        }
        return (PdfObject[])this.documentExtGState.get(pdfDictionary);
    }

    PdfDocument getPdfDocument() {
        return this.pdf;
    }

    public PdfIndirectReference getPdfIndirectReference() {
        return this.body.getPdfIndirectReference();
    }

    int getIndirectReferenceNumber() {
        return this.body.getIndirectReferenceNumber();
    }

    PdfName addSimplePattern(PdfPatternPainter pdfPatternPainter) {
        PdfName pdfName = (PdfName)this.documentPatterns.get(pdfPatternPainter);
        try {
            if (pdfName == null) {
                pdfName = new PdfName("P" + this.patternNumber);
                ++this.patternNumber;
                this.documentPatterns.put(pdfPatternPainter, pdfName);
            }
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        return pdfName;
    }

    PdfName addDirectTemplateSimple(PdfTemplate pdfTemplate) {
        PdfIndirectReference pdfIndirectReference = pdfTemplate.getIndirectReference();
        Object[] objectArray = (Object[])this.formXObjects.get(pdfIndirectReference);
        PdfName pdfName = null;
        try {
            if (objectArray == null) {
                pdfName = new PdfName("Xf" + this.formXObjectsCounter);
                ++this.formXObjectsCounter;
                if (pdfTemplate.getType() == 2) {
                    pdfTemplate = null;
                }
                this.formXObjects.put(pdfIndirectReference, new Object[]{pdfName, pdfTemplate});
            } else {
                pdfName = (PdfName)objectArray[0];
            }
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        return pdfName;
    }

    public void setPageEvent(PdfPageEvent pdfPageEvent) {
        this.pageEvent = pdfPageEvent;
    }

    public PdfPageEvent getPageEvent() {
        return this.pageEvent;
    }

    void addLocalDestinations(TreeMap treeMap) throws IOException {
        Iterator iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object[] objectArray = (Object[])treeMap.get(string);
            PdfDestination pdfDestination = (PdfDestination)objectArray[2];
            if (pdfDestination == null) {
                throw new RuntimeException("The name '" + string + "' has no local destination.");
            }
            if (objectArray[1] == null) {
                objectArray[1] = this.getPdfIndirectReference();
            }
            PdfIndirectObject pdfIndirectObject = this.body.add((PdfObject)pdfDestination, (PdfIndirectReference)objectArray[1]);
        }
    }

    public int getPageNumber() {
        return this.pdf.getPageNumber();
    }

    public void setViewerPreferences(int n) {
        this.pdf.setViewerPreferences(n);
    }

    public void setEncryption(byte[] byArray, byte[] byArray2, int n, boolean bl) throws DocumentException {
        if (this.pdf.isOpen()) {
            throw new DocumentException("Encryption can only be added before opening the document.");
        }
        this.crypto = new PdfEncryption();
        this.crypto.setupAllKeys(byArray, byArray2, n, bl);
    }

    public void setEncryption(boolean bl, String string, String string2, int n) throws DocumentException {
        this.setEncryption(DocWriter.getISOBytes(string), DocWriter.getISOBytes(string2), n, bl);
    }

    public PdfIndirectObject addToBody(PdfObject pdfObject) throws IOException {
        PdfIndirectObject pdfIndirectObject = this.body.add(pdfObject);
        return pdfIndirectObject;
    }

    public PdfIndirectObject addToBody(PdfObject pdfObject, PdfIndirectReference pdfIndirectReference) throws IOException {
        PdfIndirectObject pdfIndirectObject = this.body.add(pdfObject, pdfIndirectReference);
        return pdfIndirectObject;
    }

    public PdfIndirectObject addToBody(PdfObject pdfObject, int n) throws IOException {
        PdfIndirectObject pdfIndirectObject = this.body.add(pdfObject, n);
        return pdfIndirectObject;
    }

    public void setOpenAction(String string) {
        this.pdf.setOpenAction(string);
    }

    public void setAdditionalAction(PdfName pdfName, PdfAction pdfAction) throws PdfException {
        if (!(pdfName.equals(DOCUMENT_CLOSE) || pdfName.equals(WILL_SAVE) || pdfName.equals(DID_SAVE) || pdfName.equals(WILL_PRINT) || pdfName.equals(DID_PRINT))) {
            throw new PdfException("Invalid additional action type: " + pdfName.toString());
        }
        this.pdf.addAdditionalAction(pdfName, pdfAction);
    }

    public void setOpenAction(PdfAction pdfAction) {
        this.pdf.setOpenAction(pdfAction);
    }

    public void setPageLabels(PdfPageLabels pdfPageLabels) {
        this.pdf.setPageLabels(pdfPageLabels);
    }

    PdfEncryption getEncryption() {
        return this.crypto;
    }

    RandomAccessFileOrArray getReaderFile(PdfReader pdfReader) {
        return this.currentPdfReaderInstance.getReaderFile();
    }

    int getNewObjectNumber(PdfReader pdfReader, int n, int n2) {
        return this.currentPdfReaderInstance.getNewObjectNumber(n, n2);
    }

    public PdfImportedPage getImportedPage(PdfReader pdfReader, int n) {
        PdfReaderInstance pdfReaderInstance = (PdfReaderInstance)this.importedPages.get(pdfReader);
        if (pdfReaderInstance == null) {
            pdfReaderInstance = pdfReader.getPdfReaderInstance(this);
            this.importedPages.put(pdfReader, pdfReaderInstance);
        }
        return pdfReaderInstance.getImportedPage(n);
    }

    public void addJavaScript(PdfAction pdfAction) {
        this.pdf.addJavaScript(pdfAction);
    }

    public void addJavaScript(String string, boolean bl) {
        this.addJavaScript(PdfAction.javaScript(string, this, bl));
    }

    public void addJavaScript(String string) {
        this.addJavaScript(string, false);
    }

    public void setCropBoxSize(Rectangle rectangle) {
        this.pdf.setCropBoxSize(rectangle);
    }

    public PdfIndirectReference getPageReference(int n) {
        PdfIndirectReference pdfIndirectReference;
        if (--n < 0) {
            throw new IndexOutOfBoundsException("The page numbers start at 1.");
        }
        if (n < this.pageReferences.size()) {
            pdfIndirectReference = (PdfIndirectReference)this.pageReferences.get(n);
            if (pdfIndirectReference == null) {
                pdfIndirectReference = this.body.getPdfIndirectReference();
                this.pageReferences.set(n, pdfIndirectReference);
            }
        } else {
            int n2 = n - this.pageReferences.size();
            int n3 = 0;
            while (n3 < n2) {
                this.pageReferences.add(null);
                ++n3;
            }
            pdfIndirectReference = this.body.getPdfIndirectReference();
            this.pageReferences.add(pdfIndirectReference);
        }
        return pdfIndirectReference;
    }

    PdfIndirectReference getCurrentPage() {
        return this.getPageReference(this.currentPageNumber);
    }

    int getCurrentPageNumber() {
        return this.currentPageNumber;
    }

    public void addCalculationOrder(PdfFormField pdfFormField) {
        this.pdf.addCalculationOrder(pdfFormField);
    }

    public void setSigFlags(int n) {
        this.pdf.setSigFlags(n);
    }

    public void addAnnotation(PdfAnnotation pdfAnnotation) {
        this.pdf.addAnnotation(pdfAnnotation);
    }

    public void setPdfVersion(char c) {
        this.HEADER[7] = (byte)c;
    }

    public int reorderPages(int[] nArray) throws DocumentException {
        return this.root.reorderPages(nArray);
    }

    public float getSpaceCharRatio() {
        return this.spaceCharRatio;
    }

    public void setSpaceCharRatio(float f) {
        this.spaceCharRatio = f < 0.001f ? 0.001f : f;
    }

    public void setRunDirection(int n) {
        if (n < 1 || n > 3) {
            throw new RuntimeException("Invalid run direction: " + n);
        }
        this.runDirection = n;
    }

    public int getRunDirection() {
        return this.runDirection;
    }

    public void setDuration(int n) {
        this.pdf.setDuration(n);
    }

    public void setTransition(PdfTransition pdfTransition) {
        this.pdf.setTransition(pdfTransition);
    }

    public void freeReader(PdfReader pdfReader) throws IOException {
        this.currentPdfReaderInstance = (PdfReaderInstance)this.importedPages.get(pdfReader);
        if (this.currentPdfReaderInstance == null) {
            return;
        }
        this.currentPdfReaderInstance.writeAllPages();
        this.currentPdfReaderInstance = null;
        this.importedPages.remove(pdfReader);
    }

    public void setPageAction(PdfName pdfName, PdfAction pdfAction) throws PdfException {
        if (!pdfName.equals(PAGE_OPEN) && !pdfName.equals(PAGE_CLOSE)) {
            throw new PdfException("Invalid page additional action type: " + pdfName.toString());
        }
        this.pdf.setPageAction(pdfName, pdfAction);
    }

    public int getCurrentDocumentSize() {
        return this.body.offset() + this.body.size() * 20 + 72;
    }

    public boolean isStrictImageSequence() {
        return this.pdf.isStrictImageSequence();
    }

    public void setStrictImageSequence(boolean bl) {
        this.pdf.setStrictImageSequence(bl);
    }

    public void setPageEmpty(boolean bl) {
        this.pdf.setPageEmpty(bl);
    }

    public PdfDictionary getInfo() {
        return ((PdfDocument)this.document).getInfo();
    }

    public PdfDictionary getExtraCatalog() {
        return this.extraCatalog;
    }

    public void setExtraCatalog(PdfDictionary pdfDictionary) {
        this.extraCatalog = pdfDictionary;
    }

    public void setLinearPageMode() {
        this.root.setLinearMode(null);
    }

    public PdfDictionary getGroup() {
        return this.group;
    }

    public void setGroup(PdfDictionary pdfDictionary) {
        this.group = pdfDictionary;
    }

    static class PdfTrailer
    extends PdfDictionary {
        int offset;

        PdfTrailer(int n, int n2, PdfIndirectReference pdfIndirectReference, PdfIndirectReference pdfIndirectReference2, PdfIndirectReference pdfIndirectReference3, PdfObject pdfObject) {
            this.offset = n2;
            this.put(PdfName.SIZE, new PdfNumber(n));
            this.put(PdfName.ROOT, pdfIndirectReference);
            if (pdfIndirectReference2 != null) {
                this.put(PdfName.INFO, pdfIndirectReference2);
            }
            if (pdfIndirectReference3 != null) {
                this.put(PdfName.ENCRYPT, pdfIndirectReference3);
            }
            if (pdfObject != null) {
                this.put(PdfName.ID, pdfObject);
            }
        }

        public void toPdf(PdfWriter pdfWriter, OutputStream outputStream) throws IOException {
            outputStream.write(DocWriter.getISOBytes("trailer\n"));
            super.toPdf(null, outputStream);
            outputStream.write(DocWriter.getISOBytes("\nstartxref\n"));
            outputStream.write(DocWriter.getISOBytes(String.valueOf(this.offset)));
            outputStream.write(DocWriter.getISOBytes("\n%%EOF\n"));
        }
    }

    public static class PdfBody {
        private ArrayList xrefs = new ArrayList();
        private int position;
        private PdfWriter writer;

        PdfBody(PdfWriter pdfWriter) {
            this.xrefs.add(new PdfCrossReference(0, 65535));
            this.position = pdfWriter.getOs().getCounter();
            this.writer = pdfWriter;
        }

        PdfIndirectObject add(PdfObject pdfObject) throws IOException {
            PdfIndirectObject pdfIndirectObject = new PdfIndirectObject(this.size(), pdfObject, this.writer);
            this.xrefs.add(new PdfCrossReference(this.position));
            pdfIndirectObject.writeTo(this.writer.getOs());
            this.position = this.writer.getOs().getCounter();
            return pdfIndirectObject;
        }

        PdfIndirectReference getPdfIndirectReference() {
            this.xrefs.add(new PdfCrossReference(0));
            return new PdfIndirectReference(0, this.size() - 1);
        }

        int getIndirectReferenceNumber() {
            this.xrefs.add(new PdfCrossReference(0));
            return this.size() - 1;
        }

        PdfIndirectObject add(PdfObject pdfObject, PdfIndirectReference pdfIndirectReference) throws IOException {
            PdfIndirectObject pdfIndirectObject = new PdfIndirectObject(pdfIndirectReference.getNumber(), pdfObject, this.writer);
            this.xrefs.set(pdfIndirectReference.getNumber(), new PdfCrossReference(this.position));
            pdfIndirectObject.writeTo(this.writer.getOs());
            this.position = this.writer.getOs().getCounter();
            return pdfIndirectObject;
        }

        PdfIndirectObject add(PdfObject pdfObject, int n) throws IOException {
            PdfIndirectObject pdfIndirectObject = new PdfIndirectObject(n, pdfObject, this.writer);
            this.xrefs.set(n, new PdfCrossReference(this.position));
            pdfIndirectObject.writeTo(this.writer.getOs());
            this.position = this.writer.getOs().getCounter();
            return pdfIndirectObject;
        }

        int offset() {
            return this.position;
        }

        int size() {
            return this.xrefs.size();
        }

        void writeCrossReferenceTable(OutputStream outputStream) throws IOException {
            outputStream.write(DocWriter.getISOBytes("xref\n0 "));
            outputStream.write(DocWriter.getISOBytes(String.valueOf(this.size())));
            outputStream.write(10);
            Iterator iterator = ((AbstractList)this.xrefs).iterator();
            while (iterator.hasNext()) {
                PdfCrossReference pdfCrossReference = (PdfCrossReference)iterator.next();
                pdfCrossReference.toPdf(null, outputStream);
            }
        }

        static class PdfCrossReference {
            private int offset;
            private int generation;

            PdfCrossReference(int n, int n2) {
                this.offset = n;
                this.generation = n2;
            }

            PdfCrossReference(int n) {
                this(n, 0);
            }

            public void toPdf(PdfWriter pdfWriter, OutputStream outputStream) throws IOException {
                String string = "0000000000" + this.offset;
                StringBuffer stringBuffer = new StringBuffer(string.substring(string.length() - 10));
                string = "00000" + this.generation;
                String string2 = string.substring(string.length() - 5);
                if (this.generation == 65535) {
                    outputStream.write(DocWriter.getISOBytes(stringBuffer.append(' ').append(string2).append(" f \n").toString()));
                } else {
                    outputStream.write(DocWriter.getISOBytes(stringBuffer.append(' ').append(string2).append(" n \n").toString()));
                }
            }
        }
    }
}

