/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import com.sun.grizzly.CallbackHandler;
import com.sun.grizzly.ConnectorHandler;
import com.sun.grizzly.Context;
import com.sun.grizzly.Controller;
import com.sun.grizzly.ControllerStateListenerAdapter;
import com.sun.grizzly.DefaultPipeline;
import com.sun.grizzly.IOEvent;
import com.sun.grizzly.TCPSelectorHandler;
import com.sun.grizzly.async.AsyncQueueDataProcessor;
import com.sun.grizzly.async.AsyncQueueReadable;
import com.sun.grizzly.async.AsyncQueueWritable;
import com.sun.grizzly.async.AsyncReadCallbackHandler;
import com.sun.grizzly.async.AsyncReadCondition;
import com.sun.grizzly.async.AsyncWriteCallbackHandler;
import com.sun.grizzly.util.ByteBufferInputStream;
import com.sun.grizzly.util.OutputWriter;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCPConnectorHandler
implements ConnectorHandler<TCPSelectorHandler, CallbackHandler>,
AsyncQueueWritable,
AsyncQueueReadable {
    protected TCPSelectorHandler selectorHandler;
    private CallbackHandler callbackHandler;
    private ByteBufferInputStream inputStream;
    protected SocketChannel socketChannel;
    private volatile boolean isConnected;
    private Controller controller;
    private CountDownLatch isConnectedLatch;
    private boolean isStandalone = false;
    protected boolean tcpNoDelay = true;
    protected boolean reuseAddress = true;
    protected int linger = -1;

    @Override
    public void connect(SocketAddress remoteAddress, CallbackHandler callbackHandler) throws IOException {
        this.connect(remoteAddress, (SocketAddress)null, callbackHandler);
    }

    @Override
    public void connect(SocketAddress remoteAddress, SocketAddress localAddress, CallbackHandler callbackHandler) throws IOException {
        if (this.controller == null) {
            throw new IllegalStateException("Controller cannot be null");
        }
        this.connect(remoteAddress, localAddress, callbackHandler, (TCPSelectorHandler)this.controller.getSelectorHandler(this.protocol()));
    }

    @Override
    public void connect(SocketAddress remoteAddress, CallbackHandler callbackHandler, TCPSelectorHandler selectorHandler) throws IOException {
        this.connect(remoteAddress, (SocketAddress)null, callbackHandler, selectorHandler);
    }

    @Override
    public void connect(SocketAddress remoteAddress, SocketAddress localAddress, CallbackHandler callbackHandler, TCPSelectorHandler selectorHandler) throws IOException {
        if (this.isConnected) {
            throw new AlreadyConnectedException();
        }
        if (this.controller == null) {
            throw new IllegalStateException("Controller cannot be null");
        }
        if (selectorHandler == null) {
            throw new IllegalStateException("SelectorHandler cannot be null");
        }
        this.selectorHandler = selectorHandler;
        this.callbackHandler = callbackHandler;
        this.isConnectedLatch = new CountDownLatch(1);
        selectorHandler.connect(remoteAddress, localAddress, callbackHandler);
        this.inputStream = new ByteBufferInputStream();
        try {
            this.isConnectedLatch.await(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    @Override
    public void connect(SocketAddress remoteAddress) throws IOException {
        this.connect(remoteAddress, (SocketAddress)null);
    }

    @Override
    public void connect(SocketAddress remoteAddress, SocketAddress localAddress) throws IOException {
        if (this.isConnected) {
            throw new AlreadyConnectedException();
        }
        if (this.controller == null) {
            this.isStandalone = true;
            this.controller = new Controller();
            this.controller.setSelectorHandler(new TCPSelectorHandler(true));
            DefaultPipeline pipeline = new DefaultPipeline();
            pipeline.initPipeline();
            pipeline.startPipeline();
            this.controller.setPipeline(pipeline);
            final CountDownLatch latch = new CountDownLatch(1);
            this.controller.addStateListener(new ControllerStateListenerAdapter(){

                public void onReady() {
                    latch.countDown();
                }

                public void onException(Throwable e) {
                    latch.countDown();
                }
            });
            this.callbackHandler = this.createCallbackHandler();
            new Thread(this.controller).start();
            try {
                latch.await();
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        if (null == this.callbackHandler) {
            this.callbackHandler = this.createCallbackHandler();
        }
        this.connect(remoteAddress, localAddress, this.callbackHandler, (TCPSelectorHandler)this.controller.getSelectorHandler(this.protocol()));
    }

    private CallbackHandler<Context> createCallbackHandler() {
        return new CallbackHandler<Context>(){

            @Override
            public void onConnect(IOEvent<Context> ioEvent) {
                SelectionKey key = ioEvent.attachment().getSelectionKey();
                TCPConnectorHandler.this.socketChannel = (SocketChannel)key.channel();
                try {
                    TCPConnectorHandler.this.finishConnect(key);
                }
                catch (IOException ex) {
                    Controller.logger().severe(ex.getMessage());
                }
                TCPConnectorHandler.this.getController().registerKey(key, 4, Controller.Protocol.TCP);
            }

            @Override
            public void onRead(IOEvent<Context> ioEvent) {
            }

            @Override
            public void onWrite(IOEvent<Context> ioEvent) {
            }
        };
    }

    @Override
    public long read(ByteBuffer byteBuffer, boolean blocking) throws IOException {
        if (!this.isConnected) {
            throw new NotYetConnectedException();
        }
        SelectionKey key = this.socketChannel.keyFor(this.selectorHandler.getSelector());
        if (blocking) {
            this.inputStream.setSelectionKey(key);
            return this.inputStream.read(byteBuffer);
        }
        if (this.callbackHandler == null) {
            throw new IllegalStateException("Non blocking read needs a CallbackHandler");
        }
        int nRead = this.socketChannel.read(byteBuffer);
        if (nRead == 0) {
            this.selectorHandler.register(key, 1);
        }
        return nRead;
    }

    @Override
    public long write(ByteBuffer byteBuffer, boolean blocking) throws IOException {
        if (!this.isConnected) {
            throw new NotYetConnectedException();
        }
        if (blocking) {
            return OutputWriter.flushChannel((SelectableChannel)this.socketChannel, byteBuffer);
        }
        if (this.callbackHandler == null) {
            throw new IllegalStateException("Non blocking write needs a CallbackHandler");
        }
        SelectionKey key = this.socketChannel.keyFor(this.selectorHandler.getSelector());
        int nWrite = 1;
        int totalWriteBytes = 0;
        while (nWrite > 0 && byteBuffer.hasRemaining()) {
            nWrite = this.socketChannel.write(byteBuffer);
            totalWriteBytes += nWrite;
        }
        if (totalWriteBytes == 0 && byteBuffer.hasRemaining()) {
            this.selectorHandler.register(key, 4);
        }
        return totalWriteBytes;
    }

    @Override
    public void readFromAsyncQueue(ByteBuffer buffer, AsyncReadCallbackHandler callbackHandler) throws IOException {
        this.readFromAsyncQueue(buffer, callbackHandler, null);
    }

    @Override
    public void readFromAsyncQueue(ByteBuffer buffer, AsyncReadCallbackHandler callbackHandler, AsyncReadCondition condition) throws IOException {
        this.readFromAsyncQueue(buffer, callbackHandler, condition, null);
    }

    @Override
    public void readFromAsyncQueue(ByteBuffer buffer, AsyncReadCallbackHandler callbackHandler, AsyncReadCondition condition, AsyncQueueDataProcessor readPostProcessor) throws IOException {
        this.selectorHandler.getAsyncQueueReader().read(this.socketChannel.keyFor(this.selectorHandler.getSelector()), buffer, callbackHandler, condition, readPostProcessor);
    }

    @Override
    public void writeToAsyncQueue(ByteBuffer buffer) throws IOException {
        this.writeToAsyncQueue(buffer, null);
    }

    @Override
    public void writeToAsyncQueue(ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler) throws IOException {
        this.writeToAsyncQueue(buffer, callbackHandler, null);
    }

    @Override
    public void writeToAsyncQueue(ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler, AsyncQueueDataProcessor writePreProcessor) throws IOException {
        this.writeToAsyncQueue(buffer, callbackHandler, writePreProcessor, false);
    }

    @Override
    public void writeToAsyncQueue(ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler, AsyncQueueDataProcessor writePreProcessor, boolean isCloneByteBuffer) throws IOException {
        this.selectorHandler.getAsyncQueueWriter().write(this.socketChannel.keyFor(this.selectorHandler.getSelector()), buffer, callbackHandler, writePreProcessor, isCloneByteBuffer);
    }

    @Override
    public void writeToAsyncQueue(SocketAddress dstAddress, ByteBuffer buffer) throws IOException {
        this.writeToAsyncQueue(dstAddress, buffer, null);
    }

    @Override
    public void writeToAsyncQueue(SocketAddress dstAddress, ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler) throws IOException {
        this.writeToAsyncQueue(dstAddress, buffer, callbackHandler, null);
    }

    @Override
    public void writeToAsyncQueue(SocketAddress dstAddress, ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler, AsyncQueueDataProcessor writePreProcessor) throws IOException {
        this.writeToAsyncQueue(dstAddress, buffer, callbackHandler, writePreProcessor, false);
    }

    @Override
    public void writeToAsyncQueue(SocketAddress dstAddress, ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler, AsyncQueueDataProcessor writePreProcessor, boolean isCloneByteBuffer) throws IOException {
        this.selectorHandler.getAsyncQueueWriter().write(this.socketChannel.keyFor(this.selectorHandler.getSelector()), dstAddress, buffer, callbackHandler, writePreProcessor, isCloneByteBuffer);
    }

    @Override
    public void close() throws IOException {
        if (this.socketChannel != null) {
            if (this.selectorHandler != null) {
                SelectionKey key = this.socketChannel.keyFor(this.selectorHandler.getSelector());
                if (key == null) {
                    return;
                }
                this.selectorHandler.getSelectionKeyHandler().cancel(key);
            } else {
                this.socketChannel.close();
            }
        }
        if (this.controller != null && this.isStandalone) {
            this.controller.stop();
            this.controller = null;
        }
        this.isStandalone = false;
        this.isConnected = false;
    }

    @Override
    public void finishConnect(SelectionKey key) throws IOException {
        try {
            block5: {
                if (Controller.logger().isLoggable(Level.FINE)) {
                    Controller.logger().log(Level.FINE, "Finish connect");
                }
                this.socketChannel = (SocketChannel)key.channel();
                this.socketChannel.finishConnect();
                this.isConnected = this.socketChannel.isConnected();
                this.configureChannel(this.socketChannel);
                if (!Controller.logger().isLoggable(Level.FINE)) break block5;
                Controller.logger().log(Level.FINE, "isConnected: " + this.isConnected);
            }
            Object var4_2 = null;
            this.isConnectedLatch.countDown();
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.isConnectedLatch.countDown();
            throw throwable;
        }
    }

    public void configureChannel(SelectableChannel channel) throws IOException {
        Socket socket = ((SocketChannel)channel).socket();
        try {
            if (this.linger >= 0) {
                socket.setSoLinger(true, this.linger);
            }
        }
        catch (SocketException ex) {
            Controller.logger().log(Level.WARNING, "setSoLinger exception ", ex);
        }
        try {
            socket.setTcpNoDelay(this.tcpNoDelay);
        }
        catch (SocketException ex) {
            Controller.logger().log(Level.WARNING, "setTcpNoDelay exception ", ex);
        }
        try {
            socket.setReuseAddress(this.reuseAddress);
        }
        catch (SocketException ex) {
            Controller.logger().log(Level.WARNING, "setReuseAddress exception ", ex);
        }
    }

    @Override
    public Controller.Protocol protocol() {
        return Controller.Protocol.TCP;
    }

    public boolean isConnected() {
        return this.isConnected && this.socketChannel.isOpen();
    }

    @Override
    public Controller getController() {
        return this.controller;
    }

    @Override
    public void setController(Controller controller) {
        this.controller = controller;
    }

    @Override
    public SelectableChannel getUnderlyingChannel() {
        return this.socketChannel;
    }

    @Override
    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    @Override
    public void setCallbackHandler(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    @Override
    public TCPSelectorHandler getSelectorHandler() {
        return this.selectorHandler;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public int getLinger() {
        return this.linger;
    }

    public void setLinger(int linger) {
        this.linger = linger;
    }

    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }
}

