/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import com.sun.grizzly.CallbackHandler;
import com.sun.grizzly.CallbackHandlerContextTask;
import com.sun.grizzly.CallbackHandlerDescriptor;
import com.sun.grizzly.ConnectorHandler;
import com.sun.grizzly.ConnectorInstanceHandler;
import com.sun.grizzly.Context;
import com.sun.grizzly.Controller;
import com.sun.grizzly.IOEvent;
import com.sun.grizzly.Pipeline;
import com.sun.grizzly.PipelineFullException;
import com.sun.grizzly.ProtocolChain;
import com.sun.grizzly.ProtocolChainInstanceHandler;
import com.sun.grizzly.SelectionKeyHandler;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.TCPConnectorHandler;
import com.sun.grizzly.async.AsyncQueueReader;
import com.sun.grizzly.async.AsyncQueueReaderContextTask;
import com.sun.grizzly.async.AsyncQueueWriter;
import com.sun.grizzly.async.AsyncQueueWriterContextTask;
import com.sun.grizzly.async.TCPAsyncQueueReader;
import com.sun.grizzly.async.TCPAsyncQueueWriter;
import com.sun.grizzly.util.CallbackHandlerSelectionKeyAttachment;
import com.sun.grizzly.util.Cloner;
import com.sun.grizzly.util.Copyable;
import com.sun.grizzly.util.SelectionKeyAttachment;
import com.sun.grizzly.util.SelectionKeyOP;
import com.sun.grizzly.util.State;
import com.sun.grizzly.util.StateHolder;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCPSelectorHandler
implements SelectorHandler {
    protected ConnectorInstanceHandler connectorInstanceHandler;
    protected ConcurrentLinkedQueue<SelectionKeyOP> opToRegister;
    protected boolean tcpNoDelay = true;
    protected boolean reuseAddress = true;
    protected int linger = -1;
    protected int socketTimeout = -1;
    protected Logger logger;
    protected int serverTimeout = 0;
    protected InetAddress inet;
    protected int port = 18888;
    protected ServerSocket serverSocket;
    protected ServerSocketChannel serverSocketChannel;
    protected Selector selector;
    protected long selectTimeout = 1000L;
    protected int ssBackLog = 4096;
    protected boolean isClient = false;
    protected SelectionKeyHandler selectionKeyHandler;
    protected ProtocolChainInstanceHandler instanceHandler;
    protected Pipeline pipeline;
    protected AsyncQueueWriter asyncQueueWriter;
    protected AsyncQueueReader asyncQueueReader;
    protected Map<String, Object> attributes;
    protected StateHolder<State> stateHolder = new StateHolder(true);
    protected AtomicBoolean isShutDown = new AtomicBoolean(false);

    public TCPSelectorHandler() {
        this(false);
    }

    public TCPSelectorHandler(boolean isClient) {
        this.isClient = isClient;
    }

    @Override
    public void copyTo(Copyable copy) {
        TCPSelectorHandler copyHandler = (TCPSelectorHandler)copy;
        copyHandler.selector = this.selector;
        if (this.selectionKeyHandler != null) {
            copyHandler.setSelectionKeyHandler(Cloner.clone(this.selectionKeyHandler));
        }
        copyHandler.attributes = this.attributes;
        copyHandler.selectTimeout = this.selectTimeout;
        copyHandler.serverTimeout = this.serverTimeout;
        copyHandler.inet = this.inet;
        copyHandler.port = this.port;
        copyHandler.ssBackLog = this.ssBackLog;
        copyHandler.tcpNoDelay = this.tcpNoDelay;
        copyHandler.linger = this.linger;
        copyHandler.socketTimeout = this.socketTimeout;
        copyHandler.logger = this.logger;
        copyHandler.reuseAddress = this.reuseAddress;
        copyHandler.connectorInstanceHandler = this.connectorInstanceHandler;
        copyHandler.stateHolder = this.stateHolder;
    }

    @Override
    public Set<SelectionKey> keys() {
        if (this.selector != null) {
            return this.selector.keys();
        }
        throw new IllegalStateException("Selector is not created!");
    }

    @Override
    public boolean isOpen() {
        if (this.selector != null) {
            return this.selector.isOpen();
        }
        return false;
    }

    @Override
    public void preSelect(Context ctx) throws IOException {
        this.initOpRegistriesIfRequired();
        if (this.asyncQueueReader == null) {
            this.asyncQueueReader = new TCPAsyncQueueReader(this);
        }
        if (this.asyncQueueWriter == null) {
            this.asyncQueueWriter = new TCPAsyncQueueWriter(this);
        }
        if (this.selector == null) {
            try {
                this.isShutDown.set(false);
                this.connectorInstanceHandler = new ConnectorInstanceHandler.ConcurrentQueueDelegateCIH<ConnectorHandler>(this.getConnectorInstanceHandlerDelegate());
                this.selector = Selector.open();
                if (!this.isClient) {
                    this.serverSocketChannel = ServerSocketChannel.open();
                    this.serverSocket = this.serverSocketChannel.socket();
                    this.serverSocket.setReuseAddress(this.reuseAddress);
                    if (this.inet == null) {
                        this.serverSocket.bind(new InetSocketAddress(this.port), this.ssBackLog);
                    } else {
                        this.serverSocket.bind(new InetSocketAddress(this.inet, this.port), this.ssBackLog);
                    }
                    this.serverSocketChannel.configureBlocking(false);
                    this.serverSocketChannel.register(this.selector, 16);
                }
            }
            catch (SocketException ex) {
                throw new BindException(ex.getMessage() + ": " + this.port + "=" + this);
            }
            if (!this.isClient) {
                this.serverSocket.setSoTimeout(this.serverTimeout);
            }
        } else {
            this.processPendingOperations(ctx);
        }
    }

    protected void processPendingOperations(Context ctx) throws IOException {
        if (!this.opToRegister.isEmpty()) {
            Iterator<SelectionKeyOP> opIterator = this.opToRegister.iterator();
            while (opIterator.hasNext()) {
                SelectionKeyOP operation = opIterator.next();
                opIterator.remove();
                if ((operation.getOp() & 8) != 0) {
                    this.onConnectOp(ctx, (SelectionKeyOP.ConnectSelectionKeyOP)operation);
                } else {
                    if ((operation.getOp() & 1) != 0) {
                        this.onReadOp(operation);
                    }
                    if ((operation.getOp() & 4) != 0) {
                        this.onWriteOp(operation);
                    }
                }
                SelectionKeyOP.releaseSelectionKeyOP(operation);
            }
        }
    }

    protected void onReadOp(SelectionKeyOP selectionKeyOp) throws ClosedChannelException {
        SelectionKey key = selectionKeyOp.getSelectionKey();
        if (key != null) {
            this.selectionKeyHandler.register(key, 1);
        } else {
            this.selectionKeyHandler.register(selectionKeyOp.getChannel(), 1);
        }
    }

    protected void onWriteOp(SelectionKeyOP selectionKeyOp) throws ClosedChannelException {
        SelectionKey key = selectionKeyOp.getSelectionKey();
        if (key != null) {
            this.selectionKeyHandler.register(key, 4);
        } else {
            this.selectionKeyHandler.register(selectionKeyOp.getChannel(), 4);
        }
    }

    protected void onConnectOp(Context ctx, SelectionKeyOP.ConnectSelectionKeyOP selectionKeyOp) throws IOException {
        boolean isConnected;
        SocketAddress remoteAddress = selectionKeyOp.getRemoteAddress();
        SocketAddress localAddress = selectionKeyOp.getLocalAddress();
        CallbackHandler callbackHandler = selectionKeyOp.getCallbackHandler();
        SocketChannel socketChannel = SocketChannel.open();
        socketChannel.socket().setReuseAddress(this.reuseAddress);
        if (localAddress != null) {
            socketChannel.socket().bind(localAddress);
        }
        socketChannel.configureBlocking(false);
        SelectionKey key = socketChannel.register(this.selector, 8);
        key.attach(CallbackHandlerSelectionKeyAttachment.create(key, callbackHandler));
        try {
            isConnected = socketChannel.connect(remoteAddress);
        }
        catch (IOException e) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "IOException occured when tried to connect socket", e);
            }
            isConnected = true;
        }
        if (isConnected) {
            this.onConnectInterest(key, ctx);
        }
    }

    @Override
    public Set<SelectionKey> select(Context ctx) throws IOException {
        this.selector.select(this.selectTimeout);
        return this.selector.selectedKeys();
    }

    @Override
    public void postSelect(Context ctx) {
        Set<SelectionKey> readyKeys = this.keys();
        if (readyKeys.isEmpty()) {
            return;
        }
        if (this.isOpen()) {
            this.selectionKeyHandler.expire(readyKeys.iterator());
        }
    }

    @Override
    public void register(SelectionKey key, int ops) {
        SelectionKeyOP keyOP = SelectionKeyOP.aquireSelectionKeyOP(ops);
        keyOP.setSelectionKey(key);
        keyOP.setOp(ops);
        this.initOpRegistriesIfRequired();
        this.opToRegister.offer(keyOP);
        this.selector.wakeup();
    }

    @Override
    public void register(SelectableChannel channel, int ops) {
        SelectionKeyOP keyOP = SelectionKeyOP.aquireSelectionKeyOP(ops);
        keyOP.setChannel(channel);
        keyOP.setOp(ops);
        this.initOpRegistriesIfRequired();
        this.opToRegister.offer(keyOP);
        this.selector.wakeup();
    }

    protected void connect(SocketAddress remoteAddress, SocketAddress localAddress, CallbackHandler callBackHandler) throws IOException {
        SelectionKeyOP.ConnectSelectionKeyOP keyOP = (SelectionKeyOP.ConnectSelectionKeyOP)SelectionKeyOP.aquireSelectionKeyOP(8);
        keyOP.setOp(8);
        keyOP.setRemoteAddress(remoteAddress);
        keyOP.setLocalAddress(localAddress);
        keyOP.setCallbackHandler(callBackHandler);
        this.initOpRegistriesIfRequired();
        this.opToRegister.offer(keyOP);
        this.selector.wakeup();
    }

    @Override
    public void pause() {
        this.stateHolder.setState(State.PAUSED);
    }

    @Override
    public void resume() {
        if (!State.PAUSED.equals((Object)this.stateHolder.getState(false))) {
            throw new IllegalStateException("SelectorHandler is not in PAUSED state, but: " + (Object)((Object)this.stateHolder.getState(false)));
        }
        this.stateHolder.setState(State.STARTED);
    }

    @Override
    public StateHolder<State> getStateHolder() {
        return this.stateHolder;
    }

    @Override
    public void shutdown() {
        if (this.isShutDown.getAndSet(true)) {
            return;
        }
        this.stateHolder.setState(State.STOPPED);
        if (this.selector != null) {
            try {
                for (SelectionKey selectionKey : this.selector.keys()) {
                    this.selectionKeyHandler.close(selectionKey);
                }
            }
            catch (ClosedSelectorException e) {
            }
            catch (ConcurrentModificationException e) {
                Object[] keys;
                for (Object selectionKey : keys = this.selector.keys().toArray()) {
                    this.selectionKeyHandler.close((SelectionKey)selectionKey);
                }
            }
        }
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (Throwable ex) {
            Controller.logger().log(Level.SEVERE, "serverSocket.close", ex);
        }
        try {
            if (this.serverSocketChannel != null) {
                this.serverSocketChannel.close();
            }
        }
        catch (Throwable ex) {
            Controller.logger().log(Level.SEVERE, "serverSocketChannel.close", ex);
        }
        try {
            if (this.selector != null) {
                this.selector.close();
            }
        }
        catch (Throwable ex) {
            Controller.logger().log(Level.SEVERE, "selector.close", ex);
        }
        if (this.asyncQueueReader != null) {
            this.asyncQueueReader.close();
            this.asyncQueueReader = null;
        }
        if (this.asyncQueueWriter != null) {
            this.asyncQueueWriter.close();
            this.asyncQueueWriter = null;
        }
        this.attributes = null;
    }

    @Override
    public SelectableChannel acceptWithoutRegistration(SelectionKey key) throws IOException {
        ServerSocketChannel server = (ServerSocketChannel)key.channel();
        SocketChannel channel = server.accept();
        return channel;
    }

    @Override
    public boolean onAcceptInterest(SelectionKey key, Context ctx) throws IOException {
        SelectableChannel channel = this.acceptWithoutRegistration(key);
        if (channel != null) {
            this.configureChannel(channel);
            SelectionKey readKey = channel.register(this.selector, 1);
            readKey.attach(System.currentTimeMillis());
        }
        return false;
    }

    @Override
    public boolean onReadInterest(SelectionKey key, Context ctx) throws IOException {
        key.interestOps(key.interestOps() & 0xFFFFFFFE);
        Object attach = SelectionKeyAttachment.getAttachment(key);
        if (this.asyncQueueReader.isAsyncQueueReaderEnabledFor(key)) {
            Context context = this.pollContext(ctx, key);
            context.setCurrentOpType(Context.OpType.OP_READ);
            this.invokeAsyncQueueReader(context);
            return false;
        }
        if (attach instanceof CallbackHandler) {
            Context context = this.pollContext(ctx, key);
            context.setCurrentOpType(Context.OpType.OP_READ);
            this.invokeCallbackHandler((CallbackHandler)attach, context);
            return false;
        }
        return true;
    }

    @Override
    public boolean onWriteInterest(SelectionKey key, Context ctx) throws IOException {
        key.interestOps(key.interestOps() & 0xFFFFFFFB);
        if (this.asyncQueueWriter.hasReadyAsyncWriteData(key)) {
            Context context = this.pollContext(ctx, key);
            context.setCurrentOpType(Context.OpType.OP_WRITE);
            this.invokeAsyncQueueWriter(context);
            return false;
        }
        Object attach = SelectionKeyAttachment.getAttachment(key);
        if (attach instanceof CallbackHandler) {
            Context context = this.pollContext(ctx, key);
            context.setCurrentOpType(Context.OpType.OP_WRITE);
            this.invokeCallbackHandler((CallbackHandler)attach, context);
            return false;
        }
        return true;
    }

    @Override
    public boolean onConnectInterest(SelectionKey key, Context ctx) throws IOException {
        block3: {
            try {
                key.interestOps(key.interestOps() & 0xFFFFFFF7);
                key.interestOps(key.interestOps() & 0xFFFFFFFB);
                key.interestOps(key.interestOps() & 0xFFFFFFFE);
            }
            catch (CancelledKeyException e) {
                if (!this.logger.isLoggable(Level.FINE)) break block3;
                this.logger.log(Level.FINE, "CancelledKeyException occured when tried to change key interests", e);
            }
        }
        Object attach = SelectionKeyAttachment.getAttachment(key);
        if (attach instanceof CallbackHandler) {
            Context context = this.pollContext(ctx, key);
            context.setCurrentOpType(Context.OpType.OP_CONNECT);
            this.invokeCallbackHandler((CallbackHandler)attach, context);
        }
        return false;
    }

    protected void invokeCallbackHandler(CallbackHandler callbackHandler, Context context) throws IOException {
        IOEvent.DefaultIOEvent<Context> ioEvent = new IOEvent.DefaultIOEvent<Context>(context);
        context.setIOEvent(ioEvent);
        context.setSelectorHandler(this);
        try {
            CallbackHandlerContextTask task = CallbackHandlerContextTask.poll();
            task.setCallBackHandler(callbackHandler);
            boolean isRunInSeparateThread = true;
            if (callbackHandler instanceof CallbackHandlerDescriptor) {
                isRunInSeparateThread = ((CallbackHandlerDescriptor)((Object)callbackHandler)).isRunInSeparateThread(context.getCurrentOpType());
            }
            context.execute(task, isRunInSeparateThread);
        }
        catch (PipelineFullException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    protected void invokeAsyncQueueReader(Context context) throws IOException {
        AsyncQueueReaderContextTask task = AsyncQueueReaderContextTask.poll();
        task.setAsyncQueueReader(this.asyncQueueReader);
        try {
            context.execute(task);
        }
        catch (PipelineFullException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    protected void invokeAsyncQueueWriter(Context context) throws IOException {
        AsyncQueueWriterContextTask task = AsyncQueueWriterContextTask.poll();
        task.setAsyncQueueWriter(this.asyncQueueWriter);
        try {
            context.execute(task);
        }
        catch (PipelineFullException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    @Override
    public ConnectorHandler acquireConnectorHandler() {
        if (this.selector == null || !this.selector.isOpen()) {
            throw new IllegalStateException("SelectorHandler not yet started");
        }
        Object connectorHandler = this.connectorInstanceHandler.acquire();
        return connectorHandler;
    }

    @Override
    public void releaseConnectorHandler(ConnectorHandler connectorHandler) {
        this.connectorInstanceHandler.release(connectorHandler);
    }

    @Override
    public Controller.Protocol protocol() {
        return Controller.Protocol.TCP;
    }

    protected void initOpRegistriesIfRequired() {
        if (this.opToRegister == null) {
            this.opToRegister = new ConcurrentLinkedQueue();
        }
    }

    @Override
    public void configureChannel(SelectableChannel channel) throws IOException {
        Socket socket = ((SocketChannel)channel).socket();
        channel.configureBlocking(false);
        try {
            if (this.linger >= 0) {
                socket.setSoLinger(true, this.linger);
            }
        }
        catch (SocketException ex) {
            this.logger.log(Level.WARNING, "setSoLinger exception ", ex);
        }
        try {
            socket.setTcpNoDelay(this.tcpNoDelay);
        }
        catch (SocketException ex) {
            this.logger.log(Level.WARNING, "setTcpNoDelay exception ", ex);
        }
        try {
            socket.setReuseAddress(this.reuseAddress);
        }
        catch (SocketException ex) {
            this.logger.log(Level.WARNING, "setReuseAddress exception ", ex);
        }
    }

    @Override
    public final Selector getSelector() {
        return this.selector;
    }

    @Override
    public final void setSelector(Selector selector) {
        this.selector = selector;
    }

    @Override
    public AsyncQueueReader getAsyncQueueReader() {
        return this.asyncQueueReader;
    }

    @Override
    public AsyncQueueWriter getAsyncQueueWriter() {
        return this.asyncQueueWriter;
    }

    public long getSelectTimeout() {
        return this.selectTimeout;
    }

    public void setSelectTimeout(long selectTimeout) {
        this.selectTimeout = selectTimeout;
    }

    public int getServerTimeout() {
        return this.serverTimeout;
    }

    public void setServerTimeout(int serverTimeout) {
        this.serverTimeout = serverTimeout;
    }

    public InetAddress getInet() {
        return this.inet;
    }

    public void setInet(InetAddress inet) {
        this.inet = inet;
    }

    public int getPortLowLevel() {
        if (this.serverSocket != null) {
            return this.serverSocket.getLocalPort();
        }
        return -1;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getSsBackLog() {
        return this.ssBackLog;
    }

    public void setSsBackLog(int ssBackLog) {
        this.ssBackLog = ssBackLog;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public int getLinger() {
        return this.linger;
    }

    public void setLinger(int linger) {
        this.linger = linger;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    @Override
    public Pipeline pipeline() {
        return this.pipeline;
    }

    @Override
    public void setPipeline(Pipeline pipeline) {
        this.pipeline = pipeline;
    }

    @Override
    public SelectionKeyHandler getSelectionKeyHandler() {
        return this.selectionKeyHandler;
    }

    @Override
    public void setSelectionKeyHandler(SelectionKeyHandler selectionKeyHandler) {
        this.selectionKeyHandler = selectionKeyHandler;
        this.selectionKeyHandler.setSelectorHandler(this);
    }

    @Override
    public void setProtocolChainInstanceHandler(ProtocolChainInstanceHandler instanceHandler) {
        this.instanceHandler = instanceHandler;
    }

    @Override
    public ProtocolChainInstanceHandler getProtocolChainInstanceHandler() {
        return this.instanceHandler;
    }

    @Override
    public void closeChannel(SelectableChannel channel) {
        if (channel instanceof SocketChannel) {
            Socket socket = ((SocketChannel)channel).socket();
            try {
                if (!socket.isInputShutdown()) {
                    socket.shutdownInput();
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            try {
                if (!socket.isOutputShutdown()) {
                    socket.shutdownOutput();
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            channel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.asyncQueueReader != null) {
            this.asyncQueueReader.onClose(channel);
        }
        if (this.asyncQueueWriter != null) {
            this.asyncQueueWriter.onClose(channel);
        }
    }

    protected Context pollContext(Context serverContext, SelectionKey key) {
        ProtocolChain protocolChain = this.instanceHandler != null ? this.instanceHandler.poll() : serverContext.getController().getProtocolChainInstanceHandler().poll();
        Context context = serverContext.getController().pollContext(key);
        context.setSelectionKey(key);
        context.setSelectorHandler(this);
        context.setAsyncQueueReader(this.asyncQueueReader);
        context.setAsyncQueueWriter(this.asyncQueueWriter);
        context.setProtocolChain(protocolChain);
        return context;
    }

    protected Callable<ConnectorHandler> getConnectorInstanceHandlerDelegate() {
        return new Callable<ConnectorHandler>(){

            @Override
            public ConnectorHandler call() throws Exception {
                return new TCPConnectorHandler();
            }
        };
    }

    @Override
    public Object removeAttribute(String key) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.remove(key);
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(key, value);
    }

    @Override
    public Object getAttribute(String key) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(key);
    }

    @Override
    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }
}

