/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.filter;

import com.sun.grizzly.Context;
import com.sun.grizzly.ProtocolParser;
import com.sun.grizzly.filter.ReadFilter;
import com.sun.grizzly.util.ThreadAttachment;
import com.sun.grizzly.util.WorkerThread;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;

public abstract class ParserProtocolFilter
extends ReadFilter {
    public boolean execute(Context ctx) throws IOException {
        ProtocolParser parser = (ProtocolParser)ctx.getAttribute("ProtocolParser");
        if (parser == null) {
            parser = this.newProtocolParser();
            ctx.setAttribute("ProtocolParser", parser);
        }
        if (!parser.hasMoreBytesToParse() || parser.isExpectingMoreData()) {
            boolean continueExecution = super.execute(ctx);
            WorkerThread workerThread = (WorkerThread)((Object)Thread.currentThread());
            ByteBuffer byteBuffer = workerThread.getByteBuffer();
            parser.startBuffer(byteBuffer);
            if (!continueExecution) {
                return continueExecution;
            }
        }
        if (!parser.hasNextMessage()) {
            return false;
        }
        return this.invokeProtocolParser(ctx, parser);
    }

    protected boolean invokeProtocolParser(Context ctx, ProtocolParser parser) {
        if (parser == null) {
            throw new IllegalStateException("ProcotolParser cannot be null");
        }
        Object o = parser.getNextMessage();
        ctx.setAttribute("ProtocolMessage", o);
        return true;
    }

    public boolean postExecute(Context context) throws IOException {
        ProtocolParser parser = (ProtocolParser)context.getAttribute("ProtocolParser");
        if (parser != null && parser.hasMoreBytesToParse()) {
            context.setAttribute("succes_read", Boolean.TRUE);
            return true;
        }
        if (parser.isExpectingMoreData()) {
            parser.releaseBuffer();
            WorkerThread workerThread = (WorkerThread)((Object)Thread.currentThread());
            SelectionKey key = context.getSelectionKey();
            ThreadAttachment threadAttachment = workerThread.detach(true);
            key.attach(threadAttachment);
            context.getSelectorHandler().register(key, 1);
            return false;
        }
        parser.releaseBuffer();
        return super.postExecute(context);
    }

    public abstract ProtocolParser newProtocolParser();
}

