/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.io.File;
import org.netbeans.api.project.Project;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.RubyExecution;
import org.netbeans.modules.ruby.platform.execution.ExecutionDescriptor;
import org.netbeans.modules.ruby.platform.execution.FileLocator;
import org.netbeans.modules.ruby.platform.execution.OutputRecognizer;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.netbeans.modules.ruby.rubyproject.RubyFileLocator;
import org.netbeans.modules.ruby.rubyproject.TestNotifier;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class AutoTestSupport {
    private Project project;
    private Lookup context;
    private String charsetName;
    private String classPath;

    public AutoTestSupport(Lookup lookup, Project project, String string) {
        this.context = lookup;
        this.project = project;
        this.charsetName = string;
    }

    public void setClassPath(String string) {
        this.classPath = string;
    }

    public static boolean isInstalled(Project project) {
        GemManager gemManager = RubyPlatform.gemManagerFor((Project)project);
        return gemManager == null ? false : gemManager.isValidAutoTest(false);
    }

    public void start() {
        RubyPlatform rubyPlatform = RubyPlatform.platformFor((Project)this.project);
        GemManager gemManager = rubyPlatform.getGemManager();
        if (!gemManager.isValidAutoTest(true)) {
            return;
        }
        File file = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
        RubyFileLocator rubyFileLocator = new RubyFileLocator(this.context, this.project);
        String string = NbBundle.getMessage(AutoTestSupport.class, (String)"AutoTest");
        ExecutionDescriptor executionDescriptor = new ExecutionDescriptor(rubyPlatform, string, file, gemManager.getAutoTest());
        executionDescriptor.additionalArgs(new String[]{"-v"});
        executionDescriptor.fileLocator((FileLocator)rubyFileLocator);
        executionDescriptor.classPath(this.classPath);
        executionDescriptor.showProgress(false);
        executionDescriptor.addOutputRecognizer((OutputRecognizer)new TestNotifier(false, false));
        executionDescriptor.addStandardRecognizers();
        new RubyExecution(executionDescriptor, this.charsetName).run();
    }
}

