/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.io.File;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import org.jruby.ast.ClassNode;
import org.jruby.ast.IScopingNode;
import org.jruby.ast.Node;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.DeclarationFinder;
import org.netbeans.modules.gsf.api.Index;
import org.netbeans.modules.gsf.api.NameKind;
import org.netbeans.modules.gsf.api.SourceModel;
import org.netbeans.modules.gsf.api.SourceModelFactory;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.elements.IndexedClass;
import org.netbeans.modules.ruby.elements.IndexedElement;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.netbeans.modules.ruby.rubyproject.RSpecSupport;
import org.netbeans.spi.gototest.TestLocator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class GotoTest
implements TestLocator {
    private static final String FILE = "(.+)";
    private static final String EXT = "(.+)";
    private final String[] ZENTEST_PATTERNS = new String[]{"app/controllers/(.+)\\.(.+)", "test/controllers/(.+)_test\\.(.+)", "app/views/(.+)\\.(.+)", "test/views/(.+)_test\\.(.+)", "app/models/(.+)\\.(.+)", "test/unit/(.+)_test\\.(.+)", "lib/(.+)\\.(.+)", "test/unit/test_(.+)\\.(.+)"};
    private final String[] RSPEC_PATTERNS = new String[]{"app/models/(.+)\\.(.+)", "spec/models/(.+)_spec\\.(.+)", "app/controllers/(.+)\\.(.+)", "spec/controllers/(.+)_spec\\.(.+)", "app/views/(.+)\\.(.+)", "spec/views/(.+)_spec\\.(.+)", "app/helpers/(.+)\\.(.+)", "spec/helpers/(.+)_spec\\.(.+)", "lib/(.+)\\.(.+)", "spec/(.+)_spec\\.(.+)", "/(.+)\\.(.+)", "/(.+)_spec\\.(.+)"};
    private final String[] RAILS_PATTERNS = new String[]{"app/controllers/(.+)\\.(.+)", "test/functional/(.+)_test\\.(.+)", "app/models/(.+)\\.(.+)", "test/unit/(.+)_test\\.(.+)", "lib/(.+)\\.(.+)", "test/unit/test_(.+)\\.(.+)"};
    private final String[] RUBYTEST_PATTERNS = new String[]{"lib/(.+)\\.(.+)", "test/test_(.+)\\.(.+)", "lib/(.+)\\.(.+)", "test/(.+)_test\\.(.+)", "lib/(.+)\\.(.+)", "test/tc_(.+)\\.(.+)", "/(.+)\\.(.+)", "/test_(.+)\\.(.+)", "/(.+)\\.(.+)", "/(.+)_test\\.(.+)", "/(.+)\\.(.+)", "/tc_(.+)\\.(.+)"};

    private boolean isZenTestInstalled(Project project) {
        GemManager gemManager = RubyPlatform.gemManagerFor((Project)project);
        return gemManager != null && gemManager.getVersion("ZenTest") != null;
    }

    private boolean isRSpecInstalled(Project project) {
        return new RSpecSupport(project).isRSpecInstalled();
    }

    private boolean isRailsInstalled() {
        return true;
    }

    private void appendRegexp(StringBuilder stringBuilder, String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '/' && File.separatorChar != '/') {
                stringBuilder.append(File.separatorChar);
                continue;
            }
            if (c == '\\') continue;
            stringBuilder.append(c);
        }
    }

    private File findMatching(File file, String string, String string2) {
        assert (file.getPath().equals(file.getAbsolutePath())) : "This method requires absolute paths";
        String string3 = GotoTest.slashifyPathForRE(file.getPath());
        Pattern pattern = Pattern.compile("(.*)" + string);
        Matcher matcher = pattern.matcher(string3);
        if (matcher.matches()) {
            String string4 = matcher.group(1);
            String string5 = matcher.group(2);
            String string6 = matcher.group(3);
            int n = string2.indexOf("(.+)");
            assert (n != -1);
            int n2 = string2.indexOf("(.+)", n + "(.+)".length());
            assert (n2 != -1);
            StringBuilder stringBuilder = new StringBuilder();
            this.appendRegexp(stringBuilder, string4);
            this.appendRegexp(stringBuilder, File.separator);
            this.appendRegexp(stringBuilder, string2.substring(0, n));
            this.appendRegexp(stringBuilder, string5);
            this.appendRegexp(stringBuilder, string2.substring(n + "(.+)".length(), n2));
            this.appendRegexp(stringBuilder, string6);
            String string7 = GotoTest.slashifyPathForRE(stringBuilder.toString());
            File file2 = new File(string7);
            if (file2.exists()) {
                return file2;
            }
            if (string2.indexOf(47) != -1) {
                int n3 = string2.indexOf("(.+)");
                String string8 = string2.substring(0, n3) + string5 + string2.substring(n3 + "(.+)".length());
                Pattern pattern2 = Pattern.compile("(.*)" + string8);
                File file3 = file2.getParentFile();
                File[] fileArray = file3.listFiles();
                if (fileArray != null) {
                    for (File file4 : fileArray) {
                        if (!pattern2.matcher(GotoTest.slashifyPathForRE(file4.getPath())).matches()) continue;
                        return file4;
                    }
                }
            }
        }
        return null;
    }

    private File findMatching(String[] stringArray, File file, boolean bl) {
        for (int i = 0; i < stringArray.length; i += 2) {
            String string = stringArray[i];
            String string2 = stringArray[i + 1];
            File file2 = null;
            file2 = bl ? this.findMatching(file, string, string2) : this.findMatching(file, string2, string);
            if (file2 == null) continue;
            return file2;
        }
        return null;
    }

    private FileObject findMatchingFile(FileObject fileObject, boolean bl) {
        File file = FileUtil.toFile((FileObject)fileObject);
        File file2 = this.findMatchingFile(file = file.getAbsoluteFile(), bl);
        if (file2 != null) {
            return FileUtil.toFileObject((File)file2);
        }
        return null;
    }

    private File findMatchingFile(File file, boolean bl) {
        File file2;
        Project project = FileOwnerQuery.getOwner((FileObject)FileUtil.toFileObject((File)file));
        if (project != null) {
            if (this.isZenTestInstalled(project) && (file2 = this.findMatching(this.ZENTEST_PATTERNS, file, bl)) != null) {
                return file2;
            }
            if (this.isRSpecInstalled(project) && (file2 = this.findMatching(this.RSPEC_PATTERNS, file, bl)) != null) {
                return file2;
            }
        }
        if (this.isRailsInstalled() && (file2 = this.findMatching(this.RAILS_PATTERNS, file, bl)) != null) {
            return file2;
        }
        file2 = this.findMatching(this.RUBYTEST_PATTERNS, file, bl);
        if (file2 != null) {
            return file2;
        }
        return null;
    }

    private DeclarationFinder.DeclarationLocation find(FileObject fileObject, int n, boolean bl) {
        DeclarationFinder.DeclarationLocation declarationLocation;
        FileObject fileObject2 = this.findMatchingFile(fileObject, bl);
        if (fileObject2 != null) {
            return new DeclarationFinder.DeclarationLocation(fileObject2, -1);
        }
        if (n != -1 && (declarationLocation = this.findTestPair(fileObject, n, bl)) != DeclarationFinder.DeclarationLocation.NONE) {
            fileObject2 = declarationLocation.getFileObject();
            int n2 = declarationLocation.getOffset();
            return new DeclarationFinder.DeclarationLocation(fileObject2, n2);
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    public DeclarationFinder.DeclarationLocation findTest(FileObject fileObject, int n) {
        return this.find(fileObject, n, true);
    }

    public DeclarationFinder.DeclarationLocation findTested(FileObject fileObject, int n) {
        return this.find(fileObject, n, false);
    }

    private DeclarationFinder.DeclarationLocation findTestPair(FileObject fileObject, final int n, final boolean bl) {
        SourceModel sourceModel = SourceModelFactory.getInstance().getModel(fileObject);
        if (sourceModel == null) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        if (sourceModel.isScanInProgress()) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        final DeclarationFinder.DeclarationLocation[] declarationLocationArray = new DeclarationFinder.DeclarationLocation[]{DeclarationFinder.DeclarationLocation.NONE};
        try {
            sourceModel.runUserActionTask((CancellableTask)new CancellableTask<CompilationInfo>(){

                public void cancel() {
                }

                public void run(CompilationInfo compilationInfo) {
                    BaseDocument baseDocument;
                    Node node = AstUtilities.getRoot((CompilationInfo)compilationInfo);
                    if (node == null) {
                        return;
                    }
                    ClassNode classNode = AstUtilities.findClassAtOffset((Node)node, (int)n);
                    if (classNode == null) {
                        try {
                            baseDocument = (BaseDocument)compilationInfo.getDocument();
                            int n2 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
                            if (n2 != n) {
                                classNode = AstUtilities.findClassAtOffset((Node)node, (int)n2);
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            Exceptions.printStackTrace((Throwable)badLocationException);
                        }
                        catch (IOException iOException) {
                            Exceptions.printStackTrace((Throwable)iOException);
                        }
                    }
                    if (classNode != null && (baseDocument = RubyIndex.get((Index)compilationInfo.getIndex("text/x-ruby"))) != null) {
                        String string = AstUtilities.getClassOrModuleName((IScopingNode)classNode);
                        String string2 = "Test";
                        if (bl) {
                            String string3 = string + string2;
                            DeclarationFinder.DeclarationLocation declarationLocation = GotoTest.this.findClass(string3, (RubyIndex)baseDocument);
                            if (declarationLocation != DeclarationFinder.DeclarationLocation.NONE) {
                                declarationLocationArray[0] = declarationLocation;
                                return;
                            }
                            string3 = string2 + string;
                            declarationLocation = GotoTest.this.findClass(string3, (RubyIndex)baseDocument);
                            if (declarationLocation != DeclarationFinder.DeclarationLocation.NONE) {
                                declarationLocationArray[0] = declarationLocation;
                                return;
                            }
                        } else {
                            String string4;
                            DeclarationFinder.DeclarationLocation declarationLocation;
                            if (string.endsWith(string2) && (declarationLocation = GotoTest.this.findClass(string4 = string.substring(0, string.length() - string2.length()), (RubyIndex)baseDocument)) != DeclarationFinder.DeclarationLocation.NONE) {
                                declarationLocationArray[0] = declarationLocation;
                                return;
                            }
                            if (string.startsWith(string2) && (declarationLocation = GotoTest.this.findClass(string4 = string.substring(string2.length()), (RubyIndex)baseDocument)) != DeclarationFinder.DeclarationLocation.NONE) {
                                declarationLocationArray[0] = declarationLocation;
                                return;
                            }
                        }
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return declarationLocationArray[0];
    }

    private DeclarationFinder.DeclarationLocation findClass(String string, RubyIndex rubyIndex) {
        EnumSet<Index.SearchScope> enumSet = EnumSet.of(Index.SearchScope.SOURCE);
        Set set = rubyIndex.getClasses(string, NameKind.EXACT_NAME, true, false, false, enumSet, null);
        for (IndexedClass indexedClass : set) {
            FileObject fileObject = indexedClass.getFileObject();
            if (fileObject == null) continue;
            int n = 0;
            Node node = AstUtilities.getForeignNode((IndexedElement)indexedClass, null);
            if (node != null) {
                n = node.getPosition().getStartOffset();
            }
            return new DeclarationFinder.DeclarationLocation(fileObject, n);
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    public boolean appliesTo(FileObject fileObject) {
        return RubyUtils.isRubyFile((FileObject)fileObject) || RubyUtils.isRhtmlFile((FileObject)fileObject);
    }

    public boolean asynchronous() {
        return false;
    }

    public TestLocator.LocationResult findOpposite(FileObject fileObject, int n) {
        DeclarationFinder.DeclarationLocation declarationLocation = this.findTest(fileObject, n);
        if (declarationLocation == DeclarationFinder.DeclarationLocation.NONE) {
            declarationLocation = this.findTested(fileObject, n);
        }
        if (declarationLocation != DeclarationFinder.DeclarationLocation.NONE) {
            return new TestLocator.LocationResult(declarationLocation.getFileObject(), declarationLocation.getOffset());
        }
        return new TestLocator.LocationResult(NbBundle.getMessage(GotoTest.class, (String)"OppositeNotFound"));
    }

    public void findOpposite(FileObject fileObject, int n, TestLocator.LocationListener locationListener) {
        throw new UnsupportedOperationException("GotoTest is synchronous");
    }

    public TestLocator.FileType getFileType(FileObject fileObject) {
        String string = fileObject.getName();
        return string.indexOf("_test") != -1 || string.indexOf("test_") != -1 || string.indexOf("_spec") != -1 ? TestLocator.FileType.TEST : TestLocator.FileType.TESTED;
    }

    private static String slashifyPathForRE(String string) {
        return File.separatorChar == '/' ? string : string.replace(File.separatorChar, '/');
    }
}

