/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.templates;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyUtils;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class RubyTargetChooserPanelGUI
extends JPanel
implements ActionListener,
DocumentListener {
    private static final String NEW_CLASS_PREFIX = NbBundle.getMessage(RubyTargetChooserPanelGUI.class, (String)"LBL_RubyTargetChooserPanelGUI_NewRubyClassPrefix");
    private static final Dimension PREF_DIM = new Dimension(500, 340);
    private Project project;
    private boolean userEdit = true;
    private boolean fileEdited;
    private boolean classEdited;
    private String expectedExtension;
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private int type;
    private SourceGroup[] groups;
    private JPanel bottomPanelContainer;
    private JButton browseButton;
    private JLabel classLabel;
    private JTextField classText;
    private JLabel documentNameLabel;
    private JTextField documentNameTextField;
    private JLabel extendsLabel;
    private JTextField extendsText;
    private JLabel fileLabel;
    private JTextField fileTextField;
    private JTextField folderTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JLabel moduleLabel;
    private JTextField moduleText;
    private JTextField projectTextField;
    private JComboBox rootComboBox;
    private JSeparator targetSeparator;

    public RubyTargetChooserPanelGUI(Project project, SourceGroup[] sourceGroupArray, Component component, int n) {
        this.type = n;
        this.project = project;
        this.groups = sourceGroupArray;
        this.initComponents();
        if (n == 3) {
            this.extendsText.setText("Test::Unit::TestCase");
            this.type = 1;
            n = 1;
        }
        if (n == 1 || n == 2) {
            if (n == 2) {
                this.extendsLabel.setVisible(false);
                this.extendsText.setVisible(false);
                Mnemonics.setLocalizedText((JLabel)this.classLabel, (String)NbBundle.getMessage(RubyTargetChooserPanelGUI.class, (String)"LBL_RubyTargetChooserPanelGUI_ModuleName_Label"));
            } else {
                this.extendsText.getDocument().addDocumentListener(this);
            }
            this.moduleText.getDocument().addDocumentListener(this);
            this.classText.getDocument().addDocumentListener(this);
        } else if (n == 4) {
            Mnemonics.setLocalizedText((JLabel)this.classLabel, (String)NbBundle.getMessage(RubyTargetChooserPanelGUI.class, (String)"LBL_RubyTargetChooserPanelGUI_Spec_Class"));
            this.moduleLabel.setVisible(false);
            this.moduleText.setVisible(false);
            this.extendsLabel.setVisible(false);
            this.extendsText.setVisible(false);
            this.classText.getDocument().addDocumentListener(this);
        } else {
            this.classLabel.setVisible(false);
            this.classText.setVisible(false);
            this.moduleLabel.setVisible(false);
            this.moduleText.setVisible(false);
            this.extendsLabel.setVisible(false);
            this.extendsText.setVisible(false);
        }
        this.documentNameTextField.getDocument().addDocumentListener(this);
        if (component != null) {
            this.bottomPanelContainer.add(component, "Center");
        }
        this.browseButton.addActionListener(this);
        this.folderTextField.getDocument().addDocumentListener(this);
        this.rootComboBox.setRenderer(new GroupListCellRenderer());
        this.rootComboBox.addActionListener(this);
        this.setPreferredSize(PREF_DIM);
        this.setName(NbBundle.getBundle(RubyTargetChooserPanelGUI.class).getString("LBL_RubyTargetChooserPanelGUI_Name"));
    }

    public void addNotify() {
        Dimension dimension = this.jPanel2.getPreferredSize();
        Dimension dimension2 = this.bottomPanelContainer.getPreferredSize();
        Dimension dimension3 = this.targetSeparator.getPreferredSize();
        int n = dimension.height + dimension2.height + dimension3.height + 12;
        if (n > RubyTargetChooserPanelGUI.PREF_DIM.height) {
            this.setPreferredSize(new Dimension(RubyTargetChooserPanelGUI.PREF_DIM.width, n));
        }
        super.addNotify();
    }

    public void initValues(FileObject fileObject, FileObject fileObject2) {
        String string;
        DataObject dataObject;
        assert (this.project != null) : "Project must be specified.";
        this.projectTextField.setText(ProjectUtils.getInformation((Project)this.project).getDisplayName());
        assert (fileObject != null);
        String string2 = null;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
            string2 = dataObject.getNodeDelegate().getDisplayName();
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            string2 = fileObject.getName();
        }
        this.putClientProperty("NewFileWizard_Title", string2);
        this.rootComboBox.setModel(new DefaultComboBoxModel<SourceGroup>(this.groups));
        dataObject = this.getPreselectedGroup(fileObject2, (Boolean)fileObject.getAttribute("isTest"));
        this.rootComboBox.setSelectedItem(dataObject);
        if (fileObject2 != null) {
            this.folderTextField.setText(FileUtil.toFile((FileObject)fileObject2).getPath());
        }
        if (fileObject != null && this.documentNameTextField.getText().trim().length() == 0) {
            string = NEW_CLASS_PREFIX;
            Object object = fileObject.getAttribute("templateNamePrefix");
            if (object != null) {
                string = object.toString();
            }
            if (this.type != 4) {
                this.documentNameTextField.setText(string + fileObject.getName());
            }
            this.documentNameTextField.selectAll();
        }
        string = fileObject == null ? "" : fileObject.getExt();
        this.expectedExtension = string.length() == 0 ? "" : "." + string;
        this.updateText();
        this.fileEdited = false;
        this.classEdited = false;
        if (this.type == 1 || this.type == 2) {
            this.classText.selectAll();
        }
    }

    public FileObject getRootFolder() {
        return ((SourceGroup)this.rootComboBox.getSelectedItem()).getRootFolder();
    }

    public String getTargetFolder() {
        String string = this.folderTextField.getText().trim();
        if (string.length() == 0) {
            return null;
        }
        return string.replace(File.separatorChar, '/');
    }

    public String getTargetName() {
        String string = this.documentNameTextField.getText().trim();
        if (string.length() == 0) {
            return null;
        }
        return string;
    }

    public String getClassName() {
        String string = this.classText.getText().trim();
        if (string.length() == 0) {
            return null;
        }
        return string;
    }

    public String getModuleName() {
        String string = this.moduleText.getText().trim();
        if (string.length() == 0) {
            return null;
        }
        return string;
    }

    public String getExtends() {
        String string = this.extendsText.getText().trim();
        if (string.length() == 0) {
            return null;
        }
        return string;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    private void fireChange() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    private void initComponents() {
        this.targetSeparator = new JSeparator();
        this.bottomPanelContainer = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel1 = new JPanel();
        this.classLabel = new JLabel();
        this.classText = new JTextField();
        this.documentNameLabel = new JLabel();
        this.documentNameTextField = new JTextField();
        this.moduleLabel = new JLabel();
        this.moduleText = new JTextField();
        this.extendsLabel = new JLabel();
        this.extendsText = new JTextField();
        this.jLabel5 = new JLabel();
        this.projectTextField = new JTextField();
        this.jLabel1 = new JLabel();
        this.rootComboBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.folderTextField = new JTextField();
        this.browseButton = new JButton();
        this.fileLabel = new JLabel();
        this.fileTextField = new JTextField();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.targetSeparator, gridBagConstraints);
        this.bottomPanelContainer.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.bottomPanelContainer, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.classLabel.setLabelFor(this.classText);
        Mnemonics.setLocalizedText((JLabel)this.classLabel, (String)NbBundle.getMessage(RubyTargetChooserPanelGUI.class, (String)"LBL_RubyTargetChooserPanelGUI_ClassName_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.jPanel1.add((Component)this.classLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.jPanel1.add((Component)this.classText, gridBagConstraints);
        this.documentNameLabel.setLabelFor(this.documentNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.documentNameLabel, (String)NbBundle.getMessage(RubyTargetChooserPanelGUI.class, (String)"LBL_RubyTargetChooserPanelGUI_FileName_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.jPanel1.add((Component)this.documentNameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.jPanel1.add((Component)this.documentNameTextField, gridBagConstraints);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/ruby/rubyproject/templates/Bundle");
        this.documentNameTextField.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_documentNameTextField"));
        this.moduleLabel.setLabelFor(this.moduleText);
        Mnemonics.setLocalizedText((JLabel)this.moduleLabel, (String)NbBundle.getMessage(RubyTargetChooserPanelGUI.class, (String)"LBL_RubyTargetChooserPanelGUI_InModuleName_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.jPanel1.add((Component)this.moduleLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.jPanel1.add((Component)this.moduleText, gridBagConstraints);
        this.extendsLabel.setLabelFor(this.extendsText);
        Mnemonics.setLocalizedText((JLabel)this.extendsLabel, (String)NbBundle.getMessage(RubyTargetChooserPanelGUI.class, (String)"LBL_RubyTargetChooserPanelGUI_Extends_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.jPanel1.add((Component)this.extendsLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.jPanel1.add((Component)this.extendsText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 24, 0);
        this.jPanel2.add((Component)this.jPanel1, gridBagConstraints);
        this.jLabel5.setLabelFor(this.projectTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(RubyTargetChooserPanelGUI.class, (String)"LBL_RubyTargetChooserPanelGUI_jLabel5"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.jPanel2.add((Component)this.jLabel5, gridBagConstraints);
        this.projectTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.jPanel2.add((Component)this.projectTextField, gridBagConstraints);
        this.projectTextField.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_projectTextField"));
        this.jLabel1.setLabelFor(this.rootComboBox);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(RubyTargetChooserPanelGUI.class, (String)"LBL_RubyTargetChooserPanelGUI_jLabel1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.jPanel2.add((Component)this.rootComboBox, gridBagConstraints);
        this.rootComboBox.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_rootComboBox"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(RubyTargetChooserPanelGUI.class, (String)"LBL_RubyTargetChooserPanelGUI_Folder"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.jPanel2.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.jPanel2.add((Component)this.folderTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(RubyTargetChooserPanelGUI.class, (String)"LBL_RubyTargetChooserPanelGUI_Browse"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.jPanel2.add((Component)this.browseButton, gridBagConstraints);
        this.fileLabel.setLabelFor(this.fileTextField);
        Mnemonics.setLocalizedText((JLabel)this.fileLabel, (String)NbBundle.getMessage(RubyTargetChooserPanelGUI.class, (String)"LBL_RubyTargetChooserPanelGUI_CreatedFile_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 12, 0);
        this.jPanel2.add((Component)this.fileLabel, gridBagConstraints);
        this.fileTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 12, 0);
        this.jPanel2.add((Component)this.fileTextField, gridBagConstraints);
        this.fileTextField.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_fileTextField"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_RubyTargetChooserPanelGUI"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.browseButton == actionEvent.getSource()) {
            File file;
            JFileChooser jFileChooser = new JFileChooser();
            FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
            jFileChooser.setFileSelectionMode(1);
            jFileChooser.setMultiSelectionEnabled(false);
            String string = this.folderTextField.getText();
            if (string.length() > 0) {
                file = new File(string);
                jFileChooser.setSelectedFile(file);
                jFileChooser.setCurrentDirectory(file);
            }
            jFileChooser.setDialogTitle(NbBundle.getMessage(RubyTargetChooserPanelGUI.class, (String)"ChooseTargetFolder"));
            if (0 == jFileChooser.showOpenDialog(this)) {
                file = FileUtil.normalizeFile((File)jFileChooser.getSelectedFile());
                this.folderTextField.setText(file.getAbsolutePath());
            }
            this.updateText();
            this.fireChange();
        } else if (this.rootComboBox == actionEvent.getSource()) {
            FileObject fileObject = ((SourceGroup)this.rootComboBox.getSelectedItem()).getRootFolder();
            this.folderTextField.setText(FileUtil.toFile((FileObject)fileObject).getPath());
            this.updateText();
            this.fireChange();
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.trackEdit(documentEvent);
        this.updateText();
        this.fireChange();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncFields(JTextComponent jTextComponent, String string) {
        try {
            this.userEdit = false;
            jTextComponent.setText(string);
        }
        finally {
            this.userEdit = true;
        }
    }

    private void capitalizeFirstChar(final JTextComponent jTextComponent, DocumentEvent documentEvent) {
        if (documentEvent.getType() == DocumentEvent.EventType.REMOVE) {
            return;
        }
        String string = jTextComponent.getText().trim();
        if (string.length() > 0 && Character.isLowerCase(string.charAt(0))) {
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    String string = jTextComponent.getText().trim();
                    if (string.length() > 0 && Character.isLowerCase(string.charAt(0))) {
                        boolean bl = RubyTargetChooserPanelGUI.this.userEdit;
                        try {
                            RubyTargetChooserPanelGUI.this.userEdit = false;
                            ((AbstractDocument)jTextComponent.getDocument()).replace(0, 1, "" + Character.toUpperCase(string.charAt(0)), null);
                        }
                        catch (BadLocationException badLocationException) {
                            Exceptions.printStackTrace((Throwable)badLocationException);
                        }
                        finally {
                            RubyTargetChooserPanelGUI.this.userEdit = bl;
                        }
                    }
                }
            });
        }
    }

    private void trackEdit(DocumentEvent documentEvent) {
        if (this.userEdit) {
            Document document = documentEvent.getDocument();
            if (document == this.documentNameTextField.getDocument()) {
                this.fileEdited = true;
                String string = this.documentNameTextField.getText().trim();
                if (string.length() == 0) {
                    this.fileEdited = false;
                }
                if (!(this.type != 4 || this.classEdited && this.classText.getText().length() != 0)) {
                    this.classEdited = false;
                    if (string.endsWith("_spec")) {
                        this.syncFields(this.classText, string.substring(0, string.length() - "_spec".length()));
                    }
                } else if (!(this.type != 1 && this.type != 2 || this.classEdited && this.classText.getText().length() != 0)) {
                    this.classEdited = false;
                    this.syncFields(this.classText, RubyUtils.underlinedNameToCamel((String)string));
                }
            } else if (document == this.classText.getDocument()) {
                if (documentEvent.getType() != DocumentEvent.EventType.REMOVE) {
                    this.capitalizeFirstChar(this.classText, documentEvent);
                }
                this.classEdited = true;
                if (!this.fileEdited || this.documentNameTextField.getText().trim().length() == 0) {
                    this.fileEdited = false;
                    String string = this.classText.getText().trim();
                    if (this.type == 4 && string.length() > 0) {
                        this.syncFields(this.documentNameTextField, RubyUtils.camelToUnderlinedName((String)string) + "_spec");
                    } else {
                        this.syncFields(this.documentNameTextField, RubyUtils.camelToUnderlinedName((String)string));
                    }
                }
            } else if (document == this.extendsText.getDocument()) {
                this.capitalizeFirstChar(this.extendsText, documentEvent);
            } else if (document == this.moduleText.getDocument()) {
                this.capitalizeFirstChar(this.moduleText, documentEvent);
            }
        }
    }

    private void updateText() {
        String string = this.folderTextField.getText().trim();
        String string2 = this.documentNameTextField.getText().trim();
        if (string2.length() > 0) {
            string2 = string2 + this.expectedExtension;
        }
        String string3 = string + (string.endsWith("/") || string.endsWith(File.separator) || string.length() == 0 ? "" : "/") + string2;
        this.fileTextField.setText(string3.replace('/', File.separatorChar));
    }

    private SourceGroup getPreselectedGroup(FileObject fileObject, Boolean bl) {
        for (int i = 0; fileObject != null && i < this.groups.length; ++i) {
            FileObject fileObject2 = this.groups[i].getRootFolder();
            if (!fileObject2.equals(fileObject) && !FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) continue;
            return this.groups[i];
        }
        if (bl != null && bl.booleanValue()) {
            for (SourceGroup sourceGroup : this.groups) {
                String string = PropertyUtils.relativizeFile((File)FileUtil.toFile((FileObject)this.project.getProjectDirectory()), (File)FileUtil.toFile((FileObject)sourceGroup.getRootFolder()));
                if (!"test".equals(string) && !"test/unit".equals(string)) continue;
                return sourceGroup;
            }
        }
        return this.groups[0];
    }

    private static final class GroupListCellRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            SourceGroup sourceGroup = (SourceGroup)object;
            super.getListCellRendererComponent((JList<?>)jList, sourceGroup.getDisplayName(), n, bl, bl2);
            this.setIcon(sourceGroup.getIcon(false));
            return this;
        }
    }
}

