/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.ui.customizer;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.Document;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.rubyproject.JavaClassPathUi;
import org.netbeans.modules.ruby.rubyproject.ProjectPropertyExtender;
import org.netbeans.modules.ruby.rubyproject.RubyProject;
import org.netbeans.modules.ruby.rubyproject.RubyProjectUtil;
import org.netbeans.modules.ruby.rubyproject.SharedRubyProjectProperties;
import org.netbeans.modules.ruby.rubyproject.SourceRoots;
import org.netbeans.modules.ruby.rubyproject.UpdateHelper;
import org.netbeans.modules.ruby.rubyproject.ui.customizer.RubySourceRootsUi;
import org.netbeans.modules.ruby.spi.project.support.rake.EditableProperties;
import org.netbeans.modules.ruby.spi.project.support.rake.GeneratedFilesHelper;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.netbeans.modules.ruby.spi.project.support.rake.ReferenceHelper;
import org.netbeans.modules.ruby.spi.project.support.rake.ui.StoreGroup;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyProjectProperties
extends SharedRubyProjectProperties {
    public static final String MAIN_CLASS = "main.file";
    public static final String JAVAC_COMPILER_ARG = "javac.compilerargs";
    public static final String RUN_JVM_ARGS = "run.jvmargs";
    public static final String RUN_WORK_DIR = "work.dir";
    public static final String DIST_DIR = "dist.dir";
    public static final String DIST_JAR = "dist.jar";
    public static final String RUN_CLASSPATH = "run.classpath";
    public static final String DEBUG_CLASSPATH = "debug.classpath";
    public static final String JAR_COMPRESS = "jar.compress";
    public static final String JAVAC_SOURCE = "javac.source";
    public static final String JAVAC_TARGET = "javac.target";
    public static final String JAVAC_TEST_CLASSPATH = "javac.test.classpath";
    public static final String RUN_TEST_CLASSPATH = "run.test.classpath";
    public static final String BUILD_DIR = "build.dir";
    public static final String BUILD_CLASSES_DIR = "build.classes.dir";
    public static final String BUILD_TEST_CLASSES_DIR = "build.test.classes.dir";
    public static final String BUILD_TEST_RESULTS_DIR = "build.test.results.dir";
    public static final String BUILD_CLASSES_EXCLUDES = "build.classes.excludes";
    public static final String DIST_JAVADOC_DIR = "dist.javadoc.dir";
    public static final String NO_DEPENDENCIES = "no.dependencies";
    public static final String DEBUG_TEST_CLASSPATH = "debug.test.classpath";
    public static final String APPLICATION_ARGS = "application.args";
    DefaultTableModel SOURCE_ROOTS_MODEL;
    DefaultTableModel TEST_ROOTS_MODEL;
    Document JAVAC_COMPILER_ARG_MODEL;
    Map<String, Map<String, String>> RUN_CONFIGS;
    String activeConfig;
    private final Map<String, String> additionalProperties;
    private final RubyProject project;
    private final UpdateHelper updateHelper;
    private final PropertyEvaluator evaluator;
    private final GeneratedFilesHelper genFileHelper;
    private final ProjectPropertyExtender cs;
    private final StoreGroup privateGroup;
    private final StoreGroup projectGroup;
    private RubyPlatform platform;
    public static final String[] WELL_KNOWN_PATHS = new String[]{"${javac.classpath}"};
    public static final String LIBRARY_PREFIX = "${libs.";
    public static final String LIBRARY_SUFFIX = ".classpath}";
    public static final String ANT_ARTIFACT_PREFIX = "${reference.";

    public RubyProject getProject() {
        return this.project;
    }

    public RubyProjectProperties(RubyProject rubyProject, UpdateHelper updateHelper, PropertyEvaluator propertyEvaluator, ReferenceHelper referenceHelper, GeneratedFilesHelper generatedFilesHelper) {
        this.project = rubyProject;
        this.updateHelper = updateHelper;
        this.evaluator = propertyEvaluator;
        this.genFileHelper = generatedFilesHelper;
        this.cs = new ProjectPropertyExtender(propertyEvaluator, referenceHelper, updateHelper.getRakeProjectHelper(), WELL_KNOWN_PATHS, LIBRARY_PREFIX, LIBRARY_SUFFIX, ANT_ARTIFACT_PREFIX);
        this.privateGroup = new StoreGroup();
        this.projectGroup = new StoreGroup();
        this.additionalProperties = new HashMap<String, String>();
        this.init();
    }

    private void init() {
        this.CLASS_PATH_LIST_RENDERER = new JavaClassPathUi.ClassPathListCellRenderer(this.evaluator);
        EditableProperties editableProperties = this.updateHelper.getProperties("nbproject/project.properties");
        String string = (String)editableProperties.get((Object)"javac.classpath");
        this.JAVAC_CLASSPATH_MODEL = RubyProjectProperties.createListModel(this.cs.itemsIterator(string));
        this.INCLUDE_JAVA_MODEL = this.projectGroup.createToggleButtonModel(this.evaluator, "ruby.includejava");
        this.SOURCE_ROOTS_MODEL = RubySourceRootsUi.createModel(this.project.getSourceRoots());
        this.TEST_ROOTS_MODEL = RubySourceRootsUi.createModel(this.project.getTestSourceRoots());
        this.JAVAC_COMPILER_ARG_MODEL = this.projectGroup.createStringDocument(this.evaluator, JAVAC_COMPILER_ARG);
        this.RUN_CONFIGS = this.readRunConfigs();
        this.activeConfig = this.evaluator.getProperty("config");
    }

    public static DefaultListModel createListModel(Iterator iterator) {
        DefaultListModel defaultListModel = new DefaultListModel();
        while (iterator.hasNext()) {
            defaultListModel.addElement(iterator.next());
        }
        return defaultListModel;
    }

    public static Iterator<ProjectPropertyExtender.Item> getIterator(DefaultListModel defaultListModel) {
        return RubyProjectProperties.getList(defaultListModel).iterator();
    }

    public static List<ProjectPropertyExtender.Item> getList(DefaultListModel defaultListModel) {
        return Collections.list(defaultListModel.elements());
    }

    @Override
    public void save() {
        try {
            Boolean bl = (Boolean)ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Boolean>(){
                final FileObject projectDir;
                {
                    this.projectDir = RubyProjectProperties.this.updateHelper.getRakeProjectHelper().getProjectDirectory();
                }

                public Boolean run() throws IOException {
                    if ((RubyProjectProperties.this.genFileHelper.getBuildScriptState("nbproject/build-impl.xml", RubyProject.class.getResource("resources/build-impl.xsl")) & 4) == 4) {
                        if (RubyProjectProperties.showModifiedMessage(NbBundle.getMessage(RubyProjectProperties.class, (String)"TXT_ModifiedTitle"))) {
                            FileObject fileObject = this.projectDir.getFileObject("nbproject/build-impl.xml");
                            if (fileObject != null) {
                                fileObject.delete();
                            }
                        } else {
                            return Boolean.FALSE;
                        }
                    }
                    RubyProjectProperties.this.storeProperties();
                    return Boolean.TRUE;
                }
            });
            if (bl == Boolean.TRUE) {
                ProjectManager.getDefault().saveProject((Project)this.project);
            }
        }
        catch (MutexException mutexException) {
            ErrorManager.getDefault().notify((Throwable)((IOException)mutexException.getException()));
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    private void storeProperties() throws IOException {
        String[] stringArray = this.cs.encodeToStrings(RubyProjectProperties.getIterator(this.JAVAC_CLASSPATH_MODEL));
        this.storeRoots(this.project.getSourceRoots(), this.SOURCE_ROOTS_MODEL);
        this.storeRoots(this.project.getTestSourceRoots(), this.TEST_ROOTS_MODEL);
        EditableProperties editableProperties = this.updateHelper.getProperties("nbproject/project.properties");
        EditableProperties editableProperties2 = this.updateHelper.getProperties("nbproject/private/private.properties");
        RubyProjectProperties.storePlatform(editableProperties2, this.getPlatform());
        this.projectGroup.store(editableProperties);
        this.privateGroup.store(editableProperties2);
        this.storeRunConfigs(this.RUN_CONFIGS, editableProperties, editableProperties2);
        EditableProperties editableProperties3 = this.updateHelper.getProperties("nbproject/private/config.properties");
        if (this.activeConfig == null) {
            editableProperties3.remove((Object)"config");
        } else {
            editableProperties3.setProperty("config", this.activeConfig);
        }
        this.updateHelper.putProperties("nbproject/private/config.properties", editableProperties3);
        editableProperties.setProperty("javac.classpath", stringArray);
        editableProperties.putAll(this.additionalProperties);
        this.updateHelper.putProperties("nbproject/project.properties", editableProperties);
        this.updateHelper.putProperties("nbproject/private/private.properties", editableProperties2);
        String string = this.additionalProperties.get("source.encoding");
        if (string != null) {
            try {
                FileEncodingQuery.setDefaultEncoding((Charset)Charset.forName(string));
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                // empty catch block
            }
        }
    }

    private void storeRoots(SourceRoots sourceRoots, DefaultTableModel defaultTableModel) throws MalformedURLException {
        Vector<Vector> vector = defaultTableModel.getDataVector();
        URL[] uRLArray = new URL[vector.size()];
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            File file = (File)vector.elementAt(i).elementAt(0);
            uRLArray[i] = RubyProjectUtil.getRootURL(file, null);
            stringArray[i] = (String)vector.elementAt(i).elementAt(1);
        }
        sourceRoots.putRoots(uRLArray, stringArray);
    }

    public void putAdditionalProperty(String string, String string2) {
        this.additionalProperties.put(string, string2);
    }

    private static boolean showModifiedMessage(String string) {
        String string2 = NbBundle.getMessage(RubyProjectProperties.class, (String)"TXT_Regenerate");
        JButton jButton = new JButton(NbBundle.getMessage(RubyProjectProperties.class, (String)"CTL_RegenerateButton"));
        jButton.setDefaultCapable(true);
        jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RubyProjectProperties.class, (String)"AD_RegenerateButton"));
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string2, 2);
        message.setTitle(string);
        message.setOptionType(2);
        message.setOptions(new Object[]{jButton, NotifyDescriptor.CANCEL_OPTION});
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)message) == jButton;
    }

    RubyPlatform getPlatform() {
        if (this.platform == null) {
            this.platform = RubyPlatform.platformFor((Project)this.project);
        }
        return this.platform;
    }

    void setPlatform(RubyPlatform rubyPlatform) {
        this.platform = rubyPlatform;
    }

    public static void storePlatform(EditableProperties editableProperties, RubyPlatform rubyPlatform) {
        editableProperties.setProperty("platform.active", rubyPlatform.getID());
    }

    /*
     * WARNING - void declaration
     */
    Map<String, Map<String, String>> readRunConfigs() {
        TreeMap<String, Map<String, String>> treeMap = new TreeMap<String, Map<String, String>>(new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                return string != null ? (string2 != null ? string.compareTo(string2) : 1) : (string2 != null ? -1 : 0);
            }
        });
        TreeMap<String, void> treeMap2 = new TreeMap<String, void>();
        for (String string : new FileObject[]{MAIN_CLASS, APPLICATION_ARGS, RUN_JVM_ARGS, RUN_WORK_DIR, "rake.args"}) {
            void string2;
            String string3 = this.updateHelper.getProperties("nbproject/private/private.properties").getProperty(string);
            if (string3 == null) {
                String string4 = this.updateHelper.getProperties("nbproject/project.properties").getProperty(string);
            }
            if (string2 == null) continue;
            treeMap2.put(string, string2);
        }
        treeMap.put(null, treeMap2);
        FileObject fileObject = this.project.getProjectDirectory().getFileObject("nbproject/configs");
        if (fileObject != null) {
            for (FileObject fileObject2 : fileObject.getChildren()) {
                if (!fileObject2.hasExt("properties")) continue;
                treeMap.put(fileObject2.getName(), new TreeMap(this.updateHelper.getProperties(FileUtil.getRelativePath((FileObject)this.project.getProjectDirectory(), (FileObject)fileObject2))));
            }
        }
        if ((fileObject = this.project.getProjectDirectory().getFileObject("nbproject/private/configs")) != null) {
            for (FileObject fileObject3 : fileObject.getChildren()) {
                Map map;
                if (!fileObject3.hasExt("properties") || (map = (Map)treeMap.get(fileObject3.getName())) == null) continue;
                map.putAll(new HashMap(this.updateHelper.getProperties(FileUtil.getRelativePath((FileObject)this.project.getProjectDirectory(), (FileObject)fileObject3))));
            }
        }
        return treeMap;
    }

    void storeRunConfigs(Map<String, Map<String, String>> map, EditableProperties editableProperties, EditableProperties editableProperties2) throws IOException {
        Object object;
        String string;
        Map<String, String> map2 = map.get(null);
        for (String string2 : new String[]{MAIN_CLASS, APPLICATION_ARGS, RUN_JVM_ARGS, RUN_WORK_DIR, "rake.args"}) {
            string = map2.get(string2);
            Object object2 = object = string2.equals(APPLICATION_ARGS) || string2.equals(RUN_WORK_DIR) || string2.equals("rake.args") ? editableProperties2 : editableProperties;
            if (Utilities.compareObjects((Object)string, (Object)object.getProperty(string2))) continue;
            if (string != null && string.length() > 0) {
                object.setProperty(string2, string);
                continue;
            }
            object.remove((Object)string2);
        }
        for (Map.Entry entry : map.entrySet()) {
            String string2;
            String string3 = (String)entry.getKey();
            if (string3 == null) continue;
            string2 = "nbproject/configs/" + string3 + ".properties";
            string = "nbproject/private/configs/" + string3 + ".properties";
            object = (Map)entry.getValue();
            if (object == null) {
                this.updateHelper.putProperties(string2, null);
                this.updateHelper.putProperties(string, null);
                continue;
            }
            for (Map.Entry entry2 : object.entrySet()) {
                String string4;
                EditableProperties editableProperties3;
                String string5 = (String)entry2.getKey();
                String string6 = (String)entry2.getValue();
                if (Utilities.compareObjects((Object)string6, (Object)(editableProperties3 = this.updateHelper.getProperties(string4 = string5.equals(APPLICATION_ARGS) || string5.equals(RUN_WORK_DIR) || string5.equals("rake.args") ? string : string2)).getProperty(string5))) continue;
                if (string6 != null && (string6.length() > 0 || map2.get(string5) != null && map2.get(string5).length() > 0)) {
                    editableProperties3.setProperty(string5, string6);
                } else {
                    editableProperties3.remove((Object)string5);
                }
                this.updateHelper.putProperties(string4, editableProperties3);
            }
            this.updateHelper.putProperties(string2, this.updateHelper.getProperties(string2));
        }
    }
}

