/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.monitor.data;

import java.beans.PropertyChangeListener;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.Vector;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.schema2beans.BeanComparator;
import org.netbeans.modules.schema2beans.BeanProp;
import org.netbeans.modules.schema2beans.GraphManager;
import org.netbeans.modules.schema2beans.Version;
import org.netbeans.modules.web.monitor.data.Headers;
import org.netbeans.modules.web.monitor.data.Param;
import org.netbeans.modules.web.monitor.data.RequestAttributesIn;
import org.netbeans.modules.web.monitor.data.RequestAttributesOut;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class RequestData
extends BaseBean {
    static Vector comparators = new Vector();
    public static final String PARAM = "Param";
    public static final String HEADERS = "Headers";
    public static final String REQUESTATTRIBUTESIN = "RequestAttributesIn";
    public static final String REQUESTATTRIBUTESOUT = "RequestAttributesOut";
    public static final String REQUESTDATA = "RequestData";
    public static final String JSESSIONID = "JSESSIONID";
    public static final String COOKIE = "cookie";
    private static final boolean debug = false;

    public RequestData() {
        this(1);
    }

    public RequestData(Node node, int n) {
        super(comparators, new Version(1, 0, 6));
        if (node == null && (node = GraphManager.createRootElementNode((String)REQUESTDATA)) == null) {
            throw new RuntimeException("failed to create a new DOM root!");
        }
        Node node2 = GraphManager.getElementNode((String)REQUESTDATA, (Node)node);
        if (node2 == null) {
            throw new RuntimeException("doc root not found in the DOM graph!");
        }
        this.graphManager.setXmlDocument(node);
        this.createBean(node2, this.graphManager());
        this.initialize(n);
    }

    public RequestData(int n) {
        super(comparators, new Version(1, 0, 6));
        this.createProperty(HEADERS, HEADERS, 66080, Headers.class);
        this.createProperty(REQUESTATTRIBUTESIN, REQUESTATTRIBUTESIN, 66080, RequestAttributesIn.class);
        this.createProperty(REQUESTATTRIBUTESOUT, REQUESTATTRIBUTESOUT, 66080, RequestAttributesOut.class);
        this.createProperty(PARAM, PARAM, 66096, Param.class);
        this.createAttribute(PARAM, "name", "Name", 257, null, null);
        this.createAttribute(PARAM, "value", "Value", 513, null, null);
        this.initialize(n);
    }

    void initialize(int n) {
    }

    public void setHeaders(Headers headers) {
        this.setValue(HEADERS, (Object)headers);
    }

    public Headers getHeaders() {
        return (Headers)((Object)this.getValue(HEADERS));
    }

    public void setRequestAttributesIn(RequestAttributesIn requestAttributesIn) {
        this.setValue(REQUESTATTRIBUTESIN, (Object)requestAttributesIn);
    }

    public RequestAttributesIn getRequestAttributesIn() {
        return (RequestAttributesIn)((Object)this.getValue(REQUESTATTRIBUTESIN));
    }

    public void setRequestAttributesOut(RequestAttributesOut requestAttributesOut) {
        this.setValue(REQUESTATTRIBUTESOUT, (Object)requestAttributesOut);
    }

    public RequestAttributesOut getRequestAttributesOut() {
        return (RequestAttributesOut)((Object)this.getValue(REQUESTATTRIBUTESOUT));
    }

    public void setParam(int n, Param param) {
        this.setValue(PARAM, n, (Object)param);
    }

    public Param getParam(int n) {
        return (Param)((Object)this.getValue(PARAM, n));
    }

    public void setParam(Param[] paramArray) {
        try {
            this.setValue(PARAM, (Object[])paramArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Param[] getParam() {
        return (Param[])this.getValues(PARAM);
    }

    public int sizeParam() {
        return this.size(PARAM);
    }

    public int addParam(Param param) {
        return this.addValue(PARAM, (Object)param);
    }

    public int removeParam(Param param) {
        return this.removeValue(PARAM, (Object)param);
    }

    public void setReplaceSessionCookie(boolean bl) {
        this.setAttributeValue("replace", String.valueOf(bl));
    }

    public boolean getReplaceSessionCookie() {
        try {
            if (this.getAttributeValue("replace").equals("true")) {
                return true;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    public String getSessionID() {
        return RequestData.findSessionID(this.getCookieString());
    }

    public String getCookieString() {
        Param[] paramArray = this.getHeaders().getParam();
        StringBuffer stringBuffer = new StringBuffer();
        int n = paramArray.length;
        for (int i = 0; i < n; ++i) {
            if (!paramArray[i].getName().equalsIgnoreCase(COOKIE)) continue;
            stringBuffer.append(paramArray[i].getValue());
            stringBuffer.append(";");
        }
        return stringBuffer.toString();
    }

    public static String findSessionID(String string) {
        if (string == null || string.equals("")) {
            return "";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            String string3 = stringTokenizer.nextToken();
            int n = string3.indexOf("=");
            if (n <= -1 || !(string2 = string3.substring(0, n).trim()).equals(JSESSIONID)) continue;
            String string4 = string3.substring(n + 1, string3.length()).trim();
            string4 = RequestData.stripQuote(string4);
            return string4;
        }
        return "";
    }

    public Param[] getCookiesAsParams() {
        String string = this.getCookieString();
        if (string == null || string.equals("")) {
            return new Param[0];
        }
        Vector<Param> vector = new Vector<Param>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf("=");
            if (n <= -1) continue;
            String string3 = string2.substring(0, n).trim();
            String string4 = string2.substring(n + 1, string2.length()).trim();
            string4 = RequestData.stripQuote(string4);
            vector.addElement(new Param(string3, string4));
        }
        int n = vector.size();
        Param[] paramArray = new Param[n];
        for (int i = 0; i < n; ++i) {
            paramArray[i] = (Param)((Object)vector.elementAt(i));
        }
        return paramArray;
    }

    public int addCookie(String string, String string2) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        Param[] paramArray = this.getHeaders().getParam();
        if (paramArray == null) {
            paramArray = new Param[]{};
        }
        if ((n = paramArray.length) == 0) {
            stringBuffer.append(string);
            stringBuffer.append("=");
            stringBuffer.append(string2);
            this.setCookieHeader(stringBuffer.toString());
            return 1;
        }
        for (int i = 0; i < n; ++i) {
            if (!paramArray[i].getName().equalsIgnoreCase(COOKIE)) continue;
            String string3 = paramArray[i].getValue();
            if (string3 != null && !string3.trim().equals("")) {
                stringBuffer.append(string3.trim());
                stringBuffer.append(";");
            }
            stringBuffer.append(string);
            stringBuffer.append("=");
            stringBuffer.append(string2);
            paramArray[i].setValue(stringBuffer.toString());
            return 1;
        }
        stringBuffer.append(string);
        stringBuffer.append("=");
        stringBuffer.append(string2);
        this.setCookieHeader(stringBuffer.toString());
        return 0;
    }

    public int addCookie(String string) {
        int n = string.indexOf("=");
        if (n == -1) {
            return this.addCookie(string, "");
        }
        if (n == string.length() - 1) {
            return this.addCookie(string, "");
        }
        return this.addCookie(string.substring(0, n), string.substring(n + 1));
    }

    public void setCookieHeader(String string) {
        Param[] paramArray = this.getHeaders().getParam();
        if (paramArray == null) {
            paramArray = new Param[]{};
        }
        int n = paramArray.length;
        for (int i = 0; i < n; ++i) {
            if (!paramArray[i].getName().equalsIgnoreCase(COOKIE)) continue;
            paramArray[i].setValue(string);
            return;
        }
        Param param = new Param(COOKIE, string);
        this.getHeaders().addParam(param);
    }

    public void deleteCookie(String string, String string2) {
        Param[] paramArray = this.getHeaders().getParam();
        boolean bl = false;
        if (paramArray == null || paramArray.length == 0) {
            return;
        }
        int n = paramArray.length;
        for (int i = 0; i < n; ++i) {
            if (!paramArray[i].getName().equalsIgnoreCase(COOKIE)) continue;
            String string3 = paramArray[i].getValue();
            if (string3 == null || string3.trim().equals("")) {
                return;
            }
            StringBuffer stringBuffer = new StringBuffer();
            StringTokenizer stringTokenizer = new StringTokenizer(paramArray[i].getValue(), ";", false);
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                int n2 = string4.indexOf("=");
                if (n2 <= -1) continue;
                String string5 = string4.substring(0, n2).trim();
                String string6 = string4.substring(n2 + 1, string4.length()).trim();
                string6 = RequestData.stripQuote(string6);
                if (string5.equalsIgnoreCase(string) && string6.equalsIgnoreCase(string2)) continue;
                stringBuffer.append(string5);
                stringBuffer.append("=");
                stringBuffer.append(string6);
                stringBuffer.append(";");
            }
            if (stringBuffer.toString().equals("")) {
                this.getHeaders().removeParam(paramArray[i]);
                break;
            }
            paramArray[i].setValue(stringBuffer.toString());
            break;
        }
    }

    public void deleteCookie(String string) {
        Param[] paramArray = this.getHeaders().getParam();
        if (paramArray == null || paramArray.length == 0) {
            return;
        }
        int n = paramArray.length;
        for (int i = 0; i < n; ++i) {
            if (!paramArray[i].getName().equalsIgnoreCase(COOKIE)) continue;
            String string2 = paramArray[i].getValue();
            if (string2 == null || string2.trim().equals("")) {
                return;
            }
            StringBuffer stringBuffer = new StringBuffer();
            StringTokenizer stringTokenizer = new StringTokenizer(paramArray[i].getValue(), ";", false);
            while (stringTokenizer.hasMoreTokens()) {
                String string3;
                String string4 = stringTokenizer.nextToken();
                int n2 = string4.indexOf("=");
                if (n2 <= -1 || (string3 = string4.substring(0, n2).trim()).equalsIgnoreCase(string)) continue;
                String string5 = string4.substring(n2 + 1, string4.length()).trim();
                string5 = RequestData.stripQuote(string5);
                stringBuffer.append(string3);
                stringBuffer.append("=");
                stringBuffer.append(string5);
                stringBuffer.append(";");
            }
            if (stringBuffer.toString().equals("")) {
                this.getHeaders().removeParam(paramArray[i]);
            } else {
                paramArray[i].setValue(stringBuffer.toString());
            }
            return;
        }
    }

    public static String stripQuote(String string) {
        if (string.startsWith("\"") && string.endsWith("\"") || string.startsWith("'") && string.endsWith("'")) {
            try {
                return string.substring(1, string.length() - 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    public boolean verify() {
        return true;
    }

    public static void addComparator(BeanComparator beanComparator) {
        comparators.add(beanComparator);
    }

    public static void removeComparator(BeanComparator beanComparator) {
        comparators.remove(beanComparator);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        BeanProp beanProp = this.beanProp();
        if (beanProp != null) {
            beanProp.addPCListener(propertyChangeListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        BeanProp beanProp = this.beanProp();
        if (beanProp != null) {
            beanProp.removePCListener(propertyChangeListener);
        }
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        BeanProp beanProp = this.beanProp(string);
        if (beanProp != null) {
            beanProp.addPCListener(propertyChangeListener);
        }
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        BeanProp beanProp = this.beanProp(string);
        if (beanProp != null) {
            beanProp.removePCListener(propertyChangeListener);
        }
    }

    public void dump(StringBuffer stringBuffer, String string) {
        stringBuffer.append(string);
        stringBuffer.append(HEADERS);
        BaseBean baseBean = this.getHeaders();
        if (baseBean != null) {
            baseBean.dump(stringBuffer, string + "\t");
        } else {
            stringBuffer.append(string + "\tnull");
        }
        this.dumpAttributes(HEADERS, 0, stringBuffer, string);
        stringBuffer.append(string);
        stringBuffer.append("Param[" + this.sizeParam() + "]");
        for (int i = 0; i < this.sizeParam(); ++i) {
            stringBuffer.append(string + "\t");
            stringBuffer.append("#" + i + ":");
            baseBean = this.getParam(i);
            if (baseBean != null) {
                baseBean.dump(stringBuffer, string + "\t");
            } else {
                stringBuffer.append(string + "\tnull");
            }
            this.dumpAttributes(PARAM, i, stringBuffer, string);
        }
    }

    public String dumpBeanNode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("RequestData\n");
        this.dump(stringBuffer, "\n  ");
        return stringBuffer.toString();
    }

    public static RequestData createGraph(Node node) {
        return new RequestData(node, 2);
    }

    public static RequestData createGraph(InputStream inputStream) {
        return RequestData.createGraph(inputStream, false);
    }

    public static RequestData createGraph(InputStream inputStream, boolean bl) {
        try {
            Document document = GraphManager.createXmlDocument((InputStream)inputStream, (boolean)bl);
            return RequestData.createGraph(document);
        }
        catch (Throwable throwable) {
            throw new RuntimeException("DOM graph creation failed: " + throwable.getMessage());
        }
    }

    public static RequestData createGraph() {
        return new RequestData();
    }

    public void log(String string) {
        System.out.println("RequestData::" + string);
    }
}

