/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.wizard;

import java.awt.Component;
import java.awt.Dialog;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.xml.api.EncodingUtil;
import org.netbeans.modules.xml.schema.SchemaDataObject;
import org.netbeans.modules.xml.schema.wizard.SchemaWizardIterator;
import org.netbeans.modules.xml.wizard.AbstractPanel;
import org.netbeans.modules.xml.wizard.DocumentModel;
import org.netbeans.modules.xml.wizard.Util;
import org.netbeans.modules.xml.wizard.XMLContentPanel;
import org.netbeans.modules.xml.wizard.XMLGeneratorVisitor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

public final class SampleXMLGeneratorWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    private int index;
    private WizardDescriptor.Panel[] panels;
    private Project srcProject;
    private FileObject schemaFileObject;
    private DocumentModel model;
    private XMLContentPanel xmlPanel;
    private static String PREFIX = "ns0";
    private static final String XML_EXT = "xml";

    public SampleXMLGeneratorWizardIterator(SchemaDataObject schemaDataObject) {
        this.schemaFileObject = schemaDataObject.getPrimaryFile();
        this.srcProject = FileOwnerQuery.getOwner((FileObject)this.schemaFileObject);
    }

    public void show() {
        boolean bl;
        WizardDescriptor wizardDescriptor = new WizardDescriptor(this.getPanels());
        this.initialize(wizardDescriptor);
        wizardDescriptor.setTitleFormat(new MessageFormat("{0}"));
        wizardDescriptor.setTitle(NbBundle.getMessage(SampleXMLGeneratorWizardIterator.class, (String)"TITLE_XML_WIZARD"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wizardDescriptor);
        dialog.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SampleXMLGeneratorWizardIterator.class, (String)"TITLE_XML_WIZARD"));
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SampleXMLGeneratorWizardIterator.class, (String)"TITLE_XML_WIZARD"));
        dialog.setVisible(true);
        dialog.toFront();
        boolean bl2 = bl = wizardDescriptor.getValue() != WizardDescriptor.FINISH_OPTION;
        if (!bl) {
            try {
                this.instantiate();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private WizardDescriptor.Panel[] getPanels() {
        this.xmlPanel = new XMLContentPanel(true);
        if (this.panels == null) {
            this.panels = new WizardDescriptor.Panel[]{new AbstractPanel.WizardStep((AbstractPanel)this.xmlPanel)};
            String[] stringArray = new String[this.panels.length];
            for (int i = 0; i < this.panels.length; ++i) {
                Component component = this.panels[i].getComponent();
                if (stringArray[i] == null) {
                    stringArray[i] = component.getName();
                }
                if (!(component instanceof JComponent)) continue;
                JComponent jComponent = (JComponent)component;
                jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
                jComponent.putClientProperty("WizardPanel_contentData", stringArray);
                jComponent.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jComponent.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jComponent.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
        }
        return this.panels;
    }

    public Set instantiate() throws IOException {
        String string = this.schemaFileObject.getName();
        if (string == null || "null".equals(string)) {
            string = "XMLDocument";
        }
        final FileObject fileObject = this.schemaFileObject.getParent();
        String string2 = string;
        int n = 2;
        while (fileObject.getFileObject(string2, XML_EXT) != null) {
            string2 = string + n;
            ++n;
        }
        final String string3 = string2;
        FileSystem fileSystem = fileObject.getFileSystem();
        final FileObject[] fileObjectArray = new FileObject[1];
        FileSystem.AtomicAction atomicAction = new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                String string = EncodingUtil.getProjectEncoding((FileObject)fileObject);
                if (!EncodingUtil.isValidEncoding((String)string)) {
                    string = "UTF-8";
                }
                FileObject fileObject2 = fileObject.createData(string3, SampleXMLGeneratorWizardIterator.XML_EXT);
                FileLock fileLock = null;
                try {
                    fileLock = fileObject2.lock();
                    OutputStream outputStream = fileObject2.getOutputStream(fileLock);
                    outputStream = new BufferedOutputStream(outputStream, 999);
                    OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string);
                    String string2 = SampleXMLGeneratorWizardIterator.this.model.getRoot();
                    if (string2 == null) {
                        string2 = "root";
                    }
                    String string32 = SampleXMLGeneratorWizardIterator.this.model.getPrefix();
                    outputStreamWriter.write("<?xml version=\"1.0\" encoding=\"" + string + "\"?>\n");
                    outputStreamWriter.write("\n");
                    String string4 = string3 + "." + SampleXMLGeneratorWizardIterator.XML_EXT;
                    Date date = new Date();
                    String string5 = DateFormat.getDateInstance(1).format(date);
                    String string6 = DateFormat.getTimeInstance(3).format(date);
                    String string7 = System.getProperty("user.name");
                    outputStreamWriter.write("<!--\n");
                    outputStreamWriter.write("    Document   : " + string4 + "\n");
                    outputStreamWriter.write("    Created on : " + string5 + ", " + string6 + "\n");
                    outputStreamWriter.write("    Author     : " + string7 + "\n");
                    outputStreamWriter.write("    Description:\n");
                    outputStreamWriter.write("        Purpose of the document follows.\n");
                    outputStreamWriter.write("-->\n");
                    outputStreamWriter.write("\n");
                    String string8 = SampleXMLGeneratorWizardIterator.this.model.getNamespace();
                    if (string32 == null || "".equals(string32)) {
                        outputStreamWriter.write("<" + string2 + "  xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'\n");
                    } else {
                        outputStreamWriter.write("<" + string32 + ":" + string2 + "  xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'\n");
                    }
                    if (string32 == null || "".equals(string32)) {
                        outputStreamWriter.write("   xmlns='" + string8 + "'\n");
                    } else {
                        outputStreamWriter.write("   xmlns:" + string32 + "='" + string8 + "'\n");
                    }
                    outputStreamWriter.write("   xsi:schemaLocation='" + string8 + " " + SampleXMLGeneratorWizardIterator.this.schemaFileObject.getNameExt() + "'>\n");
                    SampleXMLGeneratorWizardIterator.this.generateXMLBody(SampleXMLGeneratorWizardIterator.this.model, string2, outputStreamWriter);
                    if (string32 == null || "".equals(string32)) {
                        outputStreamWriter.write("\n");
                        outputStreamWriter.write("</" + string2 + ">\n");
                    } else {
                        outputStreamWriter.write("\n");
                        outputStreamWriter.write("</" + string32 + ":" + string2 + ">\n");
                    }
                    ((Writer)outputStreamWriter).flush();
                    ((Writer)outputStreamWriter).close();
                    fileLock.releaseLock();
                    fileLock = null;
                    fileObjectArray[0] = fileObject2;
                }
                finally {
                    if (fileLock != null) {
                        fileLock.releaseLock();
                    }
                }
            }
        };
        fileSystem.runAtomicAction(atomicAction);
        HashSet<DataObject> hashSet = new HashSet<DataObject>(1);
        DataObject dataObject = DataObject.find((FileObject)fileObjectArray[0]);
        Util.performDefaultAction((DataObject)dataObject);
        hashSet.add(dataObject);
        return hashSet;
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        Object object;
        this.index = 0;
        URL uRL = null;
        try {
            object = this.schemaFileObject.getParent();
            uRL = object.getURL();
            if (!uRL.toExternalForm().endsWith("/")) {
                uRL = new URL(uRL.toExternalForm() + "/");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.model = new DocumentModel(uRL);
        object = FileUtil.toFile((FileObject)this.schemaFileObject);
        String string = ((File)object).getPath();
        if (string != null) {
            try {
                string = new URI(string).toASCIIString();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        this.model.setPrimarySchema(string);
        this.xmlPanel.setObject((Object)this.model);
        this.model.setPrefix(PREFIX);
        String string2 = Util.getNamespace((FileObject)this.schemaFileObject);
        this.model.setNamespace(string2);
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        this.panels = null;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public String name() {
        return NbBundle.getMessage(SchemaWizardIterator.class, (String)"TITLE_x_of_y", (Object)(this.index + 1), (Object)this.panels.length);
    }

    public boolean hasNext() {
        return this.index < this.getPanels().length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    private void generateXMLBody(DocumentModel documentModel, String string, Writer writer) {
        XMLGeneratorVisitor xMLGeneratorVisitor = new XMLGeneratorVisitor(documentModel.getPrimarySchema(), documentModel.getXMLContentAttributes(), writer);
        xMLGeneratorVisitor.generateXML(string);
    }
}

