/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SchemaAdditionalInfoGUI
extends JPanel {
    public static final String DEFAULT_TARGET_NAMESPACE = NbBundle.getMessage(SchemaAdditionalInfoGUI.class, (String)"TXT_defaultTNS");
    private static final long serialVersionUID = 1L;
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private boolean namespaceChangedByUser;
    private JTextField fileField;
    WizardDescriptor.Panel parentPanel;
    private JLabel targetNamespaceLabel;
    private JTextField targetNamespaceTextField;

    public SchemaAdditionalInfoGUI() {
        this.initComponents();
        this.targetNamespaceTextField.setText(DEFAULT_TARGET_NAMESPACE);
        this.namespaceChangedByUser = false;
        this.targetNamespaceTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void removeUpdate(DocumentEvent documentEvent) {
                SchemaAdditionalInfoGUI.this.namespaceChangedByUser = true;
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                SchemaAdditionalInfoGUI.this.namespaceChangedByUser = true;
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
    }

    public String getTargetNamespace() {
        return this.targetNamespaceTextField.getText();
    }

    private JTextField findFileNameField(Component component, String string) {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        SchemaAdditionalInfoGUI.getAllComponents(new Component[]{component}, arrayList);
        for (Component component2 : arrayList) {
            if (!(component2 instanceof JTextField)) continue;
            JTextField jTextField = (JTextField)component2;
            return jTextField;
        }
        return null;
    }

    public static void getAllComponents(Component[] componentArray, Collection<Component> collection) {
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] == null) continue;
            collection.add(componentArray[i]);
            if (((Container)componentArray[i]).getComponentCount() == 0) continue;
            SchemaAdditionalInfoGUI.getAllComponents(((Container)componentArray[i]).getComponents(), collection);
        }
    }

    void setParentPanel(WizardDescriptor.Panel panel) {
        this.parentPanel = panel;
    }

    public void attachListenerToFileName(TemplateWizard templateWizard) {
        if (this.fileField != null) {
            return;
        }
        this.fileField = this.findFileNameField(this.parentPanel.getComponent(), Templates.getTemplate((WizardDescriptor)templateWizard).getName());
        if (this.fileField != null) {
            this.fileField.getDocument().addDocumentListener(new DocumentListener(){

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.getText(documentEvent);
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.getText(documentEvent);
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                }

                private void getText(DocumentEvent documentEvent) {
                    try {
                        String string = documentEvent.getDocument().getText(0, documentEvent.getDocument().getLength());
                        SchemaAdditionalInfoGUI.this.changeDefaultURL(string);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            });
        }
    }

    private void changeDefaultURL(String string) {
        if (!this.namespaceChangedByUser && string != null) {
            String string2 = this.targetNamespaceTextField.getText();
            String string3 = string2.substring(0, string2.lastIndexOf("/") + 1);
            string3 = string3 + string;
            this.targetNamespaceTextField.setText(string3);
            this.namespaceChangedByUser = false;
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    private void initComponents() {
        this.targetNamespaceTextField = new JTextField();
        this.targetNamespaceLabel = new JLabel();
        this.targetNamespaceLabel.setHorizontalAlignment(2);
        this.targetNamespaceLabel.setText(NbBundle.getMessage(SchemaAdditionalInfoGUI.class, (String)"LBL_TargetNamespace"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.targetNamespaceLabel).add(18, 18, 18).add((Component)this.targetNamespaceTextField, -1, 352, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.targetNamespaceLabel).add((Component)this.targetNamespaceTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

