/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.management.common.data.helper;

import com.sun.esb.management.common.ManagementRemoteException;
import com.sun.esb.management.common.data.ServiceAssemblyStatisticsData;
import com.sun.esb.management.common.data.ServiceUnitStatisticsData;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceAssemblyStatisticsDataCreator {
    protected static CompositeType serviceUnitStatsType;
    protected static CompositeType serviceAssemblyStatsType;
    static String[] STATS_TABLE_INDEX;
    protected static String[] SU_STATS_ITEMS;
    protected static String[] SU_STATS_DESCRIPTIONS;
    protected static String[] SA_STATS_ITEMS;
    protected static String[] SA_STATS_DESCRIPTIONS;

    public static TabularData createTabularData(Map<String, ServiceAssemblyStatisticsData> map) throws ManagementRemoteException {
        TabularType saStatsTableType = null;
        TabularDataSupport saStatsTable = null;
        Set<String> instances = map.keySet();
        CompositeData[] saStats = new CompositeData[instances.size()];
        try {
            int index = 0;
            for (String instance : instances) {
                ServiceAssemblyStatisticsData data = map.get(instance);
                if (data == null) continue;
                saStats[index++] = ServiceAssemblyStatisticsDataCreator.getCompositeData(data);
            }
            if (index > 0 && saStats[0] != null) {
                saStatsTableType = new TabularType("DeploymentServiceStatistics", "Deployment Service Statistics", saStats[0].getCompositeType(), STATS_TABLE_INDEX);
                saStatsTable = new TabularDataSupport(saStatsTableType);
                for (int innerIndex = 0; innerIndex < index; ++innerIndex) {
                    saStatsTable.put(saStats[innerIndex]);
                }
            }
        }
        catch (OpenDataException ex) {
            throw new ManagementRemoteException(ex);
        }
        return saStatsTable;
    }

    protected static CompositeData getCompositeData(ServiceAssemblyStatisticsData data) throws OpenDataException {
        List<ServiceUnitStatisticsData> serviceUnitStatisticsList = null;
        serviceUnitStatisticsList = data.getServiceUnitStatisticsList();
        CompositeData[] serviceUnitStats = new CompositeData[serviceUnitStatisticsList.size()];
        int index = 0;
        for (ServiceUnitStatisticsData unitData : serviceUnitStatisticsList) {
            serviceUnitStats[index++] = ServiceAssemblyStatisticsDataCreator.getCompositeData(unitData);
        }
        Object[] values = new Object[]{data.getInstanceName(), data.getName(), data.getLastStartupTime(), data.getStartupTimeAverage(), data.getStopTimeAverage(), data.getShutdownTimeAverage(), serviceUnitStats};
        return new CompositeDataSupport(serviceAssemblyStatsType, SA_STATS_ITEMS, values);
    }

    protected static CompositeData getCompositeData(ServiceUnitStatisticsData data) throws OpenDataException {
        Object[] values = new Object[]{data.getName(), data.getStartupTimeAverage(), data.getStopTimeAverage(), data.getShutdownTimeAverage(), data.getEndpointNameArray()};
        return new CompositeDataSupport(serviceUnitStatsType, SU_STATS_ITEMS, values);
    }

    protected void createCompositeTypes() {
        try {
            OpenType[] SU_STATS_ITEM_TYPES = new OpenType[]{SimpleType.STRING, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, new ArrayType(1, SimpleType.STRING)};
            serviceUnitStatsType = new CompositeType("ServiceUnitStatistics", "Service Unit Statistics", SU_STATS_ITEMS, SU_STATS_DESCRIPTIONS, SU_STATS_ITEM_TYPES);
            OpenType[] SA_STATS_TYPES = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.DATE, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, new ArrayType(1, serviceUnitStatsType)};
            serviceAssemblyStatsType = new CompositeType("ServiceAssemblyStatistics", "Service Assembly Statistics", SA_STATS_ITEMS, SA_STATS_DESCRIPTIONS, SA_STATS_TYPES);
        }
        catch (OpenDataException openDataException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
    }

    static {
        STATS_TABLE_INDEX = new String[]{"InstanceName"};
        SU_STATS_ITEMS = new String[]{"ServiceUnitName", "ServiceUnitStartupTime Avg (ms)", "ServiceUnitStopTime Avg (ms)", "ServiceUnitShutdownTime Avg (ms)", "Endpoints"};
        SU_STATS_DESCRIPTIONS = new String[]{"Service Unit Name", "Service Unit StartupTime Avg (ms)", "Service Unit StopTime Avg (ms)", "Service Unit ShutdownTime Avg (ms)", "Endpoints List"};
        SA_STATS_ITEMS = new String[]{"InstanceName", "ServiceAssemblyName", "LastStartupTime", "StartupTime Avg (ms)", "StopTime Avg (ms)", "ShutdownTime Avg (ms)", "UpTime", "ServiceUnitStatistics"};
        SA_STATS_DESCRIPTIONS = new String[]{"JBI Instance Name", "Service Assembly Name", "Last Startup Time", "Startup Time Avg (ms)", "Stop Time Avg (ms)", "Up Time (ms)", "Shutdown Time Avg (ms)", "ServiceUnit Statistics"};
    }
}

