/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.management.impl.installation;

import com.sun.esb.management.api.installation.InstallationService;
import com.sun.esb.management.base.services.BaseServiceImpl;
import com.sun.esb.management.common.ManagementRemoteException;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallationServiceImpl
extends BaseServiceImpl
implements Serializable,
InstallationService {
    static final long serialVersionUID = -1L;

    public InstallationServiceImpl() {
        super(null, false);
    }

    public InstallationServiceImpl(MBeanServerConnection serverConnection) {
        super(serverConnection, false);
    }

    public InstallationServiceImpl(MBeanServerConnection serverConnection, boolean isRemoteConnection) {
        super(serverConnection, isRemoteConnection);
    }

    @Override
    public String installComponent(String zipFilePath, Properties paramProps, String targetName) throws ManagementRemoteException {
        ObjectName mbeanName = this.getInstallationServiceMBeanObjectName();
        Object resultObject = null;
        if (this.isRemoteConnection()) {
            zipFilePath = this.uploadFile(zipFilePath);
        }
        Object[] params = new Object[]{zipFilePath, paramProps, targetName};
        String[] signature = new String[]{"java.lang.String", "java.util.Properties", "java.lang.String"};
        resultObject = this.invokeMBeanOperation(mbeanName, "installComponent", params, signature);
        this.removeUploadedFile();
        return resultObject.toString();
    }

    @Override
    public String installComponent(String zipFilePath, String targetName) throws ManagementRemoteException {
        return this.installComponent(zipFilePath, new Properties(), targetName);
    }

    @Override
    public Map<String, String> installComponent(String zipFilePath, Properties paramProps, String[] targetNames) throws ManagementRemoteException {
        Map resultObject = null;
        ObjectName mbeanName = this.getInstallationServiceMBeanObjectName();
        Object[] params = new Object[]{zipFilePath, paramProps, targetNames};
        String[] signature = new String[]{"java.lang.String", "java.util.Properties", targetNames.getClass().getName()};
        resultObject = (Map)this.invokeMBeanOperation(mbeanName, "installComponent", params, signature);
        return resultObject;
    }

    @Override
    public Map<String, String> installComponent(String zipFilePath, String[] targetNames) throws ManagementRemoteException {
        return this.installComponent(zipFilePath, new Properties(), targetNames);
    }

    @Override
    public String installComponentFromDomain(String componentName, Properties properties, String targetName) throws ManagementRemoteException {
        ObjectName mbeanName = this.getInstallationServiceMBeanObjectName();
        Object resultObject = null;
        Object[] params = new Object[]{componentName, properties, targetName};
        String[] signature = new String[]{"java.lang.String", "java.util.Properties", "java.lang.String"};
        resultObject = this.invokeMBeanOperation(mbeanName, "installComponentFromDomain", params, signature);
        return resultObject.toString();
    }

    @Override
    public String installComponentFromDomain(String componentName, String targetName) throws ManagementRemoteException {
        ObjectName mbeanName = this.getInstallationServiceMBeanObjectName();
        Object resultObject = null;
        Object[] params = new Object[]{componentName, targetName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        resultObject = this.invokeMBeanOperation(mbeanName, "installComponentFromDomain", params, signature);
        return resultObject.toString();
    }

    @Override
    public Map<String, String> installComponentFromDomain(String componentName, String[] targetNames) throws ManagementRemoteException {
        ObjectName mbeanName = this.getInstallationServiceMBeanObjectName();
        Map resultObject = null;
        Object[] params = new Object[]{componentName, targetNames};
        String[] signature = new String[]{"java.lang.String", targetNames.getClass().getName()};
        resultObject = (Map)this.invokeMBeanOperation(mbeanName, "installComponentFromDomain", params, signature);
        return resultObject;
    }

    @Override
    public Map<String, String> installComponentFromDomain(String componentName, Properties properties, String[] targetNames) throws ManagementRemoteException {
        ObjectName mbeanName = this.getInstallationServiceMBeanObjectName();
        Map resultObject = null;
        Object[] params = new Object[]{componentName, properties, targetNames};
        String[] signature = new String[]{"java.lang.String", "java.util.Properties", targetNames.getClass().getName()};
        resultObject = (Map)this.invokeMBeanOperation(mbeanName, "installComponentFromDomain", params, signature);
        return resultObject;
    }

    @Override
    public String installSharedLibrary(String zipFilePath, String targetName) throws ManagementRemoteException {
        ObjectName mbeanName = this.getInstallationServiceMBeanObjectName();
        Object resultObject = null;
        if (this.isRemoteConnection()) {
            zipFilePath = this.uploadFile(zipFilePath);
        }
        Object[] params = new Object[]{zipFilePath, targetName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        resultObject = this.invokeMBeanOperation(mbeanName, "installSharedLibrary", params, signature);
        this.removeUploadedFile();
        return resultObject.toString();
    }

    @Override
    public Map<String, String> installSharedLibrary(String zipFilePath, String[] targetNames) throws ManagementRemoteException {
        ObjectName mbeanName = this.getInstallationServiceMBeanObjectName();
        Map resultObject = null;
        Object[] params = new Object[]{zipFilePath, targetNames};
        String[] signature = new String[]{"java.lang.String", targetNames.getClass().getName()};
        resultObject = (Map)this.invokeMBeanOperation(mbeanName, "installSharedLibrary", params, signature);
        return resultObject;
    }

    @Override
    public String installSharedLibraryFromDomain(String libraryName, String targetName) throws ManagementRemoteException {
        ObjectName mbeanName = this.getInstallationServiceMBeanObjectName();
        Object resultObject = null;
        Object[] params = new Object[]{libraryName, targetName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        resultObject = this.invokeMBeanOperation(mbeanName, "installSharedLibraryFromDomain", params, signature);
        return resultObject.toString();
    }

    @Override
    public Map<String, String> installSharedLibraryFromDomain(String libraryName, String[] targetNames) throws ManagementRemoteException {
        ObjectName mbeanName = this.getInstallationServiceMBeanObjectName();
        Map resultObject = null;
        Object[] params = new Object[]{libraryName, targetNames};
        String[] signature = new String[]{"java.lang.String", targetNames.getClass().getName()};
        resultObject = (Map)this.invokeMBeanOperation(mbeanName, "installSharedLibraryFromDomain", params, signature);
        return resultObject;
    }

    @Override
    public String uninstallComponent(String componentName, boolean forceDelete, boolean retainInDomain, String targetName) throws ManagementRemoteException {
        ObjectName mbeanName = this.getInstallationServiceMBeanObjectName();
        Object resultObject = null;
        Object[] params = new Object[]{componentName, forceDelete, retainInDomain, targetName};
        String[] signature = new String[]{"java.lang.String", "boolean", "boolean", "java.lang.String"};
        resultObject = this.invokeMBeanOperation(mbeanName, "uninstallComponent", params, signature);
        return resultObject.toString();
    }

    @Override
    public String uninstallComponent(String componentName, boolean forceDelete, String targetName) throws ManagementRemoteException {
        ObjectName mbeanName = this.getInstallationServiceMBeanObjectName();
        Object resultObject = null;
        Object[] params = new Object[]{componentName, forceDelete, targetName};
        String[] signature = new String[]{"java.lang.String", "boolean", "java.lang.String"};
        resultObject = this.invokeMBeanOperation(mbeanName, "uninstallComponent", params, signature);
        return resultObject.toString();
    }

    @Override
    public String uninstallComponent(String componentName, String targetName) throws ManagementRemoteException {
        ObjectName mbeanName = this.getInstallationServiceMBeanObjectName();
        Object resultObject = null;
        Object[] params = new Object[]{componentName, targetName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        resultObject = this.invokeMBeanOperation(mbeanName, "uninstallComponent", params, signature);
        return resultObject.toString();
    }

    @Override
    public Map<String, String> uninstallComponent(String componentName, String[] targetNames) throws ManagementRemoteException {
        ObjectName mbeanName = this.getInstallationServiceMBeanObjectName();
        Map resultObject = null;
        Object[] params = new Object[]{componentName, targetNames};
        String[] signature = new String[]{"java.lang.String", targetNames.getClass().getName()};
        resultObject = (Map)this.invokeMBeanOperation(mbeanName, "uninstallComponent", params, signature);
        return resultObject;
    }

    @Override
    public Map<String, String> uninstallComponent(String componentName, boolean forceDelete, String[] targetNames) throws ManagementRemoteException {
        ObjectName mbeanName = this.getInstallationServiceMBeanObjectName();
        Map resultObject = null;
        Object[] params = new Object[]{componentName, forceDelete, targetNames};
        String[] signature = new String[]{"java.lang.String", "boolean", targetNames.getClass().getName()};
        resultObject = (Map)this.invokeMBeanOperation(mbeanName, "uninstallComponent", params, signature);
        return resultObject;
    }

    @Override
    public Map<String, String> uninstallComponent(String componentName, boolean forceDelete, boolean retainInDomain, String[] targetNames) throws ManagementRemoteException {
        ObjectName mbeanName = this.getInstallationServiceMBeanObjectName();
        Map resultObject = null;
        Object[] params = new Object[]{componentName, forceDelete, retainInDomain, targetNames};
        String[] signature = new String[]{"java.lang.String", "boolean", "boolean", targetNames.getClass().getName()};
        resultObject = (Map)this.invokeMBeanOperation(mbeanName, "uninstallComponent", params, signature);
        return resultObject;
    }

    @Override
    public String uninstallSharedLibrary(String sharedLibraryName, boolean forceDelete, boolean retainInDomain, String targetName) throws ManagementRemoteException {
        ObjectName mbeanName = this.getInstallationServiceMBeanObjectName();
        Object resultObject = null;
        Object[] params = new Object[]{sharedLibraryName, forceDelete, retainInDomain, targetName};
        String[] signature = new String[]{"java.lang.String", "boolean", "boolean", "java.lang.String"};
        resultObject = this.invokeMBeanOperation(mbeanName, "uninstallSharedLibrary", params, signature);
        return resultObject.toString();
    }

    @Override
    public String uninstallSharedLibrary(String sharedLibraryName, boolean forceDelete, String targetName) throws ManagementRemoteException {
        ObjectName mbeanName = this.getInstallationServiceMBeanObjectName();
        Object resultObject = null;
        Object[] params = new Object[]{sharedLibraryName, forceDelete, targetName};
        String[] signature = new String[]{"java.lang.String", "boolean", "java.lang.String"};
        resultObject = this.invokeMBeanOperation(mbeanName, "uninstallSharedLibrary", params, signature);
        return resultObject.toString();
    }

    @Override
    public String uninstallSharedLibrary(String sharedLibraryName, String targetName) throws ManagementRemoteException {
        ObjectName mbeanName = this.getInstallationServiceMBeanObjectName();
        Object resultObject = null;
        Object[] params = new Object[]{sharedLibraryName, targetName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        resultObject = this.invokeMBeanOperation(mbeanName, "uninstallSharedLibrary", params, signature);
        return resultObject.toString();
    }

    @Override
    public Map<String, String> uninstallSharedLibrary(String sharedLibraryName, String[] targetNames) throws ManagementRemoteException {
        ObjectName mbeanName = this.getInstallationServiceMBeanObjectName();
        Map resultObject = null;
        Object[] params = new Object[]{sharedLibraryName, targetNames};
        String[] signature = new String[]{"java.lang.String", targetNames.getClass().getName()};
        resultObject = (Map)this.invokeMBeanOperation(mbeanName, "uninstallSharedLibrary", params, signature);
        return resultObject;
    }

    @Override
    public Map<String, String> uninstallSharedLibrary(String sharedLibraryName, boolean forceDelete, String[] targetNames) throws ManagementRemoteException {
        ObjectName mbeanName = this.getInstallationServiceMBeanObjectName();
        Map resultObject = null;
        Object[] params = new Object[]{sharedLibraryName, forceDelete, targetNames};
        String[] signature = new String[]{"java.lang.String", "boolean", targetNames.getClass().getName()};
        resultObject = (Map)this.invokeMBeanOperation(mbeanName, "uninstallSharedLibrary", params, signature);
        return resultObject;
    }

    @Override
    public Map<String, String> uninstallSharedLibrary(String sharedLibraryName, boolean forceDelete, boolean retainInDomain, String[] targetNames) throws ManagementRemoteException {
        ObjectName mbeanName = this.getInstallationServiceMBeanObjectName();
        Map resultObject = null;
        Object[] params = new Object[]{sharedLibraryName, forceDelete, retainInDomain, targetNames};
        String[] signature = new String[]{"java.lang.String", "boolean", "boolean", targetNames.getClass().getName()};
        resultObject = (Map)this.invokeMBeanOperation(mbeanName, "uninstallSharedLibrary", params, signature);
        return resultObject;
    }

    @Override
    public String upgradeComponent(String componentName, String zipFilePath) throws ManagementRemoteException {
        ObjectName mbeanName = this.getInstallationServiceMBeanObjectName();
        Object resultObject = null;
        if (this.isRemoteConnection()) {
            zipFilePath = this.uploadFile(zipFilePath);
        }
        Object[] params = new Object[]{componentName, zipFilePath};
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        resultObject = this.invokeMBeanOperation(mbeanName, "upgradeComponent", params, signature);
        this.removeUploadedFile();
        return resultObject.toString();
    }

    public static void main(String[] args) {
    }
}

