/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.insync.faces.refactoring;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.HashSet;
import java.util.Set;
import java.util.WeakHashMap;
import javax.lang.model.element.Element;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.visualweb.insync.faces.refactoring.ElementGrip;
import org.openide.filesystems.FileObject;

public class ElementGripFactory {
    private static ElementGripFactory instance;
    private WeakHashMap<FileObject, Interval> map = new WeakHashMap();

    private ElementGripFactory() {
    }

    public static ElementGripFactory getDefault() {
        if (instance == null) {
            instance = new ElementGripFactory();
        }
        return instance;
    }

    public void cleanUp() {
        this.map.clear();
    }

    public ElementGrip get(FileObject fileObject, int n) {
        Interval interval = this.map.get(fileObject);
        if (interval == null) {
            return null;
        }
        try {
            return interval.get((long)((long)n)).item;
        }
        catch (RuntimeException runtimeException) {
            return interval.item;
        }
    }

    public ElementGrip getParent(ElementGrip elementGrip) {
        Interval interval = this.map.get(elementGrip.getFileObject());
        return interval.getParent(elementGrip);
    }

    public void put(FileObject fileObject, TreePath treePath, CompilationInfo compilationInfo) {
        Interval interval = this.map.get(fileObject);
        Interval interval2 = Interval.createInterval(treePath, compilationInfo, interval, null, fileObject);
        if (interval2 != null) {
            this.map.put(fileObject, interval2);
        }
    }

    private static class Interval {
        long from = -1L;
        long to = -1L;
        Set<Interval> subintervals = new HashSet<Interval>();
        ElementGrip item = null;

        private Interval() {
        }

        Interval get(long l) {
            if (this.from <= l && this.to >= l) {
                for (Interval interval : this.subintervals) {
                    Interval interval2 = interval.get(l);
                    if (interval2 == null) continue;
                    return interval2;
                }
                return this;
            }
            return null;
        }

        ElementGrip getParent(ElementGrip elementGrip) {
            for (Interval interval : this.subintervals) {
                if (interval.item.equals(elementGrip)) {
                    return this.item;
                }
                ElementGrip elementGrip2 = interval.getParent(elementGrip);
                if (elementGrip2 == null) continue;
                return elementGrip2;
            }
            return null;
        }

        public static Interval createInterval(TreePath treePath, CompilationInfo compilationInfo, Interval interval, Interval interval2, FileObject fileObject) {
            Object object;
            Tree tree = treePath.getLeaf();
            long l = compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), tree);
            long l2 = compilationInfo.getTrees().getSourcePositions().getEndPosition(compilationInfo.getCompilationUnit(), tree);
            Element element = compilationInfo.getTrees().getElement(treePath);
            Tree.Kind kind = treePath.getLeaf().getKind();
            if (kind != Tree.Kind.CLASS && kind != Tree.Kind.METHOD) {
                if (treePath.getParentPath() == null || treePath.getParentPath().getLeaf().getKind() == Tree.Kind.COMPILATION_UNIT) {
                    return null;
                }
                return Interval.createInterval(treePath.getParentPath(), compilationInfo, interval, interval2, fileObject);
            }
            Interval interval3 = null;
            if (interval != null && (object = interval.get(l)) != null && ((Object)((Interval)object).item.resolveElement(compilationInfo)).equals(element)) {
                if (interval2 != null) {
                    ((Interval)object).subintervals.add(interval2);
                }
                return null;
            }
            if (interval3 == null) {
                interval3 = new Interval();
            }
            if (interval3.from != l) {
                interval3.from = l;
                interval3.to = l2;
                interval3.item = object = new ElementGrip(treePath, compilationInfo);
            }
            if (interval2 != null) {
                interval3.subintervals.add(interval2);
            }
            if (treePath.getParentPath().getLeaf().getKind() == Tree.Kind.COMPILATION_UNIT) {
                return interval3;
            }
            return Interval.createInterval(treePath.getParentPath(), compilationInfo, interval, interval3, fileObject);
        }
    }
}

