/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.insync.java;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Locale;
import java.util.concurrent.Future;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.swing.event.DocumentEvent;
import javax.tools.Diagnostic;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.visualweb.extension.openide.util.Trace;
import org.netbeans.modules.visualweb.insync.ParserAnnotation;
import org.netbeans.modules.visualweb.insync.SourceUnit;
import org.netbeans.modules.visualweb.insync.UndoManager;
import org.netbeans.modules.visualweb.insync.Unit;
import org.netbeans.modules.visualweb.insync.Util;
import org.netbeans.modules.visualweb.insync.java.JavaClass;
import org.netbeans.modules.visualweb.insync.java.ReadTaskWrapper;
import org.netbeans.modules.visualweb.insync.java.TreeMakerUtils;
import org.netbeans.modules.visualweb.insync.java.WriteTaskWrapper;
import org.openide.filesystems.FileObject;

public class JavaUnit
extends SourceUnit {
    URLClassLoader classLoader;
    private boolean markSourceDirty = true;
    ParserAnnotation[] errors = ParserAnnotation.EMPTY_ARRAY;

    public JavaUnit(FileObject fileObject, URLClassLoader uRLClassLoader, UndoManager undoManager) {
        super(fileObject, undoManager);
    }

    public void destroy() {
        this.classLoader = null;
        super.destroy();
    }

    protected void read(char[] cArray, int n) {
    }

    protected void readErrors() {
        ReadTaskWrapper.execute(new ReadTaskWrapper.Read(){

            public Object run(CompilationInfo compilationInfo) {
                ArrayList<ParserAnnotation> arrayList = new ArrayList<ParserAnnotation>();
                for (Diagnostic diagnostic : compilationInfo.getDiagnostics()) {
                    if (diagnostic.getKind() != Diagnostic.Kind.ERROR) continue;
                    ParserAnnotation parserAnnotation = new ParserAnnotation(diagnostic.getMessage(Locale.getDefault()), JavaUnit.this.fobj, (int)diagnostic.getLineNumber(), (int)diagnostic.getColumnNumber());
                    arrayList.add(parserAnnotation);
                }
                JavaUnit.this.errors = arrayList.toArray(ParserAnnotation.EMPTY_ARRAY);
                return null;
            }
        }, this.fobj, false);
        if (this.errors.length > 0 && SourceUtils.isScanInProgress()) {
            try {
                Future future = JavaSource.forFileObject((FileObject)this.fobj).runWhenScanFinished((Task)new Task<CompilationController>(){

                    public void run(CompilationController compilationController) throws Exception {
                    }
                }, true);
                future.get();
                this.readErrors();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException {
    }

    public boolean sync() {
        Util.retrieveDocument(this.fobj, true);
        Unit.State state = this.getState();
        assert (Trace.trace((String)"insync", (String)("SU.sync of " + this.getName() + " state:" + state)));
        if (state == Unit.State.CLEAN) {
            return false;
        }
        if (state == Unit.State.MODELDIRTY) {
            assert (Trace.trace((String)"insync", (String)"SU.sync attempt to read source into a dirty model"));
            return false;
        }
        this.readErrors();
        if (this.errors.length > 0) {
            this.setBusted();
        } else {
            this.setClean();
        }
        return true;
    }

    public JavaClass getJavaClass() {
        return JavaClass.getJavaClass(this.fobj);
    }

    private String getPackageName(CompilationInfo compilationInfo) {
        Element element = compilationInfo.getTrees().getElement(new TreePath(compilationInfo.getCompilationUnit()));
        if (element != null && element.getKind() == ElementKind.PACKAGE) {
            return ((PackageElement)element).getQualifiedName().toString();
        }
        return null;
    }

    public ParserAnnotation[] getErrors() {
        if (this.errors == null) {
            this.readErrors();
        }
        return this.errors;
    }

    public boolean ensureImport(final String string) {
        ImportStatus importStatus = (ImportStatus)((Object)WriteTaskWrapper.execute(new WriteTaskWrapper.Write(){

            public Object run(WorkingCopy workingCopy) {
                ImportStatus importStatus = JavaUnit.this.checkImportStatus((CompilationInfo)workingCopy, string);
                if (importStatus.equals((Object)ImportStatus.needed)) {
                    JavaUnit.this.addImport(workingCopy, string);
                }
                return importStatus;
            }
        }, this.getFileObject()));
        if (importStatus.equals((Object)ImportStatus.needed)) {
            return this.isImported(string);
        }
        return !importStatus.equals((Object)ImportStatus.not_allowed);
    }

    private void addImport(WorkingCopy workingCopy, String string) {
        ImportTree importTree = TreeMakerUtils.createImport(workingCopy, string);
        CompilationUnitTree compilationUnitTree = workingCopy.getTreeMaker().addCompUnitImport(workingCopy.getCompilationUnit(), importTree);
        workingCopy.rewrite((Tree)workingCopy.getCompilationUnit(), (Tree)compilationUnitTree);
    }

    private boolean isImported(final String string) {
        return (Boolean)ReadTaskWrapper.execute(new ReadTaskWrapper.Read(){

            public Object run(CompilationInfo compilationInfo) {
                for (ImportTree importTree : compilationInfo.getCompilationUnit().getImports()) {
                    MemberSelectTree memberSelectTree;
                    if (importTree.getQualifiedIdentifier().getKind() != Tree.Kind.MEMBER_SELECT || !JavaUnit.this.getFQN(compilationInfo, memberSelectTree = (MemberSelectTree)importTree.getQualifiedIdentifier()).equals(string)) continue;
                    return true;
                }
                return false;
            }
        }, this.getFileObject());
    }

    private String getFQN(CompilationInfo compilationInfo, ExpressionTree expressionTree) {
        if (expressionTree.getKind() == Tree.Kind.MEMBER_SELECT) {
            MemberSelectTree memberSelectTree = (MemberSelectTree)expressionTree;
            return this.getFQN(compilationInfo, memberSelectTree.getExpression()) + "." + memberSelectTree.getIdentifier().toString();
        }
        if (expressionTree.getKind() == Tree.Kind.IDENTIFIER) {
            return ((IdentifierTree)expressionTree).getName().toString();
        }
        return expressionTree.toString();
    }

    private ImportStatus checkImportStatus(CompilationInfo compilationInfo, String string) {
        int n = string.lastIndexOf(46);
        String string2 = null;
        String string3 = null;
        if (n != -1) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        String string4 = this.getPackageName(compilationInfo);
        if (string2 == null || string2.equals(string4)) {
            return ImportStatus.not_needed;
        }
        if (compilationInfo.getElements().getTypeElement(string4 + "." + string3) != null) {
            return ImportStatus.not_allowed;
        }
        for (ImportTree importTree : compilationInfo.getCompilationUnit().getImports()) {
            if (importTree.getQualifiedIdentifier().getKind() != Tree.Kind.MEMBER_SELECT) continue;
            MemberSelectTree memberSelectTree = (MemberSelectTree)importTree.getQualifiedIdentifier();
            String string5 = memberSelectTree.getIdentifier().toString();
            if (this.getFQN(compilationInfo, memberSelectTree).equals(string)) {
                return ImportStatus.exists;
            }
            if (string5.equals("*")) {
                if (!this.getFQN(compilationInfo, memberSelectTree.getExpression()).equals(string2)) continue;
                return ImportStatus.exists;
            }
            if (!string5.equals(string3)) continue;
            return ImportStatus.not_allowed;
        }
        return ImportStatus.needed;
    }

    public JavaClass addClass(String string) {
        return null;
    }

    public void removeImport(String string) {
    }

    public void removeClass(JavaClass javaClass) {
    }

    public boolean flush() {
        return true;
    }

    public void writeTo(Writer writer) throws IOException {
    }

    public void dumpTo(PrintWriter printWriter) {
    }

    protected synchronized void firstWriteLock() {
        this.markSourceDirty = false;
    }

    protected synchronized void lastWriteUnlock() {
        this.markSourceDirty = true;
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        assert (Trace.trace((String)"insync-listener", (String)"SU.insertUpdate"));
        this.undoManager.notifyBufferEdited(this);
        if (this.markSourceDirty) {
            this.setSourceDirty();
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        assert (Trace.trace((String)"insync-listener", (String)"SU.removeUpdate"));
        this.undoManager.notifyBufferEdited(this);
        if (this.markSourceDirty) {
            this.setSourceDirty();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ImportStatus {
        needed,
        not_needed,
        exists,
        not_allowed;

    }
}

