/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.insync.models;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.visualweb.extension.openide.util.Trace;
import org.netbeans.modules.visualweb.insync.Model;
import org.netbeans.modules.visualweb.insync.ParserAnnotation;
import org.netbeans.modules.visualweb.insync.UndoEvent;
import org.netbeans.modules.visualweb.insync.models.FacesModelSet;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.api.ConfigurationUtils;
import org.netbeans.modules.web.jsf.api.facesmodel.FacesConfig;
import org.netbeans.modules.web.jsf.api.facesmodel.JSFConfigComponent;
import org.netbeans.modules.web.jsf.api.facesmodel.JSFConfigModel;
import org.netbeans.modules.web.jsf.api.facesmodel.ManagedBean;
import org.netbeans.modules.xml.xam.Model;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

public class FacesConfigModel
extends Model {
    WebModule webModule;
    List<JSFConfigModel> configModels;

    public FacesConfigModel(FacesModelSet facesModelSet) {
        super(facesModelSet, facesModelSet.getProject().getProjectDirectory());
        this.webModule = WebModule.getWebModule((FileObject)facesModelSet.getProject().getProjectDirectory());
    }

    public FileObject getFile() {
        FileObject[] fileObjectArray = ConfigurationUtils.getFacesConfigFiles((WebModule)this.webModule);
        if (fileObjectArray.length > 0) {
            assert (Trace.trace((String)"insync.faces.model", (String)("FCM.FacesConfigModel file:" + fileObjectArray[0])));
            return fileObjectArray[0];
        }
        return null;
    }

    private JSFConfigModel getDefaultFacesConfigModel() {
        return ConfigurationUtils.getConfigModel((FileObject)this.getFile(), (boolean)true);
    }

    public ManagedBean[] getManagedBeans() {
        FileObject[] fileObjectArray = ConfigurationUtils.getFacesConfigFiles((WebModule)this.webModule);
        this.refreshJSFConfigModelReferences(fileObjectArray);
        ArrayList arrayList = new ArrayList();
        for (FileObject fileObject : fileObjectArray) {
            JSFConfigModel jSFConfigModel = ConfigurationUtils.getConfigModel((FileObject)fileObject, (boolean)true);
            if (this.isBusted(jSFConfigModel)) continue;
            arrayList.addAll(jSFConfigModel.getRootComponent().getManagedBeans());
        }
        return arrayList.toArray(new ManagedBean[0]);
    }

    public ManagedBean getManagedBean(String string) {
        FileObject[] fileObjectArray = ConfigurationUtils.getFacesConfigFiles((WebModule)this.webModule);
        this.refreshJSFConfigModelReferences(fileObjectArray);
        for (FileObject fileObject : fileObjectArray) {
            JSFConfigModel jSFConfigModel = ConfigurationUtils.getConfigModel((FileObject)fileObject, (boolean)true);
            if (this.isBusted(jSFConfigModel)) continue;
            List list = jSFConfigModel.getRootComponent().getManagedBeans();
            for (ManagedBean managedBean : list) {
                if (!managedBean.getManagedBeanName().equals(string)) continue;
                return managedBean;
            }
        }
        return null;
    }

    public FacesConfig getFacesConfigForManagedBean(String string) {
        FileObject[] fileObjectArray = ConfigurationUtils.getFacesConfigFiles((WebModule)this.webModule);
        this.refreshJSFConfigModelReferences(fileObjectArray);
        for (FileObject fileObject : fileObjectArray) {
            JSFConfigModel jSFConfigModel = ConfigurationUtils.getConfigModel((FileObject)fileObject, (boolean)true);
            if (this.isBusted(jSFConfigModel)) continue;
            FacesConfig facesConfig = jSFConfigModel.getRootComponent();
            List list = facesConfig.getManagedBeans();
            for (ManagedBean managedBean : list) {
                if (!managedBean.getManagedBeanName().equals(string)) continue;
                return facesConfig;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshJSFConfigModelReferences(FileObject[] fileObjectArray) {
        ArrayList<JSFConfigModel> arrayList = new ArrayList<JSFConfigModel>();
        try {
            for (FileObject fileObject : fileObjectArray) {
                JSFConfigModel jSFConfigModel = ConfigurationUtils.getConfigModel((FileObject)fileObject, (boolean)true);
                if (jSFConfigModel == null) continue;
                arrayList.add(jSFConfigModel);
            }
            Object var9_8 = null;
            this.configModels = arrayList;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.configModels = arrayList;
            throw throwable;
        }
    }

    public ManagedBean ensureManagedBean(String string, String string2, ManagedBean.Scope scope) {
        ManagedBean managedBean = this.getManagedBean(string);
        if (managedBean == null) {
            managedBean = this.addManagedBean(string, string2, scope);
            assert (Trace.trace((String)"insync.faces.model", (String)("FCM.ensureManagedBean added:" + managedBean)));
        }
        return managedBean;
    }

    public ManagedBean addManagedBean(String string, String string2, ManagedBean.Scope scope) {
        JSFConfigModel jSFConfigModel = this.getDefaultFacesConfigModel();
        if (!this.isBusted(jSFConfigModel)) {
            ManagedBean managedBean = jSFConfigModel.getFactory().createManagedBean();
            managedBean.setManagedBeanName(string);
            managedBean.setManagedBeanClass(string2);
            managedBean.setManagedBeanScope(scope);
            jSFConfigModel.startTransaction();
            jSFConfigModel.getRootComponent().addManagedBean(managedBean);
            jSFConfigModel.endTransaction();
            this.save(jSFConfigModel);
            return managedBean;
        }
        return null;
    }

    public void removeManagedBean(ManagedBean managedBean) {
        JSFConfigModel jSFConfigModel = ((JSFConfigComponent)managedBean.getParent()).getModel();
        if (!this.isBusted(jSFConfigModel)) {
            jSFConfigModel.startTransaction();
            jSFConfigModel.getRootComponent().removeManagedBean(managedBean);
            jSFConfigModel.endTransaction();
            this.save(jSFConfigModel);
        }
    }

    public static String getPackageName(ManagedBean managedBean) {
        String string = managedBean.getManagedBeanClass();
        int n = string.lastIndexOf(46);
        return n >= 0 ? string.substring(0, n) : "";
    }

    public void save(JSFConfigModel jSFConfigModel) {
        SaveCookie saveCookie;
        DataObject dataObject = (DataObject)jSFConfigModel.getModelSource().getLookup().lookup(DataObject.class);
        if (dataObject != null && (saveCookie = (SaveCookie)dataObject.getLookup().lookup(SaveCookie.class)) != null) {
            try {
                saveCookie.save();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    public boolean isBusted() {
        FileObject[] fileObjectArray;
        for (FileObject fileObject : fileObjectArray = ConfigurationUtils.getFacesConfigFiles((WebModule)this.webModule)) {
            JSFConfigModel jSFConfigModel = ConfigurationUtils.getConfigModel((FileObject)fileObject, (boolean)true);
            if (!this.isBusted(jSFConfigModel)) continue;
            return true;
        }
        return false;
    }

    private boolean isBusted(JSFConfigModel jSFConfigModel) {
        return jSFConfigModel.getState() != Model.State.VALID;
    }

    public ParserAnnotation[] getErrors() {
        FileObject[] fileObjectArray = ConfigurationUtils.getFacesConfigFiles((WebModule)this.webModule);
        ArrayList<ParserAnnotation> arrayList = new ArrayList<ParserAnnotation>();
        for (FileObject fileObject : fileObjectArray) {
            JSFConfigModel jSFConfigModel = ConfigurationUtils.getConfigModel((FileObject)fileObject, (boolean)true);
            if (jSFConfigModel.getState() != Model.State.NOT_WELL_FORMED) continue;
            ParserAnnotation parserAnnotation = new ParserAnnotation("Error in config file", fileObject, 1, 1);
            arrayList.add(parserAnnotation);
        }
        return arrayList.toArray(ParserAnnotation.EMPTY_ARRAY);
    }

    public UndoEvent writeLock(String string) {
        return null;
    }

    public void writeUnlock(UndoEvent undoEvent) {
    }

    public boolean isWriteLocked() {
        return false;
    }

    protected void syncImpl() {
    }

    public void saveUnits() {
    }

    public void flushImpl() {
    }

    public void flushNonJavaUnitsImpl() {
    }
}

