/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.editor.completion;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import javax.swing.JList;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.modules.j2ee.persistence.editor.completion.NNPaintComponent;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;

public abstract class NNResultItem
implements CompletionQuery.ResultItem,
CompletionItem {
    protected int substituteOffset = -1;
    public static final String COMPLETION_SUBSTITUTE_TEXT = "completion-substitute-text";
    static String toAdd;

    public abstract String getItemText();

    public int getSubstituteOffset() {
        return this.substituteOffset;
    }

    public boolean substituteCommonText(JTextComponent jTextComponent, int n, int n2, int n3) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean substituteText(JTextComponent jTextComponent, int n, int n2, boolean bl) {
        BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
        String string = this.getItemText();
        if (string != null) {
            if (toAdd != null && !toAdd.equals("\n")) {
                string = string + toAdd;
            }
            baseDocument.atomicLock();
            try {
                char c;
                String string2 = baseDocument.getText(n, n2);
                if (string.equals(string2)) {
                    boolean bl2 = false;
                    return bl2;
                }
                if (!string.startsWith("\"")) {
                    string = this.quoteText(string);
                }
                if ((c = baseDocument.getText(n + n2, 1).charAt(0)) == '\"') {
                    ++n2;
                }
                baseDocument.remove(n, n2);
                baseDocument.insertString(n, string, null);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            finally {
                baseDocument.atomicUnlock();
            }
            return true;
        }
        return false;
    }

    public Component getPaintComponent(JList jList, boolean bl, boolean bl2) {
        Component component = this.getPaintComponent(bl);
        if (component == null) {
            return null;
        }
        if (bl) {
            component.setBackground(jList.getSelectionBackground());
            component.setForeground(jList.getSelectionForeground());
        } else {
            component.setBackground(jList.getBackground());
            component.setForeground(jList.getForeground());
        }
        component.getAccessibleContext().setAccessibleName(this.getItemText());
        component.getAccessibleContext().setAccessibleDescription(this.getItemText());
        return component;
    }

    public abstract Component getPaintComponent(boolean var1);

    public int getPreferredWidth(Graphics graphics, Font font) {
        Component component = this.getPaintComponent(false);
        return component.getPreferredSize().width;
    }

    public void render(Graphics graphics, Font font, Color color, Color color2, int n, int n2, boolean bl) {
        Component component = this.getPaintComponent(bl);
        component.setFont(font);
        component.setForeground(color);
        component.setBackground(color2);
        component.setBounds(0, 0, n, n2);
        ((NNPaintComponent)component).paintComponent(graphics);
    }

    public String toString() {
        return this.getItemText();
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 400) {
            Completion completion = Completion.get();
            switch (keyEvent.getKeyChar()) {
                case ' ': {
                    if (keyEvent.getModifiers() != 0) break;
                    completion.hideCompletion();
                    completion.hideDocumentation();
                    break;
                }
                case '(': 
                case ',': 
                case ';': {
                    completion.hideCompletion();
                    completion.hideDocumentation();
                }
                case '.': {
                    if (!this.defaultAction((JTextComponent)keyEvent.getSource(), Character.toString(keyEvent.getKeyChar()))) break;
                    keyEvent.consume();
                }
            }
        }
    }

    protected String quoteText(String string) {
        return "\"" + string + "\"";
    }

    public CharSequence getSortText() {
        return this.getItemText();
    }

    public CharSequence getInsertPrefix() {
        return this.getItemText();
    }

    public CompletionTask createDocumentationTask() {
        return null;
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public boolean instantSubstitution(JTextComponent jTextComponent) {
        Completion completion = Completion.get();
        completion.hideCompletion();
        completion.hideDocumentation();
        this.defaultAction(jTextComponent);
        return true;
    }

    public void defaultAction(JTextComponent jTextComponent) {
        Completion completion = Completion.get();
        completion.hideCompletion();
        completion.hideDocumentation();
        this.defaultAction(jTextComponent, "");
    }

    private boolean defaultAction(JTextComponent jTextComponent, String string) {
        int n = this.substituteOffset;
        if (n == -1) {
            n = jTextComponent.getCaret().getDot();
        }
        toAdd = string;
        return this.substituteText(jTextComponent, n, jTextComponent.getCaret().getDot() - n, false);
    }

    public static final class NoConnectionElementItem
    extends NNResultItem {
        private static NNPaintComponent.NoConnectionItemPaintComponent paintComponent = null;
        private DatabaseConnection dbconn;

        public NoConnectionElementItem(DatabaseConnection databaseConnection) {
            this.dbconn = databaseConnection;
        }

        public int getSortPriority() {
            return 1;
        }

        public String getItemText() {
            return "";
        }

        public boolean substituteText(JTextComponent jTextComponent, int n, int n2, boolean bl) {
            ConnectionManager.getDefault().showConnectionDialog(this.dbconn);
            return false;
        }

        public Component getPaintComponent(boolean bl) {
            if (paintComponent == null) {
                paintComponent = new NNPaintComponent.NoConnectionItemPaintComponent();
            }
            paintComponent.setSelected(bl);
            return paintComponent;
        }

        public Object getAssociatedObject() {
            return this;
        }
    }

    public static final class ColumnElementItem
    extends DBElementItem {
        private String tableName;
        protected static NNPaintComponent.ColumnElementPaintComponent paintComponent = null;

        public ColumnElementItem(String string, String string2, boolean bl, int n) {
            super(string, bl, n);
            this.tableName = string2;
        }

        public String getTypeName() {
            return "Column";
        }

        public int getSortPriority() {
            return 100;
        }

        public String getItemText() {
            return "\"" + this.getName() + "\"";
        }

        public Component getPaintComponent(boolean bl) {
            if (paintComponent == null) {
                paintComponent = new NNPaintComponent.ColumnElementPaintComponent();
            }
            paintComponent.setContent(this.getName(), this.tableName);
            paintComponent.setSelected(bl);
            return paintComponent;
        }

        public Object getAssociatedObject() {
            return this;
        }
    }

    public static final class TableElementItem
    extends DBElementItem {
        protected static NNPaintComponent.TableElementPaintComponent paintComponent = null;

        public TableElementItem(String string, boolean bl, int n) {
            super(string, bl, n);
        }

        public String getTypeName() {
            return "Table";
        }

        public int getSortPriority() {
            return 100;
        }

        public Component getPaintComponent(boolean bl) {
            if (paintComponent == null) {
                paintComponent = new NNPaintComponent.TableElementPaintComponent();
            }
            paintComponent.setContent(this.getName());
            paintComponent.setSelected(bl);
            return paintComponent;
        }

        public Object getAssociatedObject() {
            return this;
        }
    }

    public static final class SchemaElementItem
    extends DBElementItem {
        public SchemaElementItem(String string, boolean bl, int n) {
            super(string, bl, n);
        }

        public String getTypeName() {
            return "Schema";
        }

        public int getSortPriority() {
            return 100;
        }
    }

    public static final class CatalogElementItem
    extends DBElementItem {
        public CatalogElementItem(String string, boolean bl, int n) {
            super(string, bl, n);
        }

        public String getTypeName() {
            return "Catalog";
        }

        public int getSortPriority() {
            return 100;
        }
    }

    public static final class EntityPropertyElementItem
    extends DBElementItem {
        protected static NNPaintComponent.EntityPropertyElementPaintComponent paintComponent = null;

        public EntityPropertyElementItem(String string, boolean bl, int n) {
            super(string, bl, n);
        }

        public String getTypeName() {
            return "Persistence Unit";
        }

        public int getSortPriority() {
            return 100;
        }

        public Component getPaintComponent(boolean bl) {
            if (paintComponent == null) {
                paintComponent = new NNPaintComponent.EntityPropertyElementPaintComponent();
            }
            paintComponent.setContent(this.getName());
            paintComponent.setSelected(bl);
            return paintComponent;
        }
    }

    public static final class PersistenceUnitElementItem
    extends DBElementItem {
        protected static NNPaintComponent.PersistenceUnitElementPaintComponent paintComponent = null;

        public PersistenceUnitElementItem(String string, boolean bl, int n) {
            super(string, bl, n);
        }

        public String getTypeName() {
            return "Persistence Unit";
        }

        public int getSortPriority() {
            return 100;
        }

        public Component getPaintComponent(boolean bl) {
            if (paintComponent == null) {
                paintComponent = new NNPaintComponent.PersistenceUnitElementPaintComponent();
            }
            paintComponent.setContent(this.getName());
            paintComponent.setSelected(bl);
            return paintComponent;
        }
    }

    private static abstract class DBElementItem
    extends NNResultItem {
        private String name;
        private boolean quote;
        protected static NNPaintComponent.DBElementPaintComponent paintComponent = null;

        public DBElementItem(String string, boolean bl, int n) {
            this.name = string;
            this.quote = bl;
            this.substituteOffset = n;
        }

        public DBElementItem(String string, boolean bl) {
            this(string, bl, -1);
        }

        protected String getName() {
            return this.name;
        }

        protected boolean getQuoted() {
            return this.quote;
        }

        public String getItemText() {
            if (this.quote) {
                return this.quoteText(this.name);
            }
            return this.name;
        }

        public Component getPaintComponent(boolean bl) {
            if (paintComponent == null) {
                paintComponent = new NNPaintComponent.DBElementPaintComponent();
            }
            paintComponent.setString(this.getTypeName() + ": " + this.name);
            paintComponent.setSelected(bl);
            return paintComponent;
        }

        public Object getAssociatedObject() {
            return this;
        }

        public abstract String getTypeName();
    }
}

