/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.entitygenerator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.j2ee.persistence.entitygenerator.CMPMappingModel;
import org.netbeans.modules.j2ee.persistence.entitygenerator.EntityMember;
import org.netbeans.modules.j2ee.persistence.entitygenerator.RelationshipRole;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityClass {
    private final String tableName;
    private final FileObject rootFolder;
    private final String className;
    private final String packageName;
    private List<RelationshipRole> roles;
    private List<EntityMember> fields;
    private boolean usePkField;
    private String pkFieldName;
    private CMPMappingModel mappingModel;

    public EntityClass(String string, FileObject fileObject, String string2, String string3) {
        this.tableName = string;
        this.rootFolder = fileObject;
        this.packageName = string2;
        this.className = string3;
        this.roles = Collections.emptyList();
        this.fields = new ArrayList<EntityMember>();
        this.mappingModel = new CMPMappingModel();
    }

    public void addRole(RelationshipRole relationshipRole) {
        if (this.roles == Collections.emptyList()) {
            this.roles = new ArrayList<RelationshipRole>();
        }
        this.roles.add(relationshipRole);
    }

    public List<RelationshipRole> getRoles() {
        return this.roles;
    }

    public List<EntityMember> getFields() {
        return this.fields;
    }

    public void setFields(List<EntityMember> list) {
        this.fields = list;
    }

    public String toString() {
        String string = "";
        for (EntityMember entityMember : this.getFields()) {
            string = string + " " + entityMember.getMemberName() + (entityMember.isPrimaryKey() ? " (PK) " : " ");
        }
        return "bean name " + this.getClassName() + "\ncmp-fields " + string;
    }

    public FileObject getRootFolder() {
        return this.rootFolder;
    }

    public String getPackage() {
        return this.packageName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getClassName() {
        return this.className;
    }

    public FileObject getPackageFileObject() {
        String string = this.packageName.replace('.', '/');
        return this.rootFolder.getFileObject(string);
    }

    public CMPMappingModel getCMPMapping() {
        this.mappingModel.getCMPFieldMapping().clear();
        for (EntityMember entityMember : this.getFields()) {
            this.mappingModel.setTableName(entityMember.getTableName());
            this.mappingModel.getCMPFieldMapping().put(entityMember.getMemberName(), entityMember.getColumnName());
        }
        return this.mappingModel;
    }

    public void usePkField(boolean bl) {
        this.usePkField = bl;
    }

    public boolean isUsePkField() {
        return this.usePkField;
    }

    public String getPkFieldName() {
        return this.pkFieldName;
    }

    public void setPkFieldName(String string) {
        this.pkFieldName = string;
    }
}

