/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.unit;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.j2ee.persistence.provider.InvalidPersistenceXmlException;
import org.netbeans.modules.j2ee.persistence.provider.Provider;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.spi.provider.PersistenceProviderSupplier;
import org.netbeans.modules.j2ee.persistence.wizard.Util;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardPanel;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardPanelDS;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardPanelJdbc;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class PersistenceUnitWizardDescriptor
implements WizardDescriptor.FinishablePanel,
ChangeListener {
    private PersistenceUnitWizardPanelDS p;
    private PersistenceUnitWizardPanelJdbc jdbcPanel;
    private PersistenceUnitWizardPanel panel;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private WizardDescriptor wizardDescriptor;
    private Project project;
    private boolean isContainerManaged;
    private static String ERROR_MSG_KEY = "WizardPanel_errorMessage";

    public PersistenceUnitWizardDescriptor(Project project) {
        this.project = project;
        PersistenceProviderSupplier persistenceProviderSupplier = (PersistenceProviderSupplier)project.getLookup().lookup(PersistenceProviderSupplier.class);
        this.isContainerManaged = Util.isSupportedJavaEEVersion(project) && persistenceProviderSupplier != null && persistenceProviderSupplier.supportsDefaultProvider();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public Component getComponent() {
        if (this.panel == null) {
            if (this.isContainerManaged) {
                this.p = new PersistenceUnitWizardPanelDS(this.project, this, true);
                this.panel = this.p;
            } else {
                this.jdbcPanel = new PersistenceUnitWizardPanelJdbc(this.project, this, true);
                this.panel = this.jdbcPanel;
            }
            this.panel.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Object object;
                    if (propertyChangeEvent.getPropertyName().equals("PersistenceUnitWizardPanel_isValid") && (object = propertyChangeEvent.getNewValue()) != null && object instanceof Boolean) {
                        PersistenceUnitWizardDescriptor.this.stateChanged(null);
                    }
                }
            });
        }
        return this.panel;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(PersistenceUnitWizardDescriptor.class);
    }

    public boolean isValid() {
        if (this.wizardDescriptor == null) {
            return true;
        }
        if (!ProviderUtil.isValidServerInstanceOrNone(this.project)) {
            this.wizardDescriptor.putProperty(ERROR_MSG_KEY, (Object)NbBundle.getMessage(PersistenceUnitWizardDescriptor.class, (String)"ERR_MissingServer"));
            return false;
        }
        if (this.panel != null && !this.panel.isValidPanel()) {
            try {
                if (!this.panel.isNameUnique()) {
                    this.wizardDescriptor.putProperty(ERROR_MSG_KEY, (Object)NbBundle.getMessage(PersistenceUnitWizardDescriptor.class, (String)"ERR_PersistenceUnitNameNotUnique"));
                }
            }
            catch (InvalidPersistenceXmlException invalidPersistenceXmlException) {
                this.wizardDescriptor.putProperty(ERROR_MSG_KEY, (Object)NbBundle.getMessage(PersistenceUnitWizardDescriptor.class, (String)"ERR_InvalidPersistenceXml", (Object)invalidPersistenceXmlException.getPath()));
            }
            return false;
        }
        this.wizardDescriptor.putProperty(ERROR_MSG_KEY, (Object)" ");
        return true;
    }

    public void readSettings(Object object) {
        this.wizardDescriptor = (WizardDescriptor)object;
        this.project = Templates.getProject((WizardDescriptor)this.wizardDescriptor);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public void storeSettings(Object object) {
    }

    public boolean isFinishPanel() {
        return this.isValid();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.changeSupport.fireChange();
    }

    String getPersistenceUnitName() {
        return this.panel.getPersistenceUnitName();
    }

    Library getPersistenceLibrary() {
        return this.jdbcPanel == null ? null : this.jdbcPanel.getPersistenceLibrary();
    }

    DatabaseConnection getPersistenceConnection() {
        return this.jdbcPanel == null ? null : this.jdbcPanel.getPersistenceConnection();
    }

    String getDatasource() {
        return this.p == null ? null : this.p.getDatasource();
    }

    boolean isContainerManaged() {
        return this.isContainerManaged;
    }

    boolean isJTA() {
        return this.p == null ? false : this.p.isJTA();
    }

    boolean isNonDefaultProviderEnabled() {
        return this.p == null ? false : this.p.isNonDefaultProviderEnabled();
    }

    String getNonDefaultProvider() {
        return this.p == null ? null : this.p.getNonDefaultProvider();
    }

    String getTableGeneration() {
        return this.panel.getTableGeneration();
    }

    Provider getSelectedProvider() {
        return this.panel.getSelectedProvider();
    }
}

