/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.integration.ide;

import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.netbeans.modules.uml.core.IUMLCreationFactory;
import org.netbeans.modules.uml.core.coreapplication.IPreferenceManager2;
import org.netbeans.modules.uml.core.eventframework.IEventDispatchController;
import org.netbeans.modules.uml.core.eventframework.IEventDispatcher;
import org.netbeans.modules.uml.core.metamodel.core.constructs.IClass;
import org.netbeans.modules.uml.core.metamodel.core.constructs.IDataType;
import org.netbeans.modules.uml.core.metamodel.core.constructs.IEnumeration;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamedElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamespace;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IPackage;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IRelationProxy;
import org.netbeans.modules.uml.core.metamodel.core.foundation.ITaggedValue;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IVersionableElement;
import org.netbeans.modules.uml.core.metamodel.infrastructure.RelationFactory;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IAssociation;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IAssociationEnd;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IAttribute;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IClassifier;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IGeneralization;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IImplementation;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IInterface;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.INavigableEnd;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IOperation;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IParameter;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IStructuralFeature;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.ITypedElement;
import org.netbeans.modules.uml.core.metamodel.structure.IModel;
import org.netbeans.modules.uml.core.metamodel.structure.IProject;
import org.netbeans.modules.uml.core.scm.ISCMIntegrator;
import org.netbeans.modules.uml.core.scm.ISCMTool;
import org.netbeans.modules.uml.core.support.umlsupport.Log;
import org.netbeans.modules.uml.core.support.umlsupport.StringUtilities;
import org.netbeans.modules.uml.core.support.umlutils.ETArrayList;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.core.support.umlutils.ElementLocator;
import org.netbeans.modules.uml.core.typemanagement.ITypeManager;
import org.netbeans.modules.uml.core.workspacemanagement.IWorkspace;
import org.netbeans.modules.uml.integration.ide.UMLSupport;
import org.netbeans.modules.uml.integration.ide.events.ClassInfo;
import org.netbeans.modules.uml.integration.ide.events.EventManager;
import org.netbeans.modules.uml.integration.ide.events.MemberInfo;
import org.netbeans.modules.uml.integration.ide.events.MethodInfo;
import org.netbeans.modules.uml.integration.ide.events.MethodParameterInfo;
import org.netbeans.modules.uml.integration.ide.events.SymbolTransaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaClassUtils {
    public static final int DESC_PUBLIC = 0;
    public static final int DESC_PROTECTED = 1;
    public static final int DESC_PRIVATE = 2;
    public static final int DESC_PACKAGE = 3;
    public static final String REF_CLASS = "ReferenceClass";
    private static final HashSet primitives = new HashSet();

    public static int getDescribeModifier(int n) {
        if ((n & 1) != 0) {
            return 0;
        }
        if ((n & 4) != 0) {
            return 1;
        }
        if ((n & 2) != 0) {
            return 2;
        }
        return 3;
    }

    public static int getJavaModifier(int n) {
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 2;
            }
        }
        return 0;
    }

    public static String getFullyQualifiedName(INamedElement iNamedElement) {
        StringBuffer stringBuffer = new StringBuffer();
        if (iNamedElement != null) {
            stringBuffer.append(iNamedElement.getName());
            for (IElement iElement = iNamedElement.getOwner(); iElement != null; iElement = iElement.getOwner()) {
                IClassifier iClassifier;
                if (iElement instanceof IModel) continue;
                if (iElement instanceof IClassifier) {
                    iClassifier = (IClassifier)iElement;
                    stringBuffer.insert(0, '$');
                    stringBuffer.insert(0, iClassifier.getName());
                    continue;
                }
                if (!(iElement instanceof IPackage) || iElement instanceof IProject) break;
                iClassifier = (IPackage)iElement;
                stringBuffer.insert(0, '.');
                stringBuffer.insert(0, iClassifier.getName());
            }
        }
        return stringBuffer.toString();
    }

    public static String getTaggedValue(IElement iElement, String string) {
        ITaggedValue iTaggedValue = null;
        if (iElement != null) {
            iTaggedValue = iElement.getTaggedValueByName(string);
            if (iTaggedValue == null || iTaggedValue.getName().length() == 0) {
                return null;
            }
            return iTaggedValue.getDataValue();
        }
        return null;
    }

    public static void setTaggedValue(IElement iElement, String string, String string2) {
        ITaggedValue iTaggedValue = iElement.getTaggedValueByName(string);
        if (iTaggedValue == null || iTaggedValue.getName().length() == 0) {
            if (string2 != null) {
                iElement.addTaggedValue(string, string2);
            }
        } else if (string2 != null) {
            iTaggedValue.setDataValue(string2);
        } else {
            iElement.removeTaggedValue(iTaggedValue);
        }
    }

    public static IDataType createDataType(String string) {
        Log.out((String)("]]] Creating data type " + string));
        String string2 = JavaClassUtils.getInnerClassName(string);
        INamedElement iNamedElement = SymbolTransaction.getClassOwner(string);
        if (iNamedElement == null) {
            return null;
        }
        IUMLCreationFactory iUMLCreationFactory = SymbolTransaction.getUMLCreationFactory();
        IDataType iDataType = iUMLCreationFactory.createDataType(null);
        iNamedElement.addElement((IElement)iDataType);
        iDataType.setName(string2);
        return iDataType;
    }

    public static IPackage findPackage(String string, IProject iProject) {
        INamedElement iNamedElement = JavaClassUtils.findElement(iProject, string, IPackage.class);
        return iNamedElement != null ? (IPackage)iNamedElement : null;
    }

    public static IPackage findScopedPackage(String string, INamespace iNamespace) {
        if (iNamespace == null && (iNamespace = UMLSupport.getCurrentProject()) == null) {
            return null;
        }
        ETList eTList = iNamespace.getOwnedElementsByName(string);
        if (eTList != null) {
            for (int i = eTList.getCount() - 1; i >= 0; --i) {
                INamedElement iNamedElement = (INamedElement)eTList.item(i);
                if (iNamedElement == null || !(iNamedElement instanceof IPackage)) continue;
                return (IPackage)iNamedElement;
            }
        }
        return null;
    }

    public static String convertJavaToUML(String string) {
        String string2 = string.replace('$', '.');
        int n = string2.indexOf(".");
        while (n > 0) {
            StringBuffer stringBuffer = new StringBuffer(string2);
            string2 = stringBuffer.replace(n, n + 1, "::").toString();
            n = string2.indexOf(".");
        }
        return string2;
    }

    public static String convertJavaToUML(String string, String string2) {
        String string3 = string.length() > 0 ? string + "." : "";
        String string4 = string3 + string2;
        return JavaClassUtils.convertJavaToUML(string4);
    }

    public static String convertUMLtoJava(String string) {
        String string2 = string;
        int n = string2.indexOf("::");
        while (n > 0) {
            StringBuffer stringBuffer = new StringBuffer(string2);
            string2 = stringBuffer.replace(n, n + 2, ".").toString();
            n = string2.indexOf("::");
        }
        return string2;
    }

    public static String formFullClassName(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        String string3 = string2.replace('.', '$');
        return string == null || string.equals("") ? string3 : string + "." + string3;
    }

    public static String getFullInnerClassName(String string) {
        return JavaClassUtils.getShortClassName(string).replace('$', '.');
    }

    public static String getShortClassName(String string) {
        if (string == null || string.length() < 1) {
            return "";
        }
        int n = string.lastIndexOf(46);
        String string2 = n == -1 ? string : string.substring(n + 1);
        return string2;
    }

    public static String getInnerClassName(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(36);
        String string2 = n == -1 ? JavaClassUtils.getShortClassName(string) : string.substring(n + 1);
        return string2;
    }

    public static String getOuterClassName(String string) {
        int n = string.indexOf(36);
        return n == -1 ? string : string.substring(0, n);
    }

    public static String getPackageName(String string) {
        int n = string.lastIndexOf(46);
        String string2 = n == -1 ? "" : string.substring(0, n);
        return string2;
    }

    public static String getClassName(String string) {
        if (string.indexOf("::") == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "::");
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken() + ".");
        }
        String string2 = stringBuffer.toString();
        string2 = string2.substring(0, string2.lastIndexOf("."));
        return string2;
    }

    public static String getQualifiedPackageName(String string) {
        if (string.indexOf(".") == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken() + "::");
        }
        String string2 = stringBuffer.toString();
        string2 = string2.substring(0, string2.lastIndexOf("::"));
        return string2;
    }

    protected static void showProjectSymbols(IProject iProject) {
        ETList eTList = iProject.getElements();
        if (eTList == null) {
            return;
        }
        Log.out((String)("Project " + iProject.getName() + " has " + eTList.getCount() + " elements"));
        for (int i = 0; i < eTList.getCount(); ++i) {
            IElement iElement = (IElement)eTList.item(i);
            INamedElement iNamedElement = null;
            if (iElement instanceof INamedElement) {
                iNamedElement = (INamedElement)iElement;
            }
            Log.out((String)("" + i + ") " + (iNamedElement == null ? iElement.toString() : iNamedElement.getName())));
        }
    }

    public static void findAndDeleteSymbolsByName(String string) {
        Log.out((String)("The file to delete is " + string));
        IProject iProject = null;
        if (iProject == null) {
            iProject = UMLSupport.getCurrentProject();
        }
        if (iProject != null) {
            Log.out((String)("IProject to search for symbols is == " + iProject.getName()));
            EventManager.setRoundTripActive(true);
            JavaClassUtils.findAndDeleteSymbol((INamespace)iProject, string);
            EventManager.setRoundTripActive(false);
        } else {
            Log.out((String)("Unable to find the project for the path = " + string));
        }
    }

    private static void findAndDeleteSymbol(INamespace iNamespace, String string) {
        ETList eTList = iNamespace.getOwnedElements();
        if (eTList != null) {
            for (int i = 0; i < eTList.getCount(); ++i) {
                IClassifier iClassifier;
                INamedElement iNamedElement = (INamedElement)eTList.item(i);
                if (iNamedElement instanceof IClassifier) {
                    ETList eTList2;
                    ETList eTList3;
                    iClassifier = (IClassifier)iNamedElement;
                    if (ClassInfo.getSymbolFilename(iClassifier) == null || !ClassInfo.getSymbolFilename(iClassifier).equals(string)) continue;
                    ETList eTList4 = iClassifier.getAssociations();
                    if (eTList4 != null) {
                        for (int j = 0; j < eTList4.getCount(); ++j) {
                            if (eTList4.item(j) == null) continue;
                            ((IAssociation)eTList4.item(j)).delete();
                        }
                    }
                    if ((eTList3 = iClassifier.getGeneralizations()) != null) {
                        for (int j = 0; j < eTList3.getCount(); ++j) {
                            if (eTList3.item(j) == null) continue;
                            ((IGeneralization)eTList3.item(j)).delete();
                        }
                    }
                    if ((eTList2 = iClassifier.getImplementations()) != null) {
                        for (int j = 0; j < eTList2.getCount(); ++j) {
                            if (eTList2.item(j) == null) continue;
                            ((IImplementation)eTList2.item(j)).delete();
                        }
                    }
                    iNamedElement.delete();
                    continue;
                }
                if (!(iNamedElement instanceof IPackage)) continue;
                iClassifier = (IPackage)iNamedElement;
                JavaClassUtils.findAndDeleteSymbol((INamespace)iClassifier, string);
            }
        }
    }

    public static void findAndDeletePackage(String string) {
        Log.out((String)"In findAndDeletePackage()");
        INamedElement iNamedElement = JavaClassUtils.findElement(string);
        if (iNamedElement != null) {
            Log.out((String)("ELEMENT TO DELETE : " + iNamedElement.getName()));
            if (iNamedElement instanceof IPackage) {
                IPackage iPackage = (IPackage)iNamedElement;
                Log.out((String)("THE PACKAGE TO DELETE IS : " + iPackage.getName()));
                iPackage.delete();
            }
        }
    }

    public static INamedElement findElement(IProject iProject, String string, Class clazz) {
        String string2;
        ElementLocator elementLocator;
        int n;
        Log.out((String)("Trying to find element " + string));
        if (iProject == null && (iProject = UMLSupport.getCurrentProject()) == null) {
            Log.out((String)"Project is null ...");
            return null;
        }
        Log.out((String)("findClassSymbol: Looking for element " + string + " inside project " + iProject.getName()));
        ITypeManager iTypeManager = iProject.getTypeManager();
        if (iTypeManager == null) {
            Log.impossible((String)("findClassSymbol: Project " + iProject.getName() + " has no ITypeManager"));
            return null;
        }
        String string3 = JavaClassUtils.convertJavaToUML(string);
        Log.out((String)("findClassSymbol: Asking ITypeManager for " + string3));
        ETList eTList = iTypeManager.getLocalCachedTypesByName(string3);
        int n2 = n = eTList != null ? eTList.getCount() : 0;
        if (n == 0) {
            ElementLocator elementLocator2;
            elementLocator = elementLocator2 = new ElementLocator();
            string2 = elementLocator.findScopedElements((IVersionableElement)iProject, iProject.getName() + "::" + string3);
            eTList = new ETArrayList();
            Iterator iterator = string2.iterator();
            while (iterator.hasNext()) {
                IElement iElement = (IElement)iterator.next();
                if (!(iElement instanceof INamedElement)) continue;
                eTList.add((Object)((INamedElement)iElement));
            }
            n = eTList != null ? eTList.getCount() : 0;
        }
        for (int i = 0; i < n; ++i) {
            elementLocator = (INamedElement)eTList.item(i);
            if (elementLocator == null || clazz != null && !clazz.isAssignableFrom(elementLocator.getClass()) || !(string2 = JavaClassUtils.getFullyQualifiedName((INamedElement)elementLocator)).equals(string) && !string2.replace('$', '.').equals(string)) continue;
            return elementLocator;
        }
        Log.out((String)("JavaClassUtils.findElement: Unable to find element " + string));
        return null;
    }

    public static final INamedElement findElement(String string, Class clazz) {
        return JavaClassUtils.findElement(null, string, clazz);
    }

    public static final INamedElement findElement(String string) {
        return JavaClassUtils.findElement(string, null);
    }

    public static IClassifier findClassSymbol(String string) {
        if (JavaClassUtils.isPrimitive(string)) {
            return null;
        }
        INamedElement iNamedElement = JavaClassUtils.findElement(string, IClassifier.class);
        if (iNamedElement != null) {
            if (iNamedElement instanceof IClass) {
                return (IClass)iNamedElement;
            }
            if (iNamedElement instanceof IInterface) {
                return (IInterface)iNamedElement;
            }
            if (iNamedElement instanceof IDataType) {
                return (IDataType)iNamedElement;
            }
            return (IClassifier)iNamedElement;
        }
        return null;
    }

    public static String[] getOuterClassArray(String string) {
        String string2 = JavaClassUtils.getFullInnerClassName(string);
        String[] stringArray = JavaClassUtils.tokenize2Array(string2, ".");
        return stringArray;
    }

    public static String[] tokenize2Array(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken());
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static boolean startsWith(String string, String string2) {
        if (string2 == null || string == null) {
            return false;
        }
        return string.toLowerCase().startsWith(string2.toLowerCase());
    }

    public static String getFileName(String string) {
        int n;
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        int n2 = string.lastIndexOf(File.separator);
        if (n2 != -1) {
            string = string.substring(n2 + 1);
        }
        if ((n = string.lastIndexOf(46)) != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    public static IOperation findOperation(MethodInfo methodInfo) {
        ClassInfo classInfo = methodInfo.getContainingClass();
        if (classInfo == null) {
            return null;
        }
        IClassifier iClassifier = classInfo.getClassElement();
        if (iClassifier == null) {
            iClassifier = JavaClassUtils.findClassSymbol(classInfo.getFullClassName());
        }
        if (iClassifier == null) {
            return null;
        }
        return JavaClassUtils.findOperation(iClassifier, methodInfo.getName(), methodInfo.getParameters());
    }

    public static IOperation findOperation(IClassifier iClassifier, String string, MethodParameterInfo[] methodParameterInfoArray) {
        IOperation iOperation;
        block5: {
            iOperation = null;
            Log.out((String)("findOperation: Looking for " + string + " in " + iClassifier.getName()));
            try {
                ETList eTList;
                if (iClassifier == null || (eTList = iClassifier.getOperations()) == null) break block5;
                int n = eTList.getCount();
                for (int i = 0; i < n; ++i) {
                    IOperation iOperation2 = (IOperation)eTList.item(i);
                    if (!JavaClassUtils.isDesiredOperation(iOperation2, string, methodParameterInfoArray)) continue;
                    iOperation = iOperation2;
                    break;
                }
            }
            catch (Exception exception) {
                Log.stackTrace((Throwable)exception);
            }
        }
        if (iOperation != null) {
            Log.out((String)("findOperation: Found operation " + iOperation.getName()));
        } else {
            Log.out((String)("findOperation: Couldn't find operation " + string));
        }
        return iOperation;
    }

    private static boolean isDesiredOperation(IOperation iOperation, String string, MethodParameterInfo[] methodParameterInfoArray) {
        boolean bl = false;
        try {
            String string2 = iOperation.getName();
            ETList eTList = iOperation.getFormalParameters();
            if (eTList != null && eTList.getCount() > 0 && ((IParameter)eTList.item(0)).getName() == null) {
                eTList.remove(0);
            }
            if (string.equals(string2) && JavaClassUtils.compareParameters((ETList<IParameter>)eTList, methodParameterInfoArray)) {
                bl = true;
            }
            return bl;
        }
        catch (Exception exception) {
            Log.stackTrace((Throwable)exception);
            return bl;
        }
    }

    private static boolean compareParameters(ETList<IParameter> eTList, MethodParameterInfo[] methodParameterInfoArray) {
        if (!(eTList != null && eTList.getCount() != 0 || methodParameterInfoArray != null && methodParameterInfoArray.length != 0)) {
            return true;
        }
        if ((eTList == null || eTList.getCount() == 0) != (methodParameterInfoArray == null || methodParameterInfoArray.length == 0)) {
            return false;
        }
        if (eTList.getCount() != methodParameterInfoArray.length) {
            return false;
        }
        for (int i = 0; i < methodParameterInfoArray.length; ++i) {
            String string = MemberInfo.getArrayTypeName((ITypedElement)eTList.item(i));
            String string2 = JavaClassUtils.getInnerClassName(methodParameterInfoArray[i].getType());
            if (string == null || string.equals(string2)) continue;
            if (string2.length() == 0) {
                String string3;
                String string4 = ((IParameter)eTList.item(i)).getName();
                if (string4.equals(string3 = methodParameterInfoArray[i].getName())) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static IStructuralFeature findAttribute(MemberInfo memberInfo) {
        if (memberInfo == null) {
            return null;
        }
        ClassInfo classInfo = memberInfo.getContainingClass();
        if (classInfo == null) {
            return null;
        }
        IClassifier iClassifier = classInfo.getClassElement();
        if (iClassifier == null) {
            iClassifier = JavaClassUtils.findClassSymbol(classInfo.getFullClassName());
        }
        if (iClassifier == null) {
            return null;
        }
        return JavaClassUtils.findAttribute(iClassifier, memberInfo.getName());
    }

    public static IStructuralFeature findAttribute(IClassifier iClassifier, String string) {
        IStructuralFeature iStructuralFeature = null;
        try {
            if (iClassifier != null) {
                ETList eTList;
                int n;
                ETList eTList2 = iClassifier.getOwnedElementsByName(string);
                if (eTList2 != null) {
                    int n2 = eTList2.getCount();
                    for (n = 0; n < n2; ++n) {
                        INamedElement iNamedElement = (INamedElement)eTList2.item(n);
                        if (!(iNamedElement instanceof IAttribute)) continue;
                        return (IAttribute)iNamedElement;
                    }
                }
                if ((eTList = iClassifier.getAssociations()) != null) {
                    n = eTList.getCount();
                    for (int i = 0; i < n; ++i) {
                        ETList eTList3 = ((IAssociation)eTList.item(i)).getEnds();
                        if (eTList3 == null) continue;
                        int n3 = eTList3.getCount();
                        for (int j = 0; j < n3; ++j) {
                            INavigableEnd iNavigableEnd;
                            IAssociationEnd iAssociationEnd = (IAssociationEnd)eTList3.item(j);
                            if (!iAssociationEnd.getIsNavigable() || !(iNavigableEnd = (INavigableEnd)iAssociationEnd).getName().equals(string)) continue;
                            return iNavigableEnd;
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return iStructuralFeature;
    }

    public static IAssociation findAssociation(IClassifier iClassifier, IClassifier iClassifier2) {
        ETArrayList eTArrayList = new ETArrayList();
        eTArrayList.add((Object)iClassifier);
        eTArrayList.add((Object)iClassifier2);
        return JavaClassUtils.determineCommonRelations((ETList<IElement>)eTArrayList);
    }

    public static IAssociation determineCommonRelations(ETList<IElement> eTList) {
        RelationFactory relationFactory = new RelationFactory();
        ETList eTList2 = relationFactory.determineCommonRelations(eTList);
        if (eTList2 == null) {
            return null;
        }
        int n = eTList2.getCount();
        for (int i = 0; i < n; ++i) {
            IElement iElement;
            IRelationProxy iRelationProxy = (IRelationProxy)eTList2.item(i);
            if (iRelationProxy == null || !((iElement = iRelationProxy.getConnection()) instanceof IAssociation)) continue;
            return (IAssociation)iElement;
        }
        return null;
    }

    public static void setReferenceClass(IClassifier iClassifier, boolean bl) {
        JavaClassUtils.setTaggedValue((IElement)iClassifier, REF_CLASS, bl ? "true" : null);
    }

    public static boolean isReferenceClass(IClassifier iClassifier) {
        return iClassifier != null && iClassifier instanceof IDataType && !(iClassifier instanceof IEnumeration) || "true".equals(JavaClassUtils.getTaggedValue((IElement)iClassifier, REF_CLASS));
    }

    public static boolean isOrphan(IClassifier iClassifier) {
        ETList eTList = iClassifier.getImplementations();
        ETList eTList2 = iClassifier.getGeneralizations();
        ETList eTList3 = iClassifier.getSpecializations();
        ETList eTList4 = iClassifier.getAssociations();
        ETList eTList5 = iClassifier.getSupplierDependencies();
        ETList eTList6 = iClassifier.getClientDependencies();
        return !(eTList != null && eTList.getCount() != 0 || eTList2 != null && eTList2.getCount() != 0 || eTList4 != null && eTList4.getCount() != 0 || eTList5 != null && eTList5.getCount() != 0 || eTList6 != null && eTList6.getCount() != 0 || eTList3 != null && eTList3.getCount() != 0);
    }

    public static String getPrimitiveWrapperType(String string) {
        if (string.equals("int")) {
            return "Integer";
        }
        if (string.equals("short")) {
            return "Short";
        }
        if (string.equals("long")) {
            return "Long";
        }
        if (string.equals("float")) {
            return "Float";
        }
        if (string.equals("double")) {
            return "Double";
        }
        if (string.equals("byte")) {
            return "Byte";
        }
        if (string.equals("char")) {
            return "Character";
        }
        if (string.equals("boolean")) {
            return "Boolean";
        }
        return null;
    }

    public static final boolean isPrimitive(String string) {
        return primitives.contains(string);
    }

    public static String getPkgName(String string) {
        if (string.indexOf("::") == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "::");
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken() + File.separator);
        }
        String string2 = stringBuffer.toString();
        string2 = string2.substring(0, string2.lastIndexOf(File.separator));
        return string2;
    }

    public static boolean needToCheckOut(ClassInfo classInfo) {
        IClassifier iClassifier = classInfo.getClassElement();
        if (iClassifier.isVersioned()) {
            UMLSupport uMLSupport = UMLSupport.getUMLSupport();
            IPreferenceManager2 iPreferenceManager2 = uMLSupport.getProduct().getPreferenceManager();
            String string = iPreferenceManager2.getPreferenceValue("ConfigManagement", "SourceSync");
            if (string != null && string.equals("PSK_YES")) {
                ISCMTool iSCMTool;
                String string2 = classInfo.getFilename();
                Log.out((String)("Class is versioned, so need to checkout the corresponding java file " + string2));
                ISCMIntegrator iSCMIntegrator = uMLSupport.getProduct().getSCMIntegrator();
                if (iSCMIntegrator != null && (iSCMTool = iSCMIntegrator.getSCMToolByWorkspace(UMLSupport.getCurrentWorkspace())) != null) {
                    IEventDispatchController iEventDispatchController = uMLSupport.getProduct().getEventDispatchController();
                    return true;
                }
            }
            Log.out((String)"Returning after checkout");
        }
        Log.out((String)"No need to checkout");
        return false;
    }

    public static void checkInNewFile(ClassInfo classInfo, ClassInfo classInfo2, String string) {
        if (classInfo == null || classInfo2 == null) {
            Log.err((String)"JCU: Can't check in file without ClassInfos");
            return;
        }
        String string2 = classInfo2.getFilename();
        IClassifier iClassifier = classInfo.getClassElement();
        if (iClassifier == null) {
            iClassifier = classInfo2.getClassElement();
        }
        if (iClassifier == null) {
            Log.err((String)("JCU: Can't find model element for " + classInfo));
            return;
        }
        if (string == null) {
            string = classInfo.updateFilename(null);
            Log.out((String)("JCU: oldFile retrieved was " + string));
        }
        Log.out((String)("JCU: Change event for " + string + string2));
        if (string2.equalsIgnoreCase(string.toLowerCase())) {
            Log.out((String)"JCU: Old and new files are same, so returning");
            return;
        }
        Log.out((String)"JCU: Files are different");
        UMLSupport uMLSupport = UMLSupport.getUMLSupport();
        IPreferenceManager2 iPreferenceManager2 = uMLSupport.getProduct().getPreferenceManager();
        String string3 = iPreferenceManager2.getPreferenceValue("ConfigManagement", "Enabled");
        if (string3 == null || string3.equals("PSK_NO")) {
            return;
        }
        String string4 = iPreferenceManager2.getPreferenceValue("ConfigManagement", "SourceSync");
        if (string4 != null && string4.equals("PSK_YES")) {
            IWorkspace iWorkspace;
            if (!iClassifier.isVersioned()) {
                Log.out((String)("JCU: " + iClassifier.getName() + " is not versioned, so not adding the renamed " + "file to version control"));
                return;
            }
            ISCMIntegrator iSCMIntegrator = uMLSupport.getProduct().getSCMIntegrator();
            ISCMTool iSCMTool = iSCMIntegrator.getSCMToolByWorkspace(iWorkspace = UMLSupport.getCurrentWorkspace());
            if (iSCMTool != null) {
                IEventDispatchController iEventDispatchController = uMLSupport.getProduct().getEventDispatchController();
                if (iEventDispatchController != null) {
                    IEventDispatcher iEventDispatcher = iEventDispatchController.retrieveDispatcher("SCM");
                }
            }
        }
    }

    public static String getParentName(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(46);
        int n2 = string.lastIndexOf(36);
        if (n2 > n) {
            n = n2;
        }
        if (n == -1) {
            return "";
        }
        return string.substring(0, n);
    }

    public static String replaceDollarSign(String string) {
        return StringUtilities.replaceAllSubstrings((String)string, (String)"$", (String)".");
    }

    public static IClassifier getOuterMostOwner(IClassifier iClassifier) {
        IElement iElement = iClassifier.getOwner();
        if (iElement == null || iElement instanceof IProject || iElement instanceof IPackage) {
            return iClassifier;
        }
        if (iElement instanceof IClassifier) {
            return JavaClassUtils.getOuterMostOwner((IClassifier)iElement);
        }
        return null;
    }

    public static boolean isAnOwner(IClassifier iClassifier, IClassifier iClassifier2) {
        if (iClassifier == null || iClassifier2 == null) {
            return false;
        }
        if (iClassifier.equals(iClassifier2)) {
            return true;
        }
        IElement iElement = iClassifier2.getOwner();
        if (iElement == null || iElement instanceof IProject || iElement instanceof IPackage) {
            return false;
        }
        if (iElement instanceof IClassifier) {
            return JavaClassUtils.isAnOwner(iClassifier, (IClassifier)iElement);
        }
        return false;
    }

    static {
        primitives.add("int");
        primitives.add("short");
        primitives.add("long");
        primitives.add("float");
        primitives.add("double");
        primitives.add("byte");
        primitives.add("char");
        primitives.add("boolean");
    }
}

