/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.integration.ide;

import java.util.Vector;
import org.netbeans.modules.uml.core.metamodel.core.constructs.IActor;
import org.netbeans.modules.uml.core.metamodel.core.constructs.IClass;
import org.netbeans.modules.uml.core.metamodel.core.constructs.IEnumeration;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamedElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IPackage;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IRelationProxy;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IAttribute;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IClassifier;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IInterface;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IOperation;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IParameterableElement;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IStructuralFeature;
import org.netbeans.modules.uml.core.metamodel.structure.IProject;
import org.netbeans.modules.uml.core.roundtripframework.IChangeRequest;
import org.netbeans.modules.uml.core.roundtripframework.IClassTransformChangeRequest;
import org.netbeans.modules.uml.core.roundtripframework.IDependencyChangeRequest;
import org.netbeans.modules.uml.core.roundtripframework.IElementDuplicatedChangeRequest;
import org.netbeans.modules.uml.core.roundtripframework.IRoundTripClassEventsSink;
import org.netbeans.modules.uml.core.roundtripframework.IRoundTripEnumEventsSink;
import org.netbeans.modules.uml.core.roundtripframework.requestprocessors.javarpcomponent.JavaChangeHandlerUtilities;
import org.netbeans.modules.uml.core.support.umlsupport.IResultCell;
import org.netbeans.modules.uml.core.support.umlsupport.Log;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.integration.ide.ChangeUtils;
import org.netbeans.modules.uml.integration.ide.JavaClassUtils;
import org.netbeans.modules.uml.integration.ide.RoundTripSource;
import org.netbeans.modules.uml.integration.ide.UMLSupport;
import org.netbeans.modules.uml.integration.ide.events.ClassInfo;
import org.netbeans.modules.uml.integration.ide.events.MemberInfo;
import org.netbeans.modules.uml.integration.ide.events.MethodInfo;
import org.netbeans.modules.uml.integration.ide.listeners.IAttributeChangeListener;
import org.netbeans.modules.uml.integration.ide.listeners.IClassChangeListener;
import org.netbeans.modules.uml.integration.ide.listeners.IOperationChangeListener;

public class RoundTripClassEventsSink
extends RoundTripSource
implements IRoundTripClassEventsSink,
IRoundTripEnumEventsSink {
    private static Vector changeListeners = new Vector();

    public RoundTripClassEventsSink() {
        Log.out((String)"!--------- Class events sink instantiated");
    }

    public void onPreClassChangeRequest(IChangeRequest iChangeRequest, IResultCell iResultCell) {
    }

    public void onClassChangeRequest(IChangeRequest iChangeRequest, IResultCell iResultCell) {
        try {
            Log.out((String)"!-------- Got a classChange event");
            ChangeUtils.say(iChangeRequest);
            this.fireClassChangeEvent(iChangeRequest, false);
        }
        catch (Exception exception) {
            Log.stackTrace((Throwable)exception);
        }
    }

    public void onPreEnumChangeRequest(IChangeRequest iChangeRequest, IResultCell iResultCell) {
    }

    public void onEnumChangeRequest(IChangeRequest iChangeRequest, IResultCell iResultCell) {
        try {
            Log.out((String)"!-------- Got a enumChange event");
            ChangeUtils.say(iChangeRequest);
            this.fireClassChangeEvent(iChangeRequest, false);
        }
        catch (Exception exception) {
            Log.stackTrace((Throwable)exception);
        }
    }

    protected void fireClassChangeEvent(IChangeRequest iChangeRequest, final boolean bl) {
        int n = iChangeRequest.getRequestDetailType();
        Log.out((String)("Got request detail type " + n));
        if (!this.isValidEventType(n)) {
            Log.out((String)("Request detail type " + n + " is blocked, abandoning"));
            return;
        }
        int n2 = iChangeRequest.getState();
        IElement iElement = iChangeRequest.getBefore();
        IClassifier iClassifier = null;
        JavaChangeHandlerUtilities javaChangeHandlerUtilities = new JavaChangeHandlerUtilities();
        if (iElement instanceof IClassifier) {
            iClassifier = (IClassifier)iElement;
        } else if (iElement instanceof IParameterableElement) {
            iClassifier = javaChangeHandlerUtilities.getClass(iElement);
        }
        if (iClassifier == null) {
            return;
        }
        IElement iElement2 = iChangeRequest.getAfter();
        IClassifier iClassifier2 = null;
        if (iElement2 instanceof IClassifier) {
            iClassifier2 = (IClassifier)iElement2;
        } else if (iElement2 instanceof IParameterableElement) {
            iClassifier2 = javaChangeHandlerUtilities.getClass(iElement2);
        }
        if (iClassifier2 == null) {
            return;
        }
        switch (n2) {
            case 2: {
                if (!this.isValidEvent((INamedElement)iClassifier2)) break;
                if (iChangeRequest.getRequestDetailType() != 58) {
                    ClassInfo classInfo = new ClassInfo(iClassifier2);
                    classInfo.setMethodsAndMembers(iClassifier2);
                    this.fireClassAddedEvent(classInfo, bl);
                    break;
                }
                if (iClassifier instanceof IEnumeration && !(iClassifier2 instanceof IEnumeration)) {
                    this.transformClassifier(iClassifier, iClassifier2, bl);
                    break;
                }
                if (!(iClassifier instanceof IActor) || iClassifier2 instanceof IActor) break;
                this.transformClassifier(iClassifier, iClassifier2, bl);
                break;
            }
            case 1: {
                if (!this.isValidEvent((INamedElement)iClassifier)) break;
                if (iClassifier2 instanceof IEnumeration && !(iClassifier instanceof IEnumeration)) {
                    this.transformClassifier(iClassifier, iClassifier2, bl);
                    break;
                }
                ClassInfo classInfo = new ClassInfo(iClassifier);
                this.fireClassDeletedEvent(classInfo, bl);
                break;
            }
            case 0: {
                IRelationProxy iRelationProxy;
                if (!this.isValidEvent((INamedElement)iClassifier) || !this.isValidEvent((INamedElement)iClassifier2)) break;
                if (iChangeRequest.getRequestDetailType() == 58) {
                    this.transform(iChangeRequest, bl);
                    break;
                }
                if (iChangeRequest.getRequestDetailType() == 51) {
                    IElementDuplicatedChangeRequest iElementDuplicatedChangeRequest = (IElementDuplicatedChangeRequest)iChangeRequest;
                    IElement iElement3 = iElementDuplicatedChangeRequest.getDuplicatedElement();
                    if (iElement3 instanceof IOperation) {
                        IOperation iOperation = (IOperation)iElement3;
                        IOperation iOperation2 = (IOperation)iElementDuplicatedChangeRequest.getOriginalElement();
                        final MethodInfo methodInfo = new MethodInfo(null, iOperation2);
                        final MethodInfo methodInfo2 = new MethodInfo(null, iOperation);
                        for (int i = 0; i < changeListeners.size(); ++i) {
                            final IOperationChangeListener iOperationChangeListener = (IOperationChangeListener)changeListeners.elementAt(i);
                            RoundTripSource.RoundtripThread roundtripThread = new RoundTripSource.RoundtripThread(){

                                public void work() {
                                    RoundTripClassEventsSink.this.setDefaultProject(methodInfo2);
                                    iOperationChangeListener.operationDuplicated(methodInfo, methodInfo2, bl);
                                }
                            };
                            UMLSupport.getUMLSupport().getRoundtripQueue().queueRunnable(roundtripThread);
                        }
                    } else {
                        if (!(iElement3 instanceof IAttribute)) break;
                        IAttribute iAttribute = (IAttribute)iElement3;
                        final MemberInfo memberInfo = new MemberInfo(null, (IStructuralFeature)((IAttribute)iElementDuplicatedChangeRequest.getOriginalElement()));
                        final MemberInfo memberInfo2 = new MemberInfo(null, (IStructuralFeature)iAttribute);
                        ClassInfo classInfo = memberInfo.getContainingClass();
                        ClassInfo classInfo2 = memberInfo2.getContainingClass();
                        for (int i = 0; i < changeListeners.size(); ++i) {
                            final IAttributeChangeListener iAttributeChangeListener = (IAttributeChangeListener)changeListeners.elementAt(i);
                            RoundTripSource.RoundtripThread roundtripThread = new RoundTripSource.RoundtripThread(){

                                public void work() {
                                    RoundTripClassEventsSink.this.setDefaultProject(memberInfo2);
                                    iAttributeChangeListener.attributeDuplicated(memberInfo, memberInfo2, bl);
                                }
                            };
                            UMLSupport.getUMLSupport().getRoundtripQueue().queueRunnable(roundtripThread);
                        }
                    }
                    break;
                }
                ClassInfo classInfo = new ClassInfo(iClassifier);
                ClassInfo classInfo3 = new ClassInfo(iClassifier2);
                if (n == 6 || n == 7 || n == 8) {
                    iRelationProxy = iChangeRequest.getRelation();
                    IClassifier iClassifier3 = (IClassifier)iRelationProxy.getFrom();
                    classInfo = new ClassInfo(iClassifier3);
                    classInfo3 = new ClassInfo(iClassifier3);
                    this.addRelationshipInfo(classInfo, classInfo3, n, iRelationProxy);
                }
                if (n == 44 && iChangeRequest instanceof IDependencyChangeRequest) {
                    Log.out((String)"Its a dependency change request");
                    iRelationProxy = (IDependencyChangeRequest)iChangeRequest;
                    this.handleDependencyAdded((IDependencyChangeRequest)iRelationProxy, classInfo3, bl);
                }
                this.fireClassChangedEvent(classInfo, classInfo3, bl);
            }
        }
    }

    protected void handleDependencyAdded(IDependencyChangeRequest iDependencyChangeRequest, ClassInfo classInfo, boolean bl) {
        IElement iElement = iDependencyChangeRequest.getIndependentElement();
        if (iElement instanceof IPackage) {
            IPackage iPackage = (IPackage)iElement;
            String string = JavaClassUtils.getFullyQualifiedName((INamedElement)iPackage);
            Log.out((String)("Got the package name as " + string));
            classInfo.addImport(string + ".*");
        }
    }

    protected void transform(IChangeRequest iChangeRequest, boolean bl) {
        if (iChangeRequest instanceof IClassTransformChangeRequest) {
            Log.out((String)"Its a class transform change request");
            IClassTransformChangeRequest iClassTransformChangeRequest = (IClassTransformChangeRequest)iChangeRequest;
            IElement iElement = iClassTransformChangeRequest.getBefore();
            IElement iElement2 = iClassTransformChangeRequest.getAfter();
            if (!(iElement instanceof IClass) && !(iElement instanceof IInterface) || !(iElement2 instanceof IClass) && !(iElement2 instanceof IInterface)) {
                this.transformClassifier((IClassifier)iElement, (IClassifier)iElement2, bl);
            }
            Log.out((String)("Before element type name = " + iElement.getElementType()));
            Log.out((String)("After element type name = " + iElement2.getElementType()));
            ClassInfo classInfo = null;
            ClassInfo classInfo2 = null;
            if (iElement instanceof IClass) {
                IClass iClass = (IClass)iElement;
                ETList eTList = iClass.getGeneralizations();
                ETList eTList2 = iClass.getSpecializations();
                ETList eTList3 = iClass.getImplementations();
                IInterface iInterface = (IInterface)iElement2;
                if (eTList != null && eTList.getCount() > 0) {
                    Log.out((String)"This class has associated implementation classes, not transforming");
                    return;
                }
                if (eTList3 != null && eTList3.getCount() > 0) {
                    Log.out((String)"This class has associated implementation classes, not transforming");
                    return;
                }
                if (eTList2 != null && eTList2.getCount() > 0) {
                    Log.out((String)"This class has associated implementation classes, not transforming");
                    return;
                }
                classInfo = new ClassInfo((IClassifier)iClass);
                classInfo2 = new ClassInfo((IClassifier)iInterface);
            } else if (iElement2 instanceof IClass) {
                IClass iClass = (IClass)iElement2;
                IInterface iInterface = (IInterface)iElement;
                ETList eTList = iInterface.getImplementations();
                ETList eTList4 = iInterface.getGeneralizations();
                ETList eTList5 = iInterface.getSpecializations();
                if (eTList4 != null && eTList4.getCount() > 0) {
                    Log.out((String)"This class has associated implementation classes, not transforming");
                    return;
                }
                if (eTList != null && eTList.getCount() > 0) {
                    Log.out((String)"This class has associated implementation classes, not transforming");
                    return;
                }
                if (eTList5 != null && eTList5.getCount() > 0) {
                    Log.out((String)"This class has associated implementation classes, not transforming");
                    return;
                }
                classInfo = new ClassInfo((IClassifier)iInterface);
                classInfo2 = new ClassInfo((IClassifier)iClass);
            }
            if (classInfo != null && classInfo2 != null) {
                classInfo.setMethodsAndMembers((IClassifier)iElement);
                classInfo.setComment(iElement.getDocumentation());
                classInfo2.setMethodsAndMembers((IClassifier)iElement2);
                classInfo2.setComment(iElement2.getDocumentation());
                Log.out((String)"Calling transform function");
                this.fireClassTransformEvent(classInfo, classInfo2, bl);
            }
        }
    }

    protected void transformClassifier(IClassifier iClassifier, IClassifier iClassifier2, boolean bl) {
        ClassInfo classInfo = new ClassInfo(iClassifier);
        ClassInfo classInfo2 = new ClassInfo(iClassifier2);
        classInfo2.setMethodsAndMembers(iClassifier2);
        classInfo.setMethodsAndMembers(iClassifier);
        classInfo.setComment(iClassifier.getDocumentation());
        classInfo2.setComment(iClassifier2.getDocumentation());
        this.fireClassTransformEvent(classInfo, classInfo2, bl);
    }

    protected void addRelationshipInfo(ClassInfo classInfo, ClassInfo classInfo2, int n, IRelationProxy iRelationProxy) {
        INamedElement iNamedElement = (INamedElement)iRelationProxy.getTo();
        String string = JavaClassUtils.getFullyQualifiedName(iNamedElement);
        String string2 = JavaClassUtils.getPackageName(string);
        String string3 = JavaClassUtils.getFullInnerClassName(string);
        String string4 = iRelationProxy.getConnectionElementType();
        if (string4.equals("Generalization") && !classInfo.isInterface()) {
            classInfo2.setExtendedClass(string2, string3);
            if (n == 8) {
                classInfo2.setExtendedClass(null, null);
            }
        } else if (string4.equals("Implementation") || classInfo.isInterface() && string4.equals("Generalization")) {
            switch (n) {
                case 6: {
                    Log.out((String)("Superinterface is " + string));
                    classInfo2.addInterface(string2, string3);
                    break;
                }
                case 8: {
                    classInfo2.removeInterface(string2, string3);
                }
            }
        }
    }

    protected void fireClassAddedEvent(final ClassInfo classInfo, final boolean bl) {
        if (!this.isValidEvent(classInfo, classInfo.getOuterClass()) || classInfo.isReferenceClass()) {
            return;
        }
        Log.out((String)("Class added (M->S): " + classInfo));
        for (int i = 0; i < changeListeners.size(); ++i) {
            final IClassChangeListener iClassChangeListener = (IClassChangeListener)changeListeners.elementAt(i);
            RoundTripSource.RoundtripThread roundtripThread = new RoundTripSource.RoundtripThread(){

                public void work() {
                    RoundTripClassEventsSink.this.setDefaultProject(classInfo);
                    iClassChangeListener.classAdded(classInfo, bl);
                }
            };
            this.queue(roundtripThread);
        }
    }

    protected void fireClassDeletedEvent(final ClassInfo classInfo, final boolean bl) {
        if (!this.isValidEvent(classInfo, classInfo.getOuterClass()) || classInfo.isReferenceClass()) {
            return;
        }
        Log.out((String)("Class deleted (M->S): " + classInfo));
        for (int i = 0; i < changeListeners.size(); ++i) {
            final IClassChangeListener iClassChangeListener = (IClassChangeListener)changeListeners.elementAt(i);
            RoundTripSource.RoundtripThread roundtripThread = new RoundTripSource.RoundtripThread(){

                public void work() {
                    RoundTripClassEventsSink.this.setDefaultProject(classInfo);
                    iClassChangeListener.classDeleted(classInfo, bl);
                }
            };
            this.queue(roundtripThread);
        }
    }

    protected void fireClassTransformEvent(final ClassInfo classInfo, final ClassInfo classInfo2, final boolean bl) {
        if (!this.isValidEvent(classInfo, classInfo.getOuterClass()) || classInfo.isReferenceClass() || classInfo2.isReferenceClass()) {
            return;
        }
        for (int i = 0; i < changeListeners.size(); ++i) {
            final IClassChangeListener iClassChangeListener = (IClassChangeListener)changeListeners.elementAt(i);
            RoundTripSource.RoundtripThread roundtripThread = new RoundTripSource.RoundtripThread(){

                public void work() {
                    RoundTripClassEventsSink.this.setDefaultProject(classInfo2);
                    iClassChangeListener.classTransformed(classInfo, classInfo2, bl);
                }
            };
            this.queue(roundtripThread);
        }
    }

    protected void fireBulkDeleteEvent(final Vector vector, final String string, final IProject iProject) {
        for (int i = 0; i < changeListeners.size(); ++i) {
            final IClassChangeListener iClassChangeListener = (IClassChangeListener)changeListeners.elementAt(i);
            RoundTripSource.RoundtripThread roundtripThread = new RoundTripSource.RoundtripThread(){

                public void work() {
                    UMLSupport.setDefaultProject(iProject);
                    iClassChangeListener.classesDeleted(vector, string);
                }
            };
            this.queue(roundtripThread);
        }
    }

    protected void fireClassChangedEvent(final ClassInfo classInfo, final ClassInfo classInfo2, final boolean bl) {
        if (!this.isValidEvent(classInfo, classInfo.getOuterClass()) || classInfo.isReferenceClass() || classInfo2.isReferenceClass()) {
            return;
        }
        Log.out((String)("Class changed (M->S) from " + classInfo + " to " + classInfo2));
        for (int i = 0; i < changeListeners.size(); ++i) {
            final IClassChangeListener iClassChangeListener = (IClassChangeListener)changeListeners.elementAt(i);
            RoundTripSource.RoundtripThread roundtripThread = new RoundTripSource.RoundtripThread(){

                public void work() {
                    RoundTripClassEventsSink.this.setDefaultProject(classInfo2);
                    iClassChangeListener.classChanged(classInfo, classInfo2, bl);
                }
            };
            this.queue(roundtripThread);
        }
    }

    public static void addClassChangeListener(IClassChangeListener iClassChangeListener) {
        if (iClassChangeListener != null && !changeListeners.contains(iClassChangeListener)) {
            changeListeners.add(iClassChangeListener);
        }
    }

    public static void removeClassChangeListener(IClassChangeListener iClassChangeListener) {
        if (iClassChangeListener != null) {
            changeListeners.remove(iClassChangeListener);
        }
    }
}

